/*
 * Decompiled with CFR 0.152.
 */
package io.netty.handler.codec.http2;

import io.netty.bootstrap.Bootstrap;
import io.netty.bootstrap.ServerBootstrap;
import io.netty.channel.Channel;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.ChannelInboundHandlerAdapter;
import io.netty.channel.ChannelInitializer;
import io.netty.channel.EventLoopGroup;
import io.netty.channel.nio.NioEventLoopGroup;
import io.netty.channel.socket.nio.NioServerSocketChannel;
import io.netty.channel.socket.nio.NioSocketChannel;
import io.netty.handler.codec.http2.DefaultHttp2SettingsFrame;
import io.netty.handler.codec.http2.Http2FrameCodec;
import io.netty.handler.codec.http2.Http2FrameCodecBuilder;
import io.netty.handler.codec.http2.Http2MultiplexCodecBuilder;
import io.netty.handler.codec.http2.Http2MultiplexHandler;
import io.netty.handler.codec.http2.Http2Settings;
import io.netty.handler.codec.http2.Http2SettingsAckFrame;
import io.netty.handler.codec.http2.Http2SettingsFrame;
import io.netty.util.NetUtil;
import io.netty.util.ReferenceCountUtil;
import java.net.InetSocketAddress;
import java.net.SocketAddress;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicReference;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class Http2MultiplexTransportTest {
    private EventLoopGroup eventLoopGroup;
    private Channel clientChannel;
    private Channel serverChannel;
    private Channel serverConnectedChannel;

    @Before
    public void setup() {
        this.eventLoopGroup = new NioEventLoopGroup();
    }

    @After
    public void teardown() {
        if (this.clientChannel != null) {
            this.clientChannel.close();
        }
        if (this.serverChannel != null) {
            this.serverChannel.close();
        }
        if (this.serverConnectedChannel != null) {
            this.serverConnectedChannel.close();
        }
        this.eventLoopGroup.shutdownGracefully(0L, 0L, TimeUnit.MILLISECONDS);
    }

    @Test(timeout=10000L)
    public void asyncSettingsAckWithMultiplexCodec() throws InterruptedException {
        this.asyncSettingsAck0((Http2FrameCodec)new Http2MultiplexCodecBuilder(true, (ChannelHandler)new HttpInboundHandler()).build(), null);
    }

    @Test(timeout=10000L)
    public void asyncSettingsAckWithMultiplexHandler() throws InterruptedException {
        this.asyncSettingsAck0(new Http2FrameCodecBuilder(true).build(), (ChannelHandler)new Http2MultiplexHandler((ChannelHandler)new HttpInboundHandler()));
    }

    private void asyncSettingsAck0(final Http2FrameCodec codec, final ChannelHandler multiplexer) throws InterruptedException {
        final CountDownLatch serverAckOneLatch = new CountDownLatch(1);
        final CountDownLatch serverAckAllLatch = new CountDownLatch(2);
        final CountDownLatch clientSettingsLatch = new CountDownLatch(2);
        final CountDownLatch serverConnectedChannelLatch = new CountDownLatch(1);
        final AtomicReference serverConnectedChannelRef = new AtomicReference();
        ServerBootstrap sb = new ServerBootstrap();
        sb.group(this.eventLoopGroup);
        sb.channel(NioServerSocketChannel.class);
        sb.childHandler((ChannelHandler)new ChannelInitializer<Channel>(){

            protected void initChannel(Channel ch) {
                ch.pipeline().addLast(new ChannelHandler[]{codec});
                if (multiplexer != null) {
                    ch.pipeline().addLast(new ChannelHandler[]{multiplexer});
                }
                ch.pipeline().addLast(new ChannelHandler[]{new ChannelInboundHandlerAdapter(){

                    public void channelActive(ChannelHandlerContext ctx) {
                        serverConnectedChannelRef.set(ctx.channel());
                        serverConnectedChannelLatch.countDown();
                    }

                    public void channelRead(ChannelHandlerContext ctx, Object msg) {
                        if (msg instanceof Http2SettingsAckFrame) {
                            serverAckOneLatch.countDown();
                            serverAckAllLatch.countDown();
                        }
                        ReferenceCountUtil.release((Object)msg);
                    }
                }});
            }
        });
        this.serverChannel = sb.bind((SocketAddress)new InetSocketAddress(NetUtil.LOCALHOST, 0)).awaitUninterruptibly().channel();
        Bootstrap bs = new Bootstrap();
        bs.group(this.eventLoopGroup);
        bs.channel(NioSocketChannel.class);
        bs.handler((ChannelHandler)new ChannelInitializer<Channel>(){

            protected void initChannel(Channel ch) {
                ch.pipeline().addLast(new ChannelHandler[]{Http2MultiplexCodecBuilder.forClient((ChannelHandler)new HttpInboundHandler()).autoAckSettingsFrame(false).build()});
                ch.pipeline().addLast(new ChannelHandler[]{new ChannelInboundHandlerAdapter(){

                    public void channelRead(ChannelHandlerContext ctx, Object msg) {
                        if (msg instanceof Http2SettingsFrame) {
                            clientSettingsLatch.countDown();
                        }
                        ReferenceCountUtil.release((Object)msg);
                    }
                }});
            }
        });
        this.clientChannel = bs.connect(this.serverChannel.localAddress()).awaitUninterruptibly().channel();
        serverConnectedChannelLatch.await();
        this.serverConnectedChannel = (Channel)serverConnectedChannelRef.get();
        this.serverConnectedChannel.writeAndFlush((Object)new DefaultHttp2SettingsFrame(new Http2Settings().maxConcurrentStreams(10L))).sync();
        clientSettingsLatch.await();
        Assert.assertFalse((boolean)serverAckOneLatch.await(300L, TimeUnit.MILLISECONDS));
        this.clientChannel.writeAndFlush((Object)Http2SettingsAckFrame.INSTANCE).sync();
        this.clientChannel.writeAndFlush((Object)Http2SettingsAckFrame.INSTANCE).sync();
        serverAckAllLatch.await();
    }

    @ChannelHandler.Sharable
    private static final class HttpInboundHandler
    extends ChannelInboundHandlerAdapter {
        private HttpInboundHandler() {
        }
    }
}

