/*
 * Decompiled with CFR 0.152.
 */
package io.netty.handler.codec.http2;

import io.netty.bootstrap.Bootstrap;
import io.netty.bootstrap.ServerBootstrap;
import io.netty.buffer.ByteBuf;
import io.netty.buffer.Unpooled;
import io.netty.channel.Channel;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelHandlerAdapter;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.ChannelInboundHandlerAdapter;
import io.netty.channel.ChannelInitializer;
import io.netty.channel.DefaultEventLoop;
import io.netty.channel.EventLoopGroup;
import io.netty.channel.local.LocalAddress;
import io.netty.channel.local.LocalChannel;
import io.netty.channel.local.LocalServerChannel;
import io.netty.handler.codec.http2.DefaultHttp2DataFrame;
import io.netty.handler.codec.http2.DefaultHttp2Headers;
import io.netty.handler.codec.http2.DefaultHttp2HeadersFrame;
import io.netty.handler.codec.http2.Http2CodecUtil;
import io.netty.handler.codec.http2.Http2DataFrame;
import io.netty.handler.codec.http2.Http2Headers;
import io.netty.handler.codec.http2.Http2HeadersFrame;
import io.netty.handler.codec.http2.Http2MultiplexCodecBuilder;
import io.netty.handler.codec.http2.Http2ResetFrame;
import io.netty.handler.codec.http2.Http2StreamChannel;
import io.netty.handler.codec.http2.Http2StreamChannelBootstrap;
import io.netty.handler.codec.http2.LastInboundHandler;
import io.netty.handler.codec.http2.TestChannelInitializer;
import java.net.SocketAddress;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import org.junit.After;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.Before;
import org.junit.BeforeClass;
import org.junit.Test;

public class Http2MultiplexCodecBuilderTest {
    private static EventLoopGroup group;
    private Channel serverChannel;
    private volatile Channel serverConnectedChannel;
    private Channel clientChannel;
    private LastInboundHandler serverLastInboundHandler;

    @BeforeClass
    public static void init() {
        group = new DefaultEventLoop();
    }

    @Before
    public void setUp() throws InterruptedException {
        final CountDownLatch serverChannelLatch = new CountDownLatch(1);
        LocalAddress serverAddress = new LocalAddress(this.getClass().getName());
        this.serverLastInboundHandler = new SharableLastInboundHandler();
        ServerBootstrap sb = ((ServerBootstrap)new ServerBootstrap().channel(LocalServerChannel.class)).group(group).childHandler((ChannelHandler)new ChannelInitializer<Channel>(){

            protected void initChannel(Channel ch) throws Exception {
                Http2MultiplexCodecBuilderTest.this.serverConnectedChannel = ch;
                ch.pipeline().addLast(new ChannelHandler[]{new Http2MultiplexCodecBuilder(true, (ChannelHandler)new ChannelInitializer<Channel>(){

                    protected void initChannel(Channel ch) throws Exception {
                        ch.pipeline().addLast(new ChannelHandler[]{new ChannelInboundHandlerAdapter(){
                            private boolean writable;

                            public void channelActive(ChannelHandlerContext ctx) throws Exception {
                                this.writable |= ctx.channel().isWritable();
                                super.channelActive(ctx);
                            }

                            public void channelWritabilityChanged(ChannelHandlerContext ctx) throws Exception {
                                this.writable |= ctx.channel().isWritable();
                                super.channelWritabilityChanged(ctx);
                            }

                            public void channelInactive(ChannelHandlerContext ctx) throws Exception {
                                Assert.assertTrue((boolean)this.writable);
                                super.channelInactive(ctx);
                            }
                        }});
                        ch.pipeline().addLast(new ChannelHandler[]{Http2MultiplexCodecBuilderTest.this.serverLastInboundHandler});
                    }
                }).build()});
                serverChannelLatch.countDown();
            }
        });
        this.serverChannel = sb.bind((SocketAddress)serverAddress).sync().channel();
        Bootstrap cb = (Bootstrap)((Bootstrap)((Bootstrap)new Bootstrap().channel(LocalChannel.class)).group(group)).handler((ChannelHandler)new Http2MultiplexCodecBuilder(false, (ChannelHandler)new ChannelInitializer<Channel>(){

            protected void initChannel(Channel ch) throws Exception {
                Assert.fail((String)"Should not be called for outbound streams");
            }
        }).build());
        this.clientChannel = cb.connect((SocketAddress)serverAddress).sync().channel();
        Assert.assertTrue((boolean)serverChannelLatch.await(5L, TimeUnit.SECONDS));
    }

    @AfterClass
    public static void shutdown() {
        group.shutdownGracefully(0L, 5L, TimeUnit.SECONDS);
    }

    @After
    public void tearDown() throws Exception {
        Channel serverConnectedChannel;
        if (this.clientChannel != null) {
            this.clientChannel.close().syncUninterruptibly();
            this.clientChannel = null;
        }
        if (this.serverChannel != null) {
            this.serverChannel.close().syncUninterruptibly();
            this.serverChannel = null;
        }
        if ((serverConnectedChannel = this.serverConnectedChannel) != null) {
            serverConnectedChannel.close().syncUninterruptibly();
            this.serverConnectedChannel = null;
        }
    }

    private Http2StreamChannel newOutboundStream(ChannelHandler handler) {
        return (Http2StreamChannel)new Http2StreamChannelBootstrap(this.clientChannel).handler(handler).open().syncUninterruptibly().getNow();
    }

    @Test
    public void multipleOutboundStreams() throws Exception {
        Http2StreamChannel childChannel1 = this.newOutboundStream((ChannelHandler)new TestChannelInitializer());
        Assert.assertTrue((boolean)childChannel1.isActive());
        Assert.assertFalse((boolean)Http2CodecUtil.isStreamIdValid((int)childChannel1.stream().id()));
        Http2StreamChannel childChannel2 = this.newOutboundStream((ChannelHandler)new TestChannelInitializer());
        Assert.assertTrue((boolean)childChannel2.isActive());
        Assert.assertFalse((boolean)Http2CodecUtil.isStreamIdValid((int)childChannel2.stream().id()));
        DefaultHttp2Headers headers1 = new DefaultHttp2Headers();
        DefaultHttp2Headers headers2 = new DefaultHttp2Headers();
        childChannel2.writeAndFlush((Object)new DefaultHttp2HeadersFrame((Http2Headers)headers2));
        childChannel1.writeAndFlush((Object)new DefaultHttp2HeadersFrame((Http2Headers)headers1));
        Http2HeadersFrame headersFrame2 = (Http2HeadersFrame)this.serverLastInboundHandler.blockingReadInbound();
        Assert.assertNotNull((Object)headersFrame2);
        Assert.assertEquals((long)3L, (long)headersFrame2.stream().id());
        Http2HeadersFrame headersFrame1 = (Http2HeadersFrame)this.serverLastInboundHandler.blockingReadInbound();
        Assert.assertNotNull((Object)headersFrame1);
        Assert.assertEquals((long)5L, (long)headersFrame1.stream().id());
        Assert.assertEquals((long)3L, (long)childChannel2.stream().id());
        Assert.assertEquals((long)5L, (long)childChannel1.stream().id());
        childChannel1.close();
        childChannel2.close();
        this.serverLastInboundHandler.checkException();
    }

    @Test
    public void createOutboundStream() throws Exception {
        Http2StreamChannel childChannel = this.newOutboundStream((ChannelHandler)new TestChannelInitializer());
        Assert.assertTrue((boolean)childChannel.isRegistered());
        Assert.assertTrue((boolean)childChannel.isActive());
        DefaultHttp2Headers headers = new DefaultHttp2Headers();
        childChannel.writeAndFlush((Object)new DefaultHttp2HeadersFrame((Http2Headers)headers));
        ByteBuf data = Unpooled.buffer((int)100).writeZero(100);
        childChannel.writeAndFlush((Object)new DefaultHttp2DataFrame(data, true));
        Http2HeadersFrame headersFrame = (Http2HeadersFrame)this.serverLastInboundHandler.blockingReadInbound();
        Assert.assertNotNull((Object)headersFrame);
        Assert.assertEquals((long)3L, (long)headersFrame.stream().id());
        Assert.assertEquals((Object)headers, (Object)headersFrame.headers());
        Http2DataFrame dataFrame = (Http2DataFrame)this.serverLastInboundHandler.blockingReadInbound();
        Assert.assertNotNull((Object)dataFrame);
        Assert.assertEquals((long)3L, (long)dataFrame.stream().id());
        Assert.assertEquals((Object)data.resetReaderIndex(), (Object)dataFrame.content());
        Assert.assertTrue((boolean)dataFrame.isEndStream());
        dataFrame.release();
        childChannel.close();
        Http2ResetFrame rstFrame = (Http2ResetFrame)this.serverLastInboundHandler.blockingReadInbound();
        Assert.assertNotNull((Object)rstFrame);
        Assert.assertEquals((long)3L, (long)rstFrame.stream().id());
        this.serverLastInboundHandler.checkException();
    }

    @Test
    public void testSharableCheck() {
        Assert.assertNotNull((Object)Http2MultiplexCodecBuilder.forServer((ChannelHandler)new SharableChannelHandler1()));
        Assert.assertNotNull((Object)Http2MultiplexCodecBuilder.forServer((ChannelHandler)new SharableChannelHandler2()));
    }

    @Test(expected=IllegalArgumentException.class)
    public void testUnsharableHandler() {
        Http2MultiplexCodecBuilder.forServer((ChannelHandler)new UnsharableChannelHandler());
    }

    private static class UnsharableChannelHandler
    extends ChannelHandlerAdapter {
        private UnsharableChannelHandler() {
        }

        public boolean isSharable() {
            return false;
        }
    }

    @ChannelHandler.Sharable
    private static class SharableChannelHandler2
    extends ChannelHandlerAdapter {
        private SharableChannelHandler2() {
        }
    }

    private static class SharableChannelHandler1
    extends ChannelHandlerAdapter {
        private SharableChannelHandler1() {
        }

        public boolean isSharable() {
            return true;
        }
    }

    @ChannelHandler.Sharable
    private static class SharableLastInboundHandler
    extends LastInboundHandler {
        private SharableLastInboundHandler() {
        }

        @Override
        public void channelActive(ChannelHandlerContext ctx) throws Exception {
            ctx.fireChannelActive();
        }

        @Override
        public void channelInactive(ChannelHandlerContext ctx) throws Exception {
            ctx.fireChannelInactive();
        }
    }
}

