/*
 * Decompiled with CFR 0.152.
 */
package io.netty.handler.codec.http2.internal.hpack;

import io.netty.handler.codec.http2.internal.hpack.HpackUtil;
import io.netty.util.CharsetUtil;
import io.netty.util.internal.ObjectUtil;

class HeaderField
implements Comparable<HeaderField> {
    static final int HEADER_ENTRY_OVERHEAD = 32;
    final byte[] name;
    final byte[] value;

    static int sizeOf(byte[] name, byte[] value) {
        return name.length + value.length + 32;
    }

    HeaderField(String name, String value) {
        this(name.getBytes(CharsetUtil.ISO_8859_1), value.getBytes(CharsetUtil.ISO_8859_1));
    }

    HeaderField(byte[] name, byte[] value) {
        this.name = (byte[])ObjectUtil.checkNotNull((Object)name, (String)"name");
        this.value = (byte[])ObjectUtil.checkNotNull((Object)value, (String)"value");
    }

    int size() {
        return this.name.length + this.value.length + 32;
    }

    public int hashCode() {
        return super.hashCode();
    }

    @Override
    public int compareTo(HeaderField anotherHeaderField) {
        int ret = this.compareTo(this.name, anotherHeaderField.name);
        if (ret == 0) {
            ret = this.compareTo(this.value, anotherHeaderField.value);
        }
        return ret;
    }

    private int compareTo(byte[] s1, byte[] s2) {
        int len1 = s1.length;
        int len2 = s2.length;
        int lim = Math.min(len1, len2);
        for (int k = 0; k < lim; ++k) {
            byte b1 = s1[k];
            byte b2 = s2[k];
            if (b1 == b2) continue;
            return b1 - b2;
        }
        return len1 - len2;
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (!(obj instanceof HeaderField)) {
            return false;
        }
        HeaderField other = (HeaderField)obj;
        boolean nameEquals = HpackUtil.equals(this.name, other.name);
        boolean valueEquals = HpackUtil.equals(this.value, other.value);
        return nameEquals && valueEquals;
    }

    public String toString() {
        String nameString = new String(this.name);
        String valueString = new String(this.value);
        return nameString + ": " + valueString;
    }
}

