/*
 * Decompiled with CFR 0.152.
 */
package io.netty.handler.codec.http2;

import io.netty.handler.codec.ByteStringValueConverter;
import io.netty.handler.codec.DefaultHeaders;
import io.netty.handler.codec.Headers;
import io.netty.handler.codec.ValueConverter;
import io.netty.handler.codec.http2.Http2Headers;
import io.netty.util.ByteString;

public class DefaultHttp2Headers
extends DefaultHeaders<ByteString>
implements Http2Headers {
    private DefaultHeaders.HeaderEntry<ByteString> firstNonPseudo;

    public DefaultHttp2Headers() {
        super((ValueConverter)ByteStringValueConverter.INSTANCE);
        this.firstNonPseudo = this.head;
    }

    @Override
    public Http2Headers add(ByteString name, ByteString value) {
        super.add((Object)name, (Object)value);
        return this;
    }

    @Override
    public Http2Headers add(ByteString name, Iterable<? extends ByteString> values) {
        super.add((Object)name, values);
        return this;
    }

    @Override
    public Http2Headers add(ByteString name, ByteString ... values) {
        super.add((Object)name, (Object[])values);
        return this;
    }

    @Override
    public Http2Headers addObject(ByteString name, Object value) {
        super.addObject((Object)name, value);
        return this;
    }

    @Override
    public Http2Headers addObject(ByteString name, Iterable<?> values) {
        super.addObject((Object)name, values);
        return this;
    }

    @Override
    public Http2Headers addObject(ByteString name, Object ... values) {
        super.addObject((Object)name, values);
        return this;
    }

    @Override
    public Http2Headers addBoolean(ByteString name, boolean value) {
        super.addBoolean((Object)name, value);
        return this;
    }

    @Override
    public Http2Headers addChar(ByteString name, char value) {
        super.addChar((Object)name, value);
        return this;
    }

    @Override
    public Http2Headers addByte(ByteString name, byte value) {
        super.addByte((Object)name, value);
        return this;
    }

    @Override
    public Http2Headers addShort(ByteString name, short value) {
        super.addShort((Object)name, value);
        return this;
    }

    @Override
    public Http2Headers addInt(ByteString name, int value) {
        super.addInt((Object)name, value);
        return this;
    }

    @Override
    public Http2Headers addLong(ByteString name, long value) {
        super.addLong((Object)name, value);
        return this;
    }

    @Override
    public Http2Headers addFloat(ByteString name, float value) {
        super.addFloat((Object)name, value);
        return this;
    }

    @Override
    public Http2Headers addDouble(ByteString name, double value) {
        super.addDouble((Object)name, value);
        return this;
    }

    @Override
    public Http2Headers addTimeMillis(ByteString name, long value) {
        super.addTimeMillis((Object)name, value);
        return this;
    }

    @Override
    public Http2Headers add(Headers<? extends ByteString> headers) {
        super.add(headers);
        return this;
    }

    @Override
    public Http2Headers set(ByteString name, ByteString value) {
        super.set((Object)name, (Object)value);
        return this;
    }

    @Override
    public Http2Headers set(ByteString name, Iterable<? extends ByteString> values) {
        super.set((Object)name, values);
        return this;
    }

    @Override
    public Http2Headers set(ByteString name, ByteString ... values) {
        super.set((Object)name, (Object[])values);
        return this;
    }

    @Override
    public Http2Headers setObject(ByteString name, Object value) {
        super.setObject((Object)name, value);
        return this;
    }

    @Override
    public Http2Headers setObject(ByteString name, Iterable<?> values) {
        super.setObject((Object)name, values);
        return this;
    }

    @Override
    public Http2Headers setObject(ByteString name, Object ... values) {
        super.setObject((Object)name, values);
        return this;
    }

    @Override
    public Http2Headers setBoolean(ByteString name, boolean value) {
        super.setBoolean((Object)name, value);
        return this;
    }

    @Override
    public Http2Headers setChar(ByteString name, char value) {
        super.setChar((Object)name, value);
        return this;
    }

    @Override
    public Http2Headers setByte(ByteString name, byte value) {
        super.setByte((Object)name, value);
        return this;
    }

    @Override
    public Http2Headers setShort(ByteString name, short value) {
        super.setShort((Object)name, value);
        return this;
    }

    @Override
    public Http2Headers setInt(ByteString name, int value) {
        super.setInt((Object)name, value);
        return this;
    }

    @Override
    public Http2Headers setLong(ByteString name, long value) {
        super.setLong((Object)name, value);
        return this;
    }

    @Override
    public Http2Headers setFloat(ByteString name, float value) {
        super.setFloat((Object)name, value);
        return this;
    }

    @Override
    public Http2Headers setDouble(ByteString name, double value) {
        super.setDouble((Object)name, value);
        return this;
    }

    @Override
    public Http2Headers setTimeMillis(ByteString name, long value) {
        super.setTimeMillis((Object)name, value);
        return this;
    }

    @Override
    public Http2Headers set(Headers<? extends ByteString> headers) {
        super.set(headers);
        return this;
    }

    @Override
    public Http2Headers setAll(Headers<? extends ByteString> headers) {
        super.setAll(headers);
        return this;
    }

    @Override
    public Http2Headers clear() {
        super.clear();
        return this;
    }

    @Override
    public Http2Headers method(ByteString value) {
        this.set(Http2Headers.PseudoHeaderName.METHOD.value(), value);
        return this;
    }

    @Override
    public Http2Headers scheme(ByteString value) {
        this.set(Http2Headers.PseudoHeaderName.SCHEME.value(), value);
        return this;
    }

    @Override
    public Http2Headers authority(ByteString value) {
        this.set(Http2Headers.PseudoHeaderName.AUTHORITY.value(), value);
        return this;
    }

    @Override
    public Http2Headers path(ByteString value) {
        this.set(Http2Headers.PseudoHeaderName.PATH.value(), value);
        return this;
    }

    @Override
    public Http2Headers status(ByteString value) {
        this.set(Http2Headers.PseudoHeaderName.STATUS.value(), value);
        return this;
    }

    @Override
    public ByteString method() {
        return (ByteString)this.get(Http2Headers.PseudoHeaderName.METHOD.value());
    }

    @Override
    public ByteString scheme() {
        return (ByteString)this.get(Http2Headers.PseudoHeaderName.SCHEME.value());
    }

    @Override
    public ByteString authority() {
        return (ByteString)this.get(Http2Headers.PseudoHeaderName.AUTHORITY.value());
    }

    @Override
    public ByteString path() {
        return (ByteString)this.get(Http2Headers.PseudoHeaderName.PATH.value());
    }

    @Override
    public ByteString status() {
        return (ByteString)this.get(Http2Headers.PseudoHeaderName.STATUS.value());
    }

    protected final DefaultHeaders.HeaderEntry<ByteString> newHeaderEntry(int h, ByteString name, ByteString value, DefaultHeaders.HeaderEntry<ByteString> next) {
        return new Http2HeaderEntry(h, name, value, next);
    }

    private final class Http2HeaderEntry
    extends DefaultHeaders.HeaderEntry<ByteString> {
        protected Http2HeaderEntry(int hash, ByteString key, ByteString value, DefaultHeaders.HeaderEntry<ByteString> next) {
            super(hash, (Object)key);
            this.value = value;
            this.next = next;
            if (!key.isEmpty() && key.byteAt(0) == 58) {
                this.after = DefaultHttp2Headers.this.firstNonPseudo;
                this.before = DefaultHttp2Headers.this.firstNonPseudo.before();
            } else {
                this.after = DefaultHttp2Headers.this.head;
                this.before = DefaultHttp2Headers.this.head.before();
                if (DefaultHttp2Headers.this.firstNonPseudo == DefaultHttp2Headers.this.head) {
                    DefaultHttp2Headers.this.firstNonPseudo = this;
                }
            }
            this.pointNeighborsToThis();
        }

        protected void remove() {
            if (this == DefaultHttp2Headers.this.firstNonPseudo) {
                DefaultHttp2Headers.this.firstNonPseudo = DefaultHttp2Headers.this.firstNonPseudo.after();
            }
            super.remove();
        }
    }
}

