/*
 * Decompiled with CFR 0.152.
 */
package io.netty.handler.codec.http2;

import com.twitter.hpack.Decoder;
import com.twitter.hpack.HeaderListener;
import io.netty.buffer.ByteBuf;
import io.netty.buffer.ByteBufInputStream;
import io.netty.handler.codec.http2.DefaultHttp2HeaderTableListSize;
import io.netty.handler.codec.http2.DefaultHttp2Headers;
import io.netty.handler.codec.http2.Http2Error;
import io.netty.handler.codec.http2.Http2Exception;
import io.netty.handler.codec.http2.Http2HeaderTable;
import io.netty.handler.codec.http2.Http2Headers;
import io.netty.handler.codec.http2.Http2HeadersDecoder;
import io.netty.util.ByteString;
import java.io.IOException;
import java.io.InputStream;

public class DefaultHttp2HeadersDecoder
implements Http2HeadersDecoder,
Http2HeadersDecoder.Configuration {
    private final Decoder decoder;
    private final Http2HeaderTable headerTable;

    public DefaultHttp2HeadersDecoder() {
        this(8192, 4096);
    }

    public DefaultHttp2HeadersDecoder(int maxHeaderSize, int maxHeaderTableSize) {
        this.decoder = new Decoder(maxHeaderSize, maxHeaderTableSize);
        this.headerTable = new Http2HeaderTableDecoder();
    }

    @Override
    public Http2HeaderTable headerTable() {
        return this.headerTable;
    }

    @Override
    public Http2HeadersDecoder.Configuration configuration() {
        return this;
    }

    @Override
    public Http2Headers decodeHeaders(ByteBuf headerBlock) throws Http2Exception {
        ByteBufInputStream in = new ByteBufInputStream(headerBlock);
        try {
            final DefaultHttp2Headers headers = new DefaultHttp2Headers();
            HeaderListener listener = new HeaderListener(){

                public void addHeader(byte[] key, byte[] value, boolean sensitive) {
                    headers.add(new ByteString(key, false), new ByteString(value, false));
                }
            };
            this.decoder.decode((InputStream)in, listener);
            boolean truncated = this.decoder.endHeaderBlock();
            if (truncated) {
                // empty if block
            }
            if (headers.size() > this.headerTable.maxHeaderListSize()) {
                throw Http2Exception.connectionError(Http2Error.PROTOCOL_ERROR, "Number of headers (%d) exceeds maxHeaderListSize (%d)", headers.size(), this.headerTable.maxHeaderListSize());
            }
            DefaultHttp2Headers defaultHttp2Headers = headers;
            return defaultHttp2Headers;
        }
        catch (IOException e) {
            throw Http2Exception.connectionError(Http2Error.COMPRESSION_ERROR, e, e.getMessage(), new Object[0]);
        }
        catch (Http2Exception e) {
            throw e;
        }
        catch (Throwable e) {
            throw Http2Exception.connectionError(Http2Error.COMPRESSION_ERROR, e, e.getMessage(), new Object[0]);
        }
        finally {
            try {
                in.close();
            }
            catch (IOException e) {
                throw Http2Exception.connectionError(Http2Error.INTERNAL_ERROR, e, e.getMessage(), new Object[0]);
            }
        }
    }

    private final class Http2HeaderTableDecoder
    extends DefaultHttp2HeaderTableListSize
    implements Http2HeaderTable {
        private Http2HeaderTableDecoder() {
        }

        @Override
        public void maxHeaderTableSize(int max) throws Http2Exception {
            if (max < 0) {
                throw Http2Exception.connectionError(Http2Error.PROTOCOL_ERROR, "Header Table Size must be non-negative but was %d", max);
            }
            try {
                DefaultHttp2HeadersDecoder.this.decoder.setMaxHeaderTableSize(max);
            }
            catch (Throwable t) {
                throw Http2Exception.connectionError(Http2Error.PROTOCOL_ERROR, t.getMessage(), t);
            }
        }

        @Override
        public int maxHeaderTableSize() {
            return DefaultHttp2HeadersDecoder.this.decoder.getMaxHeaderTableSize();
        }
    }
}

