/*
 * Decompiled with CFR 0.152.
 */
package io.netty.handler.codec.http2;

import io.netty.buffer.ByteBuf;
import io.netty.buffer.Unpooled;
import io.netty.channel.ChannelFuture;
import io.netty.channel.ChannelFutureListener;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.ChannelPromise;
import io.netty.handler.codec.http2.DefaultHttp2RemoteFlowController;
import io.netty.handler.codec.http2.Http2Connection;
import io.netty.handler.codec.http2.Http2ConnectionEncoder;
import io.netty.handler.codec.http2.Http2Error;
import io.netty.handler.codec.http2.Http2Exception;
import io.netty.handler.codec.http2.Http2Flags;
import io.netty.handler.codec.http2.Http2FrameSizePolicy;
import io.netty.handler.codec.http2.Http2FrameWriter;
import io.netty.handler.codec.http2.Http2HeaderTable;
import io.netty.handler.codec.http2.Http2Headers;
import io.netty.handler.codec.http2.Http2LifecycleManager;
import io.netty.handler.codec.http2.Http2NoMoreStreamIdsException;
import io.netty.handler.codec.http2.Http2RemoteFlowController;
import io.netty.handler.codec.http2.Http2Settings;
import io.netty.handler.codec.http2.Http2Stream;
import io.netty.util.ReferenceCountUtil;
import io.netty.util.concurrent.GenericFutureListener;
import io.netty.util.internal.ObjectUtil;
import java.util.ArrayDeque;

public class DefaultHttp2ConnectionEncoder
implements Http2ConnectionEncoder {
    private final Http2FrameWriter frameWriter;
    private final Http2Connection connection;
    private Http2LifecycleManager lifecycleManager;
    private final ArrayDeque<Http2Settings> outstandingLocalSettingsQueue = new ArrayDeque(4);

    public DefaultHttp2ConnectionEncoder(Http2Connection connection, Http2FrameWriter frameWriter) {
        this.connection = (Http2Connection)ObjectUtil.checkNotNull((Object)connection, (String)"connection");
        this.frameWriter = (Http2FrameWriter)ObjectUtil.checkNotNull((Object)frameWriter, (String)"frameWriter");
        if (connection.remote().flowController() == null) {
            connection.remote().flowController(new DefaultHttp2RemoteFlowController(connection));
        }
    }

    @Override
    public void lifecycleManager(Http2LifecycleManager lifecycleManager) {
        this.lifecycleManager = (Http2LifecycleManager)ObjectUtil.checkNotNull((Object)lifecycleManager, (String)"lifecycleManager");
    }

    @Override
    public Http2FrameWriter frameWriter() {
        return this.frameWriter;
    }

    @Override
    public Http2Connection connection() {
        return this.connection;
    }

    @Override
    public final Http2RemoteFlowController flowController() {
        return this.connection().remote().flowController();
    }

    @Override
    public void remoteSettings(Http2Settings settings) throws Http2Exception {
        Integer initialWindowSize;
        Integer maxFrameSize;
        Integer maxHeaderListSize;
        Long headerTableSize;
        Long maxConcurrentStreams;
        Boolean pushEnabled = settings.pushEnabled();
        Http2FrameWriter.Configuration config = this.configuration();
        Http2HeaderTable outboundHeaderTable = config.headerTable();
        Http2FrameSizePolicy outboundFrameSizePolicy = config.frameSizePolicy();
        if (pushEnabled != null) {
            if (!this.connection.isServer()) {
                throw Http2Exception.connectionError(Http2Error.PROTOCOL_ERROR, "Client received SETTINGS frame with ENABLE_PUSH specified", new Object[0]);
            }
            this.connection.remote().allowPushTo(pushEnabled);
        }
        if ((maxConcurrentStreams = settings.maxConcurrentStreams()) != null) {
            this.connection.local().maxActiveStreams((int)Math.min(maxConcurrentStreams, Integer.MAX_VALUE));
        }
        if ((headerTableSize = settings.headerTableSize()) != null) {
            outboundHeaderTable.maxHeaderTableSize((int)Math.min(headerTableSize, Integer.MAX_VALUE));
        }
        if ((maxHeaderListSize = settings.maxHeaderListSize()) != null) {
            outboundHeaderTable.maxHeaderListSize(maxHeaderListSize);
        }
        if ((maxFrameSize = settings.maxFrameSize()) != null) {
            outboundFrameSizePolicy.maxFrameSize(maxFrameSize);
        }
        if ((initialWindowSize = settings.initialWindowSize()) != null) {
            this.flowController().initialWindowSize(initialWindowSize);
        }
    }

    @Override
    public ChannelFuture writeData(ChannelHandlerContext ctx, int streamId, ByteBuf data, int padding, boolean endOfStream, ChannelPromise promise) {
        Http2Stream stream;
        try {
            stream = this.requireStream(streamId);
            switch (stream.state()) {
                case OPEN: 
                case HALF_CLOSED_REMOTE: {
                    break;
                }
                default: {
                    throw new IllegalStateException(String.format("Stream %d in unexpected state: %s", new Object[]{stream.id(), stream.state()}));
                }
            }
        }
        catch (Throwable e) {
            data.release();
            return promise.setFailure(e);
        }
        this.flowController().sendFlowControlled(ctx, stream, new FlowControlledData(ctx, stream, data, padding, endOfStream, promise));
        return promise;
    }

    @Override
    public ChannelFuture writeHeaders(ChannelHandlerContext ctx, int streamId, Http2Headers headers, int padding, boolean endStream, ChannelPromise promise) {
        return this.writeHeaders(ctx, streamId, headers, 0, (short)16, false, padding, endStream, promise);
    }

    @Override
    public ChannelFuture writeHeaders(ChannelHandlerContext ctx, int streamId, Http2Headers headers, int streamDependency, short weight, boolean exclusive, int padding, boolean endOfStream, ChannelPromise promise) {
        try {
            Http2Stream stream = this.connection.stream(streamId);
            if (stream == null) {
                stream = this.connection.local().createStream(streamId, endOfStream);
            } else {
                switch (stream.state()) {
                    case RESERVED_LOCAL: {
                        stream.open(endOfStream);
                        break;
                    }
                    case OPEN: 
                    case HALF_CLOSED_REMOTE: {
                        break;
                    }
                    default: {
                        throw new IllegalStateException(String.format("Stream %d in unexpected state: %s", new Object[]{stream.id(), stream.state()}));
                    }
                }
            }
            this.flowController().sendFlowControlled(ctx, stream, new FlowControlledHeaders(ctx, stream, headers, streamDependency, weight, exclusive, padding, endOfStream, promise));
            return promise;
        }
        catch (Http2NoMoreStreamIdsException e) {
            this.lifecycleManager.onException(ctx, e);
            return promise.setFailure((Throwable)e);
        }
        catch (Throwable e) {
            return promise.setFailure(e);
        }
    }

    @Override
    public ChannelFuture writePriority(ChannelHandlerContext ctx, int streamId, int streamDependency, short weight, boolean exclusive, ChannelPromise promise) {
        try {
            Http2Stream stream = this.connection.stream(streamId);
            if (stream == null) {
                stream = this.connection.local().createIdleStream(streamId);
            }
            stream.setPriority(streamDependency, weight, exclusive);
        }
        catch (Http2Exception.ClosedStreamCreationException stream) {
        }
        catch (Throwable t) {
            return promise.setFailure(t);
        }
        ChannelFuture future = this.frameWriter.writePriority(ctx, streamId, streamDependency, weight, exclusive, promise);
        return future;
    }

    @Override
    public ChannelFuture writeRstStream(ChannelHandlerContext ctx, int streamId, long errorCode, ChannelPromise promise) {
        return this.lifecycleManager.resetStream(ctx, streamId, errorCode, promise);
    }

    @Override
    public ChannelFuture writeSettings(ChannelHandlerContext ctx, Http2Settings settings, ChannelPromise promise) {
        this.outstandingLocalSettingsQueue.add(settings);
        try {
            Boolean pushEnabled = settings.pushEnabled();
            if (pushEnabled != null && this.connection.isServer()) {
                throw Http2Exception.connectionError(Http2Error.PROTOCOL_ERROR, "Server sending SETTINGS frame with ENABLE_PUSH specified", new Object[0]);
            }
        }
        catch (Throwable e) {
            return promise.setFailure(e);
        }
        ChannelFuture future = this.frameWriter.writeSettings(ctx, settings, promise);
        return future;
    }

    @Override
    public ChannelFuture writeSettingsAck(ChannelHandlerContext ctx, ChannelPromise promise) {
        ChannelFuture future = this.frameWriter.writeSettingsAck(ctx, promise);
        return future;
    }

    @Override
    public ChannelFuture writePing(ChannelHandlerContext ctx, boolean ack, ByteBuf data, ChannelPromise promise) {
        ChannelFuture future = this.frameWriter.writePing(ctx, ack, data, promise);
        return future;
    }

    @Override
    public ChannelFuture writePushPromise(ChannelHandlerContext ctx, int streamId, int promisedStreamId, Http2Headers headers, int padding, ChannelPromise promise) {
        try {
            if (this.connection.goAwayReceived()) {
                throw Http2Exception.connectionError(Http2Error.PROTOCOL_ERROR, "Sending PUSH_PROMISE after GO_AWAY received.", new Object[0]);
            }
            Http2Stream stream = this.requireStream(streamId);
            this.connection.local().reservePushStream(promisedStreamId, stream);
        }
        catch (Throwable e) {
            return promise.setFailure(e);
        }
        ChannelFuture future = this.frameWriter.writePushPromise(ctx, streamId, promisedStreamId, headers, padding, promise);
        return future;
    }

    @Override
    public ChannelFuture writeGoAway(ChannelHandlerContext ctx, int lastStreamId, long errorCode, ByteBuf debugData, ChannelPromise promise) {
        return this.lifecycleManager.goAway(ctx, lastStreamId, errorCode, debugData, promise);
    }

    @Override
    public ChannelFuture writeWindowUpdate(ChannelHandlerContext ctx, int streamId, int windowSizeIncrement, ChannelPromise promise) {
        return promise.setFailure((Throwable)new UnsupportedOperationException("Use the Http2[Inbound|Outbound]FlowController objects to control window sizes"));
    }

    @Override
    public ChannelFuture writeFrame(ChannelHandlerContext ctx, byte frameType, int streamId, Http2Flags flags, ByteBuf payload, ChannelPromise promise) {
        return this.frameWriter.writeFrame(ctx, frameType, streamId, flags, payload, promise);
    }

    @Override
    public void close() {
        this.frameWriter.close();
    }

    @Override
    public Http2Settings pollSentSettings() {
        return this.outstandingLocalSettingsQueue.poll();
    }

    @Override
    public Http2FrameWriter.Configuration configuration() {
        return this.frameWriter.configuration();
    }

    private Http2Stream requireStream(int streamId) {
        Http2Stream stream = this.connection.stream(streamId);
        if (stream == null) {
            String message = this.connection.streamMayHaveExisted(streamId) ? "Stream no longer exists: " + streamId : "Stream does not exist: " + streamId;
            throw new IllegalArgumentException(message);
        }
        return stream;
    }

    public abstract class FlowControlledBase
    implements Http2RemoteFlowController.FlowControlled,
    ChannelFutureListener {
        protected final ChannelHandlerContext ctx;
        protected final Http2Stream stream;
        protected final ChannelPromise promise;
        protected final boolean endOfStream;
        protected int padding;

        public FlowControlledBase(ChannelHandlerContext ctx, Http2Stream stream, int padding, boolean endOfStream, ChannelPromise promise) {
            this.ctx = ctx;
            if (padding < 0) {
                throw new IllegalArgumentException("padding must be >= 0");
            }
            this.padding = padding;
            this.endOfStream = endOfStream;
            this.stream = stream;
            this.promise = promise;
            promise.addListener((GenericFutureListener)this);
        }

        @Override
        public void writeComplete() {
            if (this.endOfStream) {
                DefaultHttp2ConnectionEncoder.this.lifecycleManager.closeStreamLocal(this.stream, (ChannelFuture)this.promise);
            }
        }

        public void operationComplete(ChannelFuture future) throws Exception {
            if (!future.isSuccess()) {
                this.error(future.cause());
            }
        }
    }

    private final class FlowControlledHeaders
    extends FlowControlledBase {
        private final Http2Headers headers;
        private final int streamDependency;
        private final short weight;
        private final boolean exclusive;

        private FlowControlledHeaders(ChannelHandlerContext ctx, Http2Stream stream, Http2Headers headers, int streamDependency, short weight, boolean exclusive, int padding, boolean endOfStream, ChannelPromise promise) {
            super(ctx, stream, padding, endOfStream, promise);
            this.headers = headers;
            this.streamDependency = streamDependency;
            this.weight = weight;
            this.exclusive = exclusive;
        }

        @Override
        public int size() {
            return 0;
        }

        @Override
        public void error(Throwable cause) {
            DefaultHttp2ConnectionEncoder.this.lifecycleManager.onException(this.ctx, cause);
            this.promise.tryFailure(cause);
        }

        @Override
        public void write(int allowedBytes) {
            DefaultHttp2ConnectionEncoder.this.frameWriter().writeHeaders(this.ctx, this.stream.id(), this.headers, this.streamDependency, this.weight, this.exclusive, this.padding, this.endOfStream, this.promise);
        }
    }

    private final class FlowControlledData
    extends FlowControlledBase {
        private ByteBuf data;
        private int size;

        private FlowControlledData(ChannelHandlerContext ctx, Http2Stream stream, ByteBuf data, int padding, boolean endOfStream, ChannelPromise promise) {
            super(ctx, stream, padding, endOfStream, promise);
            this.data = data;
            this.size = data.readableBytes() + padding;
        }

        @Override
        public int size() {
            return this.size;
        }

        @Override
        public void error(Throwable cause) {
            ReferenceCountUtil.safeRelease((Object)this.data);
            DefaultHttp2ConnectionEncoder.this.lifecycleManager.onException(this.ctx, cause);
            this.data = null;
            this.size = 0;
            this.promise.tryFailure(cause);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void write(int allowedBytes) {
            int bytesWritten = 0;
            if (this.data == null || allowedBytes == 0 && this.size != 0) {
                return;
            }
            try {
                int maxFrameSize = DefaultHttp2ConnectionEncoder.this.frameWriter().configuration().frameSizePolicy().maxFrameSize();
                do {
                    ChannelPromise writePromise;
                    ByteBuf toWrite;
                    int allowedFrameSize = Math.min(maxFrameSize, allowedBytes - bytesWritten);
                    int writeableData = this.data.readableBytes();
                    if (writeableData > allowedFrameSize) {
                        writeableData = allowedFrameSize;
                        toWrite = this.data.readSlice(writeableData).retain();
                    } else {
                        toWrite = this.data;
                        this.data = Unpooled.EMPTY_BUFFER;
                    }
                    int writeablePadding = Math.min(allowedFrameSize - writeableData, this.padding);
                    this.padding -= writeablePadding;
                    if (this.size == (bytesWritten += writeableData + writeablePadding)) {
                        writePromise = this.promise;
                    } else {
                        writePromise = this.ctx.newPromise();
                        writePromise.addListener((GenericFutureListener)this);
                    }
                    DefaultHttp2ConnectionEncoder.this.frameWriter().writeData(this.ctx, this.stream.id(), toWrite, writeablePadding, this.size == bytesWritten && this.endOfStream, writePromise);
                } while (this.size != bytesWritten && allowedBytes > bytesWritten);
            }
            finally {
                this.size -= bytesWritten;
            }
        }
    }
}

