/*
 * Decompiled with CFR 0.152.
 */
package io.netty.handler.codec.http2;

import io.netty.buffer.ByteBuf;
import io.netty.buffer.Unpooled;
import io.netty.channel.ChannelFuture;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.ChannelPromise;
import io.netty.channel.ChannelPromiseAggregator;
import io.netty.channel.embedded.EmbeddedChannel;
import io.netty.handler.codec.AsciiString;
import io.netty.handler.codec.compression.ZlibCodecFactory;
import io.netty.handler.codec.compression.ZlibWrapper;
import io.netty.handler.codec.http.HttpHeaderNames;
import io.netty.handler.codec.http.HttpHeaderValues;
import io.netty.handler.codec.http2.DefaultHttp2ConnectionEncoder;
import io.netty.handler.codec.http2.Http2ConnectionAdapter;
import io.netty.handler.codec.http2.Http2Exception;
import io.netty.handler.codec.http2.Http2Headers;
import io.netty.handler.codec.http2.Http2Stream;
import io.netty.util.concurrent.Promise;

public class CompressorHttp2ConnectionEncoder
extends DefaultHttp2ConnectionEncoder {
    private static final Http2ConnectionAdapter CLEAN_UP_LISTENER = new Http2ConnectionAdapter(){

        @Override
        public void streamRemoved(Http2Stream stream) {
            EmbeddedChannel compressor = (EmbeddedChannel)stream.getProperty(CompressorHttp2ConnectionEncoder.class);
            if (compressor != null) {
                CompressorHttp2ConnectionEncoder.cleanup(stream, compressor);
            }
        }
    };
    private final int compressionLevel;
    private final int windowBits;
    private final int memLevel;

    protected CompressorHttp2ConnectionEncoder(Builder builder) {
        super(builder);
        if (builder.compressionLevel < 0 || builder.compressionLevel > 9) {
            throw new IllegalArgumentException("compressionLevel: " + builder.compressionLevel + " (expected: 0-9)");
        }
        if (builder.windowBits < 9 || builder.windowBits > 15) {
            throw new IllegalArgumentException("windowBits: " + builder.windowBits + " (expected: 9-15)");
        }
        if (builder.memLevel < 1 || builder.memLevel > 9) {
            throw new IllegalArgumentException("memLevel: " + builder.memLevel + " (expected: 1-9)");
        }
        this.compressionLevel = builder.compressionLevel;
        this.windowBits = builder.windowBits;
        this.memLevel = builder.memLevel;
        this.connection().addListener(CLEAN_UP_LISTENER);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ChannelFuture writeData(ChannelHandlerContext ctx, int streamId, ByteBuf data, int padding, boolean endOfStream, ChannelPromise promise) {
        EmbeddedChannel channel;
        Http2Stream stream = this.connection().stream(streamId);
        EmbeddedChannel embeddedChannel = channel = stream == null ? null : (EmbeddedChannel)stream.getProperty(CompressorHttp2ConnectionEncoder.class);
        if (channel == null) {
            return super.writeData(ctx, streamId, data, padding, endOfStream, promise);
        }
        try {
            channel.writeOutbound(new Object[]{data});
            ByteBuf buf = CompressorHttp2ConnectionEncoder.nextReadableBuf(channel);
            if (buf == null) {
                if (endOfStream) {
                    if (channel.finish()) {
                        buf = CompressorHttp2ConnectionEncoder.nextReadableBuf(channel);
                    }
                    ChannelFuture channelFuture = super.writeData(ctx, streamId, buf == null ? Unpooled.EMPTY_BUFFER : buf, padding, true, promise);
                    return channelFuture;
                }
                promise.setSuccess();
                ChannelPromise channelPromise = promise;
                return channelPromise;
            }
            ChannelPromiseAggregator aggregator = new ChannelPromiseAggregator(promise);
            ChannelPromise bufPromise = ctx.newPromise();
            aggregator.add(new Promise[]{bufPromise});
            while (true) {
                ChannelPromise nextPromise;
                ByteBuf nextBuf;
                boolean compressedEndOfStream;
                boolean bl = compressedEndOfStream = (nextBuf = CompressorHttp2ConnectionEncoder.nextReadableBuf(channel)) == null && endOfStream;
                if (compressedEndOfStream && channel.finish()) {
                    nextBuf = CompressorHttp2ConnectionEncoder.nextReadableBuf(channel);
                    boolean bl2 = compressedEndOfStream = nextBuf == null;
                }
                if (nextBuf != null) {
                    nextPromise = ctx.newPromise();
                    aggregator.add(new Promise[]{nextPromise});
                } else {
                    nextPromise = null;
                }
                super.writeData(ctx, streamId, buf, padding, compressedEndOfStream, bufPromise);
                if (nextBuf == null) break;
                padding = 0;
                buf = nextBuf;
                bufPromise = nextPromise;
            }
            ChannelPromise channelPromise = promise;
            return channelPromise;
        }
        finally {
            if (endOfStream) {
                CompressorHttp2ConnectionEncoder.cleanup(stream, channel);
            }
        }
    }

    @Override
    public ChannelFuture writeHeaders(ChannelHandlerContext ctx, int streamId, Http2Headers headers, int padding, boolean endStream, ChannelPromise promise) {
        this.initCompressor(streamId, headers, endStream);
        return super.writeHeaders(ctx, streamId, headers, padding, endStream, promise);
    }

    @Override
    public ChannelFuture writeHeaders(ChannelHandlerContext ctx, int streamId, Http2Headers headers, int streamDependency, short weight, boolean exclusive, int padding, boolean endOfStream, ChannelPromise promise) {
        this.initCompressor(streamId, headers, endOfStream);
        return super.writeHeaders(ctx, streamId, headers, streamDependency, weight, exclusive, padding, endOfStream, promise);
    }

    protected EmbeddedChannel newContentCompressor(AsciiString contentEncoding) throws Http2Exception {
        if (HttpHeaderValues.GZIP.equalsIgnoreCase((CharSequence)contentEncoding) || HttpHeaderValues.X_GZIP.equalsIgnoreCase((CharSequence)contentEncoding)) {
            return this.newCompressionChannel(ZlibWrapper.GZIP);
        }
        if (HttpHeaderValues.DEFLATE.equalsIgnoreCase((CharSequence)contentEncoding) || HttpHeaderValues.X_DEFLATE.equalsIgnoreCase((CharSequence)contentEncoding)) {
            return this.newCompressionChannel(ZlibWrapper.ZLIB);
        }
        return null;
    }

    protected AsciiString getTargetContentEncoding(AsciiString contentEncoding) throws Http2Exception {
        return contentEncoding;
    }

    private EmbeddedChannel newCompressionChannel(ZlibWrapper wrapper) {
        return new EmbeddedChannel(new ChannelHandler[]{ZlibCodecFactory.newZlibEncoder((ZlibWrapper)wrapper, (int)this.compressionLevel, (int)this.windowBits, (int)this.memLevel)});
    }

    private void initCompressor(int streamId, Http2Headers headers, boolean endOfStream) {
        EmbeddedChannel compressor;
        block10: {
            Http2Stream stream = this.connection().stream(streamId);
            if (stream == null) {
                return;
            }
            compressor = (EmbeddedChannel)stream.getProperty(CompressorHttp2ConnectionEncoder.class);
            if (compressor == null) {
                if (!endOfStream) {
                    AsciiString encoding = (AsciiString)headers.get(HttpHeaderNames.CONTENT_ENCODING);
                    if (encoding == null) {
                        encoding = HttpHeaderValues.IDENTITY;
                    }
                    try {
                        compressor = this.newContentCompressor(encoding);
                        if (compressor == null) break block10;
                        stream.setProperty(CompressorHttp2ConnectionEncoder.class, compressor);
                        AsciiString targetContentEncoding = this.getTargetContentEncoding(encoding);
                        if (HttpHeaderValues.IDENTITY.equalsIgnoreCase((CharSequence)targetContentEncoding)) {
                            headers.remove(HttpHeaderNames.CONTENT_ENCODING);
                            break block10;
                        }
                        headers.set(HttpHeaderNames.CONTENT_ENCODING, targetContentEncoding);
                    }
                    catch (Throwable throwable) {}
                }
            } else if (endOfStream) {
                CompressorHttp2ConnectionEncoder.cleanup(stream, compressor);
            }
        }
        if (compressor != null) {
            headers.remove(HttpHeaderNames.CONTENT_LENGTH);
        }
    }

    private static void cleanup(Http2Stream stream, EmbeddedChannel compressor) {
        if (compressor.finish()) {
            ByteBuf buf;
            while ((buf = (ByteBuf)compressor.readOutbound()) != null) {
                buf.release();
            }
        }
        stream.removeProperty(CompressorHttp2ConnectionEncoder.class);
    }

    private static ByteBuf nextReadableBuf(EmbeddedChannel compressor) {
        ByteBuf buf;
        while (true) {
            if ((buf = (ByteBuf)compressor.readOutbound()) == null) {
                return null;
            }
            if (buf.isReadable()) break;
            buf.release();
        }
        return buf;
    }

    public static class Builder
    extends DefaultHttp2ConnectionEncoder.Builder {
        protected int compressionLevel = 6;
        protected int windowBits = 15;
        protected int memLevel = 8;

        public Builder compressionLevel(int compressionLevel) {
            this.compressionLevel = compressionLevel;
            return this;
        }

        public Builder windowBits(int windowBits) {
            this.windowBits = windowBits;
            return this;
        }

        public Builder memLevel(int memLevel) {
            this.memLevel = memLevel;
            return this;
        }

        @Override
        public CompressorHttp2ConnectionEncoder build() {
            return new CompressorHttp2ConnectionEncoder(this);
        }
    }
}

