/*
 * Decompiled with CFR 0.152.
 */
package io.netty.handler.codec.http;

import io.netty.handler.codec.http.CombinedHttpHeaders;
import io.netty.handler.codec.http.DefaultHttpHeaders;
import io.netty.handler.codec.http.HttpHeaderNames;
import io.netty.handler.codec.http.HttpHeaders;
import io.netty.handler.codec.http.HttpHeadersTestUtils;
import io.netty.util.AsciiString;
import java.util.Arrays;
import java.util.Collections;
import java.util.Iterator;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;
import org.junit.Assert;
import org.junit.Test;

public class CombinedHttpHeadersTest {
    private static final CharSequence HEADER_NAME = "testHeader";

    @Test
    public void addCharSequencesCsv() {
        CombinedHttpHeaders headers = CombinedHttpHeadersTest.newCombinedHttpHeaders();
        headers.add(HEADER_NAME, HttpHeadersTestUtils.HeaderValue.THREE.asList());
        CombinedHttpHeadersTest.assertCsvValues(headers, HttpHeadersTestUtils.HeaderValue.THREE);
    }

    @Test
    public void addCharSequencesCsvWithExistingHeader() {
        CombinedHttpHeaders headers = CombinedHttpHeadersTest.newCombinedHttpHeaders();
        headers.add(HEADER_NAME, HttpHeadersTestUtils.HeaderValue.THREE.asList());
        headers.add(HEADER_NAME, HttpHeadersTestUtils.HeaderValue.FIVE.subset(4));
        CombinedHttpHeadersTest.assertCsvValues(headers, HttpHeadersTestUtils.HeaderValue.FIVE);
    }

    @Test
    public void addCombinedHeadersWhenEmpty() {
        CombinedHttpHeaders headers = CombinedHttpHeadersTest.newCombinedHttpHeaders();
        CombinedHttpHeaders otherHeaders = CombinedHttpHeadersTest.newCombinedHttpHeaders();
        otherHeaders.add(HEADER_NAME, (Object)"a");
        otherHeaders.add(HEADER_NAME, (Object)"b");
        headers.add((HttpHeaders)otherHeaders);
        Assert.assertEquals((Object)"a,b", (Object)headers.get(HEADER_NAME));
    }

    @Test
    public void addCombinedHeadersWhenNotEmpty() {
        CombinedHttpHeaders headers = CombinedHttpHeadersTest.newCombinedHttpHeaders();
        headers.add(HEADER_NAME, (Object)"a");
        CombinedHttpHeaders otherHeaders = CombinedHttpHeadersTest.newCombinedHttpHeaders();
        otherHeaders.add(HEADER_NAME, (Object)"b");
        otherHeaders.add(HEADER_NAME, (Object)"c");
        headers.add((HttpHeaders)otherHeaders);
        Assert.assertEquals((Object)"a,b,c", (Object)headers.get(HEADER_NAME));
    }

    @Test
    public void dontCombineSetCookieHeaders() {
        CombinedHttpHeaders headers = CombinedHttpHeadersTest.newCombinedHttpHeaders();
        headers.add((CharSequence)HttpHeaderNames.SET_COOKIE, (Object)"a");
        CombinedHttpHeaders otherHeaders = CombinedHttpHeadersTest.newCombinedHttpHeaders();
        otherHeaders.add((CharSequence)HttpHeaderNames.SET_COOKIE, (Object)"b");
        otherHeaders.add((CharSequence)HttpHeaderNames.SET_COOKIE, (Object)"c");
        headers.add((HttpHeaders)otherHeaders);
        MatcherAssert.assertThat((Object)headers.getAll((CharSequence)HttpHeaderNames.SET_COOKIE), (Matcher)Matchers.hasSize((int)3));
    }

    @Test
    public void dontCombineSetCookieHeadersRegardlessOfCase() {
        CombinedHttpHeaders headers = CombinedHttpHeadersTest.newCombinedHttpHeaders();
        headers.add("Set-Cookie", (Object)"a");
        CombinedHttpHeaders otherHeaders = CombinedHttpHeadersTest.newCombinedHttpHeaders();
        otherHeaders.add("set-cookie", (Object)"b");
        otherHeaders.add("SET-COOKIE", (Object)"c");
        headers.add((HttpHeaders)otherHeaders);
        MatcherAssert.assertThat((Object)headers.getAll((CharSequence)HttpHeaderNames.SET_COOKIE), (Matcher)Matchers.hasSize((int)3));
    }

    @Test
    public void setCombinedHeadersWhenNotEmpty() {
        CombinedHttpHeaders headers = CombinedHttpHeadersTest.newCombinedHttpHeaders();
        headers.add(HEADER_NAME, (Object)"a");
        CombinedHttpHeaders otherHeaders = CombinedHttpHeadersTest.newCombinedHttpHeaders();
        otherHeaders.add(HEADER_NAME, (Object)"b");
        otherHeaders.add(HEADER_NAME, (Object)"c");
        headers.set((HttpHeaders)otherHeaders);
        Assert.assertEquals((Object)"b,c", (Object)headers.get(HEADER_NAME));
    }

    @Test
    public void addUncombinedHeaders() {
        CombinedHttpHeaders headers = CombinedHttpHeadersTest.newCombinedHttpHeaders();
        headers.add(HEADER_NAME, (Object)"a");
        DefaultHttpHeaders otherHeaders = new DefaultHttpHeaders();
        otherHeaders.add(HEADER_NAME, (Object)"b");
        otherHeaders.add(HEADER_NAME, (Object)"c");
        headers.add((HttpHeaders)otherHeaders);
        Assert.assertEquals((Object)"a,b,c", (Object)headers.get(HEADER_NAME));
    }

    @Test
    public void setUncombinedHeaders() {
        CombinedHttpHeaders headers = CombinedHttpHeadersTest.newCombinedHttpHeaders();
        headers.add(HEADER_NAME, (Object)"a");
        DefaultHttpHeaders otherHeaders = new DefaultHttpHeaders();
        otherHeaders.add(HEADER_NAME, (Object)"b");
        otherHeaders.add(HEADER_NAME, (Object)"c");
        headers.set((HttpHeaders)otherHeaders);
        Assert.assertEquals((Object)"b,c", (Object)headers.get(HEADER_NAME));
    }

    @Test
    public void addCharSequencesCsvWithValueContainingComma() {
        CombinedHttpHeaders headers = CombinedHttpHeadersTest.newCombinedHttpHeaders();
        headers.add(HEADER_NAME, HttpHeadersTestUtils.HeaderValue.SIX_QUOTED.subset(4));
        Assert.assertTrue((boolean)AsciiString.contentEquals((CharSequence)HttpHeadersTestUtils.HeaderValue.SIX_QUOTED.subsetAsCsvString(4), (CharSequence)headers.get(HEADER_NAME)));
        Assert.assertEquals(HttpHeadersTestUtils.HeaderValue.SIX_QUOTED.subset(4), (Object)headers.getAll(HEADER_NAME));
    }

    @Test
    public void addCharSequencesCsvWithValueContainingCommas() {
        CombinedHttpHeaders headers = CombinedHttpHeadersTest.newCombinedHttpHeaders();
        headers.add(HEADER_NAME, HttpHeadersTestUtils.HeaderValue.EIGHT.subset(6));
        Assert.assertTrue((boolean)AsciiString.contentEquals((CharSequence)HttpHeadersTestUtils.HeaderValue.EIGHT.subsetAsCsvString(6), (CharSequence)headers.get(HEADER_NAME)));
        Assert.assertEquals(HttpHeadersTestUtils.HeaderValue.EIGHT.subset(6), (Object)headers.getAll(HEADER_NAME));
    }

    @Test(expected=NullPointerException.class)
    public void addCharSequencesCsvNullValue() {
        CombinedHttpHeaders headers = CombinedHttpHeadersTest.newCombinedHttpHeaders();
        Object value = null;
        headers.add(HEADER_NAME, value);
    }

    @Test
    public void addCharSequencesCsvMultipleTimes() {
        CombinedHttpHeaders headers = CombinedHttpHeadersTest.newCombinedHttpHeaders();
        for (int i = 0; i < 5; ++i) {
            headers.add(HEADER_NAME, (Object)"value");
        }
        Assert.assertTrue((boolean)AsciiString.contentEquals((CharSequence)"value,value,value,value,value", (CharSequence)headers.get(HEADER_NAME)));
    }

    @Test
    public void addCharSequenceCsv() {
        CombinedHttpHeaders headers = CombinedHttpHeadersTest.newCombinedHttpHeaders();
        CombinedHttpHeadersTest.addValues(headers, HttpHeadersTestUtils.HeaderValue.ONE, HttpHeadersTestUtils.HeaderValue.TWO, HttpHeadersTestUtils.HeaderValue.THREE);
        CombinedHttpHeadersTest.assertCsvValues(headers, HttpHeadersTestUtils.HeaderValue.THREE);
    }

    @Test
    public void addCharSequenceCsvSingleValue() {
        CombinedHttpHeaders headers = CombinedHttpHeadersTest.newCombinedHttpHeaders();
        CombinedHttpHeadersTest.addValues(headers, HttpHeadersTestUtils.HeaderValue.ONE);
        CombinedHttpHeadersTest.assertCsvValue(headers, HttpHeadersTestUtils.HeaderValue.ONE);
    }

    @Test
    public void addIterableCsv() {
        CombinedHttpHeaders headers = CombinedHttpHeadersTest.newCombinedHttpHeaders();
        headers.add(HEADER_NAME, HttpHeadersTestUtils.HeaderValue.THREE.asList());
        CombinedHttpHeadersTest.assertCsvValues(headers, HttpHeadersTestUtils.HeaderValue.THREE);
    }

    @Test
    public void addIterableCsvWithExistingHeader() {
        CombinedHttpHeaders headers = CombinedHttpHeadersTest.newCombinedHttpHeaders();
        headers.add(HEADER_NAME, HttpHeadersTestUtils.HeaderValue.THREE.asList());
        headers.add(HEADER_NAME, HttpHeadersTestUtils.HeaderValue.FIVE.subset(4));
        CombinedHttpHeadersTest.assertCsvValues(headers, HttpHeadersTestUtils.HeaderValue.FIVE);
    }

    @Test
    public void addIterableCsvSingleValue() {
        CombinedHttpHeaders headers = CombinedHttpHeadersTest.newCombinedHttpHeaders();
        headers.add(HEADER_NAME, HttpHeadersTestUtils.HeaderValue.ONE.asList());
        CombinedHttpHeadersTest.assertCsvValue(headers, HttpHeadersTestUtils.HeaderValue.ONE);
    }

    @Test
    public void addIterableCsvEmpty() {
        CombinedHttpHeaders headers = CombinedHttpHeadersTest.newCombinedHttpHeaders();
        headers.add(HEADER_NAME, Collections.emptyList());
        Assert.assertEquals(Collections.singletonList(""), (Object)headers.getAll(HEADER_NAME));
    }

    @Test
    public void addObjectCsv() {
        CombinedHttpHeaders headers = CombinedHttpHeadersTest.newCombinedHttpHeaders();
        CombinedHttpHeadersTest.addObjectValues(headers, HttpHeadersTestUtils.HeaderValue.ONE, HttpHeadersTestUtils.HeaderValue.TWO, HttpHeadersTestUtils.HeaderValue.THREE);
        CombinedHttpHeadersTest.assertCsvValues(headers, HttpHeadersTestUtils.HeaderValue.THREE);
    }

    @Test
    public void addObjectsCsv() {
        CombinedHttpHeaders headers = CombinedHttpHeadersTest.newCombinedHttpHeaders();
        headers.add(HEADER_NAME, HttpHeadersTestUtils.HeaderValue.THREE.asList());
        CombinedHttpHeadersTest.assertCsvValues(headers, HttpHeadersTestUtils.HeaderValue.THREE);
    }

    @Test
    public void addObjectsIterableCsv() {
        CombinedHttpHeaders headers = CombinedHttpHeadersTest.newCombinedHttpHeaders();
        headers.add(HEADER_NAME, HttpHeadersTestUtils.HeaderValue.THREE.asList());
        CombinedHttpHeadersTest.assertCsvValues(headers, HttpHeadersTestUtils.HeaderValue.THREE);
    }

    @Test
    public void addObjectsCsvWithExistingHeader() {
        CombinedHttpHeaders headers = CombinedHttpHeadersTest.newCombinedHttpHeaders();
        headers.add(HEADER_NAME, HttpHeadersTestUtils.HeaderValue.THREE.asList());
        headers.add(HEADER_NAME, HttpHeadersTestUtils.HeaderValue.FIVE.subset(4));
        CombinedHttpHeadersTest.assertCsvValues(headers, HttpHeadersTestUtils.HeaderValue.FIVE);
    }

    @Test
    public void setCharSequenceCsv() {
        CombinedHttpHeaders headers = CombinedHttpHeadersTest.newCombinedHttpHeaders();
        headers.set(HEADER_NAME, HttpHeadersTestUtils.HeaderValue.THREE.asList());
        CombinedHttpHeadersTest.assertCsvValues(headers, HttpHeadersTestUtils.HeaderValue.THREE);
    }

    @Test
    public void setIterableCsv() {
        CombinedHttpHeaders headers = CombinedHttpHeadersTest.newCombinedHttpHeaders();
        headers.set(HEADER_NAME, HttpHeadersTestUtils.HeaderValue.THREE.asList());
        CombinedHttpHeadersTest.assertCsvValues(headers, HttpHeadersTestUtils.HeaderValue.THREE);
    }

    @Test
    public void setObjectObjectsCsv() {
        CombinedHttpHeaders headers = CombinedHttpHeadersTest.newCombinedHttpHeaders();
        headers.set(HEADER_NAME, HttpHeadersTestUtils.HeaderValue.THREE.asList());
        CombinedHttpHeadersTest.assertCsvValues(headers, HttpHeadersTestUtils.HeaderValue.THREE);
    }

    @Test
    public void setObjectIterableCsv() {
        CombinedHttpHeaders headers = CombinedHttpHeadersTest.newCombinedHttpHeaders();
        headers.set(HEADER_NAME, HttpHeadersTestUtils.HeaderValue.THREE.asList());
        CombinedHttpHeadersTest.assertCsvValues(headers, HttpHeadersTestUtils.HeaderValue.THREE);
    }

    private static CombinedHttpHeaders newCombinedHttpHeaders() {
        return new CombinedHttpHeaders(true);
    }

    private static void assertCsvValues(CombinedHttpHeaders headers, HttpHeadersTestUtils.HeaderValue headerValue) {
        Assert.assertTrue((boolean)AsciiString.contentEquals((CharSequence)headerValue.asCsv(), (CharSequence)headers.get(HEADER_NAME)));
        Assert.assertEquals(headerValue.asList(), (Object)headers.getAll(HEADER_NAME));
    }

    private static void assertCsvValue(CombinedHttpHeaders headers, HttpHeadersTestUtils.HeaderValue headerValue) {
        Assert.assertTrue((boolean)AsciiString.contentEquals((CharSequence)headerValue.toString(), (CharSequence)headers.get(HEADER_NAME)));
        Assert.assertTrue((boolean)AsciiString.contentEquals((CharSequence)headerValue.toString(), (CharSequence)((CharSequence)headers.getAll(HEADER_NAME).get(0))));
    }

    private static void addValues(CombinedHttpHeaders headers, HttpHeadersTestUtils.HeaderValue ... headerValues) {
        for (HttpHeadersTestUtils.HeaderValue v : headerValues) {
            headers.add(HEADER_NAME, (Object)v.toString());
        }
    }

    private static void addObjectValues(CombinedHttpHeaders headers, HttpHeadersTestUtils.HeaderValue ... headerValues) {
        for (HttpHeadersTestUtils.HeaderValue v : headerValues) {
            headers.add(HEADER_NAME, (Object)v.toString());
        }
    }

    @Test
    public void testGetAll() {
        CombinedHttpHeaders headers = CombinedHttpHeadersTest.newCombinedHttpHeaders();
        headers.set(HEADER_NAME, Arrays.asList("a", "b", "c"));
        Assert.assertEquals(Arrays.asList("a", "b", "c"), (Object)headers.getAll(HEADER_NAME));
        headers.set(HEADER_NAME, Arrays.asList("a,", "b,", "c,"));
        Assert.assertEquals(Arrays.asList("a,", "b,", "c,"), (Object)headers.getAll(HEADER_NAME));
        headers.set(HEADER_NAME, Arrays.asList("a\"", "b\"", "c\""));
        Assert.assertEquals(Arrays.asList("a\"", "b\"", "c\""), (Object)headers.getAll(HEADER_NAME));
        headers.set(HEADER_NAME, Arrays.asList("\"a\"", "\"b\"", "\"c\""));
        Assert.assertEquals(Arrays.asList("a", "b", "c"), (Object)headers.getAll(HEADER_NAME));
        headers.set(HEADER_NAME, (Object)"a,b,c");
        Assert.assertEquals(Collections.singletonList("a,b,c"), (Object)headers.getAll(HEADER_NAME));
        headers.set(HEADER_NAME, (Object)"\"a,b,c\"");
        Assert.assertEquals(Collections.singletonList("a,b,c"), (Object)headers.getAll(HEADER_NAME));
    }

    @Test
    public void getAllDontCombineSetCookie() {
        CombinedHttpHeaders headers = CombinedHttpHeadersTest.newCombinedHttpHeaders();
        headers.add((CharSequence)HttpHeaderNames.SET_COOKIE, (Object)"a");
        headers.add((CharSequence)HttpHeaderNames.SET_COOKIE, (Object)"b");
        MatcherAssert.assertThat((Object)headers.getAll((CharSequence)HttpHeaderNames.SET_COOKIE), (Matcher)Matchers.hasSize((int)2));
        Assert.assertEquals(Arrays.asList("a", "b"), (Object)headers.getAll((CharSequence)HttpHeaderNames.SET_COOKIE));
    }

    @Test
    public void owsTrimming() {
        CombinedHttpHeaders headers = CombinedHttpHeadersTest.newCombinedHttpHeaders();
        headers.set(HEADER_NAME, Arrays.asList("\ta", "   ", "  b ", "\t \t"));
        headers.add(HEADER_NAME, (Object)" c, d \t");
        Assert.assertEquals(Arrays.asList("a", "", "b", "", "c, d"), (Object)headers.getAll(HEADER_NAME));
        Assert.assertEquals((Object)"a,,b,,\"c, d\"", (Object)headers.get(HEADER_NAME));
        Assert.assertTrue((boolean)headers.containsValue(HEADER_NAME, (CharSequence)"a", true));
        Assert.assertTrue((boolean)headers.containsValue(HEADER_NAME, (CharSequence)" a ", true));
        Assert.assertTrue((boolean)headers.containsValue(HEADER_NAME, (CharSequence)"a", true));
        Assert.assertFalse((boolean)headers.containsValue(HEADER_NAME, (CharSequence)"a,b", true));
        Assert.assertFalse((boolean)headers.containsValue(HEADER_NAME, (CharSequence)" c, d ", true));
        Assert.assertFalse((boolean)headers.containsValue(HEADER_NAME, (CharSequence)"c, d", true));
        Assert.assertTrue((boolean)headers.containsValue(HEADER_NAME, (CharSequence)" c ", true));
        Assert.assertTrue((boolean)headers.containsValue(HEADER_NAME, (CharSequence)"d", true));
        Assert.assertTrue((boolean)headers.containsValue(HEADER_NAME, (CharSequence)"\t", true));
        Assert.assertTrue((boolean)headers.containsValue(HEADER_NAME, (CharSequence)"", true));
        Assert.assertFalse((boolean)headers.containsValue(HEADER_NAME, (CharSequence)"e", true));
        HttpHeaders copiedHeaders = CombinedHttpHeadersTest.newCombinedHttpHeaders().add((HttpHeaders)headers);
        Assert.assertEquals(Arrays.asList("a", "", "b", "", "c, d"), (Object)copiedHeaders.getAll(HEADER_NAME));
    }

    @Test
    public void valueIterator() {
        CombinedHttpHeaders headers = CombinedHttpHeadersTest.newCombinedHttpHeaders();
        headers.set(HEADER_NAME, Arrays.asList("\ta", "   ", "  b ", "\t \t"));
        headers.add(HEADER_NAME, (Object)" c, d \t");
        Assert.assertFalse((boolean)headers.valueStringIterator((CharSequence)"foo").hasNext());
        CombinedHttpHeadersTest.assertValueIterator(headers.valueStringIterator(HEADER_NAME));
        Assert.assertFalse((boolean)headers.valueCharSequenceIterator((CharSequence)"foo").hasNext());
        CombinedHttpHeadersTest.assertValueIterator(headers.valueCharSequenceIterator(HEADER_NAME));
    }

    @Test
    public void nonCombinableHeaderIterator() {
        CombinedHttpHeaders headers = CombinedHttpHeadersTest.newCombinedHttpHeaders();
        headers.add((CharSequence)HttpHeaderNames.SET_COOKIE, (Object)"c");
        headers.add((CharSequence)HttpHeaderNames.SET_COOKIE, (Object)"b");
        headers.add((CharSequence)HttpHeaderNames.SET_COOKIE, (Object)"a");
        Iterator strItr = headers.valueStringIterator((CharSequence)HttpHeaderNames.SET_COOKIE);
        Assert.assertTrue((boolean)strItr.hasNext());
        Assert.assertEquals((Object)"a", strItr.next());
        Assert.assertTrue((boolean)strItr.hasNext());
        Assert.assertEquals((Object)"b", strItr.next());
        Assert.assertTrue((boolean)strItr.hasNext());
        Assert.assertEquals((Object)"c", strItr.next());
    }

    private static void assertValueIterator(Iterator<? extends CharSequence> strItr) {
        Assert.assertTrue((boolean)strItr.hasNext());
        Assert.assertEquals((Object)"a", (Object)strItr.next());
        Assert.assertTrue((boolean)strItr.hasNext());
        Assert.assertEquals((Object)"", (Object)strItr.next());
        Assert.assertTrue((boolean)strItr.hasNext());
        Assert.assertEquals((Object)"b", (Object)strItr.next());
        Assert.assertTrue((boolean)strItr.hasNext());
        Assert.assertEquals((Object)"", (Object)strItr.next());
        Assert.assertTrue((boolean)strItr.hasNext());
        Assert.assertEquals((Object)"c, d", (Object)strItr.next());
        Assert.assertFalse((boolean)strItr.hasNext());
    }
}

