/*
 * Decompiled with CFR 0.152.
 */
package io.netty.handler.codec.http.websocketx;

import io.netty.handler.codec.http.websocketx.CloseWebSocketFrame;
import io.netty.handler.codec.http.websocketx.WebSocketCloseStatus;
import org.assertj.core.api.Assertions;
import org.assertj.core.api.ThrowableAssert;
import org.junit.jupiter.api.Test;

class CloseWebSocketFrameTest {
    CloseWebSocketFrameTest() {
    }

    @Test
    void testInvalidCode() {
        CloseWebSocketFrameTest.doTestInvalidCode(new ThrowableAssert.ThrowingCallable(){

            public void call() throws RuntimeException {
                new CloseWebSocketFrame(WebSocketCloseStatus.ABNORMAL_CLOSURE);
            }
        });
        CloseWebSocketFrameTest.doTestInvalidCode(new ThrowableAssert.ThrowingCallable(){

            public void call() throws RuntimeException {
                new CloseWebSocketFrame(WebSocketCloseStatus.ABNORMAL_CLOSURE, "invalid code");
            }
        });
        CloseWebSocketFrameTest.doTestInvalidCode(new ThrowableAssert.ThrowingCallable(){

            public void call() throws RuntimeException {
                new CloseWebSocketFrame(1006, "invalid code");
            }
        });
        CloseWebSocketFrameTest.doTestInvalidCode(new ThrowableAssert.ThrowingCallable(){

            public void call() throws RuntimeException {
                new CloseWebSocketFrame(true, 0, 1006, "invalid code");
            }
        });
    }

    @Test
    void testValidCode() {
        CloseWebSocketFrameTest.doTestValidCode(new CloseWebSocketFrame(WebSocketCloseStatus.NORMAL_CLOSURE), WebSocketCloseStatus.NORMAL_CLOSURE.code(), WebSocketCloseStatus.NORMAL_CLOSURE.reasonText());
        CloseWebSocketFrameTest.doTestValidCode(new CloseWebSocketFrame(WebSocketCloseStatus.NORMAL_CLOSURE, "valid code"), WebSocketCloseStatus.NORMAL_CLOSURE.code(), "valid code");
        CloseWebSocketFrameTest.doTestValidCode(new CloseWebSocketFrame(1000, "valid code"), 1000, "valid code");
        CloseWebSocketFrameTest.doTestValidCode(new CloseWebSocketFrame(true, 0, 1000, "valid code"), 1000, "valid code");
    }

    private static void doTestInvalidCode(ThrowableAssert.ThrowingCallable callable) {
        Assertions.assertThatExceptionOfType(IllegalArgumentException.class).isThrownBy(callable);
    }

    private static void doTestValidCode(CloseWebSocketFrame frame, int expectedCode, String expectedReason) {
        Assertions.assertThat((int)frame.statusCode()).isEqualTo(expectedCode);
        Assertions.assertThat((String)frame.reasonText()).isEqualTo(expectedReason);
    }
}

