/*
 * Decompiled with CFR 0.152.
 */
package io.netty.handler.codec.http.multipart;

import io.netty.buffer.ByteBuf;
import io.netty.buffer.Unpooled;
import io.netty.buffer.UnpooledByteBufAllocator;
import io.netty.handler.codec.DecoderResult;
import io.netty.handler.codec.http.DefaultFullHttpRequest;
import io.netty.handler.codec.http.DefaultHttpContent;
import io.netty.handler.codec.http.DefaultHttpRequest;
import io.netty.handler.codec.http.DefaultLastHttpContent;
import io.netty.handler.codec.http.HttpContent;
import io.netty.handler.codec.http.HttpHeaderNames;
import io.netty.handler.codec.http.HttpHeaderValues;
import io.netty.handler.codec.http.HttpMethod;
import io.netty.handler.codec.http.HttpRequest;
import io.netty.handler.codec.http.HttpVersion;
import io.netty.handler.codec.http.LastHttpContent;
import io.netty.handler.codec.http.multipart.Attribute;
import io.netty.handler.codec.http.multipart.DefaultHttpDataFactory;
import io.netty.handler.codec.http.multipart.FileUpload;
import io.netty.handler.codec.http.multipart.HttpDataFactory;
import io.netty.handler.codec.http.multipart.HttpPostRequestDecoder;
import io.netty.handler.codec.http.multipart.HttpPostStandardRequestDecoder;
import io.netty.handler.codec.http.multipart.InterfaceHttpData;
import io.netty.handler.codec.http.multipart.MemoryFileUpload;
import io.netty.util.CharsetUtil;
import java.net.URLEncoder;
import java.nio.charset.Charset;
import java.nio.charset.UnsupportedCharsetException;
import java.util.Arrays;
import org.junit.Assert;
import org.junit.Test;

public class HttpPostRequestDecoderTest {
    @Test
    public void testBinaryStreamUploadWithSpace() throws Exception {
        HttpPostRequestDecoderTest.testBinaryStreamUpload(true);
    }

    @Test
    public void testBinaryStreamUploadWithoutSpace() throws Exception {
        HttpPostRequestDecoderTest.testBinaryStreamUpload(false);
    }

    private static void testBinaryStreamUpload(boolean withSpace) throws Exception {
        String boundary = "dLV9Wyq26L_-JQxk6ferf-RT153LhOO";
        String contentTypeValue = withSpace ? "multipart/form-data; boundary=dLV9Wyq26L_-JQxk6ferf-RT153LhOO" : "multipart/form-data;boundary=dLV9Wyq26L_-JQxk6ferf-RT153LhOO";
        DefaultHttpRequest req = new DefaultHttpRequest(HttpVersion.HTTP_1_1, HttpMethod.POST, "http://localhost");
        req.setDecoderResult(DecoderResult.SUCCESS);
        req.headers().add((CharSequence)HttpHeaderNames.CONTENT_TYPE, (Object)contentTypeValue);
        req.headers().add((CharSequence)HttpHeaderNames.TRANSFER_ENCODING, (Object)HttpHeaderValues.CHUNKED);
        DefaultHttpDataFactory inMemoryFactory = new DefaultHttpDataFactory(false);
        for (String data : Arrays.asList("", "\r", "\r\r", "\r\r\r")) {
            String body = "--dLV9Wyq26L_-JQxk6ferf-RT153LhOO\r\nContent-Disposition: form-data; name=\"file\"; filename=\"tmp-0.txt\"\r\nContent-Type: image/gif\r\n\r\n" + data + "\r\n--" + "dLV9Wyq26L_-JQxk6ferf-RT153LhOO" + "--\r\n";
            HttpPostRequestDecoder decoder = new HttpPostRequestDecoder((HttpDataFactory)inMemoryFactory, (HttpRequest)req);
            decoder.offer((HttpContent)new DefaultHttpContent(Unpooled.copiedBuffer((CharSequence)body, (Charset)CharsetUtil.UTF_8)));
            decoder.offer((HttpContent)new DefaultHttpContent(Unpooled.EMPTY_BUFFER));
            Assert.assertTrue((boolean)decoder.hasNext());
            MemoryFileUpload upload = (MemoryFileUpload)decoder.next();
            Assert.assertEquals((String)("Invalid decoded data [data=" + data.replaceAll("\r", "\\\\r") + ", upload=" + upload + ']'), (Object)data, (Object)upload.getString(CharsetUtil.UTF_8));
            upload.release();
            decoder.destroy();
        }
    }

    @Test
    public void testFullHttpRequestUpload() throws Exception {
        String boundary = "dLV9Wyq26L_-JQxk6ferf-RT153LhOO";
        DefaultFullHttpRequest req = new DefaultFullHttpRequest(HttpVersion.HTTP_1_1, HttpMethod.POST, "http://localhost");
        req.setDecoderResult(DecoderResult.SUCCESS);
        req.headers().add((CharSequence)HttpHeaderNames.CONTENT_TYPE, (Object)"multipart/form-data; boundary=dLV9Wyq26L_-JQxk6ferf-RT153LhOO");
        req.headers().add((CharSequence)HttpHeaderNames.TRANSFER_ENCODING, (Object)HttpHeaderValues.CHUNKED);
        DefaultHttpDataFactory inMemoryFactory = new DefaultHttpDataFactory(false);
        for (String data : Arrays.asList("", "\r", "\r\r", "\r\r\r")) {
            String body = "--dLV9Wyq26L_-JQxk6ferf-RT153LhOO\r\nContent-Disposition: form-data; name=\"file\"; filename=\"tmp-0.txt\"\r\nContent-Type: image/gif\r\n\r\n" + data + "\r\n--" + "dLV9Wyq26L_-JQxk6ferf-RT153LhOO" + "--\r\n";
            req.content().writeBytes(body.getBytes(CharsetUtil.UTF_8));
        }
        HttpPostRequestDecoder decoder = new HttpPostRequestDecoder((HttpDataFactory)inMemoryFactory, (HttpRequest)req);
        Assert.assertFalse((boolean)decoder.getBodyHttpDatas().isEmpty());
        req.release();
        decoder.destroy();
    }

    @Test
    public void testMultipartCodecWithCRasEndOfAttribute() throws Exception {
        int i;
        String boundary = "dLV9Wyq26L_-JQxk6ferf-RT153LhOO";
        DefaultHttpDataFactory inMemoryFactory = new DefaultHttpDataFactory(false);
        String extradata = "aaaa";
        String[] datas = new String[5];
        for (i = 0; i < 4; ++i) {
            datas[i] = extradata;
            for (int j = 0; j < i; ++j) {
                int n = i;
                datas[n] = datas[n] + '\r';
            }
        }
        for (i = 0; i < 4; ++i) {
            DefaultFullHttpRequest req = new DefaultFullHttpRequest(HttpVersion.HTTP_1_1, HttpMethod.POST, "http://localhost");
            req.setDecoderResult(DecoderResult.SUCCESS);
            req.headers().add((CharSequence)HttpHeaderNames.CONTENT_TYPE, (Object)"multipart/form-data; boundary=dLV9Wyq26L_-JQxk6ferf-RT153LhOO");
            req.headers().add((CharSequence)HttpHeaderNames.TRANSFER_ENCODING, (Object)HttpHeaderValues.CHUNKED);
            String body = "--dLV9Wyq26L_-JQxk6ferf-RT153LhOO\r\nContent-Disposition: form-data; name=\"file" + i + "\"\r\nContent-Type: image/gif\r\n\r\n" + datas[i] + "\r\n--" + "dLV9Wyq26L_-JQxk6ferf-RT153LhOO" + "--\r\n";
            req.content().writeBytes(body.getBytes(CharsetUtil.UTF_8));
            HttpPostRequestDecoder decoder = new HttpPostRequestDecoder((HttpDataFactory)inMemoryFactory, (HttpRequest)req);
            Assert.assertFalse((boolean)decoder.getBodyHttpDatas().isEmpty());
            InterfaceHttpData httpdata = decoder.getBodyHttpData("file" + i);
            Assert.assertNotNull((Object)httpdata);
            Attribute attribute = (Attribute)httpdata;
            byte[] datar = attribute.get();
            Assert.assertNotNull((Object)datar);
            Assert.assertEquals((long)datas[i].getBytes(CharsetUtil.UTF_8).length, (long)datar.length);
            req.release();
            decoder.destroy();
        }
    }

    @Test
    public void testQuotedBoundary() throws Exception {
        String boundary = "dLV9Wyq26L_-JQxk6ferf-RT153LhOO";
        DefaultFullHttpRequest req = new DefaultFullHttpRequest(HttpVersion.HTTP_1_1, HttpMethod.POST, "http://localhost");
        req.setDecoderResult(DecoderResult.SUCCESS);
        req.headers().add((CharSequence)HttpHeaderNames.CONTENT_TYPE, (Object)"multipart/form-data; boundary=\"dLV9Wyq26L_-JQxk6ferf-RT153LhOO\"");
        req.headers().add((CharSequence)HttpHeaderNames.TRANSFER_ENCODING, (Object)HttpHeaderValues.CHUNKED);
        DefaultHttpDataFactory inMemoryFactory = new DefaultHttpDataFactory(false);
        for (String data : Arrays.asList("", "\r", "\r\r", "\r\r\r")) {
            String body = "--dLV9Wyq26L_-JQxk6ferf-RT153LhOO\r\nContent-Disposition: form-data; name=\"file\"; filename=\"tmp-0.txt\"\r\nContent-Type: image/gif\r\n\r\n" + data + "\r\n--" + "dLV9Wyq26L_-JQxk6ferf-RT153LhOO" + "--\r\n";
            req.content().writeBytes(body.getBytes(CharsetUtil.UTF_8));
        }
        HttpPostRequestDecoder decoder = new HttpPostRequestDecoder((HttpDataFactory)inMemoryFactory, (HttpRequest)req);
        Assert.assertFalse((boolean)decoder.getBodyHttpDatas().isEmpty());
        req.release();
        decoder.destroy();
    }

    @Test
    public void testNoZeroOut() throws Exception {
        String boundary = "E832jQp_Rq2ErFmAduHSR8YlMSm0FCY";
        DefaultHttpDataFactory aMemFactory = new DefaultHttpDataFactory(false);
        DefaultHttpRequest aRequest = new DefaultHttpRequest(HttpVersion.HTTP_1_1, HttpMethod.POST, "http://localhost");
        aRequest.headers().set((CharSequence)HttpHeaderNames.CONTENT_TYPE, (Object)"multipart/form-data; boundary=E832jQp_Rq2ErFmAduHSR8YlMSm0FCY");
        aRequest.headers().set((CharSequence)HttpHeaderNames.TRANSFER_ENCODING, (Object)HttpHeaderValues.CHUNKED);
        HttpPostRequestDecoder aDecoder = new HttpPostRequestDecoder((HttpDataFactory)aMemFactory, (HttpRequest)aRequest);
        String aData = "some data would be here. the data should be long enough that it will be longer than the original buffer length of 256 bytes in the HttpPostRequestDecoder in order to trigger the issue. Some more data just to be on the safe side.";
        String body = "--E832jQp_Rq2ErFmAduHSR8YlMSm0FCY\r\nContent-Disposition: form-data; name=\"root\"\r\nContent-Type: text/plain\r\n\r\nsome data would be here. the data should be long enough that it will be longer than the original buffer length of 256 bytes in the HttpPostRequestDecoder in order to trigger the issue. Some more data just to be on the safe side.\r\n--E832jQp_Rq2ErFmAduHSR8YlMSm0FCY--\r\n";
        byte[] aBytes = "--E832jQp_Rq2ErFmAduHSR8YlMSm0FCY\r\nContent-Disposition: form-data; name=\"root\"\r\nContent-Type: text/plain\r\n\r\nsome data would be here. the data should be long enough that it will be longer than the original buffer length of 256 bytes in the HttpPostRequestDecoder in order to trigger the issue. Some more data just to be on the safe side.\r\n--E832jQp_Rq2ErFmAduHSR8YlMSm0FCY--\r\n".getBytes();
        int split = 125;
        UnpooledByteBufAllocator aAlloc = new UnpooledByteBufAllocator(true);
        ByteBuf aSmallBuf = aAlloc.heapBuffer(split, split);
        ByteBuf aLargeBuf = aAlloc.heapBuffer(aBytes.length - split, aBytes.length - split);
        aSmallBuf.writeBytes(aBytes, 0, split);
        aLargeBuf.writeBytes(aBytes, split, aBytes.length - split);
        aDecoder.offer((HttpContent)new DefaultHttpContent(aSmallBuf));
        aDecoder.offer((HttpContent)new DefaultHttpContent(aLargeBuf));
        aDecoder.offer((HttpContent)LastHttpContent.EMPTY_LAST_CONTENT);
        Assert.assertTrue((String)"Should have a piece of data", (boolean)aDecoder.hasNext());
        InterfaceHttpData aDecodedData = aDecoder.next();
        Assert.assertEquals((Object)InterfaceHttpData.HttpDataType.Attribute, (Object)aDecodedData.getHttpDataType());
        Attribute aAttr = (Attribute)aDecodedData;
        Assert.assertEquals((Object)"some data would be here. the data should be long enough that it will be longer than the original buffer length of 256 bytes in the HttpPostRequestDecoder in order to trigger the issue. Some more data just to be on the safe side.", (Object)aAttr.getValue());
        aDecodedData.release();
        aDecoder.destroy();
    }

    @Test
    public void testChunkCorrect() throws Exception {
        String payload = "town=794649819&town=784444184&town=794649672&town=794657800&town=794655734&town=794649377&town=794652136&town=789936338&town=789948986&town=789949643&town=786358677&town=794655880&town=786398977&town=789901165&town=789913325&town=789903418&town=789903579&town=794645251&town=794694126&town=794694831&town=794655274&town=789913656&town=794653956&town=794665634&town=789936598&town=789904658&town=789899210&town=799696252&town=794657521&town=789904837&town=789961286&town=789958704&town=789948839&town=789933899&town=793060398&town=794659180&town=794659365&town=799724096&town=794696332&town=789953438&town=786398499&town=794693372&town=789935439&town=794658041&town=789917595&town=794655427&town=791930372&town=794652891&town=794656365&town=789960339&town=794645586&town=794657688&town=794697211&town=789937427&town=789902813&town=789941130&town=794696907&town=789904328&town=789955151&town=789911570&town=794655074&town=789939531&town=789935242&town=789903835&town=789953800&town=794649962&town=789939841&town=789934819&town=789959672&town=794659043&town=794657035&town=794658938&town=794651746&town=794653732&town=794653881&town=786397909&town=794695736&town=799724044&town=794695926&town=789912270&town=794649030&town=794657946&town=794655370&town=794659660&town=794694617&town=799149862&town=789953234&town=789900476&town=794654995&town=794671126&town=789908868&town=794652942&town=789955605&town=789901934&town=789950015&town=789937922&town=789962576&town=786360170&town=789954264&town=789911738&town=789955416&town=799724187&town=789911879&town=794657462&town=789912561&town=789913167&town=794655195&town=789938266&town=789952099&town=794657160&town=789949414&town=794691293&town=794698153&town=789935636&town=789956374&town=789934635&town=789935475&town=789935085&town=794651425&town=794654936&town=794655680&town=789908669&town=794652031&town=789951298&town=789938382&town=794651503&town=794653330&town=817675037&town=789951623&town=789958999&town=789961555&town=794694050&town=794650241&town=794656286&town=794692081&town=794660090&town=794665227&town=794665136&town=794669931";
        DefaultHttpRequest defaultHttpRequest = new DefaultHttpRequest(HttpVersion.HTTP_1_1, HttpMethod.POST, "/");
        HttpPostRequestDecoder decoder = new HttpPostRequestDecoder((HttpRequest)defaultHttpRequest);
        int firstChunk = 10;
        int middleChunk = 1024;
        byte[] payload1 = payload.substring(0, firstChunk).getBytes();
        byte[] payload2 = payload.substring(firstChunk, firstChunk + middleChunk).getBytes();
        byte[] payload3 = payload.substring(firstChunk + middleChunk, firstChunk + middleChunk * 2).getBytes();
        byte[] payload4 = payload.substring(firstChunk + middleChunk * 2).getBytes();
        ByteBuf buf1 = Unpooled.directBuffer((int)payload1.length);
        ByteBuf buf2 = Unpooled.directBuffer((int)payload2.length);
        ByteBuf buf3 = Unpooled.directBuffer((int)payload3.length);
        ByteBuf buf4 = Unpooled.directBuffer((int)payload4.length);
        buf1.writeBytes(payload1);
        buf2.writeBytes(payload2);
        buf3.writeBytes(payload3);
        buf4.writeBytes(payload4);
        decoder.offer((HttpContent)new DefaultHttpContent(buf1));
        decoder.offer((HttpContent)new DefaultHttpContent(buf2));
        decoder.offer((HttpContent)new DefaultHttpContent(buf3));
        decoder.offer((HttpContent)new DefaultLastHttpContent(buf4));
        Assert.assertFalse((boolean)decoder.getBodyHttpDatas().isEmpty());
        Assert.assertEquals((long)139L, (long)decoder.getBodyHttpDatas().size());
        Attribute attr = (Attribute)decoder.getBodyHttpData("town");
        Assert.assertEquals((Object)"794649819", (Object)attr.getValue());
        decoder.destroy();
        buf1.release();
        buf2.release();
        buf3.release();
        buf4.release();
    }

    @Test
    public void testFilenameContainingSemicolon() throws Exception {
        String boundary = "dLV9Wyq26L_-JQxk6ferf-RT153LhOO";
        DefaultFullHttpRequest req = new DefaultFullHttpRequest(HttpVersion.HTTP_1_1, HttpMethod.POST, "http://localhost");
        req.headers().add((CharSequence)HttpHeaderNames.CONTENT_TYPE, (Object)"multipart/form-data; boundary=dLV9Wyq26L_-JQxk6ferf-RT153LhOO");
        DefaultHttpDataFactory inMemoryFactory = new DefaultHttpDataFactory(false);
        String data = "asdf";
        String filename = "tmp;0.txt";
        String body = "--dLV9Wyq26L_-JQxk6ferf-RT153LhOO\r\nContent-Disposition: form-data; name=\"file\"; filename=\"tmp;0.txt\"\r\nContent-Type: image/gif\r\n\r\nasdf\r\n--dLV9Wyq26L_-JQxk6ferf-RT153LhOO--\r\n";
        req.content().writeBytes("--dLV9Wyq26L_-JQxk6ferf-RT153LhOO\r\nContent-Disposition: form-data; name=\"file\"; filename=\"tmp;0.txt\"\r\nContent-Type: image/gif\r\n\r\nasdf\r\n--dLV9Wyq26L_-JQxk6ferf-RT153LhOO--\r\n".getBytes(CharsetUtil.UTF_8.name()));
        HttpPostRequestDecoder decoder = new HttpPostRequestDecoder((HttpDataFactory)inMemoryFactory, (HttpRequest)req);
        Assert.assertFalse((boolean)decoder.getBodyHttpDatas().isEmpty());
        req.release();
        decoder.destroy();
    }

    @Test
    public void testFilenameContainingSemicolon2() throws Exception {
        String boundary = "dLV9Wyq26L_-JQxk6ferf-RT153LhOO";
        DefaultFullHttpRequest req = new DefaultFullHttpRequest(HttpVersion.HTTP_1_1, HttpMethod.POST, "http://localhost");
        req.headers().add((CharSequence)HttpHeaderNames.CONTENT_TYPE, (Object)"multipart/form-data; boundary=dLV9Wyq26L_-JQxk6ferf-RT153LhOO");
        DefaultHttpDataFactory inMemoryFactory = new DefaultHttpDataFactory(false);
        String data = "asdf";
        String filename = "tmp;0.txt";
        String body = "--dLV9Wyq26L_-JQxk6ferf-RT153LhOO\r\nContent-Disposition: form-data; name=\"file\"; filename=\"tmp;0.txt\"\r\nContent-Type: image/gif\r\n\r\nasdf\r\n--dLV9Wyq26L_-JQxk6ferf-RT153LhOO--\r\n";
        req.content().writeBytes("--dLV9Wyq26L_-JQxk6ferf-RT153LhOO\r\nContent-Disposition: form-data; name=\"file\"; filename=\"tmp;0.txt\"\r\nContent-Type: image/gif\r\n\r\nasdf\r\n--dLV9Wyq26L_-JQxk6ferf-RT153LhOO--\r\n".getBytes(CharsetUtil.UTF_8.name()));
        HttpPostRequestDecoder decoder = new HttpPostRequestDecoder((HttpDataFactory)inMemoryFactory, (HttpRequest)req);
        Assert.assertFalse((boolean)decoder.getBodyHttpDatas().isEmpty());
        InterfaceHttpData part1 = (InterfaceHttpData)decoder.getBodyHttpDatas().get(0);
        Assert.assertTrue((boolean)(part1 instanceof FileUpload));
        FileUpload fileUpload = (FileUpload)part1;
        Assert.assertEquals((Object)"tmp 0.txt", (Object)fileUpload.getFilename());
        req.release();
        decoder.destroy();
    }

    @Test
    public void testMultipartRequestWithoutContentTypeBody() {
        String boundary = "dLV9Wyq26L_-JQxk6ferf-RT153LhOO";
        DefaultFullHttpRequest req = new DefaultFullHttpRequest(HttpVersion.HTTP_1_1, HttpMethod.POST, "http://localhost");
        req.setDecoderResult(DecoderResult.SUCCESS);
        req.headers().add((CharSequence)HttpHeaderNames.CONTENT_TYPE, (Object)"multipart/form-data; boundary=dLV9Wyq26L_-JQxk6ferf-RT153LhOO");
        req.headers().add((CharSequence)HttpHeaderNames.TRANSFER_ENCODING, (Object)HttpHeaderValues.CHUNKED);
        DefaultHttpDataFactory inMemoryFactory = new DefaultHttpDataFactory(false);
        for (String data : Arrays.asList("", "\r", "\r\r", "\r\r\r")) {
            String body = "--dLV9Wyq26L_-JQxk6ferf-RT153LhOO\r\nContent-Disposition: form-data; name=\"file\"; filename=\"tmp-0.txt\"\r\n\r\n" + data + "\r\n--" + "dLV9Wyq26L_-JQxk6ferf-RT153LhOO" + "--\r\n";
            req.content().writeBytes(body.getBytes(CharsetUtil.UTF_8));
        }
        HttpPostRequestDecoder decoder = new HttpPostRequestDecoder((HttpDataFactory)inMemoryFactory, (HttpRequest)req);
        Assert.assertFalse((boolean)decoder.getBodyHttpDatas().isEmpty());
        req.release();
        decoder.destroy();
    }

    @Test
    public void testDecodeOtherMimeHeaderFields() throws Exception {
        String boundary = "74e78d11b0214bdcbc2f86491eeb4902";
        String filecontent = "123456";
        String body = "--74e78d11b0214bdcbc2f86491eeb4902\r\nContent-Disposition: form-data; name=\"file\"; filename=\"attached.txt\"\r\nContent-Type: application/octet-stream\r\nContent-Encoding: gzip\r\n\r\n" + filecontent + "\r\n--" + "74e78d11b0214bdcbc2f86491eeb4902" + "--";
        DefaultFullHttpRequest req = new DefaultFullHttpRequest(HttpVersion.HTTP_1_1, HttpMethod.POST, "http://localhost", Unpooled.wrappedBuffer((byte[])body.getBytes()));
        req.headers().add((CharSequence)HttpHeaderNames.CONTENT_TYPE, (Object)"multipart/form-data; boundary=74e78d11b0214bdcbc2f86491eeb4902");
        req.headers().add((CharSequence)HttpHeaderNames.TRANSFER_ENCODING, (Object)HttpHeaderValues.CHUNKED);
        DefaultHttpDataFactory inMemoryFactory = new DefaultHttpDataFactory(false);
        HttpPostRequestDecoder decoder = new HttpPostRequestDecoder((HttpDataFactory)inMemoryFactory, (HttpRequest)req);
        Assert.assertFalse((boolean)decoder.getBodyHttpDatas().isEmpty());
        InterfaceHttpData part1 = (InterfaceHttpData)decoder.getBodyHttpDatas().get(0);
        Assert.assertTrue((String)"the item should be a FileUpload", (boolean)(part1 instanceof FileUpload));
        FileUpload fileUpload = (FileUpload)part1;
        byte[] fileBytes = fileUpload.get();
        Assert.assertTrue((String)"the filecontent should not be decoded", (boolean)filecontent.equals(new String(fileBytes)));
        req.release();
        decoder.destroy();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testMultipartRequestWithFileInvalidCharset() throws Exception {
        String boundary = "dLV9Wyq26L_-JQxk6ferf-RT153LhOO";
        DefaultFullHttpRequest req = new DefaultFullHttpRequest(HttpVersion.HTTP_1_1, HttpMethod.POST, "http://localhost");
        req.headers().add((CharSequence)HttpHeaderNames.CONTENT_TYPE, (Object)"multipart/form-data; boundary=dLV9Wyq26L_-JQxk6ferf-RT153LhOO");
        DefaultHttpDataFactory inMemoryFactory = new DefaultHttpDataFactory(false);
        String data = "asdf";
        String filename = "tmp;0.txt";
        String body = "--dLV9Wyq26L_-JQxk6ferf-RT153LhOO\r\nContent-Disposition: form-data; name=\"file\"; filename=\"tmp;0.txt\"\r\nContent-Type: image/gif; charset=ABCD\r\n\r\nasdf\r\n--dLV9Wyq26L_-JQxk6ferf-RT153LhOO--\r\n";
        req.content().writeBytes("--dLV9Wyq26L_-JQxk6ferf-RT153LhOO\r\nContent-Disposition: form-data; name=\"file\"; filename=\"tmp;0.txt\"\r\nContent-Type: image/gif; charset=ABCD\r\n\r\nasdf\r\n--dLV9Wyq26L_-JQxk6ferf-RT153LhOO--\r\n".getBytes(CharsetUtil.UTF_8));
        try {
            new HttpPostRequestDecoder((HttpDataFactory)inMemoryFactory, (HttpRequest)req);
            Assert.fail((String)"Was expecting an ErrorDataDecoderException");
        }
        catch (HttpPostRequestDecoder.ErrorDataDecoderException e) {
            Assert.assertTrue((boolean)(e.getCause() instanceof UnsupportedCharsetException));
        }
        finally {
            req.release();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testMultipartRequestWithFieldInvalidCharset() throws Exception {
        String boundary = "dLV9Wyq26L_-JQxk6ferf-RT153LhOO";
        DefaultFullHttpRequest req = new DefaultFullHttpRequest(HttpVersion.HTTP_1_1, HttpMethod.POST, "http://localhost");
        req.headers().add((CharSequence)HttpHeaderNames.CONTENT_TYPE, (Object)"multipart/form-data; boundary=dLV9Wyq26L_-JQxk6ferf-RT153LhOO");
        DefaultHttpDataFactory inMemoryFactory = new DefaultHttpDataFactory(false);
        String aData = "some data would be here. the data should be long enough that it will be longer than the original buffer length of 256 bytes in the HttpPostRequestDecoder in order to trigger the issue. Some more data just to be on the safe side.";
        String body = "--dLV9Wyq26L_-JQxk6ferf-RT153LhOO\r\nContent-Disposition: form-data; name=\"root\"\r\nContent-Type: text/plain; charset=ABCD\r\n\r\nsome data would be here. the data should be long enough that it will be longer than the original buffer length of 256 bytes in the HttpPostRequestDecoder in order to trigger the issue. Some more data just to be on the safe side.\r\n--dLV9Wyq26L_-JQxk6ferf-RT153LhOO--\r\n";
        req.content().writeBytes("--dLV9Wyq26L_-JQxk6ferf-RT153LhOO\r\nContent-Disposition: form-data; name=\"root\"\r\nContent-Type: text/plain; charset=ABCD\r\n\r\nsome data would be here. the data should be long enough that it will be longer than the original buffer length of 256 bytes in the HttpPostRequestDecoder in order to trigger the issue. Some more data just to be on the safe side.\r\n--dLV9Wyq26L_-JQxk6ferf-RT153LhOO--\r\n".getBytes(CharsetUtil.UTF_8));
        try {
            new HttpPostRequestDecoder((HttpDataFactory)inMemoryFactory, (HttpRequest)req);
            Assert.fail((String)"Was expecting an ErrorDataDecoderException");
        }
        catch (HttpPostRequestDecoder.ErrorDataDecoderException e) {
            Assert.assertTrue((boolean)(e.getCause() instanceof UnsupportedCharsetException));
        }
        finally {
            req.release();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testFormEncodeIncorrect() throws Exception {
        DefaultLastHttpContent content = new DefaultLastHttpContent(Unpooled.copiedBuffer((CharSequence)"project=netty&&project=netty", (Charset)CharsetUtil.US_ASCII));
        DefaultHttpRequest req = new DefaultHttpRequest(HttpVersion.HTTP_1_1, HttpMethod.POST, "/");
        HttpPostRequestDecoder decoder = new HttpPostRequestDecoder((HttpRequest)req);
        try {
            decoder.offer((HttpContent)content);
            Assert.fail();
        }
        catch (HttpPostRequestDecoder.ErrorDataDecoderException e) {
            Assert.assertTrue((boolean)(e.getCause() instanceof IllegalArgumentException));
        }
        finally {
            content.release();
            decoder.destroy();
        }
    }

    @Test
    public void testDecodeContentDispositionFieldParameters() throws Exception {
        String boundary = "74e78d11b0214bdcbc2f86491eeb4902";
        String encoding = "utf-8";
        String filename = "attached_\u0444\u0430\u0439\u043b.txt";
        String filenameEncoded = URLEncoder.encode(filename, encoding);
        String body = "--74e78d11b0214bdcbc2f86491eeb4902\r\nContent-Disposition: form-data; name=\"file\"; filename*=" + encoding + "''" + filenameEncoded + "\r\n\r\nfoo\r\n\r\n--" + "74e78d11b0214bdcbc2f86491eeb4902" + "--";
        DefaultFullHttpRequest req = new DefaultFullHttpRequest(HttpVersion.HTTP_1_1, HttpMethod.POST, "http://localhost", Unpooled.wrappedBuffer((byte[])body.getBytes()));
        req.headers().add((CharSequence)HttpHeaderNames.CONTENT_TYPE, (Object)"multipart/form-data; boundary=74e78d11b0214bdcbc2f86491eeb4902");
        DefaultHttpDataFactory inMemoryFactory = new DefaultHttpDataFactory(false);
        HttpPostRequestDecoder decoder = new HttpPostRequestDecoder((HttpDataFactory)inMemoryFactory, (HttpRequest)req);
        Assert.assertFalse((boolean)decoder.getBodyHttpDatas().isEmpty());
        InterfaceHttpData part1 = (InterfaceHttpData)decoder.getBodyHttpDatas().get(0);
        Assert.assertTrue((String)"the item should be a FileUpload", (boolean)(part1 instanceof FileUpload));
        FileUpload fileUpload = (FileUpload)part1;
        Assert.assertEquals((String)"the filename should be decoded", (Object)filename, (Object)fileUpload.getFilename());
        req.release();
        decoder.destroy();
    }

    @Test
    public void testDecodeWithLanguageContentDispositionFieldParameters() throws Exception {
        String boundary = "74e78d11b0214bdcbc2f86491eeb4902";
        String encoding = "utf-8";
        String filename = "attached_\u0444\u0430\u0439\u043b.txt";
        String language = "anything";
        String filenameEncoded = URLEncoder.encode(filename, encoding);
        String body = "--74e78d11b0214bdcbc2f86491eeb4902\r\nContent-Disposition: form-data; name=\"file\"; filename*=" + encoding + "'" + language + "'" + filenameEncoded + "\r\n\r\nfoo\r\n\r\n--" + "74e78d11b0214bdcbc2f86491eeb4902" + "--";
        DefaultFullHttpRequest req = new DefaultFullHttpRequest(HttpVersion.HTTP_1_1, HttpMethod.POST, "http://localhost", Unpooled.wrappedBuffer((byte[])body.getBytes()));
        req.headers().add((CharSequence)HttpHeaderNames.CONTENT_TYPE, (Object)"multipart/form-data; boundary=74e78d11b0214bdcbc2f86491eeb4902");
        DefaultHttpDataFactory inMemoryFactory = new DefaultHttpDataFactory(false);
        HttpPostRequestDecoder decoder = new HttpPostRequestDecoder((HttpDataFactory)inMemoryFactory, (HttpRequest)req);
        Assert.assertFalse((boolean)decoder.getBodyHttpDatas().isEmpty());
        InterfaceHttpData part1 = (InterfaceHttpData)decoder.getBodyHttpDatas().get(0);
        Assert.assertTrue((String)"the item should be a FileUpload", (boolean)(part1 instanceof FileUpload));
        FileUpload fileUpload = (FileUpload)part1;
        Assert.assertEquals((String)"the filename should be decoded", (Object)filename, (Object)fileUpload.getFilename());
        req.release();
        decoder.destroy();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testDecodeMalformedNotEncodedContentDispositionFieldParameters() throws Exception {
        String boundary = "74e78d11b0214bdcbc2f86491eeb4902";
        String body = "--74e78d11b0214bdcbc2f86491eeb4902\r\nContent-Disposition: form-data; name=\"file\"; filename*=not-encoded\r\n\r\nfoo\r\n\r\n--74e78d11b0214bdcbc2f86491eeb4902--";
        DefaultFullHttpRequest req = new DefaultFullHttpRequest(HttpVersion.HTTP_1_1, HttpMethod.POST, "http://localhost", Unpooled.wrappedBuffer((byte[])"--74e78d11b0214bdcbc2f86491eeb4902\r\nContent-Disposition: form-data; name=\"file\"; filename*=not-encoded\r\n\r\nfoo\r\n\r\n--74e78d11b0214bdcbc2f86491eeb4902--".getBytes()));
        req.headers().add((CharSequence)HttpHeaderNames.CONTENT_TYPE, (Object)"multipart/form-data; boundary=74e78d11b0214bdcbc2f86491eeb4902");
        DefaultHttpDataFactory inMemoryFactory = new DefaultHttpDataFactory(false);
        try {
            new HttpPostRequestDecoder((HttpDataFactory)inMemoryFactory, (HttpRequest)req);
            Assert.fail((String)"Was expecting an ErrorDataDecoderException");
        }
        catch (HttpPostRequestDecoder.ErrorDataDecoderException e) {
            Assert.assertTrue((boolean)(e.getCause() instanceof ArrayIndexOutOfBoundsException));
        }
        finally {
            req.release();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testDecodeMalformedBadCharsetContentDispositionFieldParameters() throws Exception {
        String boundary = "74e78d11b0214bdcbc2f86491eeb4902";
        String body = "--74e78d11b0214bdcbc2f86491eeb4902\r\nContent-Disposition: form-data; name=\"file\"; filename*=not-a-charset''filename\r\n\r\nfoo\r\n\r\n--74e78d11b0214bdcbc2f86491eeb4902--";
        DefaultFullHttpRequest req = new DefaultFullHttpRequest(HttpVersion.HTTP_1_1, HttpMethod.POST, "http://localhost", Unpooled.wrappedBuffer((byte[])"--74e78d11b0214bdcbc2f86491eeb4902\r\nContent-Disposition: form-data; name=\"file\"; filename*=not-a-charset''filename\r\n\r\nfoo\r\n\r\n--74e78d11b0214bdcbc2f86491eeb4902--".getBytes()));
        req.headers().add((CharSequence)HttpHeaderNames.CONTENT_TYPE, (Object)"multipart/form-data; boundary=74e78d11b0214bdcbc2f86491eeb4902");
        DefaultHttpDataFactory inMemoryFactory = new DefaultHttpDataFactory(false);
        try {
            new HttpPostRequestDecoder((HttpDataFactory)inMemoryFactory, (HttpRequest)req);
            Assert.fail((String)"Was expecting an ErrorDataDecoderException");
        }
        catch (HttpPostRequestDecoder.ErrorDataDecoderException e) {
            Assert.assertTrue((boolean)(e.getCause() instanceof UnsupportedCharsetException));
        }
        finally {
            req.release();
        }
    }

    @Test
    public void testDecodeMalformedEmptyContentTypeFieldParameters() throws Exception {
        String boundary = "dLV9Wyq26L_-JQxk6ferf-RT153LhOO";
        DefaultFullHttpRequest req = new DefaultFullHttpRequest(HttpVersion.HTTP_1_1, HttpMethod.POST, "http://localhost");
        req.headers().add((CharSequence)HttpHeaderNames.CONTENT_TYPE, (Object)"multipart/form-data; boundary=dLV9Wyq26L_-JQxk6ferf-RT153LhOO");
        DefaultHttpDataFactory inMemoryFactory = new DefaultHttpDataFactory(false);
        String data = "asdf";
        String filename = "tmp-0.txt";
        String body = "--dLV9Wyq26L_-JQxk6ferf-RT153LhOO\r\nContent-Disposition: form-data; name=\"file\"; filename=\"tmp-0.txt\"\r\nContent-Type: \r\n\r\nasdf\r\n--dLV9Wyq26L_-JQxk6ferf-RT153LhOO--\r\n";
        req.content().writeBytes("--dLV9Wyq26L_-JQxk6ferf-RT153LhOO\r\nContent-Disposition: form-data; name=\"file\"; filename=\"tmp-0.txt\"\r\nContent-Type: \r\n\r\nasdf\r\n--dLV9Wyq26L_-JQxk6ferf-RT153LhOO--\r\n".getBytes(CharsetUtil.UTF_8.name()));
        HttpPostRequestDecoder decoder = new HttpPostRequestDecoder((HttpDataFactory)inMemoryFactory, (HttpRequest)req);
        Assert.assertFalse((boolean)decoder.getBodyHttpDatas().isEmpty());
        InterfaceHttpData part1 = (InterfaceHttpData)decoder.getBodyHttpDatas().get(0);
        Assert.assertTrue((boolean)(part1 instanceof FileUpload));
        FileUpload fileUpload = (FileUpload)part1;
        Assert.assertEquals((Object)"tmp-0.txt", (Object)fileUpload.getFilename());
        req.release();
        decoder.destroy();
    }

    @Test
    public void testMultipartRequest() throws Exception {
        String BOUNDARY = "01f136d9282f";
        byte[] bodyBytes = ("--" + BOUNDARY + "\nContent-Disposition: form-data; name=\"msg_id\"\n\n15200\n--" + BOUNDARY + "\nContent-Disposition: form-data; name=\"msg\"\n\ntest message\n--" + BOUNDARY + "--").getBytes();
        ByteBuf byteBuf = Unpooled.directBuffer((int)bodyBytes.length);
        byteBuf.writeBytes(bodyBytes);
        DefaultFullHttpRequest req = new DefaultFullHttpRequest(HttpVersion.HTTP_1_0, HttpMethod.POST, "/up", byteBuf);
        req.headers().add((CharSequence)HttpHeaderNames.CONTENT_TYPE, (Object)("multipart/form-data; boundary=" + BOUNDARY));
        HttpPostRequestDecoder decoder = new HttpPostRequestDecoder((HttpDataFactory)new DefaultHttpDataFactory(16384L), (HttpRequest)req, CharsetUtil.UTF_8);
        Assert.assertTrue((boolean)decoder.isMultipart());
        Assert.assertFalse((boolean)decoder.getBodyHttpDatas().isEmpty());
        Assert.assertEquals((long)2L, (long)decoder.getBodyHttpDatas().size());
        Attribute attrMsg = (Attribute)decoder.getBodyHttpData("msg");
        Assert.assertTrue((boolean)attrMsg.getByteBuf().isDirect());
        Assert.assertEquals((Object)"test message", (Object)attrMsg.getValue());
        Attribute attrMsgId = (Attribute)decoder.getBodyHttpData("msg_id");
        Assert.assertTrue((boolean)attrMsgId.getByteBuf().isDirect());
        Assert.assertEquals((Object)"15200", (Object)attrMsgId.getValue());
        decoder.destroy();
        Assert.assertTrue((boolean)req.release());
    }

    @Test(expected=HttpPostRequestDecoder.ErrorDataDecoderException.class)
    public void testNotLeak() {
        DefaultFullHttpRequest request = new DefaultFullHttpRequest(HttpVersion.HTTP_1_1, HttpMethod.POST, "/", Unpooled.copiedBuffer((CharSequence)"a=1&&b=2", (Charset)CharsetUtil.US_ASCII));
        try {
            new HttpPostStandardRequestDecoder((HttpRequest)request).destroy();
        }
        finally {
            Assert.assertTrue((boolean)request.release());
        }
    }

    @Test(expected=HttpPostRequestDecoder.ErrorDataDecoderException.class)
    public void testNotLeakDirectBufferWhenWrapIllegalArgumentException() {
        HttpPostRequestDecoderTest.testNotLeakWhenWrapIllegalArgumentException(Unpooled.directBuffer());
    }

    @Test(expected=HttpPostRequestDecoder.ErrorDataDecoderException.class)
    public void testNotLeakHeapBufferWhenWrapIllegalArgumentException() {
        HttpPostRequestDecoderTest.testNotLeakWhenWrapIllegalArgumentException(Unpooled.buffer());
    }

    private static void testNotLeakWhenWrapIllegalArgumentException(ByteBuf buf) {
        buf.writeCharSequence((CharSequence)"a=b&foo=%22bar%22&==", CharsetUtil.US_ASCII);
        DefaultFullHttpRequest request = new DefaultFullHttpRequest(HttpVersion.HTTP_1_1, HttpMethod.POST, "/", buf);
        try {
            new HttpPostStandardRequestDecoder((HttpRequest)request).destroy();
        }
        finally {
            Assert.assertTrue((boolean)request.release());
        }
    }

    @Test
    public void testMultipartFormDataContentType() {
        DefaultHttpRequest request = new DefaultHttpRequest(HttpVersion.HTTP_1_1, HttpMethod.POST, "/");
        Assert.assertFalse((boolean)HttpPostRequestDecoder.isMultipart((HttpRequest)request));
        String multipartDataValue = HttpHeaderValues.MULTIPART_FORM_DATA + ";boundary=gc0p4Jq0M2Yt08jU534c0p";
        request.headers().set((CharSequence)HttpHeaderNames.CONTENT_TYPE, (Object)(";" + multipartDataValue));
        Assert.assertFalse((boolean)HttpPostRequestDecoder.isMultipart((HttpRequest)request));
        request.headers().set((CharSequence)HttpHeaderNames.CONTENT_TYPE, (Object)multipartDataValue);
        Assert.assertTrue((boolean)HttpPostRequestDecoder.isMultipart((HttpRequest)request));
    }

    @Test
    public void testDecodeWithLanguageContentDispositionFieldParametersForFix() throws Exception {
        String boundary = "952178786863262625034234";
        String encoding = "UTF-8";
        String filename = "\u6d4b\u8bd5test.txt";
        String filenameEncoded = URLEncoder.encode(filename, encoding);
        String body = "--952178786863262625034234\r\nContent-Disposition: form-data; name=\"file\"; filename*=\"" + encoding + "''" + filenameEncoded + "\"\r\n\r\nfoo\r\n\r\n--" + "952178786863262625034234" + "--";
        DefaultFullHttpRequest req = new DefaultFullHttpRequest(HttpVersion.HTTP_1_1, HttpMethod.POST, "http://localhost", Unpooled.wrappedBuffer((byte[])body.getBytes()));
        req.headers().add((CharSequence)HttpHeaderNames.CONTENT_TYPE, (Object)"multipart/form-data; boundary=952178786863262625034234");
        DefaultHttpDataFactory inMemoryFactory = new DefaultHttpDataFactory(false);
        HttpPostRequestDecoder decoder = new HttpPostRequestDecoder((HttpDataFactory)inMemoryFactory, (HttpRequest)req);
        Assert.assertFalse((boolean)decoder.getBodyHttpDatas().isEmpty());
        InterfaceHttpData part1 = (InterfaceHttpData)decoder.getBodyHttpDatas().get(0);
        Assert.assertTrue((String)"the item should be a FileUpload", (boolean)(part1 instanceof FileUpload));
        FileUpload fileUpload = (FileUpload)part1;
        Assert.assertEquals((String)"the filename should be decoded", (Object)filename, (Object)fileUpload.getFilename());
        req.release();
        decoder.destroy();
    }

    @Test
    public void testDecodeFullHttpRequestWithUrlEncodedBody() throws Exception {
        byte[] bodyBytes = "foo=bar&a=b&empty=&city=%3c%22new%22%20york%20city%3e&other_city=los+angeles".getBytes();
        ByteBuf content = Unpooled.directBuffer((int)bodyBytes.length);
        content.writeBytes(bodyBytes);
        DefaultFullHttpRequest req = new DefaultFullHttpRequest(HttpVersion.HTTP_1_1, HttpMethod.POST, "/", content);
        HttpPostRequestDecoder decoder = new HttpPostRequestDecoder((HttpRequest)req);
        Assert.assertFalse((boolean)decoder.getBodyHttpDatas().isEmpty());
        Assert.assertFalse((boolean)decoder.getBodyHttpDatas().isEmpty());
        Assert.assertEquals((long)5L, (long)decoder.getBodyHttpDatas().size());
        Attribute attr = (Attribute)decoder.getBodyHttpData("foo");
        Assert.assertTrue((boolean)attr.getByteBuf().isDirect());
        Assert.assertEquals((Object)"bar", (Object)attr.getValue());
        attr = (Attribute)decoder.getBodyHttpData("a");
        Assert.assertTrue((boolean)attr.getByteBuf().isDirect());
        Assert.assertEquals((Object)"b", (Object)attr.getValue());
        attr = (Attribute)decoder.getBodyHttpData("empty");
        Assert.assertTrue((boolean)attr.getByteBuf().isDirect());
        Assert.assertEquals((Object)"", (Object)attr.getValue());
        attr = (Attribute)decoder.getBodyHttpData("city");
        Assert.assertTrue((boolean)attr.getByteBuf().isDirect());
        Assert.assertEquals((Object)"<\"new\" york city>", (Object)attr.getValue());
        attr = (Attribute)decoder.getBodyHttpData("other_city");
        Assert.assertTrue((boolean)attr.getByteBuf().isDirect());
        Assert.assertEquals((Object)"los angeles", (Object)attr.getValue());
        req.release();
        decoder.destroy();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testDecodeFullHttpRequestWithUrlEncodedBodyWithBrokenHexByte0() {
        byte[] bodyBytes = "foo=bar&a=b&empty=%&city=paris".getBytes();
        ByteBuf content = Unpooled.directBuffer((int)bodyBytes.length);
        content.writeBytes(bodyBytes);
        DefaultFullHttpRequest req = new DefaultFullHttpRequest(HttpVersion.HTTP_1_1, HttpMethod.POST, "/", content);
        try {
            new HttpPostRequestDecoder((HttpRequest)req);
            Assert.fail((String)"Was expecting an ErrorDataDecoderException");
        }
        catch (HttpPostRequestDecoder.ErrorDataDecoderException e) {
            Assert.assertEquals((Object)"Invalid hex byte at index '0' in string: '%'", (Object)e.getMessage());
        }
        finally {
            Assert.assertTrue((boolean)req.release());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testDecodeFullHttpRequestWithUrlEncodedBodyWithBrokenHexByte1() {
        byte[] bodyBytes = "foo=bar&a=b&empty=%2&city=london".getBytes();
        ByteBuf content = Unpooled.directBuffer((int)bodyBytes.length);
        content.writeBytes(bodyBytes);
        DefaultFullHttpRequest req = new DefaultFullHttpRequest(HttpVersion.HTTP_1_1, HttpMethod.POST, "/", content);
        try {
            new HttpPostRequestDecoder((HttpRequest)req);
            Assert.fail((String)"Was expecting an ErrorDataDecoderException");
        }
        catch (HttpPostRequestDecoder.ErrorDataDecoderException e) {
            Assert.assertEquals((Object)"Invalid hex byte at index '0' in string: '%2'", (Object)e.getMessage());
        }
        finally {
            Assert.assertTrue((boolean)req.release());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testDecodeFullHttpRequestWithUrlEncodedBodyWithInvalidHexNibbleHi() {
        byte[] bodyBytes = "foo=bar&a=b&empty=%Zc&city=london".getBytes();
        ByteBuf content = Unpooled.directBuffer((int)bodyBytes.length);
        content.writeBytes(bodyBytes);
        DefaultFullHttpRequest req = new DefaultFullHttpRequest(HttpVersion.HTTP_1_1, HttpMethod.POST, "/", content);
        try {
            new HttpPostRequestDecoder((HttpRequest)req);
            Assert.fail((String)"Was expecting an ErrorDataDecoderException");
        }
        catch (HttpPostRequestDecoder.ErrorDataDecoderException e) {
            Assert.assertEquals((Object)"Invalid hex byte at index '0' in string: '%Zc'", (Object)e.getMessage());
        }
        finally {
            Assert.assertTrue((boolean)req.release());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testDecodeFullHttpRequestWithUrlEncodedBodyWithInvalidHexNibbleLo() {
        byte[] bodyBytes = "foo=bar&a=b&empty=%2g&city=london".getBytes();
        ByteBuf content = Unpooled.directBuffer((int)bodyBytes.length);
        content.writeBytes(bodyBytes);
        DefaultFullHttpRequest req = new DefaultFullHttpRequest(HttpVersion.HTTP_1_1, HttpMethod.POST, "/", content);
        try {
            new HttpPostRequestDecoder((HttpRequest)req);
            Assert.fail((String)"Was expecting an ErrorDataDecoderException");
        }
        catch (HttpPostRequestDecoder.ErrorDataDecoderException e) {
            Assert.assertEquals((Object)"Invalid hex byte at index '0' in string: '%2g'", (Object)e.getMessage());
        }
        finally {
            Assert.assertTrue((boolean)req.release());
        }
    }
}

