/*
 * Decompiled with CFR 0.152.
 */
package io.netty.handler.codec.http;

import io.netty.buffer.ByteBuf;
import io.netty.buffer.Unpooled;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.ChannelInboundHandlerAdapter;
import io.netty.channel.embedded.EmbeddedChannel;
import io.netty.handler.codec.CodecException;
import io.netty.handler.codec.DecoderResult;
import io.netty.handler.codec.EncoderException;
import io.netty.handler.codec.MessageToByteEncoder;
import io.netty.handler.codec.http.DefaultFullHttpRequest;
import io.netty.handler.codec.http.DefaultFullHttpResponse;
import io.netty.handler.codec.http.DefaultHttpContent;
import io.netty.handler.codec.http.DefaultHttpResponse;
import io.netty.handler.codec.http.DefaultLastHttpContent;
import io.netty.handler.codec.http.FullHttpRequest;
import io.netty.handler.codec.http.FullHttpResponse;
import io.netty.handler.codec.http.HttpContent;
import io.netty.handler.codec.http.HttpContentEncoder;
import io.netty.handler.codec.http.HttpHeaderNames;
import io.netty.handler.codec.http.HttpHeaderValues;
import io.netty.handler.codec.http.HttpHeadersTestUtils;
import io.netty.handler.codec.http.HttpMethod;
import io.netty.handler.codec.http.HttpResponse;
import io.netty.handler.codec.http.HttpResponseStatus;
import io.netty.handler.codec.http.HttpVersion;
import io.netty.handler.codec.http.LastHttpContent;
import io.netty.util.CharsetUtil;
import java.util.concurrent.atomic.AtomicBoolean;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.junit.Assert;
import org.junit.Test;

public class HttpContentEncoderTest {
    @Test
    public void testSplitContent() throws Exception {
        EmbeddedChannel ch = new EmbeddedChannel(new ChannelHandler[]{new TestEncoder()});
        ch.writeInbound(new Object[]{new DefaultFullHttpRequest(HttpVersion.HTTP_1_1, HttpMethod.GET, "/")});
        ch.writeOutbound(new Object[]{new DefaultHttpResponse(HttpVersion.HTTP_1_1, HttpResponseStatus.OK)});
        ch.writeOutbound(new Object[]{new DefaultHttpContent(Unpooled.wrappedBuffer((byte[])new byte[3]))});
        ch.writeOutbound(new Object[]{new DefaultHttpContent(Unpooled.wrappedBuffer((byte[])new byte[2]))});
        ch.writeOutbound(new Object[]{new DefaultLastHttpContent(Unpooled.wrappedBuffer((byte[])new byte[1]))});
        HttpContentEncoderTest.assertEncodedResponse(ch);
        HttpContent chunk = (HttpContent)ch.readOutbound();
        MatcherAssert.assertThat((Object)chunk.content().toString(CharsetUtil.US_ASCII), (Matcher)CoreMatchers.is((Object)"3"));
        chunk.release();
        chunk = (HttpContent)ch.readOutbound();
        MatcherAssert.assertThat((Object)chunk.content().toString(CharsetUtil.US_ASCII), (Matcher)CoreMatchers.is((Object)"2"));
        chunk.release();
        chunk = (HttpContent)ch.readOutbound();
        MatcherAssert.assertThat((Object)chunk.content().toString(CharsetUtil.US_ASCII), (Matcher)CoreMatchers.is((Object)"1"));
        chunk.release();
        chunk = (HttpContent)ch.readOutbound();
        MatcherAssert.assertThat((Object)chunk.content().isReadable(), (Matcher)CoreMatchers.is((Object)false));
        MatcherAssert.assertThat((Object)chunk, (Matcher)CoreMatchers.is((Matcher)CoreMatchers.instanceOf(LastHttpContent.class)));
        chunk.release();
        MatcherAssert.assertThat((Object)ch.readOutbound(), (Matcher)CoreMatchers.is((Matcher)CoreMatchers.nullValue()));
    }

    @Test
    public void testChunkedContent() throws Exception {
        EmbeddedChannel ch = new EmbeddedChannel(new ChannelHandler[]{new TestEncoder()});
        ch.writeInbound(new Object[]{new DefaultFullHttpRequest(HttpVersion.HTTP_1_1, HttpMethod.GET, "/")});
        DefaultHttpResponse res = new DefaultHttpResponse(HttpVersion.HTTP_1_1, HttpResponseStatus.OK);
        res.headers().set((CharSequence)HttpHeaderNames.TRANSFER_ENCODING, (Object)HttpHeaderValues.CHUNKED);
        ch.writeOutbound(new Object[]{res});
        HttpContentEncoderTest.assertEncodedResponse(ch);
        ch.writeOutbound(new Object[]{new DefaultHttpContent(Unpooled.wrappedBuffer((byte[])new byte[3]))});
        ch.writeOutbound(new Object[]{new DefaultHttpContent(Unpooled.wrappedBuffer((byte[])new byte[2]))});
        ch.writeOutbound(new Object[]{new DefaultLastHttpContent(Unpooled.wrappedBuffer((byte[])new byte[1]))});
        HttpContent chunk = (HttpContent)ch.readOutbound();
        MatcherAssert.assertThat((Object)chunk.content().toString(CharsetUtil.US_ASCII), (Matcher)CoreMatchers.is((Object)"3"));
        chunk.release();
        chunk = (HttpContent)ch.readOutbound();
        MatcherAssert.assertThat((Object)chunk.content().toString(CharsetUtil.US_ASCII), (Matcher)CoreMatchers.is((Object)"2"));
        chunk.release();
        chunk = (HttpContent)ch.readOutbound();
        MatcherAssert.assertThat((Object)chunk.content().toString(CharsetUtil.US_ASCII), (Matcher)CoreMatchers.is((Object)"1"));
        MatcherAssert.assertThat((Object)chunk, (Matcher)CoreMatchers.is((Matcher)CoreMatchers.instanceOf(HttpContent.class)));
        chunk.release();
        chunk = (HttpContent)ch.readOutbound();
        MatcherAssert.assertThat((Object)chunk.content().isReadable(), (Matcher)CoreMatchers.is((Object)false));
        MatcherAssert.assertThat((Object)chunk, (Matcher)CoreMatchers.is((Matcher)CoreMatchers.instanceOf(LastHttpContent.class)));
        chunk.release();
        MatcherAssert.assertThat((Object)ch.readOutbound(), (Matcher)CoreMatchers.is((Matcher)CoreMatchers.nullValue()));
    }

    @Test
    public void testChunkedContentWithTrailingHeader() throws Exception {
        EmbeddedChannel ch = new EmbeddedChannel(new ChannelHandler[]{new TestEncoder()});
        ch.writeInbound(new Object[]{new DefaultFullHttpRequest(HttpVersion.HTTP_1_1, HttpMethod.GET, "/")});
        DefaultHttpResponse res = new DefaultHttpResponse(HttpVersion.HTTP_1_1, HttpResponseStatus.OK);
        res.headers().set((CharSequence)HttpHeaderNames.TRANSFER_ENCODING, (Object)HttpHeaderValues.CHUNKED);
        ch.writeOutbound(new Object[]{res});
        HttpContentEncoderTest.assertEncodedResponse(ch);
        ch.writeOutbound(new Object[]{new DefaultHttpContent(Unpooled.wrappedBuffer((byte[])new byte[3]))});
        ch.writeOutbound(new Object[]{new DefaultHttpContent(Unpooled.wrappedBuffer((byte[])new byte[2]))});
        DefaultLastHttpContent content = new DefaultLastHttpContent(Unpooled.wrappedBuffer((byte[])new byte[1]));
        content.trailingHeaders().set(HttpHeadersTestUtils.of("X-Test"), (Object)HttpHeadersTestUtils.of("Netty"));
        ch.writeOutbound(new Object[]{content});
        HttpContent chunk = (HttpContent)ch.readOutbound();
        MatcherAssert.assertThat((Object)chunk.content().toString(CharsetUtil.US_ASCII), (Matcher)CoreMatchers.is((Object)"3"));
        chunk.release();
        chunk = (HttpContent)ch.readOutbound();
        MatcherAssert.assertThat((Object)chunk.content().toString(CharsetUtil.US_ASCII), (Matcher)CoreMatchers.is((Object)"2"));
        chunk.release();
        chunk = (HttpContent)ch.readOutbound();
        MatcherAssert.assertThat((Object)chunk.content().toString(CharsetUtil.US_ASCII), (Matcher)CoreMatchers.is((Object)"1"));
        MatcherAssert.assertThat((Object)chunk, (Matcher)CoreMatchers.is((Matcher)CoreMatchers.instanceOf(HttpContent.class)));
        chunk.release();
        chunk = (HttpContent)ch.readOutbound();
        MatcherAssert.assertThat((Object)chunk.content().isReadable(), (Matcher)CoreMatchers.is((Object)false));
        MatcherAssert.assertThat((Object)chunk, (Matcher)CoreMatchers.is((Matcher)CoreMatchers.instanceOf(LastHttpContent.class)));
        Assert.assertEquals((Object)"Netty", (Object)((LastHttpContent)chunk).trailingHeaders().get(HttpHeadersTestUtils.of("X-Test")));
        Assert.assertEquals((Object)DecoderResult.SUCCESS, (Object)res.decoderResult());
        chunk.release();
        MatcherAssert.assertThat((Object)ch.readOutbound(), (Matcher)CoreMatchers.is((Matcher)CoreMatchers.nullValue()));
    }

    @Test
    public void testFullContentWithContentLength() throws Exception {
        EmbeddedChannel ch = new EmbeddedChannel(new ChannelHandler[]{new TestEncoder()});
        ch.writeInbound(new Object[]{new DefaultFullHttpRequest(HttpVersion.HTTP_1_1, HttpMethod.GET, "/")});
        DefaultFullHttpResponse fullRes = new DefaultFullHttpResponse(HttpVersion.HTTP_1_1, HttpResponseStatus.OK, Unpooled.wrappedBuffer((byte[])new byte[42]));
        fullRes.headers().set((CharSequence)HttpHeaderNames.CONTENT_LENGTH, (Object)42);
        ch.writeOutbound(new Object[]{fullRes});
        HttpResponse res = (HttpResponse)ch.readOutbound();
        MatcherAssert.assertThat((Object)res, (Matcher)CoreMatchers.is((Matcher)CoreMatchers.not((Matcher)CoreMatchers.instanceOf(HttpContent.class))));
        MatcherAssert.assertThat((Object)res.headers().get((CharSequence)HttpHeaderNames.TRANSFER_ENCODING), (Matcher)CoreMatchers.is((Matcher)CoreMatchers.nullValue()));
        MatcherAssert.assertThat((Object)res.headers().get((CharSequence)HttpHeaderNames.CONTENT_LENGTH), (Matcher)CoreMatchers.is((Object)"2"));
        MatcherAssert.assertThat((Object)res.headers().get((CharSequence)HttpHeaderNames.CONTENT_ENCODING), (Matcher)CoreMatchers.is((Object)"test"));
        HttpContent c = (HttpContent)ch.readOutbound();
        MatcherAssert.assertThat((Object)c.content().readableBytes(), (Matcher)CoreMatchers.is((Object)2));
        MatcherAssert.assertThat((Object)c.content().toString(CharsetUtil.US_ASCII), (Matcher)CoreMatchers.is((Object)"42"));
        c.release();
        LastHttpContent last = (LastHttpContent)ch.readOutbound();
        MatcherAssert.assertThat((Object)last.content().readableBytes(), (Matcher)CoreMatchers.is((Object)0));
        last.release();
        MatcherAssert.assertThat((Object)ch.readOutbound(), (Matcher)CoreMatchers.is((Matcher)CoreMatchers.nullValue()));
    }

    @Test
    public void testFullContent() throws Exception {
        EmbeddedChannel ch = new EmbeddedChannel(new ChannelHandler[]{new TestEncoder()});
        ch.writeInbound(new Object[]{new DefaultFullHttpRequest(HttpVersion.HTTP_1_1, HttpMethod.GET, "/")});
        DefaultFullHttpResponse res = new DefaultFullHttpResponse(HttpVersion.HTTP_1_1, HttpResponseStatus.OK, Unpooled.wrappedBuffer((byte[])new byte[42]));
        ch.writeOutbound(new Object[]{res});
        HttpContentEncoderTest.assertEncodedResponse(ch);
        HttpContent c = (HttpContent)ch.readOutbound();
        MatcherAssert.assertThat((Object)c.content().readableBytes(), (Matcher)CoreMatchers.is((Object)2));
        MatcherAssert.assertThat((Object)c.content().toString(CharsetUtil.US_ASCII), (Matcher)CoreMatchers.is((Object)"42"));
        c.release();
        LastHttpContent last = (LastHttpContent)ch.readOutbound();
        MatcherAssert.assertThat((Object)last.content().readableBytes(), (Matcher)CoreMatchers.is((Object)0));
        last.release();
        MatcherAssert.assertThat((Object)ch.readOutbound(), (Matcher)CoreMatchers.is((Matcher)CoreMatchers.nullValue()));
    }

    @Test
    public void testEmptySplitContent() throws Exception {
        EmbeddedChannel ch = new EmbeddedChannel(new ChannelHandler[]{new TestEncoder()});
        ch.writeInbound(new Object[]{new DefaultFullHttpRequest(HttpVersion.HTTP_1_1, HttpMethod.GET, "/")});
        ch.writeOutbound(new Object[]{new DefaultHttpResponse(HttpVersion.HTTP_1_1, HttpResponseStatus.OK)});
        HttpContentEncoderTest.assertEncodedResponse(ch);
        ch.writeOutbound(new Object[]{LastHttpContent.EMPTY_LAST_CONTENT});
        HttpContent chunk = (HttpContent)ch.readOutbound();
        MatcherAssert.assertThat((Object)chunk.content().toString(CharsetUtil.US_ASCII), (Matcher)CoreMatchers.is((Object)"0"));
        MatcherAssert.assertThat((Object)chunk, (Matcher)CoreMatchers.is((Matcher)CoreMatchers.instanceOf(HttpContent.class)));
        chunk.release();
        chunk = (HttpContent)ch.readOutbound();
        MatcherAssert.assertThat((Object)chunk.content().isReadable(), (Matcher)CoreMatchers.is((Object)false));
        MatcherAssert.assertThat((Object)chunk, (Matcher)CoreMatchers.is((Matcher)CoreMatchers.instanceOf(LastHttpContent.class)));
        chunk.release();
        MatcherAssert.assertThat((Object)ch.readOutbound(), (Matcher)CoreMatchers.is((Matcher)CoreMatchers.nullValue()));
    }

    @Test
    public void testEmptyFullContent() throws Exception {
        EmbeddedChannel ch = new EmbeddedChannel(new ChannelHandler[]{new TestEncoder()});
        ch.writeInbound(new Object[]{new DefaultFullHttpRequest(HttpVersion.HTTP_1_1, HttpMethod.GET, "/")});
        DefaultFullHttpResponse res = new DefaultFullHttpResponse(HttpVersion.HTTP_1_1, HttpResponseStatus.OK, Unpooled.EMPTY_BUFFER);
        ch.writeOutbound(new Object[]{res});
        Object o = ch.readOutbound();
        MatcherAssert.assertThat((Object)o, (Matcher)CoreMatchers.is((Matcher)CoreMatchers.instanceOf(FullHttpResponse.class)));
        res = (FullHttpResponse)o;
        MatcherAssert.assertThat((Object)res.headers().get((CharSequence)HttpHeaderNames.TRANSFER_ENCODING), (Matcher)CoreMatchers.is((Matcher)CoreMatchers.nullValue()));
        MatcherAssert.assertThat((Object)res.headers().get((CharSequence)HttpHeaderNames.CONTENT_ENCODING), (Matcher)CoreMatchers.is((Matcher)CoreMatchers.nullValue()));
        MatcherAssert.assertThat((Object)res.content().readableBytes(), (Matcher)CoreMatchers.is((Object)0));
        MatcherAssert.assertThat((Object)res.content().toString(CharsetUtil.US_ASCII), (Matcher)CoreMatchers.is((Object)""));
        res.release();
        MatcherAssert.assertThat((Object)ch.readOutbound(), (Matcher)CoreMatchers.is((Matcher)CoreMatchers.nullValue()));
    }

    @Test
    public void testEmptyFullContentWithTrailer() throws Exception {
        EmbeddedChannel ch = new EmbeddedChannel(new ChannelHandler[]{new TestEncoder()});
        ch.writeInbound(new Object[]{new DefaultFullHttpRequest(HttpVersion.HTTP_1_1, HttpMethod.GET, "/")});
        DefaultFullHttpResponse res = new DefaultFullHttpResponse(HttpVersion.HTTP_1_1, HttpResponseStatus.OK, Unpooled.EMPTY_BUFFER);
        res.trailingHeaders().set(HttpHeadersTestUtils.of("X-Test"), (Object)HttpHeadersTestUtils.of("Netty"));
        ch.writeOutbound(new Object[]{res});
        Object o = ch.readOutbound();
        MatcherAssert.assertThat((Object)o, (Matcher)CoreMatchers.is((Matcher)CoreMatchers.instanceOf(FullHttpResponse.class)));
        res = (FullHttpResponse)o;
        MatcherAssert.assertThat((Object)res.headers().get((CharSequence)HttpHeaderNames.TRANSFER_ENCODING), (Matcher)CoreMatchers.is((Matcher)CoreMatchers.nullValue()));
        MatcherAssert.assertThat((Object)res.headers().get((CharSequence)HttpHeaderNames.CONTENT_ENCODING), (Matcher)CoreMatchers.is((Matcher)CoreMatchers.nullValue()));
        MatcherAssert.assertThat((Object)res.content().readableBytes(), (Matcher)CoreMatchers.is((Object)0));
        MatcherAssert.assertThat((Object)res.content().toString(CharsetUtil.US_ASCII), (Matcher)CoreMatchers.is((Object)""));
        Assert.assertEquals((Object)"Netty", (Object)res.trailingHeaders().get(HttpHeadersTestUtils.of("X-Test")));
        Assert.assertEquals((Object)DecoderResult.SUCCESS, (Object)res.decoderResult());
        MatcherAssert.assertThat((Object)ch.readOutbound(), (Matcher)CoreMatchers.is((Matcher)CoreMatchers.nullValue()));
    }

    @Test
    public void testEmptyHeadResponse() throws Exception {
        EmbeddedChannel ch = new EmbeddedChannel(new ChannelHandler[]{new TestEncoder()});
        DefaultFullHttpRequest req = new DefaultFullHttpRequest(HttpVersion.HTTP_1_1, HttpMethod.HEAD, "/");
        ch.writeInbound(new Object[]{req});
        DefaultHttpResponse res = new DefaultHttpResponse(HttpVersion.HTTP_1_1, HttpResponseStatus.OK);
        res.headers().set((CharSequence)HttpHeaderNames.TRANSFER_ENCODING, (Object)HttpHeaderValues.CHUNKED);
        ch.writeOutbound(new Object[]{res});
        ch.writeOutbound(new Object[]{LastHttpContent.EMPTY_LAST_CONTENT});
        HttpContentEncoderTest.assertEmptyResponse(ch);
    }

    @Test
    public void testHttp304Response() throws Exception {
        EmbeddedChannel ch = new EmbeddedChannel(new ChannelHandler[]{new TestEncoder()});
        DefaultFullHttpRequest req = new DefaultFullHttpRequest(HttpVersion.HTTP_1_1, HttpMethod.GET, "/");
        req.headers().set((CharSequence)HttpHeaderNames.ACCEPT_ENCODING, (Object)HttpHeaderValues.GZIP);
        ch.writeInbound(new Object[]{req});
        DefaultHttpResponse res = new DefaultHttpResponse(HttpVersion.HTTP_1_1, HttpResponseStatus.NOT_MODIFIED);
        res.headers().set((CharSequence)HttpHeaderNames.TRANSFER_ENCODING, (Object)HttpHeaderValues.CHUNKED);
        ch.writeOutbound(new Object[]{res});
        ch.writeOutbound(new Object[]{LastHttpContent.EMPTY_LAST_CONTENT});
        HttpContentEncoderTest.assertEmptyResponse(ch);
    }

    @Test
    public void testConnect200Response() throws Exception {
        EmbeddedChannel ch = new EmbeddedChannel(new ChannelHandler[]{new TestEncoder()});
        DefaultFullHttpRequest req = new DefaultFullHttpRequest(HttpVersion.HTTP_1_1, HttpMethod.CONNECT, "google.com:80");
        ch.writeInbound(new Object[]{req});
        DefaultHttpResponse res = new DefaultHttpResponse(HttpVersion.HTTP_1_1, HttpResponseStatus.OK);
        res.headers().set((CharSequence)HttpHeaderNames.TRANSFER_ENCODING, (Object)HttpHeaderValues.CHUNKED);
        ch.writeOutbound(new Object[]{res});
        ch.writeOutbound(new Object[]{LastHttpContent.EMPTY_LAST_CONTENT});
        HttpContentEncoderTest.assertEmptyResponse(ch);
    }

    @Test
    public void testConnectFailureResponse() throws Exception {
        String content = "Not allowed by configuration";
        EmbeddedChannel ch = new EmbeddedChannel(new ChannelHandler[]{new TestEncoder()});
        DefaultFullHttpRequest req = new DefaultFullHttpRequest(HttpVersion.HTTP_1_1, HttpMethod.CONNECT, "google.com:80");
        ch.writeInbound(new Object[]{req});
        DefaultHttpResponse res = new DefaultHttpResponse(HttpVersion.HTTP_1_1, HttpResponseStatus.METHOD_NOT_ALLOWED);
        res.headers().set((CharSequence)HttpHeaderNames.TRANSFER_ENCODING, (Object)HttpHeaderValues.CHUNKED);
        ch.writeOutbound(new Object[]{res});
        ch.writeOutbound(new Object[]{new DefaultHttpContent(Unpooled.wrappedBuffer((byte[])content.getBytes(CharsetUtil.UTF_8)))});
        ch.writeOutbound(new Object[]{LastHttpContent.EMPTY_LAST_CONTENT});
        HttpContentEncoderTest.assertEncodedResponse(ch);
        Object o = ch.readOutbound();
        MatcherAssert.assertThat((Object)o, (Matcher)CoreMatchers.is((Matcher)CoreMatchers.instanceOf(HttpContent.class)));
        HttpContent chunk = (HttpContent)o;
        MatcherAssert.assertThat((Object)chunk.content().toString(CharsetUtil.US_ASCII), (Matcher)CoreMatchers.is((Object)"28"));
        chunk.release();
        chunk = (HttpContent)ch.readOutbound();
        MatcherAssert.assertThat((Object)chunk.content().isReadable(), (Matcher)CoreMatchers.is((Object)true));
        MatcherAssert.assertThat((Object)chunk.content().toString(CharsetUtil.US_ASCII), (Matcher)CoreMatchers.is((Object)"0"));
        chunk.release();
        chunk = (HttpContent)ch.readOutbound();
        MatcherAssert.assertThat((Object)chunk, (Matcher)CoreMatchers.is((Matcher)CoreMatchers.instanceOf(LastHttpContent.class)));
        chunk.release();
        MatcherAssert.assertThat((Object)ch.readOutbound(), (Matcher)CoreMatchers.is((Matcher)CoreMatchers.nullValue()));
    }

    @Test
    public void testHttp1_0() throws Exception {
        EmbeddedChannel ch = new EmbeddedChannel(new ChannelHandler[]{new TestEncoder()});
        DefaultFullHttpRequest req = new DefaultFullHttpRequest(HttpVersion.HTTP_1_0, HttpMethod.GET, "/");
        Assert.assertTrue((boolean)ch.writeInbound(new Object[]{req}));
        DefaultHttpResponse res = new DefaultHttpResponse(HttpVersion.HTTP_1_0, HttpResponseStatus.OK);
        res.headers().set((CharSequence)HttpHeaderNames.CONTENT_LENGTH, (Object)HttpHeaderValues.ZERO);
        Assert.assertTrue((boolean)ch.writeOutbound(new Object[]{res}));
        Assert.assertTrue((boolean)ch.writeOutbound(new Object[]{LastHttpContent.EMPTY_LAST_CONTENT}));
        Assert.assertTrue((boolean)ch.finish());
        FullHttpRequest request = (FullHttpRequest)ch.readInbound();
        Assert.assertTrue((boolean)request.release());
        Assert.assertNull((Object)ch.readInbound());
        HttpResponse response = (HttpResponse)ch.readOutbound();
        Assert.assertSame((Object)res, (Object)response);
        LastHttpContent content = (LastHttpContent)ch.readOutbound();
        Assert.assertSame((Object)LastHttpContent.EMPTY_LAST_CONTENT, (Object)content);
        content.release();
        Assert.assertNull((Object)ch.readOutbound());
    }

    @Test
    public void testCleanupThrows() {
        HttpContentEncoder encoder = new HttpContentEncoder(){

            protected HttpContentEncoder.Result beginEncode(HttpResponse httpResponse, String acceptEncoding) throws Exception {
                return new HttpContentEncoder.Result("myencoding", new EmbeddedChannel(new ChannelHandler[]{new ChannelInboundHandlerAdapter(){

                    public void channelInactive(ChannelHandlerContext ctx) throws Exception {
                        ctx.fireExceptionCaught((Throwable)new EncoderException());
                        ctx.fireChannelInactive();
                    }
                }}));
            }
        };
        final AtomicBoolean channelInactiveCalled = new AtomicBoolean();
        EmbeddedChannel channel = new EmbeddedChannel(new ChannelHandler[]{encoder, new ChannelInboundHandlerAdapter(){

            public void channelInactive(ChannelHandlerContext ctx) throws Exception {
                Assert.assertTrue((boolean)channelInactiveCalled.compareAndSet(false, true));
                super.channelInactive(ctx);
            }
        }});
        Assert.assertTrue((boolean)channel.writeInbound(new Object[]{new DefaultFullHttpRequest(HttpVersion.HTTP_1_1, HttpMethod.GET, "/")}));
        Assert.assertTrue((boolean)channel.writeOutbound(new Object[]{new DefaultHttpResponse(HttpVersion.HTTP_1_1, HttpResponseStatus.OK)}));
        DefaultHttpContent content = new DefaultHttpContent(Unpooled.buffer().writeZero(10));
        Assert.assertTrue((boolean)channel.writeOutbound(new Object[]{content}));
        Assert.assertEquals((long)1L, (long)content.refCnt());
        try {
            channel.finishAndReleaseAll();
            Assert.fail();
        }
        catch (CodecException codecException) {
            // empty catch block
        }
        Assert.assertTrue((boolean)channelInactiveCalled.get());
        Assert.assertEquals((long)0L, (long)content.refCnt());
    }

    private static void assertEmptyResponse(EmbeddedChannel ch) {
        Object o = ch.readOutbound();
        MatcherAssert.assertThat((Object)o, (Matcher)CoreMatchers.is((Matcher)CoreMatchers.instanceOf(HttpResponse.class)));
        HttpResponse res = (HttpResponse)o;
        MatcherAssert.assertThat((Object)res, (Matcher)CoreMatchers.is((Matcher)CoreMatchers.not((Matcher)CoreMatchers.instanceOf(HttpContent.class))));
        MatcherAssert.assertThat((Object)res.headers().get((CharSequence)HttpHeaderNames.TRANSFER_ENCODING), (Matcher)CoreMatchers.is((Object)"chunked"));
        MatcherAssert.assertThat((Object)res.headers().get((CharSequence)HttpHeaderNames.CONTENT_LENGTH), (Matcher)CoreMatchers.is((Matcher)CoreMatchers.nullValue()));
        HttpContent chunk = (HttpContent)ch.readOutbound();
        MatcherAssert.assertThat((Object)chunk, (Matcher)CoreMatchers.is((Matcher)CoreMatchers.instanceOf(LastHttpContent.class)));
        chunk.release();
        MatcherAssert.assertThat((Object)ch.readOutbound(), (Matcher)CoreMatchers.is((Matcher)CoreMatchers.nullValue()));
    }

    private static void assertEncodedResponse(EmbeddedChannel ch) {
        Object o = ch.readOutbound();
        MatcherAssert.assertThat((Object)o, (Matcher)CoreMatchers.is((Matcher)CoreMatchers.instanceOf(HttpResponse.class)));
        HttpResponse res = (HttpResponse)o;
        MatcherAssert.assertThat((Object)res, (Matcher)CoreMatchers.is((Matcher)CoreMatchers.not((Matcher)CoreMatchers.instanceOf(HttpContent.class))));
        MatcherAssert.assertThat((Object)res.headers().get((CharSequence)HttpHeaderNames.TRANSFER_ENCODING), (Matcher)CoreMatchers.is((Object)"chunked"));
        MatcherAssert.assertThat((Object)res.headers().get((CharSequence)HttpHeaderNames.CONTENT_LENGTH), (Matcher)CoreMatchers.is((Matcher)CoreMatchers.nullValue()));
        MatcherAssert.assertThat((Object)res.headers().get((CharSequence)HttpHeaderNames.CONTENT_ENCODING), (Matcher)CoreMatchers.is((Object)"test"));
    }

    private static final class TestEncoder
    extends HttpContentEncoder {
        private TestEncoder() {
        }

        protected HttpContentEncoder.Result beginEncode(HttpResponse httpResponse, String acceptEncoding) {
            return new HttpContentEncoder.Result("test", new EmbeddedChannel(new ChannelHandler[]{new MessageToByteEncoder<ByteBuf>(){

                protected void encode(ChannelHandlerContext ctx, ByteBuf in, ByteBuf out) throws Exception {
                    out.writeBytes(String.valueOf(in.readableBytes()).getBytes(CharsetUtil.US_ASCII));
                    in.skipBytes(in.readableBytes());
                }
            }}));
        }
    }
}

