/*
 * Decompiled with CFR 0.152.
 */
package io.netty.handler.codec.http;

import io.netty.buffer.ByteBuf;
import io.netty.buffer.ByteBufAllocator;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.embedded.EmbeddedChannel;
import io.netty.handler.codec.http.DefaultHttpContent;
import io.netty.handler.codec.http.HttpChunkedInput;
import io.netty.handler.codec.http.HttpContent;
import io.netty.handler.codec.http.LastHttpContent;
import io.netty.handler.stream.ChunkedFile;
import io.netty.handler.stream.ChunkedInput;
import io.netty.handler.stream.ChunkedNioFile;
import io.netty.handler.stream.ChunkedNioStream;
import io.netty.handler.stream.ChunkedStream;
import io.netty.handler.stream.ChunkedWriteHandler;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.channels.Channels;
import org.junit.Assert;
import org.junit.Test;

public class HttpChunkedInputTest {
    private static final byte[] BYTES = new byte[65536];
    private static final File TMP;

    @Test
    public void testChunkedStream() {
        HttpChunkedInputTest.check(new ChunkedInput[]{new HttpChunkedInput((ChunkedInput)new ChunkedStream((InputStream)new ByteArrayInputStream(BYTES)))});
    }

    @Test
    public void testChunkedNioStream() {
        HttpChunkedInputTest.check(new ChunkedInput[]{new HttpChunkedInput((ChunkedInput)new ChunkedNioStream(Channels.newChannel(new ByteArrayInputStream(BYTES))))});
    }

    @Test
    public void testChunkedFile() throws IOException {
        HttpChunkedInputTest.check(new ChunkedInput[]{new HttpChunkedInput((ChunkedInput)new ChunkedFile(TMP))});
    }

    @Test
    public void testChunkedNioFile() throws IOException {
        HttpChunkedInputTest.check(new ChunkedInput[]{new HttpChunkedInput((ChunkedInput)new ChunkedNioFile(TMP))});
    }

    @Test
    public void testWrappedReturnNull() throws Exception {
        HttpChunkedInput input = new HttpChunkedInput((ChunkedInput)new ChunkedInput<ByteBuf>(){

            public boolean isEndOfInput() throws Exception {
                return false;
            }

            public void close() throws Exception {
            }

            public ByteBuf readChunk(ChannelHandlerContext ctx) throws Exception {
                return null;
            }

            public ByteBuf readChunk(ByteBufAllocator allocator) throws Exception {
                return null;
            }

            public long length() {
                return 0L;
            }

            public long progress() {
                return 0L;
            }
        });
        Assert.assertNull((Object)input.readChunk(ByteBufAllocator.DEFAULT));
    }

    private static void check(ChunkedInput<?> ... inputs) {
        HttpContent httpContent;
        EmbeddedChannel ch = new EmbeddedChannel(new ChannelHandler[]{new ChunkedWriteHandler()});
        for (ChunkedInput<?> input : inputs) {
            ch.writeOutbound(new Object[]{input});
        }
        Assert.assertTrue((boolean)ch.finish());
        int i = 0;
        int read = 0;
        HttpContent lastHttpContent = null;
        while ((httpContent = (HttpContent)ch.readOutbound()) != null) {
            if (lastHttpContent != null) {
                Assert.assertTrue((String)"Chunk must be DefaultHttpContent", (boolean)(lastHttpContent instanceof DefaultHttpContent));
            }
            ByteBuf buffer = httpContent.content();
            while (buffer.isReadable()) {
                Assert.assertEquals((long)BYTES[i++], (long)buffer.readByte());
                ++read;
                if (i != BYTES.length) continue;
                i = 0;
            }
            buffer.release();
            lastHttpContent = httpContent;
        }
        Assert.assertEquals((long)(BYTES.length * inputs.length), (long)read);
        Assert.assertSame((String)"Last chunk must be LastHttpContent.EMPTY_LAST_CONTENT", (Object)LastHttpContent.EMPTY_LAST_CONTENT, (Object)lastHttpContent);
    }

    static {
        for (int i = 0; i < BYTES.length; ++i) {
            HttpChunkedInputTest.BYTES[i] = (byte)i;
        }
        FileOutputStream out = null;
        try {
            TMP = File.createTempFile("netty-chunk-", ".tmp");
            TMP.deleteOnExit();
            out = new FileOutputStream(TMP);
            out.write(BYTES);
            out.flush();
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        finally {
            if (out != null) {
                try {
                    out.close();
                }
                catch (IOException iOException) {}
            }
        }
    }
}

