/*
 * Decompiled with CFR 0.152.
 */
package io.netty.handler.codec.http.websocketx;

import io.netty.handler.codec.http.websocketx.WebSocketCloseStatus;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.TreeSet;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;
import org.junit.Assert;
import org.junit.Test;

public class WebSocketCloseStatusTest {
    private final List<WebSocketCloseStatus> validCodes = Arrays.asList(WebSocketCloseStatus.NORMAL_CLOSURE, WebSocketCloseStatus.ENDPOINT_UNAVAILABLE, WebSocketCloseStatus.PROTOCOL_ERROR, WebSocketCloseStatus.INVALID_MESSAGE_TYPE, WebSocketCloseStatus.INVALID_PAYLOAD_DATA, WebSocketCloseStatus.POLICY_VIOLATION, WebSocketCloseStatus.MESSAGE_TOO_BIG, WebSocketCloseStatus.MANDATORY_EXTENSION, WebSocketCloseStatus.INTERNAL_SERVER_ERROR, WebSocketCloseStatus.SERVICE_RESTART, WebSocketCloseStatus.TRY_AGAIN_LATER, WebSocketCloseStatus.BAD_GATEWAY);

    @Test
    public void testToString() {
        Assert.assertEquals((Object)"1000 Bye", (Object)WebSocketCloseStatus.NORMAL_CLOSURE.toString());
    }

    @Test
    public void testKnownStatuses() {
        Assert.assertSame((Object)WebSocketCloseStatus.NORMAL_CLOSURE, (Object)WebSocketCloseStatus.valueOf((int)1000));
        Assert.assertSame((Object)WebSocketCloseStatus.ENDPOINT_UNAVAILABLE, (Object)WebSocketCloseStatus.valueOf((int)1001));
        Assert.assertSame((Object)WebSocketCloseStatus.PROTOCOL_ERROR, (Object)WebSocketCloseStatus.valueOf((int)1002));
        Assert.assertSame((Object)WebSocketCloseStatus.INVALID_MESSAGE_TYPE, (Object)WebSocketCloseStatus.valueOf((int)1003));
        Assert.assertSame((Object)WebSocketCloseStatus.INVALID_PAYLOAD_DATA, (Object)WebSocketCloseStatus.valueOf((int)1007));
        Assert.assertSame((Object)WebSocketCloseStatus.POLICY_VIOLATION, (Object)WebSocketCloseStatus.valueOf((int)1008));
        Assert.assertSame((Object)WebSocketCloseStatus.MESSAGE_TOO_BIG, (Object)WebSocketCloseStatus.valueOf((int)1009));
        Assert.assertSame((Object)WebSocketCloseStatus.MANDATORY_EXTENSION, (Object)WebSocketCloseStatus.valueOf((int)1010));
        Assert.assertSame((Object)WebSocketCloseStatus.INTERNAL_SERVER_ERROR, (Object)WebSocketCloseStatus.valueOf((int)1011));
        Assert.assertSame((Object)WebSocketCloseStatus.SERVICE_RESTART, (Object)WebSocketCloseStatus.valueOf((int)1012));
        Assert.assertSame((Object)WebSocketCloseStatus.TRY_AGAIN_LATER, (Object)WebSocketCloseStatus.valueOf((int)1013));
        Assert.assertSame((Object)WebSocketCloseStatus.BAD_GATEWAY, (Object)WebSocketCloseStatus.valueOf((int)1014));
    }

    @Test
    public void testNaturalOrder() {
        MatcherAssert.assertThat((Object)WebSocketCloseStatus.PROTOCOL_ERROR, (Matcher)Matchers.greaterThan((Comparable)WebSocketCloseStatus.NORMAL_CLOSURE));
        MatcherAssert.assertThat((Object)WebSocketCloseStatus.PROTOCOL_ERROR, (Matcher)Matchers.greaterThan((Comparable)WebSocketCloseStatus.valueOf((int)1001)));
        MatcherAssert.assertThat((Object)WebSocketCloseStatus.PROTOCOL_ERROR, (Matcher)Matchers.comparesEqualTo((Comparable)WebSocketCloseStatus.PROTOCOL_ERROR));
        MatcherAssert.assertThat((Object)WebSocketCloseStatus.PROTOCOL_ERROR, (Matcher)Matchers.comparesEqualTo((Comparable)WebSocketCloseStatus.valueOf((int)1002)));
        MatcherAssert.assertThat((Object)WebSocketCloseStatus.PROTOCOL_ERROR, (Matcher)Matchers.lessThan((Comparable)WebSocketCloseStatus.INVALID_MESSAGE_TYPE));
        MatcherAssert.assertThat((Object)WebSocketCloseStatus.PROTOCOL_ERROR, (Matcher)Matchers.lessThan((Comparable)WebSocketCloseStatus.valueOf((int)1007)));
    }

    @Test
    public void testUserDefinedStatuses() {
        WebSocketCloseStatus feedTimeot = new WebSocketCloseStatus(6033, "Feed timed out");
        WebSocketCloseStatus untradablePrice = new WebSocketCloseStatus(6034, "Untradable price");
        Assert.assertNotSame((Object)feedTimeot, (Object)WebSocketCloseStatus.valueOf((int)6033));
        Assert.assertEquals((long)feedTimeot.code(), (long)6033L);
        Assert.assertEquals((Object)feedTimeot.reasonText(), (Object)"Feed timed out");
        Assert.assertNotSame((Object)untradablePrice, (Object)WebSocketCloseStatus.valueOf((int)6034));
        Assert.assertEquals((long)untradablePrice.code(), (long)6034L);
        Assert.assertEquals((Object)untradablePrice.reasonText(), (Object)"Untradable price");
    }

    @Test
    public void testRfc6455CodeValidation() {
        List<Integer> knownCodes = Arrays.asList(WebSocketCloseStatus.NORMAL_CLOSURE.code(), WebSocketCloseStatus.ENDPOINT_UNAVAILABLE.code(), WebSocketCloseStatus.PROTOCOL_ERROR.code(), WebSocketCloseStatus.INVALID_MESSAGE_TYPE.code(), WebSocketCloseStatus.INVALID_PAYLOAD_DATA.code(), WebSocketCloseStatus.POLICY_VIOLATION.code(), WebSocketCloseStatus.MESSAGE_TOO_BIG.code(), WebSocketCloseStatus.MANDATORY_EXTENSION.code(), WebSocketCloseStatus.INTERNAL_SERVER_ERROR.code(), WebSocketCloseStatus.SERVICE_RESTART.code(), WebSocketCloseStatus.TRY_AGAIN_LATER.code(), WebSocketCloseStatus.BAD_GATEWAY.code());
        TreeSet<Integer> invalidCodes = new TreeSet<Integer>();
        for (int statusCode = Short.MIN_VALUE; statusCode < Short.MAX_VALUE; ++statusCode) {
            if (WebSocketCloseStatus.isValidStatusCode((int)statusCode)) continue;
            invalidCodes.add(statusCode);
        }
        Assert.assertEquals((long)0L, (long)((Integer)invalidCodes.first()).intValue());
        Assert.assertEquals((long)2999L, (long)((Integer)invalidCodes.last()).intValue());
        Assert.assertEquals((long)(3000 - this.validCodes.size()), (long)invalidCodes.size());
        invalidCodes.retainAll(knownCodes);
        Assert.assertEquals(invalidCodes, Collections.emptySet());
    }
}

