/*
 * Decompiled with CFR 0.152.
 */
package io.netty.handler.codec.http.websocketx.extensions;

import io.netty.channel.ChannelHandler;
import io.netty.channel.embedded.EmbeddedChannel;
import io.netty.handler.codec.CodecException;
import io.netty.handler.codec.http.HttpHeaderNames;
import io.netty.handler.codec.http.HttpRequest;
import io.netty.handler.codec.http.HttpResponse;
import io.netty.handler.codec.http.websocketx.extensions.WebSocketClientExtension;
import io.netty.handler.codec.http.websocketx.extensions.WebSocketClientExtensionHandler;
import io.netty.handler.codec.http.websocketx.extensions.WebSocketClientExtensionHandshaker;
import io.netty.handler.codec.http.websocketx.extensions.WebSocketExtensionData;
import io.netty.handler.codec.http.websocketx.extensions.WebSocketExtensionTestUtil;
import io.netty.handler.codec.http.websocketx.extensions.WebSocketExtensionUtil;
import java.util.Collections;
import java.util.List;
import org.junit.Assert;
import org.junit.Test;
import org.mockito.Mockito;
import org.mockito.verification.VerificationMode;

public class WebSocketClientExtensionHandlerTest {
    WebSocketClientExtensionHandshaker mainHandshakerMock = (WebSocketClientExtensionHandshaker)Mockito.mock(WebSocketClientExtensionHandshaker.class, (String)"mainHandshaker");
    WebSocketClientExtensionHandshaker fallbackHandshakerMock = (WebSocketClientExtensionHandshaker)Mockito.mock(WebSocketClientExtensionHandshaker.class, (String)"fallbackHandshaker");
    WebSocketClientExtension mainExtensionMock = (WebSocketClientExtension)Mockito.mock(WebSocketClientExtension.class, (String)"mainExtension");
    WebSocketClientExtension fallbackExtensionMock = (WebSocketClientExtension)Mockito.mock(WebSocketClientExtension.class, (String)"fallbackExtension");

    @Test
    public void testMainSuccess() {
        Mockito.when((Object)this.mainHandshakerMock.newRequestData()).thenReturn((Object)new WebSocketExtensionData("main", Collections.emptyMap()));
        Mockito.when((Object)this.mainHandshakerMock.handshakeExtension((WebSocketExtensionData)Mockito.any(WebSocketExtensionData.class))).thenReturn((Object)this.mainExtensionMock);
        Mockito.when((Object)this.fallbackHandshakerMock.newRequestData()).thenReturn((Object)new WebSocketExtensionData("fallback", Collections.emptyMap()));
        Mockito.when((Object)this.mainExtensionMock.rsv()).thenReturn((Object)4);
        Mockito.when((Object)this.mainExtensionMock.newExtensionEncoder()).thenReturn((Object)new WebSocketExtensionTestUtil.DummyEncoder());
        Mockito.when((Object)this.mainExtensionMock.newExtensionDecoder()).thenReturn((Object)new WebSocketExtensionTestUtil.DummyDecoder());
        EmbeddedChannel ch = new EmbeddedChannel(new ChannelHandler[]{new WebSocketClientExtensionHandler(new WebSocketClientExtensionHandshaker[]{this.mainHandshakerMock, this.fallbackHandshakerMock})});
        HttpRequest req = WebSocketExtensionTestUtil.newUpgradeRequest(null);
        ch.writeOutbound(new Object[]{req});
        HttpRequest req2 = (HttpRequest)ch.readOutbound();
        List reqExts = WebSocketExtensionUtil.extractExtensions((String)req2.headers().get((CharSequence)HttpHeaderNames.SEC_WEBSOCKET_EXTENSIONS));
        HttpResponse res = WebSocketExtensionTestUtil.newUpgradeResponse("main");
        ch.writeInbound(new Object[]{res});
        HttpResponse res2 = (HttpResponse)ch.readInbound();
        List resExts = WebSocketExtensionUtil.extractExtensions((String)res2.headers().get((CharSequence)HttpHeaderNames.SEC_WEBSOCKET_EXTENSIONS));
        Assert.assertEquals((long)2L, (long)reqExts.size());
        Assert.assertEquals((Object)"main", (Object)((WebSocketExtensionData)reqExts.get(0)).name());
        Assert.assertEquals((Object)"fallback", (Object)((WebSocketExtensionData)reqExts.get(1)).name());
        Assert.assertEquals((long)1L, (long)resExts.size());
        Assert.assertEquals((Object)"main", (Object)((WebSocketExtensionData)resExts.get(0)).name());
        Assert.assertTrue((boolean)((WebSocketExtensionData)resExts.get(0)).parameters().isEmpty());
        Assert.assertNotNull((Object)ch.pipeline().get(WebSocketExtensionTestUtil.DummyDecoder.class));
        Assert.assertNotNull((Object)(ch.pipeline().get(WebSocketExtensionTestUtil.DummyEncoder.class) != null ? 1 : 0));
        ((WebSocketClientExtensionHandshaker)Mockito.verify((Object)this.mainHandshakerMock)).newRequestData();
        ((WebSocketClientExtensionHandshaker)Mockito.verify((Object)this.mainHandshakerMock)).handshakeExtension((WebSocketExtensionData)Mockito.any(WebSocketExtensionData.class));
        ((WebSocketClientExtensionHandshaker)Mockito.verify((Object)this.fallbackHandshakerMock)).newRequestData();
        ((WebSocketClientExtension)Mockito.verify((Object)this.mainExtensionMock, (VerificationMode)Mockito.atLeastOnce())).rsv();
        ((WebSocketClientExtension)Mockito.verify((Object)this.mainExtensionMock)).newExtensionEncoder();
        ((WebSocketClientExtension)Mockito.verify((Object)this.mainExtensionMock)).newExtensionDecoder();
    }

    @Test
    public void testFallbackSuccess() {
        Mockito.when((Object)this.mainHandshakerMock.newRequestData()).thenReturn((Object)new WebSocketExtensionData("main", Collections.emptyMap()));
        Mockito.when((Object)this.mainHandshakerMock.handshakeExtension((WebSocketExtensionData)Mockito.any(WebSocketExtensionData.class))).thenReturn(null);
        Mockito.when((Object)this.fallbackHandshakerMock.newRequestData()).thenReturn((Object)new WebSocketExtensionData("fallback", Collections.emptyMap()));
        Mockito.when((Object)this.fallbackHandshakerMock.handshakeExtension((WebSocketExtensionData)Mockito.any(WebSocketExtensionData.class))).thenReturn((Object)this.fallbackExtensionMock);
        Mockito.when((Object)this.fallbackExtensionMock.rsv()).thenReturn((Object)4);
        Mockito.when((Object)this.fallbackExtensionMock.newExtensionEncoder()).thenReturn((Object)new WebSocketExtensionTestUtil.DummyEncoder());
        Mockito.when((Object)this.fallbackExtensionMock.newExtensionDecoder()).thenReturn((Object)new WebSocketExtensionTestUtil.DummyDecoder());
        EmbeddedChannel ch = new EmbeddedChannel(new ChannelHandler[]{new WebSocketClientExtensionHandler(new WebSocketClientExtensionHandshaker[]{this.mainHandshakerMock, this.fallbackHandshakerMock})});
        HttpRequest req = WebSocketExtensionTestUtil.newUpgradeRequest(null);
        ch.writeOutbound(new Object[]{req});
        HttpRequest req2 = (HttpRequest)ch.readOutbound();
        List reqExts = WebSocketExtensionUtil.extractExtensions((String)req2.headers().get((CharSequence)HttpHeaderNames.SEC_WEBSOCKET_EXTENSIONS));
        HttpResponse res = WebSocketExtensionTestUtil.newUpgradeResponse("fallback");
        ch.writeInbound(new Object[]{res});
        HttpResponse res2 = (HttpResponse)ch.readInbound();
        List resExts = WebSocketExtensionUtil.extractExtensions((String)res2.headers().get((CharSequence)HttpHeaderNames.SEC_WEBSOCKET_EXTENSIONS));
        Assert.assertEquals((long)2L, (long)reqExts.size());
        Assert.assertEquals((Object)"main", (Object)((WebSocketExtensionData)reqExts.get(0)).name());
        Assert.assertEquals((Object)"fallback", (Object)((WebSocketExtensionData)reqExts.get(1)).name());
        Assert.assertEquals((long)1L, (long)resExts.size());
        Assert.assertEquals((Object)"fallback", (Object)((WebSocketExtensionData)resExts.get(0)).name());
        Assert.assertTrue((boolean)((WebSocketExtensionData)resExts.get(0)).parameters().isEmpty());
        Assert.assertNotNull((Object)ch.pipeline().get(WebSocketExtensionTestUtil.DummyDecoder.class));
        Assert.assertNotNull((Object)ch.pipeline().get(WebSocketExtensionTestUtil.DummyEncoder.class));
        ((WebSocketClientExtensionHandshaker)Mockito.verify((Object)this.mainHandshakerMock)).newRequestData();
        ((WebSocketClientExtensionHandshaker)Mockito.verify((Object)this.mainHandshakerMock)).handshakeExtension((WebSocketExtensionData)Mockito.any(WebSocketExtensionData.class));
        ((WebSocketClientExtensionHandshaker)Mockito.verify((Object)this.fallbackHandshakerMock)).newRequestData();
        ((WebSocketClientExtensionHandshaker)Mockito.verify((Object)this.fallbackHandshakerMock)).handshakeExtension((WebSocketExtensionData)Mockito.any(WebSocketExtensionData.class));
        ((WebSocketClientExtension)Mockito.verify((Object)this.fallbackExtensionMock, (VerificationMode)Mockito.atLeastOnce())).rsv();
        ((WebSocketClientExtension)Mockito.verify((Object)this.fallbackExtensionMock)).newExtensionEncoder();
        ((WebSocketClientExtension)Mockito.verify((Object)this.fallbackExtensionMock)).newExtensionDecoder();
    }

    @Test
    public void testAllSuccess() {
        Mockito.when((Object)this.mainHandshakerMock.newRequestData()).thenReturn((Object)new WebSocketExtensionData("main", Collections.emptyMap()));
        Mockito.when((Object)this.mainHandshakerMock.handshakeExtension(WebSocketExtensionTestUtil.webSocketExtensionDataMatcher("main"))).thenReturn((Object)this.mainExtensionMock);
        Mockito.when((Object)this.mainHandshakerMock.handshakeExtension(WebSocketExtensionTestUtil.webSocketExtensionDataMatcher("fallback"))).thenReturn(null);
        Mockito.when((Object)this.fallbackHandshakerMock.newRequestData()).thenReturn((Object)new WebSocketExtensionData("fallback", Collections.emptyMap()));
        Mockito.when((Object)this.fallbackHandshakerMock.handshakeExtension(WebSocketExtensionTestUtil.webSocketExtensionDataMatcher("main"))).thenReturn(null);
        Mockito.when((Object)this.fallbackHandshakerMock.handshakeExtension(WebSocketExtensionTestUtil.webSocketExtensionDataMatcher("fallback"))).thenReturn((Object)this.fallbackExtensionMock);
        WebSocketExtensionTestUtil.DummyEncoder mainEncoder = new WebSocketExtensionTestUtil.DummyEncoder();
        WebSocketExtensionTestUtil.DummyDecoder mainDecoder = new WebSocketExtensionTestUtil.DummyDecoder();
        Mockito.when((Object)this.mainExtensionMock.rsv()).thenReturn((Object)4);
        Mockito.when((Object)this.mainExtensionMock.newExtensionEncoder()).thenReturn((Object)mainEncoder);
        Mockito.when((Object)this.mainExtensionMock.newExtensionDecoder()).thenReturn((Object)mainDecoder);
        WebSocketExtensionTestUtil.Dummy2Encoder fallbackEncoder = new WebSocketExtensionTestUtil.Dummy2Encoder();
        WebSocketExtensionTestUtil.Dummy2Decoder fallbackDecoder = new WebSocketExtensionTestUtil.Dummy2Decoder();
        Mockito.when((Object)this.fallbackExtensionMock.rsv()).thenReturn((Object)2);
        Mockito.when((Object)this.fallbackExtensionMock.newExtensionEncoder()).thenReturn((Object)fallbackEncoder);
        Mockito.when((Object)this.fallbackExtensionMock.newExtensionDecoder()).thenReturn((Object)fallbackDecoder);
        EmbeddedChannel ch = new EmbeddedChannel(new ChannelHandler[]{new WebSocketClientExtensionHandler(new WebSocketClientExtensionHandshaker[]{this.mainHandshakerMock, this.fallbackHandshakerMock})});
        HttpRequest req = WebSocketExtensionTestUtil.newUpgradeRequest(null);
        ch.writeOutbound(new Object[]{req});
        HttpRequest req2 = (HttpRequest)ch.readOutbound();
        List reqExts = WebSocketExtensionUtil.extractExtensions((String)req2.headers().get((CharSequence)HttpHeaderNames.SEC_WEBSOCKET_EXTENSIONS));
        HttpResponse res = WebSocketExtensionTestUtil.newUpgradeResponse("main, fallback");
        ch.writeInbound(new Object[]{res});
        HttpResponse res2 = (HttpResponse)ch.readInbound();
        List resExts = WebSocketExtensionUtil.extractExtensions((String)res2.headers().get((CharSequence)HttpHeaderNames.SEC_WEBSOCKET_EXTENSIONS));
        Assert.assertEquals((long)2L, (long)reqExts.size());
        Assert.assertEquals((Object)"main", (Object)((WebSocketExtensionData)reqExts.get(0)).name());
        Assert.assertEquals((Object)"fallback", (Object)((WebSocketExtensionData)reqExts.get(1)).name());
        Assert.assertEquals((long)2L, (long)resExts.size());
        Assert.assertEquals((Object)"main", (Object)((WebSocketExtensionData)resExts.get(0)).name());
        Assert.assertEquals((Object)"fallback", (Object)((WebSocketExtensionData)resExts.get(1)).name());
        Assert.assertNotNull((Object)ch.pipeline().context((ChannelHandler)mainEncoder));
        Assert.assertNotNull((Object)ch.pipeline().context((ChannelHandler)mainDecoder));
        Assert.assertNotNull((Object)ch.pipeline().context((ChannelHandler)fallbackEncoder));
        Assert.assertNotNull((Object)ch.pipeline().context((ChannelHandler)fallbackDecoder));
        ((WebSocketClientExtensionHandshaker)Mockito.verify((Object)this.mainHandshakerMock)).newRequestData();
        ((WebSocketClientExtensionHandshaker)Mockito.verify((Object)this.mainHandshakerMock)).handshakeExtension(WebSocketExtensionTestUtil.webSocketExtensionDataMatcher("main"));
        ((WebSocketClientExtensionHandshaker)Mockito.verify((Object)this.mainHandshakerMock)).handshakeExtension(WebSocketExtensionTestUtil.webSocketExtensionDataMatcher("fallback"));
        ((WebSocketClientExtensionHandshaker)Mockito.verify((Object)this.fallbackHandshakerMock)).newRequestData();
        ((WebSocketClientExtensionHandshaker)Mockito.verify((Object)this.fallbackHandshakerMock)).handshakeExtension(WebSocketExtensionTestUtil.webSocketExtensionDataMatcher("fallback"));
        ((WebSocketClientExtension)Mockito.verify((Object)this.mainExtensionMock, (VerificationMode)Mockito.atLeastOnce())).rsv();
        ((WebSocketClientExtension)Mockito.verify((Object)this.mainExtensionMock)).newExtensionEncoder();
        ((WebSocketClientExtension)Mockito.verify((Object)this.mainExtensionMock)).newExtensionDecoder();
        ((WebSocketClientExtension)Mockito.verify((Object)this.fallbackExtensionMock, (VerificationMode)Mockito.atLeastOnce())).rsv();
        ((WebSocketClientExtension)Mockito.verify((Object)this.fallbackExtensionMock)).newExtensionEncoder();
        ((WebSocketClientExtension)Mockito.verify((Object)this.fallbackExtensionMock)).newExtensionDecoder();
    }

    @Test(expected=CodecException.class)
    public void testIfMainAndFallbackUseRSV1WillFail() {
        Mockito.when((Object)this.mainHandshakerMock.newRequestData()).thenReturn((Object)new WebSocketExtensionData("main", Collections.emptyMap()));
        Mockito.when((Object)this.mainHandshakerMock.handshakeExtension(WebSocketExtensionTestUtil.webSocketExtensionDataMatcher("main"))).thenReturn((Object)this.mainExtensionMock);
        Mockito.when((Object)this.mainHandshakerMock.handshakeExtension(WebSocketExtensionTestUtil.webSocketExtensionDataMatcher("fallback"))).thenReturn(null);
        Mockito.when((Object)this.fallbackHandshakerMock.newRequestData()).thenReturn((Object)new WebSocketExtensionData("fallback", Collections.emptyMap()));
        Mockito.when((Object)this.fallbackHandshakerMock.handshakeExtension(WebSocketExtensionTestUtil.webSocketExtensionDataMatcher("main"))).thenReturn(null);
        Mockito.when((Object)this.fallbackHandshakerMock.handshakeExtension(WebSocketExtensionTestUtil.webSocketExtensionDataMatcher("fallback"))).thenReturn((Object)this.fallbackExtensionMock);
        Mockito.when((Object)this.mainExtensionMock.rsv()).thenReturn((Object)4);
        Mockito.when((Object)this.fallbackExtensionMock.rsv()).thenReturn((Object)4);
        EmbeddedChannel ch = new EmbeddedChannel(new ChannelHandler[]{new WebSocketClientExtensionHandler(new WebSocketClientExtensionHandshaker[]{this.mainHandshakerMock, this.fallbackHandshakerMock})});
        HttpRequest req = WebSocketExtensionTestUtil.newUpgradeRequest(null);
        ch.writeOutbound(new Object[]{req});
        HttpRequest req2 = (HttpRequest)ch.readOutbound();
        List reqExts = WebSocketExtensionUtil.extractExtensions((String)req2.headers().get((CharSequence)HttpHeaderNames.SEC_WEBSOCKET_EXTENSIONS));
        HttpResponse res = WebSocketExtensionTestUtil.newUpgradeResponse("main, fallback");
        ch.writeInbound(new Object[]{res});
        Assert.assertEquals((long)2L, (long)reqExts.size());
        Assert.assertEquals((Object)"main", (Object)((WebSocketExtensionData)reqExts.get(0)).name());
        Assert.assertEquals((Object)"fallback", (Object)((WebSocketExtensionData)reqExts.get(1)).name());
        ((WebSocketClientExtensionHandshaker)Mockito.verify((Object)this.mainHandshakerMock)).newRequestData();
        ((WebSocketClientExtensionHandshaker)Mockito.verify((Object)this.mainHandshakerMock, (VerificationMode)Mockito.atLeastOnce())).handshakeExtension(WebSocketExtensionTestUtil.webSocketExtensionDataMatcher("main"));
        ((WebSocketClientExtensionHandshaker)Mockito.verify((Object)this.mainHandshakerMock, (VerificationMode)Mockito.atLeastOnce())).handshakeExtension(WebSocketExtensionTestUtil.webSocketExtensionDataMatcher("fallback"));
        ((WebSocketClientExtensionHandshaker)Mockito.verify((Object)this.fallbackHandshakerMock)).newRequestData();
        ((WebSocketClientExtensionHandshaker)Mockito.verify((Object)this.fallbackHandshakerMock, (VerificationMode)Mockito.atLeastOnce())).handshakeExtension(WebSocketExtensionTestUtil.webSocketExtensionDataMatcher("main"));
        ((WebSocketClientExtensionHandshaker)Mockito.verify((Object)this.fallbackHandshakerMock, (VerificationMode)Mockito.atLeastOnce())).handshakeExtension(WebSocketExtensionTestUtil.webSocketExtensionDataMatcher("fallback"));
        ((WebSocketClientExtension)Mockito.verify((Object)this.mainExtensionMock, (VerificationMode)Mockito.atLeastOnce())).rsv();
        ((WebSocketClientExtension)Mockito.verify((Object)this.fallbackExtensionMock, (VerificationMode)Mockito.atLeastOnce())).rsv();
    }
}

