/*
 * Decompiled with CFR 0.152.
 */
package io.netty.handler.codec.http.websocketx;

import io.netty.handler.codec.http.DefaultFullHttpRequest;
import io.netty.handler.codec.http.DefaultHttpHeaders;
import io.netty.handler.codec.http.FullHttpRequest;
import io.netty.handler.codec.http.FullHttpResponse;
import io.netty.handler.codec.http.HttpHeaderNames;
import io.netty.handler.codec.http.HttpHeaderValues;
import io.netty.handler.codec.http.HttpHeaders;
import io.netty.handler.codec.http.HttpMethod;
import io.netty.handler.codec.http.HttpVersion;
import io.netty.handler.codec.http.websocketx.WebSocketDecoderConfig;
import io.netty.handler.codec.http.websocketx.WebSocketServerHandshaker;
import io.netty.handler.codec.http.websocketx.WebSocketVersion;
import org.junit.Assert;
import org.junit.Test;

public abstract class WebSocketServerHandshakerTest {
    protected abstract WebSocketServerHandshaker newHandshaker(String var1, String var2, WebSocketDecoderConfig var3);

    protected abstract WebSocketVersion webSocketVersion();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testDuplicateHandshakeResponseHeaders() {
        WebSocketServerHandshaker serverHandshaker = this.newHandshaker("ws://example.com/chat", "chat", WebSocketDecoderConfig.DEFAULT);
        DefaultFullHttpRequest request = new DefaultFullHttpRequest(HttpVersion.HTTP_1_1, HttpMethod.GET, "/chat");
        request.headers().set((CharSequence)HttpHeaderNames.HOST, (Object)"example.com").set((CharSequence)HttpHeaderNames.ORIGIN, (Object)"example.com").set((CharSequence)HttpHeaderNames.UPGRADE, (Object)HttpHeaderValues.WEBSOCKET).set((CharSequence)HttpHeaderNames.CONNECTION, (Object)HttpHeaderValues.UPGRADE).set((CharSequence)HttpHeaderNames.SEC_WEBSOCKET_KEY, (Object)"dGhlIHNhbXBsZSBub25jZQ==").set((CharSequence)HttpHeaderNames.SEC_WEBSOCKET_ORIGIN, (Object)"http://example.com").set((CharSequence)HttpHeaderNames.SEC_WEBSOCKET_PROTOCOL, (Object)"chat, superchat").set((CharSequence)HttpHeaderNames.SEC_WEBSOCKET_VERSION, (Object)this.webSocketVersion().toAsciiString());
        DefaultHttpHeaders customResponseHeaders = new DefaultHttpHeaders();
        customResponseHeaders.set((CharSequence)HttpHeaderNames.CONNECTION, (Object)HttpHeaderValues.UPGRADE).set((CharSequence)HttpHeaderNames.UPGRADE, (Object)HttpHeaderValues.WEBSOCKET).set("custom", (Object)"header");
        if (this.webSocketVersion() != WebSocketVersion.V00) {
            customResponseHeaders.set((CharSequence)HttpHeaderNames.SEC_WEBSOCKET_ACCEPT, (Object)"12345");
        }
        FullHttpResponse response = null;
        try {
            response = serverHandshaker.newHandshakeResponse((FullHttpRequest)request, (HttpHeaders)customResponseHeaders);
            HttpHeaders responseHeaders = response.headers();
            Assert.assertEquals((long)1L, (long)responseHeaders.getAll((CharSequence)HttpHeaderNames.CONNECTION).size());
            Assert.assertEquals((long)1L, (long)responseHeaders.getAll((CharSequence)HttpHeaderNames.UPGRADE).size());
            Assert.assertTrue((boolean)responseHeaders.containsValue((CharSequence)"custom", (CharSequence)"header", true));
            if (this.webSocketVersion() != WebSocketVersion.V00) {
                Assert.assertFalse((boolean)responseHeaders.containsValue((CharSequence)HttpHeaderNames.SEC_WEBSOCKET_ACCEPT, (CharSequence)"12345", false));
            }
        }
        finally {
            request.release();
            if (response != null) {
                response.release();
            }
        }
    }
}

