/*
 * Decompiled with CFR 0.152.
 */
package io.netty.handler.codec.http;

import io.netty.buffer.Unpooled;
import io.netty.channel.ChannelHandler;
import io.netty.channel.embedded.EmbeddedChannel;
import io.netty.handler.codec.http.HttpHeaderNames;
import io.netty.handler.codec.http.HttpRequest;
import io.netty.handler.codec.http.HttpRequestDecoder;
import io.netty.handler.codec.http.LastHttpContent;
import io.netty.util.CharsetUtil;
import java.nio.charset.Charset;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;
import org.hamcrest.core.IsInstanceOf;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;

@RunWith(value=Parameterized.class)
public class MultipleContentLengthHeadersTest {
    private final boolean allowDuplicateContentLengths;
    private final boolean sameValue;
    private final boolean singleField;
    private EmbeddedChannel channel;

    @Parameterized.Parameters
    public static Collection<Object[]> parameters() {
        return Arrays.asList({false, false, false}, {false, false, true}, {false, true, false}, {false, true, true}, {true, false, false}, {true, false, true}, {true, true, false}, {true, true, true});
    }

    public MultipleContentLengthHeadersTest(boolean allowDuplicateContentLengths, boolean sameValue, boolean singleField) {
        this.allowDuplicateContentLengths = allowDuplicateContentLengths;
        this.sameValue = sameValue;
        this.singleField = singleField;
    }

    @Before
    public void setUp() {
        HttpRequestDecoder decoder = new HttpRequestDecoder(4096, 8192, 8192, true, 128, this.allowDuplicateContentLengths);
        this.channel = new EmbeddedChannel(new ChannelHandler[]{decoder});
    }

    @Test
    public void testMultipleContentLengthHeadersBehavior() {
        String requestStr = this.setupRequestString();
        MatcherAssert.assertThat((Object)this.channel.writeInbound(new Object[]{Unpooled.copiedBuffer((CharSequence)requestStr, (Charset)CharsetUtil.US_ASCII)}), (Matcher)Matchers.is((Object)true));
        HttpRequest request = (HttpRequest)this.channel.readInbound();
        if (this.allowDuplicateContentLengths) {
            if (this.sameValue) {
                MultipleContentLengthHeadersTest.assertValid(request);
                List contentLengths = request.headers().getAll((CharSequence)HttpHeaderNames.CONTENT_LENGTH);
                MatcherAssert.assertThat((Object)contentLengths, (Matcher)Matchers.contains((Object[])new String[]{"1"}));
                LastHttpContent body = (LastHttpContent)this.channel.readInbound();
                MatcherAssert.assertThat((Object)body.content().readableBytes(), (Matcher)Matchers.is((Object)1));
                MatcherAssert.assertThat((Object)body.content().readCharSequence(1, CharsetUtil.US_ASCII).toString(), (Matcher)Matchers.is((Object)"a"));
            } else {
                MultipleContentLengthHeadersTest.assertInvalid(request);
            }
        } else {
            MultipleContentLengthHeadersTest.assertInvalid(request);
        }
        MatcherAssert.assertThat((Object)this.channel.finish(), (Matcher)Matchers.is((Object)false));
    }

    private String setupRequestString() {
        String firstValue = "1";
        String secondValue = this.sameValue ? firstValue : "2";
        String contentLength = this.singleField ? "Content-Length: " + firstValue + ", " + secondValue + "\r\n\r\n" : "Content-Length: " + firstValue + "\r\nContent-Length: " + secondValue + "\r\n\r\n";
        return "PUT /some/path HTTP/1.1\r\n" + contentLength + "ab";
    }

    @Test
    public void testDanglingComma() {
        String requestStr = "GET /some/path HTTP/1.1\r\nContent-Length: 1,\r\nConnection: close\n\nab";
        MatcherAssert.assertThat((Object)this.channel.writeInbound(new Object[]{Unpooled.copiedBuffer((CharSequence)requestStr, (Charset)CharsetUtil.US_ASCII)}), (Matcher)Matchers.is((Object)true));
        HttpRequest request = (HttpRequest)this.channel.readInbound();
        MultipleContentLengthHeadersTest.assertInvalid(request);
        MatcherAssert.assertThat((Object)this.channel.finish(), (Matcher)Matchers.is((Object)false));
    }

    private static void assertValid(HttpRequest request) {
        MatcherAssert.assertThat((Object)request.decoderResult().isFailure(), (Matcher)Matchers.is((Object)false));
    }

    private static void assertInvalid(HttpRequest request) {
        MatcherAssert.assertThat((Object)request.decoderResult().isFailure(), (Matcher)Matchers.is((Object)true));
        MatcherAssert.assertThat((Object)request.decoderResult().cause(), (Matcher)IsInstanceOf.instanceOf(IllegalArgumentException.class));
        MatcherAssert.assertThat((Object)request.decoderResult().cause().getMessage(), (Matcher)Matchers.containsString((String)"Multiple Content-Length values found"));
    }
}

