/*
 * Decompiled with CFR 0.152.
 */
package io.netty.handler.codec.http;

import io.netty.buffer.ByteBuf;
import io.netty.buffer.Unpooled;
import io.netty.channel.ChannelDuplexHandler;
import io.netty.channel.ChannelFuture;
import io.netty.channel.ChannelFutureListener;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.ChannelInboundHandlerAdapter;
import io.netty.channel.ChannelPromise;
import io.netty.channel.embedded.EmbeddedChannel;
import io.netty.handler.codec.http.FullHttpRequest;
import io.netty.handler.codec.http.HttpHeaders;
import io.netty.handler.codec.http.HttpServerCodec;
import io.netty.handler.codec.http.HttpServerUpgradeHandler;
import io.netty.util.CharsetUtil;
import io.netty.util.concurrent.GenericFutureListener;
import java.nio.charset.Charset;
import java.util.Collection;
import java.util.Collections;
import org.junit.Assert;
import org.junit.Test;

public class HttpServerUpgradeHandlerTest {
    @Test
    public void upgradesPipelineInSameMethodInvocation() {
        HttpServerCodec httpServerCodec = new HttpServerCodec();
        HttpServerUpgradeHandler.UpgradeCodecFactory factory = new HttpServerUpgradeHandler.UpgradeCodecFactory(){

            public HttpServerUpgradeHandler.UpgradeCodec newUpgradeCodec(CharSequence protocol) {
                return new TestUpgradeCodec();
            }
        };
        ChannelDuplexHandler testInStackFrame = new ChannelDuplexHandler(){
            private boolean inReadCall;
            private boolean writeUpgradeMessage;
            private boolean writeFlushed;

            public void channelRead(ChannelHandlerContext ctx, Object msg) throws Exception {
                Assert.assertFalse((boolean)this.inReadCall);
                Assert.assertFalse((boolean)this.writeUpgradeMessage);
                this.inReadCall = true;
                try {
                    super.channelRead(ctx, msg);
                    Assert.assertTrue((boolean)this.writeUpgradeMessage);
                    Assert.assertFalse((boolean)this.writeFlushed);
                    Assert.assertNull((Object)ctx.pipeline().get(HttpServerCodec.class));
                    Assert.assertNotNull((Object)ctx.pipeline().get("marker"));
                }
                finally {
                    this.inReadCall = false;
                }
            }

            public void write(final ChannelHandlerContext ctx, final Object msg, final ChannelPromise promise) {
                Assert.assertTrue((boolean)this.inReadCall);
                this.writeUpgradeMessage = true;
                ctx.channel().eventLoop().execute(new Runnable(){

                    @Override
                    public void run() {
                        ctx.write(msg, promise);
                    }
                });
                promise.addListener((GenericFutureListener)new ChannelFutureListener(){

                    public void operationComplete(ChannelFuture future) {
                        writeFlushed = true;
                    }
                });
            }
        };
        HttpServerUpgradeHandler upgradeHandler = new HttpServerUpgradeHandler((HttpServerUpgradeHandler.SourceCodec)httpServerCodec, factory);
        EmbeddedChannel channel = new EmbeddedChannel(new ChannelHandler[]{testInStackFrame, httpServerCodec, upgradeHandler});
        String upgradeString = "GET / HTTP/1.1\r\nHost: example.com\r\nConnection: Upgrade, HTTP2-Settings\r\nUpgrade: nextprotocol\r\nHTTP2-Settings: AAMAAABkAAQAAP__\r\n\r\n";
        ByteBuf upgrade = Unpooled.copiedBuffer((CharSequence)upgradeString, (Charset)CharsetUtil.US_ASCII);
        Assert.assertFalse((boolean)channel.writeInbound(new Object[]{upgrade}));
        Assert.assertNull((Object)channel.pipeline().get(HttpServerCodec.class));
        Assert.assertNotNull((Object)channel.pipeline().get("marker"));
        channel.flushOutbound();
        ByteBuf upgradeMessage = (ByteBuf)channel.readOutbound();
        String expectedHttpResponse = "HTTP/1.1 101 Switching Protocols\r\nconnection: upgrade\r\nupgrade: nextprotocol\r\n\r\n";
        Assert.assertEquals((Object)expectedHttpResponse, (Object)upgradeMessage.toString(CharsetUtil.US_ASCII));
        Assert.assertTrue((boolean)upgradeMessage.release());
        Assert.assertFalse((boolean)channel.finishAndReleaseAll());
    }

    private class TestUpgradeCodec
    implements HttpServerUpgradeHandler.UpgradeCodec {
        private TestUpgradeCodec() {
        }

        public Collection<CharSequence> requiredUpgradeHeaders() {
            return Collections.emptyList();
        }

        public boolean prepareUpgradeResponse(ChannelHandlerContext ctx, FullHttpRequest upgradeRequest, HttpHeaders upgradeHeaders) {
            return true;
        }

        public void upgradeTo(ChannelHandlerContext ctx, FullHttpRequest upgradeRequest) {
            Assert.assertEquals((Object)ctx.pipeline().context(HttpServerUpgradeHandler.class), (Object)ctx);
            Assert.assertNotNull((Object)ctx.pipeline().get(HttpServerUpgradeHandler.class));
            ctx.pipeline().addAfter(ctx.name(), "marker", (ChannelHandler)new ChannelInboundHandlerAdapter());
        }
    }
}

