/*
 * Decompiled with CFR 0.152.
 */
package io.netty.handler.codec.http.websocketx;

import io.netty.buffer.ByteBuf;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.embedded.EmbeddedChannel;
import io.netty.handler.codec.http.websocketx.CloseWebSocketFrame;
import io.netty.handler.codec.http.websocketx.WebSocket08FrameDecoder;
import io.netty.handler.codec.http.websocketx.WebSocket08FrameEncoder;
import java.util.HashSet;
import java.util.Iterator;
import org.junit.Assert;
import org.junit.Test;
import org.mockito.Mockito;

public class WebSocket08FrameDecoderTest {
    @Test
    public void channelInactive() throws Exception {
        WebSocket08FrameDecoder decoder = new WebSocket08FrameDecoder(true, true, 65535, false);
        ChannelHandlerContext ctx = (ChannelHandlerContext)Mockito.mock(ChannelHandlerContext.class);
        decoder.channelInactive(ctx);
        ((ChannelHandlerContext)Mockito.verify((Object)ctx)).fireChannelInactive();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void supportIanaStatusCodes() throws Exception {
        HashSet<Integer> forbiddenIanaCodes = new HashSet<Integer>();
        forbiddenIanaCodes.add(1004);
        forbiddenIanaCodes.add(1005);
        forbiddenIanaCodes.add(1006);
        HashSet<Integer> validIanaCodes = new HashSet<Integer>();
        for (int i = 1000; i < 1015; ++i) {
            validIanaCodes.add(i);
        }
        validIanaCodes.removeAll(forbiddenIanaCodes);
        Iterator iterator = validIanaCodes.iterator();
        while (iterator.hasNext()) {
            int statusCode = (Integer)iterator.next();
            EmbeddedChannel encoderChannel = new EmbeddedChannel(new ChannelHandler[]{new WebSocket08FrameEncoder(true)});
            EmbeddedChannel decoderChannel = new EmbeddedChannel(new ChannelHandler[]{new WebSocket08FrameDecoder(true, true, 65535, false)});
            Assert.assertTrue((boolean)encoderChannel.writeOutbound(new Object[]{new CloseWebSocketFrame(statusCode, "Bye")}));
            Assert.assertTrue((boolean)encoderChannel.finish());
            ByteBuf serializedCloseFrame = (ByteBuf)encoderChannel.readOutbound();
            Assert.assertNull((Object)encoderChannel.readOutbound());
            Assert.assertTrue((boolean)decoderChannel.writeInbound(new Object[]{serializedCloseFrame}));
            Assert.assertTrue((boolean)decoderChannel.finish());
            CloseWebSocketFrame outputFrame = (CloseWebSocketFrame)decoderChannel.readInbound();
            Assert.assertNull((Object)decoderChannel.readOutbound());
            try {
                Assert.assertEquals((long)statusCode, (long)outputFrame.statusCode());
            }
            finally {
                outputFrame.release();
            }
        }
    }
}

