/*
 * Decompiled with CFR 0.152.
 */
package io.netty.handler.codec.http;

import io.netty.buffer.Unpooled;
import io.netty.channel.ChannelHandler;
import io.netty.channel.embedded.EmbeddedChannel;
import io.netty.handler.codec.TooLongFrameException;
import io.netty.handler.codec.http.HttpContent;
import io.netty.handler.codec.http.HttpHeaderNames;
import io.netty.handler.codec.http.HttpHeaders;
import io.netty.handler.codec.http.HttpHeadersTestUtils;
import io.netty.handler.codec.http.HttpMethod;
import io.netty.handler.codec.http.HttpRequest;
import io.netty.handler.codec.http.HttpRequestDecoder;
import io.netty.handler.codec.http.HttpVersion;
import io.netty.handler.codec.http.LastHttpContent;
import io.netty.util.AsciiString;
import io.netty.util.CharsetUtil;
import java.nio.charset.Charset;
import java.util.List;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.junit.Assert;
import org.junit.Test;

public class HttpRequestDecoderTest {
    private static final byte[] CONTENT_CRLF_DELIMITERS = HttpRequestDecoderTest.createContent("\r\n");
    private static final byte[] CONTENT_LF_DELIMITERS = HttpRequestDecoderTest.createContent("\n");
    private static final byte[] CONTENT_MIXED_DELIMITERS = HttpRequestDecoderTest.createContent("\r\n", "\n");
    private static final int CONTENT_LENGTH = 8;

    private static byte[] createContent(String ... lineDelimiters) {
        String lineDelimiter2;
        String lineDelimiter;
        if (lineDelimiters.length == 2) {
            lineDelimiter = lineDelimiters[0];
            lineDelimiter2 = lineDelimiters[1];
        } else {
            lineDelimiter = lineDelimiters[0];
            lineDelimiter2 = lineDelimiters[0];
        }
        return ("GET /some/path?foo=bar&wibble=eek HTTP/1.1\r\nUpgrade: WebSocket" + lineDelimiter2 + "Connection: Upgrade" + lineDelimiter + "Host: localhost" + lineDelimiter2 + "Origin: http://localhost:8080" + lineDelimiter + "Sec-WebSocket-Key1: 10  28 8V7 8 48     0" + lineDelimiter2 + "Sec-WebSocket-Key2: 8 Xt754O3Q3QW 0   _60" + lineDelimiter + "Content-Length: " + 8 + lineDelimiter2 + "\r\n12345678").getBytes(CharsetUtil.US_ASCII);
    }

    @Test
    public void testDecodeWholeRequestAtOnceCRLFDelimiters() {
        HttpRequestDecoderTest.testDecodeWholeRequestAtOnce(CONTENT_CRLF_DELIMITERS);
    }

    @Test
    public void testDecodeWholeRequestAtOnceLFDelimiters() {
        HttpRequestDecoderTest.testDecodeWholeRequestAtOnce(CONTENT_LF_DELIMITERS);
    }

    @Test
    public void testDecodeWholeRequestAtOnceMixedDelimiters() {
        HttpRequestDecoderTest.testDecodeWholeRequestAtOnce(CONTENT_MIXED_DELIMITERS);
    }

    private static void testDecodeWholeRequestAtOnce(byte[] content) {
        EmbeddedChannel channel = new EmbeddedChannel(new ChannelHandler[]{new HttpRequestDecoder()});
        Assert.assertTrue((boolean)channel.writeInbound(new Object[]{Unpooled.copiedBuffer((byte[])content)}));
        HttpRequest req = (HttpRequest)channel.readInbound();
        Assert.assertNotNull((Object)req);
        HttpRequestDecoderTest.checkHeaders(req.headers());
        LastHttpContent c = (LastHttpContent)channel.readInbound();
        Assert.assertEquals((long)8L, (long)c.content().readableBytes());
        Assert.assertEquals((Object)Unpooled.wrappedBuffer((byte[])content, (int)(content.length - 8), (int)8), (Object)c.content().readSlice(8));
        c.release();
        Assert.assertFalse((boolean)channel.finish());
        Assert.assertNull((Object)channel.readInbound());
    }

    private static void checkHeaders(HttpHeaders headers) {
        Assert.assertEquals((long)7L, (long)headers.names().size());
        HttpRequestDecoderTest.checkHeader(headers, "Upgrade", "WebSocket");
        HttpRequestDecoderTest.checkHeader(headers, "Connection", "Upgrade");
        HttpRequestDecoderTest.checkHeader(headers, "Host", "localhost");
        HttpRequestDecoderTest.checkHeader(headers, "Origin", "http://localhost:8080");
        HttpRequestDecoderTest.checkHeader(headers, "Sec-WebSocket-Key1", "10  28 8V7 8 48     0");
        HttpRequestDecoderTest.checkHeader(headers, "Sec-WebSocket-Key2", "8 Xt754O3Q3QW 0   _60");
        HttpRequestDecoderTest.checkHeader(headers, "Content-Length", String.valueOf(8));
    }

    private static void checkHeader(HttpHeaders headers, String name, String value) {
        List header1 = headers.getAll(HttpHeadersTestUtils.of(name));
        Assert.assertEquals((long)1L, (long)header1.size());
        Assert.assertEquals((Object)value, header1.get(0));
    }

    @Test
    public void testDecodeWholeRequestInMultipleStepsCRLFDelimiters() {
        HttpRequestDecoderTest.testDecodeWholeRequestInMultipleSteps(CONTENT_CRLF_DELIMITERS);
    }

    @Test
    public void testDecodeWholeRequestInMultipleStepsLFDelimiters() {
        HttpRequestDecoderTest.testDecodeWholeRequestInMultipleSteps(CONTENT_LF_DELIMITERS);
    }

    @Test
    public void testDecodeWholeRequestInMultipleStepsMixedDelimiters() {
        HttpRequestDecoderTest.testDecodeWholeRequestInMultipleSteps(CONTENT_MIXED_DELIMITERS);
    }

    private static void testDecodeWholeRequestInMultipleSteps(byte[] content) {
        for (int i = 1; i < content.length; ++i) {
            HttpRequestDecoderTest.testDecodeWholeRequestInMultipleSteps(content, i);
        }
    }

    private static void testDecodeWholeRequestInMultipleSteps(byte[] content, int fragmentSize) {
        int amount;
        EmbeddedChannel channel = new EmbeddedChannel(new ChannelHandler[]{new HttpRequestDecoder()});
        int headerLength = content.length - 8;
        for (int a = 0; a < headerLength; a += amount) {
            amount = fragmentSize;
            if (a + amount > headerLength) {
                amount = headerLength - a;
            }
            channel.writeInbound(new Object[]{Unpooled.copiedBuffer((byte[])content, (int)a, (int)amount)});
        }
        for (int i = 8; i > 0; --i) {
            channel.writeInbound(new Object[]{Unpooled.copiedBuffer((byte[])content, (int)(content.length - i), (int)1)});
        }
        HttpRequest req = (HttpRequest)channel.readInbound();
        Assert.assertNotNull((Object)req);
        HttpRequestDecoderTest.checkHeaders(req.headers());
        for (int i = 8; i > 1; --i) {
            HttpContent c = (HttpContent)channel.readInbound();
            Assert.assertEquals((long)1L, (long)c.content().readableBytes());
            Assert.assertEquals((long)content[content.length - i], (long)c.content().readByte());
            c.release();
        }
        LastHttpContent c = (LastHttpContent)channel.readInbound();
        Assert.assertEquals((long)1L, (long)c.content().readableBytes());
        Assert.assertEquals((long)content[content.length - 1], (long)c.content().readByte());
        c.release();
        Assert.assertFalse((boolean)channel.finish());
        Assert.assertNull((Object)channel.readInbound());
    }

    @Test
    public void testMultiLineHeader() {
        EmbeddedChannel channel = new EmbeddedChannel(new ChannelHandler[]{new HttpRequestDecoder()});
        String crlf = "\r\n";
        String request = "GET /some/path HTTP/1.1" + crlf + "Host: localhost" + crlf + "MyTestHeader: part1" + crlf + "              newLinePart2" + crlf + "MyTestHeader2: part21" + crlf + "\t            newLinePart22" + crlf + crlf;
        Assert.assertTrue((boolean)channel.writeInbound(new Object[]{Unpooled.copiedBuffer((CharSequence)request, (Charset)CharsetUtil.US_ASCII)}));
        HttpRequest req = (HttpRequest)channel.readInbound();
        Assert.assertEquals((Object)"part1 newLinePart2", (Object)req.headers().get(HttpHeadersTestUtils.of("MyTestHeader")));
        Assert.assertEquals((Object)"part21 newLinePart22", (Object)req.headers().get(HttpHeadersTestUtils.of("MyTestHeader2")));
        LastHttpContent c = (LastHttpContent)channel.readInbound();
        c.release();
        Assert.assertFalse((boolean)channel.finish());
        Assert.assertNull((Object)channel.readInbound());
    }

    @Test
    public void testEmptyHeaderValue() {
        EmbeddedChannel channel = new EmbeddedChannel(new ChannelHandler[]{new HttpRequestDecoder()});
        String crlf = "\r\n";
        String request = "GET /some/path HTTP/1.1" + crlf + "Host: localhost" + crlf + "EmptyHeader:" + crlf + crlf;
        channel.writeInbound(new Object[]{Unpooled.copiedBuffer((CharSequence)request, (Charset)CharsetUtil.US_ASCII)});
        HttpRequest req = (HttpRequest)channel.readInbound();
        Assert.assertEquals((Object)"", (Object)req.headers().get(HttpHeadersTestUtils.of("EmptyHeader")));
    }

    @Test
    public void test100Continue() {
        HttpRequestDecoder decoder = new HttpRequestDecoder();
        EmbeddedChannel channel = new EmbeddedChannel(new ChannelHandler[]{decoder});
        String oversized = "PUT /file HTTP/1.1\r\nExpect: 100-continue\r\nContent-Length: 1048576000\r\n\r\n";
        channel.writeInbound(new Object[]{Unpooled.copiedBuffer((CharSequence)oversized, (Charset)CharsetUtil.US_ASCII)});
        Assert.assertThat((Object)channel.readInbound(), (Matcher)CoreMatchers.is((Matcher)CoreMatchers.instanceOf(HttpRequest.class)));
        decoder.reset();
        String query = "GET /max-file-size HTTP/1.1\r\n\r\n";
        channel.writeInbound(new Object[]{Unpooled.copiedBuffer((CharSequence)query, (Charset)CharsetUtil.US_ASCII)});
        Assert.assertThat((Object)channel.readInbound(), (Matcher)CoreMatchers.is((Matcher)CoreMatchers.instanceOf(HttpRequest.class)));
        Assert.assertThat((Object)channel.readInbound(), (Matcher)CoreMatchers.is((Matcher)CoreMatchers.instanceOf(LastHttpContent.class)));
        Assert.assertThat((Object)channel.finish(), (Matcher)CoreMatchers.is((Object)false));
    }

    @Test
    public void test100ContinueWithBadClient() {
        HttpRequestDecoder decoder = new HttpRequestDecoder();
        EmbeddedChannel channel = new EmbeddedChannel(new ChannelHandler[]{decoder});
        String oversized = "PUT /file HTTP/1.1\r\nExpect: 100-continue\r\nContent-Length: 1048576000\r\n\r\nWAY_TOO_LARGE_DATA_BEGINS";
        channel.writeInbound(new Object[]{Unpooled.copiedBuffer((CharSequence)oversized, (Charset)CharsetUtil.US_ASCII)});
        Assert.assertThat((Object)channel.readInbound(), (Matcher)CoreMatchers.is((Matcher)CoreMatchers.instanceOf(HttpRequest.class)));
        HttpContent prematureData = (HttpContent)channel.readInbound();
        prematureData.release();
        Assert.assertThat((Object)channel.readInbound(), (Matcher)CoreMatchers.is((Matcher)CoreMatchers.nullValue()));
        decoder.reset();
        String query = "GET /max-file-size HTTP/1.1\r\n\r\n";
        channel.writeInbound(new Object[]{Unpooled.copiedBuffer((CharSequence)query, (Charset)CharsetUtil.US_ASCII)});
        Assert.assertThat((Object)channel.readInbound(), (Matcher)CoreMatchers.is((Matcher)CoreMatchers.instanceOf(HttpRequest.class)));
        Assert.assertThat((Object)channel.readInbound(), (Matcher)CoreMatchers.is((Matcher)CoreMatchers.instanceOf(LastHttpContent.class)));
        Assert.assertThat((Object)channel.finish(), (Matcher)CoreMatchers.is((Object)false));
    }

    @Test
    public void testMessagesSplitBetweenMultipleBuffers() {
        EmbeddedChannel channel = new EmbeddedChannel(new ChannelHandler[]{new HttpRequestDecoder()});
        String crlf = "\r\n";
        String str1 = "GET /some/path HTTP/1.1" + crlf + "Host: localhost1" + crlf + crlf + "GET /some/other/path HTTP/1.0" + crlf + "Hos";
        String str2 = "t: localhost2" + crlf + "content-length: 0" + crlf + crlf;
        channel.writeInbound(new Object[]{Unpooled.copiedBuffer((CharSequence)str1, (Charset)CharsetUtil.US_ASCII)});
        HttpRequest req = (HttpRequest)channel.readInbound();
        Assert.assertEquals((Object)HttpVersion.HTTP_1_1, (Object)req.protocolVersion());
        Assert.assertEquals((Object)"/some/path", (Object)req.uri());
        Assert.assertEquals((long)1L, (long)req.headers().size());
        Assert.assertTrue((boolean)AsciiString.contentEqualsIgnoreCase((CharSequence)"localhost1", (CharSequence)req.headers().get((CharSequence)HttpHeaderNames.HOST)));
        LastHttpContent cnt = (LastHttpContent)channel.readInbound();
        cnt.release();
        channel.writeInbound(new Object[]{Unpooled.copiedBuffer((CharSequence)str2, (Charset)CharsetUtil.US_ASCII)});
        req = (HttpRequest)channel.readInbound();
        Assert.assertEquals((Object)HttpVersion.HTTP_1_0, (Object)req.protocolVersion());
        Assert.assertEquals((Object)"/some/other/path", (Object)req.uri());
        Assert.assertEquals((long)2L, (long)req.headers().size());
        Assert.assertTrue((boolean)AsciiString.contentEqualsIgnoreCase((CharSequence)"localhost2", (CharSequence)req.headers().get((CharSequence)HttpHeaderNames.HOST)));
        Assert.assertTrue((boolean)AsciiString.contentEqualsIgnoreCase((CharSequence)"0", (CharSequence)req.headers().get((CharSequence)HttpHeaderNames.CONTENT_LENGTH)));
        cnt = (LastHttpContent)channel.readInbound();
        cnt.release();
        Assert.assertFalse((boolean)channel.finishAndReleaseAll());
    }

    @Test
    public void testTooLargeInitialLine() {
        EmbeddedChannel channel = new EmbeddedChannel(new ChannelHandler[]{new HttpRequestDecoder(10, 1024, 1024)});
        String requestStr = "GET /some/path HTTP/1.1\r\nHost: localhost1\r\n\r\n";
        Assert.assertTrue((boolean)channel.writeInbound(new Object[]{Unpooled.copiedBuffer((CharSequence)requestStr, (Charset)CharsetUtil.US_ASCII)}));
        HttpRequest request = (HttpRequest)channel.readInbound();
        Assert.assertTrue((boolean)request.decoderResult().isFailure());
        Assert.assertTrue((boolean)(request.decoderResult().cause() instanceof TooLongFrameException));
        Assert.assertFalse((boolean)channel.finish());
    }

    @Test
    public void testTooLargeInitialLineWithWSOnly() {
        HttpRequestDecoderTest.testTooLargeInitialLineWithControlCharsOnly("                    ");
    }

    @Test
    public void testTooLargeInitialLineWithCRLFOnly() {
        HttpRequestDecoderTest.testTooLargeInitialLineWithControlCharsOnly("\r\n\r\n\r\n\r\n\r\n\r\n\r\n\r\n");
    }

    private static void testTooLargeInitialLineWithControlCharsOnly(String controlChars) {
        EmbeddedChannel channel = new EmbeddedChannel(new ChannelHandler[]{new HttpRequestDecoder(15, 1024, 1024)});
        String requestStr = controlChars + "GET / HTTP/1.1\r\nHost: localhost1\r\n\r\n";
        Assert.assertTrue((boolean)channel.writeInbound(new Object[]{Unpooled.copiedBuffer((CharSequence)requestStr, (Charset)CharsetUtil.US_ASCII)}));
        HttpRequest request = (HttpRequest)channel.readInbound();
        Assert.assertTrue((boolean)request.decoderResult().isFailure());
        Assert.assertTrue((boolean)(request.decoderResult().cause() instanceof TooLongFrameException));
        Assert.assertFalse((boolean)channel.finish());
    }

    @Test
    public void testInitialLineWithLeadingControlChars() {
        EmbeddedChannel channel = new EmbeddedChannel(new ChannelHandler[]{new HttpRequestDecoder()});
        String crlf = "\r\n";
        String request = crlf + "GET /some/path HTTP/1.1" + crlf + "Host: localhost" + crlf + crlf;
        Assert.assertTrue((boolean)channel.writeInbound(new Object[]{Unpooled.copiedBuffer((CharSequence)request, (Charset)CharsetUtil.US_ASCII)}));
        HttpRequest req = (HttpRequest)channel.readInbound();
        Assert.assertEquals((Object)HttpMethod.GET, (Object)req.method());
        Assert.assertEquals((Object)"/some/path", (Object)req.uri());
        Assert.assertEquals((Object)HttpVersion.HTTP_1_1, (Object)req.protocolVersion());
        Assert.assertTrue((boolean)channel.finishAndReleaseAll());
    }

    @Test
    public void testTooLargeHeaders() {
        EmbeddedChannel channel = new EmbeddedChannel(new ChannelHandler[]{new HttpRequestDecoder(1024, 10, 1024)});
        String requestStr = "GET /some/path HTTP/1.1\r\nHost: localhost1\r\n\r\n";
        Assert.assertTrue((boolean)channel.writeInbound(new Object[]{Unpooled.copiedBuffer((CharSequence)requestStr, (Charset)CharsetUtil.US_ASCII)}));
        HttpRequest request = (HttpRequest)channel.readInbound();
        Assert.assertTrue((boolean)request.decoderResult().isFailure());
        Assert.assertTrue((boolean)(request.decoderResult().cause() instanceof TooLongFrameException));
        Assert.assertFalse((boolean)channel.finish());
    }

    @Test
    public void testWhitespace() {
        String requestStr = "GET /some/path HTTP/1.1\r\nTransfer-Encoding : chunked\r\nHost: netty.io\r\n\r\n";
        HttpRequestDecoderTest.testInvalidHeaders0(requestStr);
    }

    @Test
    public void testWhitespaceBeforeTransferEncoding01() {
        String requestStr = "GET /some/path HTTP/1.1\r\n Transfer-Encoding : chunked\r\nContent-Length: 1\r\nHost: netty.io\r\n\r\na";
        HttpRequestDecoderTest.testInvalidHeaders0(requestStr);
    }

    @Test
    public void testWhitespaceBeforeTransferEncoding02() {
        String requestStr = "POST / HTTP/1.1 Transfer-Encoding : chunked\r\nHost: target.comContent-Length: 65\r\n\r\n0\r\n\r\nGET /maliciousRequest HTTP/1.1\r\nHost: evilServer.com\r\nFoo: x";
        HttpRequestDecoderTest.testInvalidHeaders0(requestStr);
    }

    @Test
    public void testHeaderWithNoValueAndMissingColon() {
        String requestStr = "GET /some/path HTTP/1.1\r\nContent-Length: 0\r\nHost:\r\nnetty.io\r\n\r\n";
        HttpRequestDecoderTest.testInvalidHeaders0(requestStr);
    }

    @Test
    public void testMultipleContentLengthHeaders() {
        String requestStr = "GET /some/path HTTP/1.1\r\nContent-Length: 1\r\nContent-Length: 0\r\n\r\nb";
        HttpRequestDecoderTest.testInvalidHeaders0(requestStr);
    }

    @Test
    public void testMultipleContentLengthHeaders2() {
        String requestStr = "GET /some/path HTTP/1.1\r\nContent-Length: 1\r\nConnection: close\r\nContent-Length: 0\r\n\r\nb";
        HttpRequestDecoderTest.testInvalidHeaders0(requestStr);
    }

    @Test
    public void testContentLengthHeaderWithCommaValue() {
        String requestStr = "GET /some/path HTTP/1.1\r\nContent-Length: 1,1\r\n\r\nb";
        HttpRequestDecoderTest.testInvalidHeaders0(requestStr);
    }

    @Test
    public void testMultipleContentLengthHeadersWithFolding() {
        String requestStr = "POST / HTTP/1.1\r\nHost: example.com\r\nConnection: close\r\nContent-Length: 5\r\nContent-Length:\r\n\t6\r\n\r\n123456";
        HttpRequestDecoderTest.testInvalidHeaders0(requestStr);
    }

    @Test
    public void testContentLengthAndTransferEncodingHeadersWithVerticalTab() {
        HttpRequestDecoderTest.testContentLengthAndTransferEncodingHeadersWithInvalidSeparator('\u000b', false);
        HttpRequestDecoderTest.testContentLengthAndTransferEncodingHeadersWithInvalidSeparator('\u000b', true);
    }

    @Test
    public void testContentLengthAndTransferEncodingHeadersWithCR() {
        HttpRequestDecoderTest.testContentLengthAndTransferEncodingHeadersWithInvalidSeparator('\r', false);
        HttpRequestDecoderTest.testContentLengthAndTransferEncodingHeadersWithInvalidSeparator('\r', true);
    }

    private static void testContentLengthAndTransferEncodingHeadersWithInvalidSeparator(char separator, boolean extraLine) {
        String requestStr = "POST / HTTP/1.1\r\nHost: example.com\r\nConnection: close\r\nContent-Length: 9\r\nTransfer-Encoding:" + separator + "chunked\r\n\r\n" + (extraLine ? "0\r\n\r\n" : "") + "something\r\n\r\n";
        HttpRequestDecoderTest.testInvalidHeaders0(requestStr);
    }

    @Test
    public void testContentLengthHeaderAndChunked() {
        String requestStr = "POST / HTTP/1.1\r\nHost: example.com\r\nConnection: close\r\nContent-Length: 5\r\nTransfer-Encoding: chunked\r\n\r\n0\r\n\r\n";
        EmbeddedChannel channel = new EmbeddedChannel(new ChannelHandler[]{new HttpRequestDecoder()});
        Assert.assertTrue((boolean)channel.writeInbound(new Object[]{Unpooled.copiedBuffer((CharSequence)requestStr, (Charset)CharsetUtil.US_ASCII)}));
        HttpRequest request = (HttpRequest)channel.readInbound();
        Assert.assertFalse((boolean)request.decoderResult().isFailure());
        Assert.assertTrue((boolean)request.headers().contains("Transfer-Encoding", "chunked", false));
        Assert.assertFalse((boolean)request.headers().contains("Content-Length"));
        LastHttpContent c = (LastHttpContent)channel.readInbound();
        Assert.assertFalse((boolean)channel.finish());
    }

    private static void testInvalidHeaders0(String requestStr) {
        EmbeddedChannel channel = new EmbeddedChannel(new ChannelHandler[]{new HttpRequestDecoder()});
        Assert.assertTrue((boolean)channel.writeInbound(new Object[]{Unpooled.copiedBuffer((CharSequence)requestStr, (Charset)CharsetUtil.US_ASCII)}));
        HttpRequest request = (HttpRequest)channel.readInbound();
        Assert.assertTrue((boolean)request.decoderResult().isFailure());
        Assert.assertTrue((boolean)(request.decoderResult().cause() instanceof IllegalArgumentException));
        Assert.assertFalse((boolean)channel.finish());
    }
}

