/*
 * Decompiled with CFR 0.152.
 */
package io.netty.handler.codec.http.websocketx.extensions;

import io.netty.channel.ChannelHandlerContext;
import io.netty.handler.codec.http.DefaultHttpRequest;
import io.netty.handler.codec.http.DefaultHttpResponse;
import io.netty.handler.codec.http.HttpHeaderNames;
import io.netty.handler.codec.http.HttpHeaderValues;
import io.netty.handler.codec.http.HttpMethod;
import io.netty.handler.codec.http.HttpRequest;
import io.netty.handler.codec.http.HttpResponse;
import io.netty.handler.codec.http.HttpResponseStatus;
import io.netty.handler.codec.http.HttpVersion;
import io.netty.handler.codec.http.websocketx.WebSocketFrame;
import io.netty.handler.codec.http.websocketx.extensions.WebSocketExtensionData;
import io.netty.handler.codec.http.websocketx.extensions.WebSocketExtensionDecoder;
import io.netty.handler.codec.http.websocketx.extensions.WebSocketExtensionEncoder;
import java.util.List;
import org.mockito.ArgumentMatcher;
import org.mockito.Mockito;

public final class WebSocketExtensionTestUtil {
    public static HttpRequest newUpgradeRequest(String ext) {
        DefaultHttpRequest req = new DefaultHttpRequest(HttpVersion.HTTP_1_1, HttpMethod.GET, "/chat");
        req.headers().set((CharSequence)HttpHeaderNames.HOST, (Object)"server.example.com");
        req.headers().set((CharSequence)HttpHeaderNames.UPGRADE, (Object)HttpHeaderValues.WEBSOCKET.toString().toLowerCase());
        req.headers().set((CharSequence)HttpHeaderNames.CONNECTION, (Object)"Upgrade");
        req.headers().set((CharSequence)HttpHeaderNames.ORIGIN, (Object)"http://example.com");
        if (ext != null) {
            req.headers().set((CharSequence)HttpHeaderNames.SEC_WEBSOCKET_EXTENSIONS, (Object)ext);
        }
        return req;
    }

    public static HttpResponse newUpgradeResponse(String ext) {
        DefaultHttpResponse res = new DefaultHttpResponse(HttpVersion.HTTP_1_1, HttpResponseStatus.SWITCHING_PROTOCOLS);
        res.headers().set((CharSequence)HttpHeaderNames.HOST, (Object)"server.example.com");
        res.headers().set((CharSequence)HttpHeaderNames.UPGRADE, (Object)HttpHeaderValues.WEBSOCKET.toString().toLowerCase());
        res.headers().set((CharSequence)HttpHeaderNames.CONNECTION, (Object)"Upgrade");
        res.headers().set((CharSequence)HttpHeaderNames.ORIGIN, (Object)"http://example.com");
        if (ext != null) {
            res.headers().set((CharSequence)HttpHeaderNames.SEC_WEBSOCKET_EXTENSIONS, (Object)ext);
        }
        return res;
    }

    static WebSocketExtensionData webSocketExtensionDataMatcher(String text) {
        return (WebSocketExtensionData)Mockito.argThat((ArgumentMatcher)new WebSocketExtensionDataMatcher(text));
    }

    private WebSocketExtensionTestUtil() {
    }

    static class Dummy2Decoder
    extends WebSocketExtensionDecoder {
        Dummy2Decoder() {
        }

        protected void decode(ChannelHandlerContext ctx, WebSocketFrame msg, List<Object> out) throws Exception {
        }
    }

    static class Dummy2Encoder
    extends WebSocketExtensionEncoder {
        Dummy2Encoder() {
        }

        protected void encode(ChannelHandlerContext ctx, WebSocketFrame msg, List<Object> out) throws Exception {
        }
    }

    static class DummyDecoder
    extends WebSocketExtensionDecoder {
        DummyDecoder() {
        }

        protected void decode(ChannelHandlerContext ctx, WebSocketFrame msg, List<Object> out) throws Exception {
        }
    }

    static class DummyEncoder
    extends WebSocketExtensionEncoder {
        DummyEncoder() {
        }

        protected void encode(ChannelHandlerContext ctx, WebSocketFrame msg, List<Object> out) throws Exception {
        }
    }

    static final class WebSocketExtensionDataMatcher
    implements ArgumentMatcher<WebSocketExtensionData> {
        private final String name;

        WebSocketExtensionDataMatcher(String name) {
            this.name = name;
        }

        public boolean matches(WebSocketExtensionData data) {
            return data != null && this.name.equals(data.name());
        }
    }
}

