/*
 * Decompiled with CFR 0.152.
 */
package io.netty.handler.codec.http.websocketx;

import io.netty.buffer.ByteBuf;
import io.netty.buffer.Unpooled;
import io.netty.channel.ChannelHandler;
import io.netty.channel.embedded.EmbeddedChannel;
import io.netty.handler.codec.http.websocketx.PingWebSocketFrame;
import io.netty.handler.codec.http.websocketx.PongWebSocketFrame;
import io.netty.handler.codec.http.websocketx.TextWebSocketFrame;
import io.netty.handler.codec.http.websocketx.WebSocketFrame;
import io.netty.handler.codec.http.websocketx.WebSocketProtocolHandler;
import io.netty.handler.flow.FlowControlHandler;
import io.netty.util.CharsetUtil;
import java.nio.charset.Charset;
import org.junit.Assert;
import org.junit.Test;

public class WebSocketProtocolHandlerTest {
    @Test
    public void testPingFrame() {
        ByteBuf pingData = Unpooled.copiedBuffer((CharSequence)"Hello, world", (Charset)CharsetUtil.UTF_8);
        EmbeddedChannel channel = new EmbeddedChannel(new ChannelHandler[]{new WebSocketProtocolHandler(){}});
        PingWebSocketFrame inputMessage = new PingWebSocketFrame(pingData);
        Assert.assertFalse((boolean)channel.writeInbound(new Object[]{inputMessage}));
        PongWebSocketFrame response = (PongWebSocketFrame)channel.readOutbound();
        Assert.assertEquals((Object)pingData, (Object)response.content());
        pingData.release();
        Assert.assertFalse((boolean)channel.finish());
    }

    @Test
    public void testPingPongFlowControlWhenAutoReadIsDisabled() {
        String text1 = "Hello, world #1";
        String text2 = "Hello, world #2";
        String text3 = "Hello, world #3";
        String text4 = "Hello, world #4";
        EmbeddedChannel channel = new EmbeddedChannel();
        channel.config().setAutoRead(false);
        channel.pipeline().addLast(new ChannelHandler[]{new FlowControlHandler()});
        channel.pipeline().addLast(new ChannelHandler[]{new WebSocketProtocolHandler(){}});
        Assert.assertFalse((boolean)channel.writeInbound(new Object[]{new PingWebSocketFrame(Unpooled.copiedBuffer((CharSequence)text1, (Charset)CharsetUtil.UTF_8)), new TextWebSocketFrame(text2), new TextWebSocketFrame(text3), new PingWebSocketFrame(Unpooled.copiedBuffer((CharSequence)text4, (Charset)CharsetUtil.UTF_8))}));
        Assert.assertNull((Object)channel.readInbound());
        Assert.assertNull((Object)channel.readOutbound());
        channel.read();
        PongWebSocketFrame response1 = (PongWebSocketFrame)channel.readOutbound();
        Assert.assertEquals((Object)text1, (Object)response1.content().toString(CharsetUtil.UTF_8));
        TextWebSocketFrame message2 = (TextWebSocketFrame)channel.readInbound();
        Assert.assertEquals((Object)text2, (Object)message2.text());
        Assert.assertNull((Object)channel.readInbound());
        Assert.assertNull((Object)channel.readOutbound());
        channel.read();
        TextWebSocketFrame message3 = (TextWebSocketFrame)channel.readInbound();
        Assert.assertEquals((Object)text3, (Object)message3.text());
        Assert.assertNull((Object)channel.readInbound());
        Assert.assertNull((Object)channel.readOutbound());
        response1.release();
        message2.release();
        message3.release();
        Assert.assertFalse((boolean)channel.finish());
    }

    @Test
    public void testPongFrameDropFrameFalse() {
        EmbeddedChannel channel = new EmbeddedChannel(new ChannelHandler[]{new WebSocketProtocolHandler(false){}});
        PongWebSocketFrame pingResponse = new PongWebSocketFrame();
        Assert.assertTrue((boolean)channel.writeInbound(new Object[]{pingResponse}));
        WebSocketProtocolHandlerTest.assertPropagatedInbound(pingResponse, channel);
        pingResponse.release();
        Assert.assertFalse((boolean)channel.finish());
    }

    @Test
    public void testPongFrameDropFrameTrue() {
        EmbeddedChannel channel = new EmbeddedChannel(new ChannelHandler[]{new WebSocketProtocolHandler(true){}});
        PongWebSocketFrame pingResponse = new PongWebSocketFrame();
        Assert.assertFalse((boolean)channel.writeInbound(new Object[]{pingResponse}));
    }

    @Test
    public void testTextFrame() {
        EmbeddedChannel channel = new EmbeddedChannel(new ChannelHandler[]{new WebSocketProtocolHandler(){}});
        TextWebSocketFrame textFrame = new TextWebSocketFrame();
        Assert.assertTrue((boolean)channel.writeInbound(new Object[]{textFrame}));
        WebSocketProtocolHandlerTest.assertPropagatedInbound(textFrame, channel);
        textFrame.release();
        Assert.assertFalse((boolean)channel.finish());
    }

    private static <T extends WebSocketFrame> void assertPropagatedInbound(T message, EmbeddedChannel channel) {
        WebSocketFrame propagatedResponse = (WebSocketFrame)channel.readInbound();
        Assert.assertEquals(message, (Object)propagatedResponse);
    }
}

