/*
 * Decompiled with CFR 0.152.
 */
package io.netty.handler.codec.http.multipart;

import io.netty.buffer.ByteBuf;
import io.netty.buffer.ByteBufInputStream;
import io.netty.buffer.Unpooled;
import io.netty.handler.codec.http.multipart.DiskFileUpload;
import io.netty.util.CharsetUtil;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import org.junit.Assert;
import org.junit.Test;

public class DiskFileUploadTest {
    @Test
    public void testSpecificCustomBaseDir() throws IOException {
        File baseDir = new File("target/DiskFileUploadTest/testSpecificCustomBaseDir");
        baseDir.mkdirs();
        DiskFileUpload f = new DiskFileUpload("d1", "d1", "application/json", null, null, 100L, baseDir.getAbsolutePath(), false);
        f.setContent(Unpooled.EMPTY_BUFFER);
        Assert.assertTrue((boolean)f.getFile().getAbsolutePath().startsWith(baseDir.getAbsolutePath()));
        Assert.assertTrue((boolean)f.getFile().exists());
        Assert.assertEquals((long)0L, (long)f.getFile().length());
        f.delete();
    }

    @Test
    public final void testDiskFileUploadEquals() {
        DiskFileUpload f2 = new DiskFileUpload("d1", "d1", "application/json", null, null, 100L);
        Assert.assertEquals((Object)f2, (Object)f2);
        f2.delete();
    }

    @Test
    public void testEmptyBufferSetMultipleTimes() throws IOException {
        DiskFileUpload f = new DiskFileUpload("d1", "d1", "application/json", null, null, 100L);
        f.setContent(Unpooled.EMPTY_BUFFER);
        Assert.assertTrue((boolean)f.getFile().exists());
        Assert.assertEquals((long)0L, (long)f.getFile().length());
        f.setContent(Unpooled.EMPTY_BUFFER);
        Assert.assertTrue((boolean)f.getFile().exists());
        Assert.assertEquals((long)0L, (long)f.getFile().length());
        f.delete();
    }

    @Test
    public void testEmptyBufferSetAfterNonEmptyBuffer() throws IOException {
        DiskFileUpload f = new DiskFileUpload("d1", "d1", "application/json", null, null, 100L);
        f.setContent(Unpooled.wrappedBuffer((byte[])new byte[]{1, 2, 3, 4}));
        Assert.assertTrue((boolean)f.getFile().exists());
        Assert.assertEquals((long)4L, (long)f.getFile().length());
        f.setContent(Unpooled.EMPTY_BUFFER);
        Assert.assertTrue((boolean)f.getFile().exists());
        Assert.assertEquals((long)0L, (long)f.getFile().length());
        f.delete();
    }

    @Test
    public void testNonEmptyBufferSetMultipleTimes() throws IOException {
        DiskFileUpload f = new DiskFileUpload("d1", "d1", "application/json", null, null, 100L);
        f.setContent(Unpooled.wrappedBuffer((byte[])new byte[]{1, 2, 3, 4}));
        Assert.assertTrue((boolean)f.getFile().exists());
        Assert.assertEquals((long)4L, (long)f.getFile().length());
        f.setContent(Unpooled.wrappedBuffer((byte[])new byte[]{1, 2}));
        Assert.assertTrue((boolean)f.getFile().exists());
        Assert.assertEquals((long)2L, (long)f.getFile().length());
        f.delete();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testAddContents() throws Exception {
        DiskFileUpload f1 = new DiskFileUpload("file1", "file1", "application/json", null, null, 0L);
        try {
            String json = "{\"foo\":\"bar\"}";
            byte[] bytes = json.getBytes(CharsetUtil.UTF_8);
            f1.addContent(Unpooled.wrappedBuffer((byte[])bytes), true);
            Assert.assertEquals((Object)json, (Object)f1.getString());
            Assert.assertArrayEquals((byte[])bytes, (byte[])f1.get());
            File file = f1.getFile();
            Assert.assertEquals((long)bytes.length, (long)file.length());
            FileInputStream fis = new FileInputStream(file);
            try {
                byte[] buf = new byte[bytes.length];
                int offset = 0;
                int read = 0;
                int len = buf.length;
                while ((read = fis.read(buf, offset, len)) > 0 && (len -= read) > 0 && (offset += read) < buf.length) {
                }
                Assert.assertArrayEquals((byte[])bytes, (byte[])buf);
            }
            finally {
                fis.close();
            }
        }
        finally {
            f1.delete();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testSetContentFromByteBuf() throws Exception {
        DiskFileUpload f1 = new DiskFileUpload("file2", "file2", "application/json", null, null, 0L);
        try {
            String json = "{\"hello\":\"world\"}";
            byte[] bytes = json.getBytes(CharsetUtil.UTF_8);
            f1.setContent(Unpooled.wrappedBuffer((byte[])bytes));
            Assert.assertEquals((Object)json, (Object)f1.getString());
            Assert.assertArrayEquals((byte[])bytes, (byte[])f1.get());
            File file = f1.getFile();
            Assert.assertEquals((long)bytes.length, (long)file.length());
            Assert.assertArrayEquals((byte[])bytes, (byte[])DiskFileUploadTest.doReadFile(file, bytes.length));
        }
        finally {
            f1.delete();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testSetContentFromInputStream() throws Exception {
        String json = "{\"hello\":\"world\",\"foo\":\"bar\"}";
        DiskFileUpload f1 = new DiskFileUpload("file3", "file3", "application/json", null, null, 0L);
        try {
            byte[] bytes = json.getBytes(CharsetUtil.UTF_8);
            ByteBuf buf = Unpooled.wrappedBuffer((byte[])bytes);
            ByteBufInputStream is = new ByteBufInputStream(buf);
            try {
                f1.setContent((InputStream)is);
                Assert.assertEquals((Object)json, (Object)f1.getString());
                Assert.assertArrayEquals((byte[])bytes, (byte[])f1.get());
                File file = f1.getFile();
                Assert.assertEquals((long)bytes.length, (long)file.length());
                Assert.assertArrayEquals((byte[])bytes, (byte[])DiskFileUploadTest.doReadFile(file, bytes.length));
            }
            finally {
                buf.release();
                is.close();
            }
        }
        finally {
            f1.delete();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static byte[] doReadFile(File file, int maxRead) throws Exception {
        FileInputStream fis = new FileInputStream(file);
        try {
            byte[] buf = new byte[maxRead];
            int offset = 0;
            int read = 0;
            int len = buf.length;
            while ((read = fis.read(buf, offset, len)) > 0 && (len -= read) > 0 && (offset += read) < buf.length) {
            }
            byte[] byArray = buf;
            return byArray;
        }
        finally {
            fis.close();
        }
    }
}

