/*
 * Decompiled with CFR 0.152.
 */
package io.netty.handler.codec.http.websocketx.extensions.compression;

import io.netty.buffer.ByteBuf;
import io.netty.buffer.Unpooled;
import io.netty.channel.ChannelHandler;
import io.netty.channel.embedded.EmbeddedChannel;
import io.netty.handler.codec.compression.ZlibCodecFactory;
import io.netty.handler.codec.compression.ZlibWrapper;
import io.netty.handler.codec.http.websocketx.BinaryWebSocketFrame;
import io.netty.handler.codec.http.websocketx.extensions.WebSocketExtensionFilter;
import io.netty.handler.codec.http.websocketx.extensions.compression.PerFrameDeflateDecoder;
import java.util.Random;
import org.junit.Assert;
import org.junit.Test;

public class PerFrameDeflateDecoderTest {
    private static final Random random = new Random();

    @Test
    public void testCompressedFrame() {
        EmbeddedChannel encoderChannel = new EmbeddedChannel(new ChannelHandler[]{ZlibCodecFactory.newZlibEncoder((ZlibWrapper)ZlibWrapper.NONE, (int)9, (int)15, (int)8)});
        EmbeddedChannel decoderChannel = new EmbeddedChannel(new ChannelHandler[]{new PerFrameDeflateDecoder(false)});
        byte[] payload = new byte[300];
        random.nextBytes(payload);
        Assert.assertTrue((boolean)encoderChannel.writeOutbound(new Object[]{Unpooled.wrappedBuffer((byte[])payload)}));
        ByteBuf compressedPayload = (ByteBuf)encoderChannel.readOutbound();
        BinaryWebSocketFrame compressedFrame = new BinaryWebSocketFrame(true, 5, compressedPayload.slice(0, compressedPayload.readableBytes() - 4));
        Assert.assertTrue((boolean)decoderChannel.writeInbound(new Object[]{compressedFrame}));
        BinaryWebSocketFrame uncompressedFrame = (BinaryWebSocketFrame)decoderChannel.readInbound();
        Assert.assertNotNull((Object)uncompressedFrame);
        Assert.assertNotNull((Object)uncompressedFrame.content());
        Assert.assertEquals((long)1L, (long)uncompressedFrame.rsv());
        Assert.assertEquals((long)300L, (long)uncompressedFrame.content().readableBytes());
        byte[] finalPayload = new byte[300];
        uncompressedFrame.content().readBytes(finalPayload);
        Assert.assertArrayEquals((byte[])finalPayload, (byte[])payload);
        uncompressedFrame.release();
    }

    @Test
    public void testNormalFrame() {
        EmbeddedChannel decoderChannel = new EmbeddedChannel(new ChannelHandler[]{new PerFrameDeflateDecoder(false)});
        byte[] payload = new byte[300];
        random.nextBytes(payload);
        BinaryWebSocketFrame frame = new BinaryWebSocketFrame(true, 1, Unpooled.wrappedBuffer((byte[])payload));
        Assert.assertTrue((boolean)decoderChannel.writeInbound(new Object[]{frame}));
        BinaryWebSocketFrame newFrame = (BinaryWebSocketFrame)decoderChannel.readInbound();
        Assert.assertNotNull((Object)newFrame);
        Assert.assertNotNull((Object)newFrame.content());
        Assert.assertEquals((long)1L, (long)newFrame.rsv());
        Assert.assertEquals((long)300L, (long)newFrame.content().readableBytes());
        byte[] finalPayload = new byte[300];
        newFrame.content().readBytes(finalPayload);
        Assert.assertArrayEquals((byte[])finalPayload, (byte[])payload);
        newFrame.release();
    }

    @Test
    public void testCompressedEmptyFrame() {
        EmbeddedChannel encoderChannel = new EmbeddedChannel(new ChannelHandler[]{ZlibCodecFactory.newZlibEncoder((ZlibWrapper)ZlibWrapper.NONE, (int)9, (int)15, (int)8)});
        EmbeddedChannel decoderChannel = new EmbeddedChannel(new ChannelHandler[]{new PerFrameDeflateDecoder(false)});
        Assert.assertTrue((boolean)encoderChannel.writeOutbound(new Object[]{Unpooled.EMPTY_BUFFER}));
        ByteBuf compressedPayload = (ByteBuf)encoderChannel.readOutbound();
        BinaryWebSocketFrame compressedFrame = new BinaryWebSocketFrame(true, 5, compressedPayload);
        Assert.assertTrue((boolean)decoderChannel.writeInbound(new Object[]{compressedFrame}));
        BinaryWebSocketFrame uncompressedFrame = (BinaryWebSocketFrame)decoderChannel.readInbound();
        Assert.assertNotNull((Object)uncompressedFrame);
        Assert.assertNotNull((Object)uncompressedFrame.content());
        Assert.assertEquals((long)1L, (long)uncompressedFrame.rsv());
        Assert.assertEquals((long)0L, (long)uncompressedFrame.content().readableBytes());
        uncompressedFrame.release();
    }

    @Test
    public void testDecompressionSkip() {
        EmbeddedChannel encoderChannel = new EmbeddedChannel(new ChannelHandler[]{ZlibCodecFactory.newZlibEncoder((ZlibWrapper)ZlibWrapper.NONE, (int)9, (int)15, (int)8)});
        EmbeddedChannel decoderChannel = new EmbeddedChannel(new ChannelHandler[]{new PerFrameDeflateDecoder(false, WebSocketExtensionFilter.ALWAYS_SKIP)});
        byte[] payload = new byte[300];
        random.nextBytes(payload);
        Assert.assertTrue((boolean)encoderChannel.writeOutbound(new Object[]{Unpooled.wrappedBuffer((byte[])payload)}));
        ByteBuf compressedPayload = (ByteBuf)encoderChannel.readOutbound();
        BinaryWebSocketFrame compressedBinaryFrame = new BinaryWebSocketFrame(true, 5, compressedPayload);
        Assert.assertTrue((boolean)decoderChannel.writeInbound(new Object[]{compressedBinaryFrame}));
        BinaryWebSocketFrame inboundBinaryFrame = (BinaryWebSocketFrame)decoderChannel.readInbound();
        Assert.assertNotNull((Object)inboundBinaryFrame);
        Assert.assertNotNull((Object)inboundBinaryFrame.content());
        Assert.assertEquals((Object)compressedPayload, (Object)inboundBinaryFrame.content());
        Assert.assertEquals((long)5L, (long)inboundBinaryFrame.rsv());
        Assert.assertTrue((boolean)inboundBinaryFrame.release());
        Assert.assertTrue((boolean)encoderChannel.finishAndReleaseAll());
        Assert.assertFalse((boolean)decoderChannel.finish());
    }
}

