/*
 * Decompiled with CFR 0.152.
 */
package io.netty.handler.codec.http.websocketx;

import io.netty.channel.Channel;
import io.netty.channel.embedded.EmbeddedChannel;
import io.netty.handler.codec.http.FullHttpResponse;
import io.netty.handler.codec.http.HttpHeaderNames;
import io.netty.handler.codec.http.HttpMessage;
import io.netty.handler.codec.http.HttpResponseStatus;
import io.netty.handler.codec.http.HttpUtil;
import io.netty.handler.codec.http.websocketx.WebSocketServerHandshakerFactory;
import io.netty.handler.codec.http.websocketx.WebSocketVersion;
import io.netty.util.ReferenceCountUtil;
import org.junit.Assert;
import org.junit.Test;

public class WebSocketServerHandshakerFactoryTest {
    @Test
    public void testUnsupportedVersion() throws Exception {
        EmbeddedChannel ch = new EmbeddedChannel();
        WebSocketServerHandshakerFactory.sendUnsupportedVersionResponse((Channel)ch);
        ch.runPendingTasks();
        Object msg = ch.readOutbound();
        if (!(msg instanceof FullHttpResponse)) {
            Assert.fail((String)("Got wrong response " + msg));
        }
        FullHttpResponse response = (FullHttpResponse)msg;
        Assert.assertEquals((Object)HttpResponseStatus.UPGRADE_REQUIRED, (Object)response.status());
        Assert.assertEquals((Object)WebSocketVersion.V13.toHttpHeaderValue(), (Object)response.headers().get((CharSequence)HttpHeaderNames.SEC_WEBSOCKET_VERSION));
        Assert.assertTrue((boolean)HttpUtil.isContentLengthSet((HttpMessage)response));
        Assert.assertEquals((long)0L, (long)HttpUtil.getContentLength((HttpMessage)response));
        ReferenceCountUtil.release((Object)response);
        Assert.assertFalse((boolean)ch.finish());
    }
}

