/*
 * Decompiled with CFR 0.152.
 */
package io.netty.handler.codec.http.websocketx;

import io.netty.buffer.ByteBuf;
import io.netty.channel.ChannelHandler;
import io.netty.channel.embedded.EmbeddedChannel;
import io.netty.handler.codec.http.websocketx.CloseWebSocketFrame;
import io.netty.handler.codec.http.websocketx.WebSocket00FrameEncoder;
import org.junit.Assert;
import org.junit.Test;

public class WebSocket00FrameEncoderTest {
    @Test
    public void testMultipleWebSocketCloseFrames() {
        EmbeddedChannel channel = new EmbeddedChannel(new ChannelHandler[]{new WebSocket00FrameEncoder()});
        Assert.assertTrue((boolean)channel.writeOutbound(new Object[]{new CloseWebSocketFrame()}));
        Assert.assertTrue((boolean)channel.writeOutbound(new Object[]{new CloseWebSocketFrame()}));
        Assert.assertTrue((boolean)channel.finish());
        WebSocket00FrameEncoderTest.assertCloseWebSocketFrame(channel);
        WebSocket00FrameEncoderTest.assertCloseWebSocketFrame(channel);
        Assert.assertNull((Object)channel.readOutbound());
    }

    private static void assertCloseWebSocketFrame(EmbeddedChannel channel) {
        ByteBuf buf = (ByteBuf)channel.readOutbound();
        Assert.assertEquals((long)2L, (long)buf.readableBytes());
        Assert.assertEquals((long)-1L, (long)buf.readByte());
        Assert.assertEquals((long)0L, (long)buf.readByte());
        buf.release();
    }
}

