/*
 * Decompiled with CFR 0.152.
 */
package io.netty.handler.codec.http;

import io.netty.channel.ChannelHandler;
import io.netty.channel.embedded.EmbeddedChannel;
import io.netty.handler.codec.http.DefaultFullHttpRequest;
import io.netty.handler.codec.http.DefaultFullHttpResponse;
import io.netty.handler.codec.http.HttpHeaderNames;
import io.netty.handler.codec.http.HttpMessage;
import io.netty.handler.codec.http.HttpMethod;
import io.netty.handler.codec.http.HttpRequest;
import io.netty.handler.codec.http.HttpResponse;
import io.netty.handler.codec.http.HttpResponseStatus;
import io.netty.handler.codec.http.HttpServerExpectContinueHandler;
import io.netty.handler.codec.http.HttpUtil;
import io.netty.handler.codec.http.HttpVersion;
import io.netty.util.ReferenceCountUtil;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.junit.Assert;
import org.junit.Test;

public class HttpServerExpectContinueHandlerTest {
    @Test
    public void shouldRespondToExpectedHeader() {
        EmbeddedChannel channel = new EmbeddedChannel(new ChannelHandler[]{new HttpServerExpectContinueHandler(){

            protected HttpResponse acceptMessage(HttpRequest request) {
                DefaultFullHttpResponse response = new DefaultFullHttpResponse(HttpVersion.HTTP_1_1, HttpResponseStatus.CONTINUE);
                response.headers().set("foo", (Object)"bar");
                return response;
            }
        }});
        DefaultFullHttpRequest request = new DefaultFullHttpRequest(HttpVersion.HTTP_1_1, HttpMethod.GET, "/");
        HttpUtil.set100ContinueExpected((HttpMessage)request, (boolean)true);
        channel.writeInbound(new Object[]{request});
        HttpResponse response = (HttpResponse)channel.readOutbound();
        Assert.assertThat((Object)response.status(), (Matcher)CoreMatchers.is((Object)HttpResponseStatus.CONTINUE));
        Assert.assertThat((Object)response.headers().get("foo"), (Matcher)CoreMatchers.is((Object)"bar"));
        ReferenceCountUtil.release((Object)response);
        HttpRequest processedRequest = (HttpRequest)channel.readInbound();
        Assert.assertFalse((boolean)processedRequest.headers().contains((CharSequence)HttpHeaderNames.EXPECT));
        ReferenceCountUtil.release((Object)processedRequest);
        Assert.assertFalse((boolean)channel.finishAndReleaseAll());
    }

    @Test
    public void shouldAllowCustomResponses() {
        EmbeddedChannel channel = new EmbeddedChannel(new ChannelHandler[]{new HttpServerExpectContinueHandler(){

            protected HttpResponse acceptMessage(HttpRequest request) {
                return null;
            }

            protected HttpResponse rejectResponse(HttpRequest request) {
                return new DefaultFullHttpResponse(HttpVersion.HTTP_1_1, HttpResponseStatus.REQUEST_ENTITY_TOO_LARGE);
            }
        }});
        DefaultFullHttpRequest request = new DefaultFullHttpRequest(HttpVersion.HTTP_1_1, HttpMethod.GET, "/");
        HttpUtil.set100ContinueExpected((HttpMessage)request, (boolean)true);
        channel.writeInbound(new Object[]{request});
        HttpResponse response = (HttpResponse)channel.readOutbound();
        Assert.assertThat((Object)response.status(), (Matcher)CoreMatchers.is((Object)HttpResponseStatus.REQUEST_ENTITY_TOO_LARGE));
        ReferenceCountUtil.release((Object)response);
        Assert.assertTrue((boolean)channel.inboundMessages().isEmpty());
        Assert.assertFalse((boolean)channel.finishAndReleaseAll());
    }
}

