/*
 * Decompiled with CFR 0.152.
 */
package io.netty.handler.codec.http.websocketx.extensions.compression;

import io.netty.channel.ChannelHandler;
import io.netty.channel.embedded.EmbeddedChannel;
import io.netty.handler.codec.http.HttpHeaderNames;
import io.netty.handler.codec.http.HttpRequest;
import io.netty.handler.codec.http.HttpResponse;
import io.netty.handler.codec.http.websocketx.extensions.WebSocketExtensionData;
import io.netty.handler.codec.http.websocketx.extensions.WebSocketExtensionTestUtil;
import io.netty.handler.codec.http.websocketx.extensions.WebSocketExtensionUtil;
import io.netty.handler.codec.http.websocketx.extensions.WebSocketServerExtensionHandler;
import io.netty.handler.codec.http.websocketx.extensions.WebSocketServerExtensionHandshaker;
import io.netty.handler.codec.http.websocketx.extensions.compression.PerMessageDeflateDecoder;
import io.netty.handler.codec.http.websocketx.extensions.compression.PerMessageDeflateEncoder;
import io.netty.handler.codec.http.websocketx.extensions.compression.PerMessageDeflateServerExtensionHandshaker;
import io.netty.handler.codec.http.websocketx.extensions.compression.WebSocketServerCompressionHandler;
import java.util.List;
import org.junit.Assert;
import org.junit.Test;

public class WebSocketServerCompressionHandlerTest {
    @Test
    public void testNormalSuccess() {
        EmbeddedChannel ch = new EmbeddedChannel(new ChannelHandler[]{new WebSocketServerCompressionHandler()});
        HttpRequest req = WebSocketExtensionTestUtil.newUpgradeRequest("permessage-deflate");
        ch.writeInbound(new Object[]{req});
        HttpResponse res = WebSocketExtensionTestUtil.newUpgradeResponse(null);
        ch.writeOutbound(new Object[]{res});
        HttpResponse res2 = (HttpResponse)ch.readOutbound();
        List exts = WebSocketExtensionUtil.extractExtensions((String)res2.headers().get((CharSequence)HttpHeaderNames.SEC_WEBSOCKET_EXTENSIONS));
        Assert.assertEquals((Object)"permessage-deflate", (Object)((WebSocketExtensionData)exts.get(0)).name());
        Assert.assertTrue((boolean)((WebSocketExtensionData)exts.get(0)).parameters().isEmpty());
        Assert.assertNotNull((Object)ch.pipeline().get(PerMessageDeflateDecoder.class));
        Assert.assertNotNull((Object)ch.pipeline().get(PerMessageDeflateEncoder.class));
    }

    @Test
    public void testClientWindowSizeSuccess() {
        EmbeddedChannel ch = new EmbeddedChannel(new ChannelHandler[]{new WebSocketServerExtensionHandler(new WebSocketServerExtensionHandshaker[]{new PerMessageDeflateServerExtensionHandshaker(6, false, 10, false, false)})});
        HttpRequest req = WebSocketExtensionTestUtil.newUpgradeRequest("permessage-deflate; client_max_window_bits");
        ch.writeInbound(new Object[]{req});
        HttpResponse res = WebSocketExtensionTestUtil.newUpgradeResponse(null);
        ch.writeOutbound(new Object[]{res});
        HttpResponse res2 = (HttpResponse)ch.readOutbound();
        List exts = WebSocketExtensionUtil.extractExtensions((String)res2.headers().get((CharSequence)HttpHeaderNames.SEC_WEBSOCKET_EXTENSIONS));
        Assert.assertEquals((Object)"permessage-deflate", (Object)((WebSocketExtensionData)exts.get(0)).name());
        Assert.assertEquals((Object)"10", ((WebSocketExtensionData)exts.get(0)).parameters().get("client_max_window_bits"));
        Assert.assertNotNull((Object)ch.pipeline().get(PerMessageDeflateDecoder.class));
        Assert.assertNotNull((Object)ch.pipeline().get(PerMessageDeflateEncoder.class));
    }

    @Test
    public void testClientWindowSizeUnavailable() {
        EmbeddedChannel ch = new EmbeddedChannel(new ChannelHandler[]{new WebSocketServerExtensionHandler(new WebSocketServerExtensionHandshaker[]{new PerMessageDeflateServerExtensionHandshaker(6, false, 10, false, false)})});
        HttpRequest req = WebSocketExtensionTestUtil.newUpgradeRequest("permessage-deflate");
        ch.writeInbound(new Object[]{req});
        HttpResponse res = WebSocketExtensionTestUtil.newUpgradeResponse(null);
        ch.writeOutbound(new Object[]{res});
        HttpResponse res2 = (HttpResponse)ch.readOutbound();
        List exts = WebSocketExtensionUtil.extractExtensions((String)res2.headers().get((CharSequence)HttpHeaderNames.SEC_WEBSOCKET_EXTENSIONS));
        Assert.assertEquals((Object)"permessage-deflate", (Object)((WebSocketExtensionData)exts.get(0)).name());
        Assert.assertTrue((boolean)((WebSocketExtensionData)exts.get(0)).parameters().isEmpty());
        Assert.assertNotNull((Object)ch.pipeline().get(PerMessageDeflateDecoder.class));
        Assert.assertNotNull((Object)ch.pipeline().get(PerMessageDeflateEncoder.class));
    }

    @Test
    public void testServerWindowSizeSuccess() {
        EmbeddedChannel ch = new EmbeddedChannel(new ChannelHandler[]{new WebSocketServerExtensionHandler(new WebSocketServerExtensionHandshaker[]{new PerMessageDeflateServerExtensionHandshaker(6, true, 15, false, false)})});
        HttpRequest req = WebSocketExtensionTestUtil.newUpgradeRequest("permessage-deflate; server_max_window_bits=10");
        ch.writeInbound(new Object[]{req});
        HttpResponse res = WebSocketExtensionTestUtil.newUpgradeResponse(null);
        ch.writeOutbound(new Object[]{res});
        HttpResponse res2 = (HttpResponse)ch.readOutbound();
        List exts = WebSocketExtensionUtil.extractExtensions((String)res2.headers().get((CharSequence)HttpHeaderNames.SEC_WEBSOCKET_EXTENSIONS));
        Assert.assertEquals((Object)"permessage-deflate", (Object)((WebSocketExtensionData)exts.get(0)).name());
        Assert.assertEquals((Object)"10", ((WebSocketExtensionData)exts.get(0)).parameters().get("server_max_window_bits"));
        Assert.assertNotNull((Object)ch.pipeline().get(PerMessageDeflateDecoder.class));
        Assert.assertNotNull((Object)ch.pipeline().get(PerMessageDeflateEncoder.class));
    }

    @Test
    public void testServerWindowSizeDisable() {
        EmbeddedChannel ch = new EmbeddedChannel(new ChannelHandler[]{new WebSocketServerExtensionHandler(new WebSocketServerExtensionHandshaker[]{new PerMessageDeflateServerExtensionHandshaker(6, false, 15, false, false)})});
        HttpRequest req = WebSocketExtensionTestUtil.newUpgradeRequest("permessage-deflate; server_max_window_bits=10");
        ch.writeInbound(new Object[]{req});
        HttpResponse res = WebSocketExtensionTestUtil.newUpgradeResponse(null);
        ch.writeOutbound(new Object[]{res});
        HttpResponse res2 = (HttpResponse)ch.readOutbound();
        Assert.assertFalse((boolean)res2.headers().contains((CharSequence)HttpHeaderNames.SEC_WEBSOCKET_EXTENSIONS));
        Assert.assertNull((Object)ch.pipeline().get(PerMessageDeflateDecoder.class));
        Assert.assertNull((Object)ch.pipeline().get(PerMessageDeflateEncoder.class));
    }

    @Test
    public void testServerNoContext() {
        EmbeddedChannel ch = new EmbeddedChannel(new ChannelHandler[]{new WebSocketServerCompressionHandler()});
        HttpRequest req = WebSocketExtensionTestUtil.newUpgradeRequest("permessage-deflate; server_no_context_takeover");
        ch.writeInbound(new Object[]{req});
        HttpResponse res = WebSocketExtensionTestUtil.newUpgradeResponse(null);
        ch.writeOutbound(new Object[]{res});
        HttpResponse res2 = (HttpResponse)ch.readOutbound();
        Assert.assertFalse((boolean)res2.headers().contains((CharSequence)HttpHeaderNames.SEC_WEBSOCKET_EXTENSIONS));
        Assert.assertNull((Object)ch.pipeline().get(PerMessageDeflateDecoder.class));
        Assert.assertNull((Object)ch.pipeline().get(PerMessageDeflateEncoder.class));
    }

    @Test
    public void testClientNoContext() {
        EmbeddedChannel ch = new EmbeddedChannel(new ChannelHandler[]{new WebSocketServerCompressionHandler()});
        HttpRequest req = WebSocketExtensionTestUtil.newUpgradeRequest("permessage-deflate; client_no_context_takeover");
        ch.writeInbound(new Object[]{req});
        HttpResponse res = WebSocketExtensionTestUtil.newUpgradeResponse(null);
        ch.writeOutbound(new Object[]{res});
        HttpResponse res2 = (HttpResponse)ch.readOutbound();
        List exts = WebSocketExtensionUtil.extractExtensions((String)res2.headers().get((CharSequence)HttpHeaderNames.SEC_WEBSOCKET_EXTENSIONS));
        Assert.assertEquals((Object)"permessage-deflate", (Object)((WebSocketExtensionData)exts.get(0)).name());
        Assert.assertTrue((boolean)((WebSocketExtensionData)exts.get(0)).parameters().isEmpty());
        Assert.assertNotNull((Object)ch.pipeline().get(PerMessageDeflateDecoder.class));
        Assert.assertNotNull((Object)ch.pipeline().get(PerMessageDeflateEncoder.class));
    }

    @Test
    public void testServerWindowSizeDisableThenFallback() {
        EmbeddedChannel ch = new EmbeddedChannel(new ChannelHandler[]{new WebSocketServerExtensionHandler(new WebSocketServerExtensionHandshaker[]{new PerMessageDeflateServerExtensionHandshaker(6, false, 15, false, false)})});
        HttpRequest req = WebSocketExtensionTestUtil.newUpgradeRequest("permessage-deflate; server_max_window_bits=10, permessage-deflate");
        ch.writeInbound(new Object[]{req});
        HttpResponse res = WebSocketExtensionTestUtil.newUpgradeResponse(null);
        ch.writeOutbound(new Object[]{res});
        HttpResponse res2 = (HttpResponse)ch.readOutbound();
        List exts = WebSocketExtensionUtil.extractExtensions((String)res2.headers().get((CharSequence)HttpHeaderNames.SEC_WEBSOCKET_EXTENSIONS));
        Assert.assertEquals((Object)"permessage-deflate", (Object)((WebSocketExtensionData)exts.get(0)).name());
        Assert.assertTrue((boolean)((WebSocketExtensionData)exts.get(0)).parameters().isEmpty());
        Assert.assertNotNull((Object)ch.pipeline().get(PerMessageDeflateDecoder.class));
        Assert.assertNotNull((Object)ch.pipeline().get(PerMessageDeflateEncoder.class));
    }
}

