/*
 * Decompiled with CFR 0.152.
 */
package io.netty.handler.codec.http;

import io.netty.buffer.ByteBuf;
import io.netty.buffer.Unpooled;
import io.netty.channel.ChannelHandler;
import io.netty.channel.embedded.EmbeddedChannel;
import io.netty.handler.codec.http.DefaultFullHttpResponse;
import io.netty.handler.codec.http.DefaultHttpResponse;
import io.netty.handler.codec.http.FullHttpRequest;
import io.netty.handler.codec.http.HttpContent;
import io.netty.handler.codec.http.HttpHeaderNames;
import io.netty.handler.codec.http.HttpMessage;
import io.netty.handler.codec.http.HttpMethod;
import io.netty.handler.codec.http.HttpObjectAggregator;
import io.netty.handler.codec.http.HttpRequest;
import io.netty.handler.codec.http.HttpResponseStatus;
import io.netty.handler.codec.http.HttpServerCodec;
import io.netty.handler.codec.http.HttpUtil;
import io.netty.handler.codec.http.HttpVersion;
import io.netty.handler.codec.http.LastHttpContent;
import io.netty.util.CharsetUtil;
import java.nio.charset.Charset;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.junit.Assert;
import org.junit.Test;

public class HttpServerCodecTest {
    @Test
    public void testUnfinishedChunkedHttpRequestIsLastFlag() throws Exception {
        HttpContent httpChunk;
        int maxChunkSize = 2000;
        HttpServerCodec httpServerCodec = new HttpServerCodec(1000, 1000, maxChunkSize);
        EmbeddedChannel decoderEmbedder = new EmbeddedChannel(new ChannelHandler[]{httpServerCodec});
        int totalContentLength = maxChunkSize * 5;
        decoderEmbedder.writeInbound(new Object[]{Unpooled.copiedBuffer((CharSequence)("PUT /test HTTP/1.1\r\nContent-Length: " + totalContentLength + "\r\n\r\n"), (Charset)CharsetUtil.UTF_8)});
        int offeredContentLength = (int)((double)maxChunkSize * 2.5);
        decoderEmbedder.writeInbound(new Object[]{HttpServerCodecTest.prepareDataChunk(offeredContentLength)});
        decoderEmbedder.finish();
        HttpMessage httpMessage = (HttpMessage)decoderEmbedder.readInbound();
        Assert.assertNotNull((Object)httpMessage);
        boolean empty = true;
        int totalBytesPolled = 0;
        while ((httpChunk = (HttpContent)decoderEmbedder.readInbound()) != null) {
            empty = false;
            totalBytesPolled += httpChunk.content().readableBytes();
            Assert.assertFalse((boolean)(httpChunk instanceof LastHttpContent));
            httpChunk.release();
        }
        Assert.assertFalse((boolean)empty);
        Assert.assertEquals((long)offeredContentLength, (long)totalBytesPolled);
    }

    @Test
    public void test100Continue() throws Exception {
        EmbeddedChannel ch = new EmbeddedChannel(new ChannelHandler[]{new HttpServerCodec(), new HttpObjectAggregator(1024)});
        ch.writeInbound(new Object[]{Unpooled.copiedBuffer((CharSequence)"PUT /upload-large HTTP/1.1\r\nExpect: 100-continue\r\nContent-Length: 1\r\n\r\n", (Charset)CharsetUtil.UTF_8)});
        Assert.assertThat((Object)ch.readInbound(), (Matcher)CoreMatchers.is((Matcher)CoreMatchers.nullValue()));
        ByteBuf continueResponse = (ByteBuf)ch.readOutbound();
        Assert.assertThat((Object)continueResponse.toString(CharsetUtil.UTF_8), (Matcher)CoreMatchers.is((Object)"HTTP/1.1 100 Continue\r\n\r\n"));
        continueResponse.release();
        Assert.assertThat((Object)ch.readOutbound(), (Matcher)CoreMatchers.is((Matcher)CoreMatchers.nullValue()));
        ch.writeInbound(new Object[]{Unpooled.wrappedBuffer((byte[])new byte[]{42})});
        FullHttpRequest req = (FullHttpRequest)ch.readInbound();
        Assert.assertThat((Object)req.headers().get((CharSequence)HttpHeaderNames.CONTENT_LENGTH), (Matcher)CoreMatchers.is((Object)"1"));
        Assert.assertThat((Object)req.content().readableBytes(), (Matcher)CoreMatchers.is((Object)1));
        Assert.assertThat((Object)req.content().readByte(), (Matcher)CoreMatchers.is((Object)42));
        req.release();
        Assert.assertThat((Object)ch.readInbound(), (Matcher)CoreMatchers.is((Matcher)CoreMatchers.nullValue()));
        DefaultFullHttpResponse res = new DefaultFullHttpResponse(HttpVersion.HTTP_1_1, HttpResponseStatus.CREATED);
        res.content().writeBytes("OK".getBytes(CharsetUtil.UTF_8));
        res.headers().setInt((CharSequence)HttpHeaderNames.CONTENT_LENGTH, 2);
        ch.writeOutbound(new Object[]{res});
        ByteBuf encodedRes = (ByteBuf)ch.readOutbound();
        Assert.assertThat((Object)encodedRes.toString(CharsetUtil.UTF_8), (Matcher)CoreMatchers.is((Object)("HTTP/1.1 201 Created\r\n" + HttpHeaderNames.CONTENT_LENGTH + ": 2\r\n\r\nOK")));
        encodedRes.release();
        ch.finish();
    }

    @Test
    public void testChunkedHeadResponse() {
        EmbeddedChannel ch = new EmbeddedChannel(new ChannelHandler[]{new HttpServerCodec()});
        Assert.assertTrue((boolean)ch.writeInbound(new Object[]{Unpooled.copiedBuffer((CharSequence)"HEAD / HTTP/1.1\r\n\r\n", (Charset)CharsetUtil.UTF_8)}));
        HttpRequest request = (HttpRequest)ch.readInbound();
        Assert.assertEquals((Object)HttpMethod.HEAD, (Object)request.method());
        LastHttpContent content = (LastHttpContent)ch.readInbound();
        Assert.assertFalse((boolean)content.content().isReadable());
        content.release();
        DefaultHttpResponse response = new DefaultHttpResponse(HttpVersion.HTTP_1_1, HttpResponseStatus.OK);
        HttpUtil.setTransferEncodingChunked((HttpMessage)response, (boolean)true);
        Assert.assertTrue((boolean)ch.writeOutbound(new Object[]{response}));
        Assert.assertTrue((boolean)ch.writeOutbound(new Object[]{LastHttpContent.EMPTY_LAST_CONTENT}));
        Assert.assertTrue((boolean)ch.finish());
        ByteBuf buf = (ByteBuf)ch.readOutbound();
        Assert.assertEquals((Object)"HTTP/1.1 200 OK\r\ntransfer-encoding: chunked\r\n\r\n", (Object)buf.toString(CharsetUtil.US_ASCII));
        buf.release();
        buf = (ByteBuf)ch.readOutbound();
        Assert.assertFalse((boolean)buf.isReadable());
        buf.release();
        Assert.assertFalse((boolean)ch.finishAndReleaseAll());
    }

    @Test
    public void testChunkedHeadFullHttpResponse() {
        EmbeddedChannel ch = new EmbeddedChannel(new ChannelHandler[]{new HttpServerCodec()});
        Assert.assertTrue((boolean)ch.writeInbound(new Object[]{Unpooled.copiedBuffer((CharSequence)"HEAD / HTTP/1.1\r\n\r\n", (Charset)CharsetUtil.UTF_8)}));
        HttpRequest request = (HttpRequest)ch.readInbound();
        Assert.assertEquals((Object)HttpMethod.HEAD, (Object)request.method());
        LastHttpContent content = (LastHttpContent)ch.readInbound();
        Assert.assertFalse((boolean)content.content().isReadable());
        content.release();
        DefaultFullHttpResponse response = new DefaultFullHttpResponse(HttpVersion.HTTP_1_1, HttpResponseStatus.OK);
        HttpUtil.setTransferEncodingChunked((HttpMessage)response, (boolean)true);
        Assert.assertTrue((boolean)ch.writeOutbound(new Object[]{response}));
        Assert.assertTrue((boolean)ch.finish());
        ByteBuf buf = (ByteBuf)ch.readOutbound();
        Assert.assertEquals((Object)"HTTP/1.1 200 OK\r\ntransfer-encoding: chunked\r\n\r\n", (Object)buf.toString(CharsetUtil.US_ASCII));
        buf.release();
        Assert.assertFalse((boolean)ch.finishAndReleaseAll());
    }

    private static ByteBuf prepareDataChunk(int size) {
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < size; ++i) {
            sb.append('a');
        }
        return Unpooled.copiedBuffer((CharSequence)sb.toString(), (Charset)CharsetUtil.UTF_8);
    }
}

