/*
 * Decompiled with CFR 0.152.
 */
package io.netty.handler.codec.http;

import io.netty.channel.ChannelFuture;
import io.netty.channel.ChannelFutureListener;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelHandlerContext;
import io.netty.handler.codec.http.DefaultFullHttpResponse;
import io.netty.handler.codec.http.FullHttpRequest;
import io.netty.handler.codec.http.FullHttpResponse;
import io.netty.handler.codec.http.HttpHeaderNames;
import io.netty.handler.codec.http.HttpHeaderValues;
import io.netty.handler.codec.http.HttpObject;
import io.netty.handler.codec.http.HttpObjectAggregator;
import io.netty.handler.codec.http.HttpRequest;
import io.netty.handler.codec.http.HttpResponseStatus;
import io.netty.handler.codec.http.HttpVersion;
import io.netty.util.ReferenceCountUtil;
import io.netty.util.ReferenceCounted;
import io.netty.util.concurrent.GenericFutureListener;
import io.netty.util.internal.ObjectUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

public class HttpServerUpgradeHandler
extends HttpObjectAggregator {
    private static final String UPGRADE_STRING = HttpHeaderNames.UPGRADE.toString();
    private final SourceCodec sourceCodec;
    private final UpgradeCodecFactory upgradeCodecFactory;
    private boolean handlingUpgrade;

    public HttpServerUpgradeHandler(SourceCodec sourceCodec, UpgradeCodecFactory upgradeCodecFactory) {
        this(sourceCodec, upgradeCodecFactory, 0);
    }

    public HttpServerUpgradeHandler(SourceCodec sourceCodec, UpgradeCodecFactory upgradeCodecFactory, int maxContentLength) {
        super(maxContentLength);
        this.sourceCodec = (SourceCodec)ObjectUtil.checkNotNull((Object)sourceCodec, (String)"sourceCodec");
        this.upgradeCodecFactory = (UpgradeCodecFactory)ObjectUtil.checkNotNull((Object)upgradeCodecFactory, (String)"upgradeCodecFactory");
    }

    protected void decode(ChannelHandlerContext ctx, HttpObject msg, List<Object> out) throws Exception {
        FullHttpRequest fullRequest;
        this.handlingUpgrade |= HttpServerUpgradeHandler.isUpgradeRequest(msg);
        if (!this.handlingUpgrade) {
            ReferenceCountUtil.retain((Object)msg);
            out.add(msg);
            return;
        }
        if (msg instanceof FullHttpRequest) {
            fullRequest = (FullHttpRequest)msg;
            ReferenceCountUtil.retain((Object)msg);
            out.add(msg);
        } else {
            super.decode(ctx, (Object)msg, out);
            if (out.isEmpty()) {
                return;
            }
            assert (out.size() == 1);
            this.handlingUpgrade = false;
            fullRequest = (FullHttpRequest)out.get(0);
        }
        if (this.upgrade(ctx, fullRequest)) {
            out.clear();
        }
    }

    private static boolean isUpgradeRequest(HttpObject msg) {
        return msg instanceof HttpRequest && ((HttpRequest)msg).headers().get((CharSequence)HttpHeaderNames.UPGRADE) != null;
    }

    private boolean upgrade(final ChannelHandlerContext ctx, final FullHttpRequest request) {
        ArrayList<String> requestedProtocols = HttpServerUpgradeHandler.splitHeader(request.headers().get((CharSequence)HttpHeaderNames.UPGRADE));
        int numRequestedProtocols = requestedProtocols.size();
        UpgradeCodec upgradeCodec = null;
        String upgradeProtocol = null;
        for (int i = 0; i < numRequestedProtocols; ++i) {
            String p = requestedProtocols.get(i);
            UpgradeCodec c = this.upgradeCodecFactory.newUpgradeCodec(p);
            if (c == null) continue;
            upgradeProtocol = p;
            upgradeCodec = c;
            break;
        }
        if (upgradeCodec == null) {
            return false;
        }
        String connectionHeader = request.headers().get((CharSequence)HttpHeaderNames.CONNECTION);
        if (connectionHeader == null) {
            return false;
        }
        Collection<String> requiredHeaders = upgradeCodec.requiredUpgradeHeaders();
        ArrayList<String> values = HttpServerUpgradeHandler.splitHeader(connectionHeader);
        if (!values.contains(UPGRADE_STRING) || !values.containsAll(requiredHeaders)) {
            return false;
        }
        for (String requiredHeader : requiredHeaders) {
            if (request.headers().contains(requiredHeader)) continue;
            return false;
        }
        final UpgradeEvent event = new UpgradeEvent(upgradeProtocol, request);
        final FullHttpResponse upgradeResponse = HttpServerUpgradeHandler.createUpgradeResponse(upgradeProtocol);
        upgradeCodec.prepareUpgradeResponse(ctx, request, upgradeResponse);
        final UpgradeCodec finalUpgradeCodec = upgradeCodec;
        ctx.writeAndFlush((Object)upgradeResponse).addListener((GenericFutureListener)new ChannelFutureListener(){

            public void operationComplete(ChannelFuture future) throws Exception {
                try {
                    if (future.isSuccess()) {
                        HttpServerUpgradeHandler.this.sourceCodec.upgradeFrom(ctx);
                        finalUpgradeCodec.upgradeTo(ctx, request, upgradeResponse);
                        ctx.fireUserEventTriggered((Object)event.retain());
                        ctx.pipeline().remove((ChannelHandler)HttpServerUpgradeHandler.this);
                    } else {
                        future.channel().close();
                    }
                }
                finally {
                    event.release();
                }
            }
        });
        return true;
    }

    private static FullHttpResponse createUpgradeResponse(String upgradeProtocol) {
        DefaultFullHttpResponse res = new DefaultFullHttpResponse(HttpVersion.HTTP_1_1, HttpResponseStatus.SWITCHING_PROTOCOLS);
        res.headers().add((CharSequence)HttpHeaderNames.CONNECTION, (Object)HttpHeaderValues.UPGRADE);
        res.headers().add((CharSequence)HttpHeaderNames.UPGRADE, (Object)upgradeProtocol);
        res.headers().add((CharSequence)HttpHeaderNames.CONTENT_LENGTH, (Object)"0");
        return res;
    }

    private static ArrayList<String> splitHeader(CharSequence header) {
        StringBuilder builder = new StringBuilder(header.length());
        ArrayList<String> protocols = new ArrayList<String>(4);
        for (int i = 0; i < header.length(); ++i) {
            char c = header.charAt(i);
            if (Character.isWhitespace(c)) continue;
            if (c == ',') {
                protocols.add(builder.toString());
                builder.setLength(0);
                continue;
            }
            builder.append(c);
        }
        if (builder.length() > 0) {
            protocols.add(builder.toString());
        }
        return protocols;
    }

    public static final class UpgradeEvent
    implements ReferenceCounted {
        private final String protocol;
        private final FullHttpRequest upgradeRequest;

        private UpgradeEvent(String protocol, FullHttpRequest upgradeRequest) {
            this.protocol = protocol;
            this.upgradeRequest = upgradeRequest;
        }

        public String protocol() {
            return this.protocol;
        }

        public FullHttpRequest upgradeRequest() {
            return this.upgradeRequest;
        }

        public int refCnt() {
            return this.upgradeRequest.refCnt();
        }

        public UpgradeEvent retain() {
            this.upgradeRequest.retain();
            return this;
        }

        public UpgradeEvent retain(int increment) {
            this.upgradeRequest.retain(increment);
            return this;
        }

        public UpgradeEvent touch() {
            this.upgradeRequest.touch();
            return this;
        }

        public UpgradeEvent touch(Object hint) {
            this.upgradeRequest.touch(hint);
            return this;
        }

        public boolean release() {
            return this.upgradeRequest.release();
        }

        public boolean release(int decrement) {
            return this.upgradeRequest.release();
        }

        public String toString() {
            return "UpgradeEvent [protocol=" + this.protocol + ", upgradeRequest=" + this.upgradeRequest + ']';
        }
    }

    public static interface UpgradeCodecFactory {
        public UpgradeCodec newUpgradeCodec(String var1);
    }

    public static interface UpgradeCodec {
        public Collection<String> requiredUpgradeHeaders();

        public void prepareUpgradeResponse(ChannelHandlerContext var1, FullHttpRequest var2, FullHttpResponse var3);

        public void upgradeTo(ChannelHandlerContext var1, FullHttpRequest var2, FullHttpResponse var3);
    }

    public static interface SourceCodec {
        public void upgradeFrom(ChannelHandlerContext var1);
    }
}

