/*
 * Decompiled with CFR 0.152.
 */
package io.netty.handler.codec.spdy;

import io.netty.channel.ChannelHandlerContext;
import io.netty.handler.codec.MessageToMessageEncoder;
import io.netty.handler.codec.UnsupportedMessageTypeException;
import io.netty.handler.codec.http.FullHttpMessage;
import io.netty.handler.codec.http.FullHttpRequest;
import io.netty.handler.codec.http.HttpContent;
import io.netty.handler.codec.http.HttpHeaders;
import io.netty.handler.codec.http.HttpMessage;
import io.netty.handler.codec.http.HttpObject;
import io.netty.handler.codec.http.HttpRequest;
import io.netty.handler.codec.http.HttpResponse;
import io.netty.handler.codec.http.LastHttpContent;
import io.netty.handler.codec.spdy.DefaultSpdyDataFrame;
import io.netty.handler.codec.spdy.DefaultSpdyHeadersFrame;
import io.netty.handler.codec.spdy.DefaultSpdySynReplyFrame;
import io.netty.handler.codec.spdy.DefaultSpdySynStreamFrame;
import io.netty.handler.codec.spdy.SpdyHeaders;
import io.netty.handler.codec.spdy.SpdyHttpHeaders;
import io.netty.handler.codec.spdy.SpdySynReplyFrame;
import io.netty.handler.codec.spdy.SpdySynStreamFrame;
import io.netty.handler.codec.spdy.SpdyVersion;
import java.util.List;
import java.util.Map;

public class SpdyHttpEncoder
extends MessageToMessageEncoder<HttpObject> {
    private final int spdyVersion;
    private int currentStreamId;

    public SpdyHttpEncoder(SpdyVersion version) {
        if (version == null) {
            throw new NullPointerException("version");
        }
        this.spdyVersion = version.getVersion();
    }

    protected void encode(ChannelHandlerContext ctx, HttpObject msg, List<Object> out) throws Exception {
        SpdySynStreamFrame spdySynStreamFrame;
        boolean valid = false;
        boolean last = false;
        if (msg instanceof HttpRequest) {
            HttpRequest httpRequest = (HttpRequest)msg;
            spdySynStreamFrame = this.createSynStreamFrame(httpRequest);
            out.add(spdySynStreamFrame);
            last = spdySynStreamFrame.isLast();
            valid = true;
        }
        if (msg instanceof HttpResponse) {
            HttpResponse httpResponse = (HttpResponse)msg;
            if (httpResponse.headers().contains((CharSequence)SpdyHttpHeaders.Names.ASSOCIATED_TO_STREAM_ID)) {
                spdySynStreamFrame = this.createSynStreamFrame(httpResponse);
                last = spdySynStreamFrame.isLast();
                out.add(spdySynStreamFrame);
            } else {
                SpdySynReplyFrame spdySynReplyFrame = this.createSynReplyFrame(httpResponse);
                last = spdySynReplyFrame.isLast();
                out.add(spdySynReplyFrame);
            }
            valid = true;
        }
        if (msg instanceof HttpContent && !last) {
            HttpContent chunk = (HttpContent)msg;
            chunk.content().retain();
            DefaultSpdyDataFrame spdyDataFrame = new DefaultSpdyDataFrame(this.currentStreamId, chunk.content());
            spdyDataFrame.setLast(chunk instanceof LastHttpContent);
            if (chunk instanceof LastHttpContent) {
                LastHttpContent trailer = (LastHttpContent)chunk;
                HttpHeaders trailers = trailer.trailingHeaders();
                if (trailers.isEmpty()) {
                    out.add(spdyDataFrame);
                } else {
                    DefaultSpdyHeadersFrame spdyHeadersFrame = new DefaultSpdyHeadersFrame(this.currentStreamId);
                    for (Map.Entry entry : trailers) {
                        spdyHeadersFrame.headers().add((CharSequence)entry.getKey(), entry.getValue());
                    }
                    out.add(spdyHeadersFrame);
                    out.add(spdyDataFrame);
                }
            } else {
                out.add(spdyDataFrame);
            }
            valid = true;
        }
        if (!valid) {
            throw new UnsupportedMessageTypeException((Object)msg, new Class[0]);
        }
    }

    private SpdySynStreamFrame createSynStreamFrame(HttpMessage httpMessage) throws Exception {
        HttpHeaders httpHeaders = httpMessage.headers();
        int streamID = HttpHeaders.getIntHeader(httpMessage, (CharSequence)SpdyHttpHeaders.Names.STREAM_ID);
        int associatedToStreamId = HttpHeaders.getIntHeader(httpMessage, (CharSequence)SpdyHttpHeaders.Names.ASSOCIATED_TO_STREAM_ID, 0);
        byte priority = (byte)HttpHeaders.getIntHeader(httpMessage, (CharSequence)SpdyHttpHeaders.Names.PRIORITY, 0);
        String URL2 = httpHeaders.get((CharSequence)SpdyHttpHeaders.Names.URL);
        String scheme = httpHeaders.get((CharSequence)SpdyHttpHeaders.Names.SCHEME);
        httpHeaders.remove((CharSequence)SpdyHttpHeaders.Names.STREAM_ID);
        httpHeaders.remove((CharSequence)SpdyHttpHeaders.Names.ASSOCIATED_TO_STREAM_ID);
        httpHeaders.remove((CharSequence)SpdyHttpHeaders.Names.PRIORITY);
        httpHeaders.remove((CharSequence)SpdyHttpHeaders.Names.URL);
        httpHeaders.remove((CharSequence)SpdyHttpHeaders.Names.SCHEME);
        httpHeaders.remove("Connection");
        httpHeaders.remove("Keep-Alive");
        httpHeaders.remove("Proxy-Connection");
        httpHeaders.remove("Transfer-Encoding");
        DefaultSpdySynStreamFrame spdySynStreamFrame = new DefaultSpdySynStreamFrame(streamID, associatedToStreamId, priority);
        SpdyHeaders frameHeaders = spdySynStreamFrame.headers();
        if (httpMessage instanceof FullHttpRequest) {
            HttpRequest httpRequest = (HttpRequest)httpMessage;
            frameHeaders.set((CharSequence)SpdyHeaders.HttpNames.METHOD, (Object)httpRequest.method());
            frameHeaders.set((CharSequence)SpdyHeaders.HttpNames.PATH, (Object)httpRequest.uri());
            frameHeaders.set((CharSequence)SpdyHeaders.HttpNames.VERSION, (Object)httpMessage.protocolVersion());
        }
        if (httpMessage instanceof HttpResponse) {
            HttpResponse httpResponse = (HttpResponse)httpMessage;
            frameHeaders.set((CharSequence)SpdyHeaders.HttpNames.STATUS, (Object)httpResponse.status());
            frameHeaders.set((CharSequence)SpdyHeaders.HttpNames.PATH, (Object)URL2);
            frameHeaders.set((CharSequence)SpdyHeaders.HttpNames.VERSION, (Object)httpMessage.protocolVersion());
            spdySynStreamFrame.setUnidirectional(true);
        }
        if (this.spdyVersion >= 3) {
            String host = HttpHeaders.getHost(httpMessage);
            httpHeaders.remove("Host");
            frameHeaders.set((CharSequence)SpdyHeaders.HttpNames.HOST, (Object)host);
        }
        if (scheme == null) {
            scheme = "https";
        }
        frameHeaders.set((CharSequence)SpdyHeaders.HttpNames.SCHEME, (Object)scheme);
        for (Map.Entry entry : httpHeaders) {
            frameHeaders.add((CharSequence)entry.getKey(), entry.getValue());
        }
        this.currentStreamId = spdySynStreamFrame.streamId();
        spdySynStreamFrame.setLast(SpdyHttpEncoder.isLast(httpMessage));
        return spdySynStreamFrame;
    }

    private SpdySynReplyFrame createSynReplyFrame(HttpResponse httpResponse) throws Exception {
        HttpHeaders httpHeaders = httpResponse.headers();
        int streamID = HttpHeaders.getIntHeader((HttpMessage)httpResponse, (CharSequence)SpdyHttpHeaders.Names.STREAM_ID);
        httpHeaders.remove((CharSequence)SpdyHttpHeaders.Names.STREAM_ID);
        httpHeaders.remove("Connection");
        httpHeaders.remove("Keep-Alive");
        httpHeaders.remove("Proxy-Connection");
        httpHeaders.remove("Transfer-Encoding");
        DefaultSpdySynReplyFrame spdySynReplyFrame = new DefaultSpdySynReplyFrame(streamID);
        SpdyHeaders frameHeaders = spdySynReplyFrame.headers();
        frameHeaders.set((CharSequence)SpdyHeaders.HttpNames.STATUS, (Object)httpResponse.status());
        frameHeaders.set((CharSequence)SpdyHeaders.HttpNames.VERSION, (Object)httpResponse.protocolVersion());
        for (Map.Entry entry : httpHeaders) {
            spdySynReplyFrame.headers().add((CharSequence)entry.getKey(), entry.getValue());
        }
        this.currentStreamId = streamID;
        spdySynReplyFrame.setLast(SpdyHttpEncoder.isLast(httpResponse));
        return spdySynReplyFrame;
    }

    private static boolean isLast(HttpMessage httpMessage) {
        FullHttpMessage fullMessage;
        return httpMessage instanceof FullHttpMessage && (fullMessage = (FullHttpMessage)httpMessage).trailingHeaders().isEmpty() && !fullMessage.content().isReadable();
    }
}

