/*
 * Decompiled with CFR 0.152.
 */
package io.netty.handler.codec.spdy;

import io.netty.buffer.ByteBuf;
import io.netty.channel.ChannelHandlerContext;
import io.netty.handler.codec.MessageToMessageDecoder;
import io.netty.handler.codec.TooLongFrameException;
import io.netty.handler.codec.http.DefaultFullHttpRequest;
import io.netty.handler.codec.http.DefaultFullHttpResponse;
import io.netty.handler.codec.http.FullHttpMessage;
import io.netty.handler.codec.http.FullHttpRequest;
import io.netty.handler.codec.http.FullHttpResponse;
import io.netty.handler.codec.http.HttpHeaders;
import io.netty.handler.codec.http.HttpMessage;
import io.netty.handler.codec.http.HttpMethod;
import io.netty.handler.codec.http.HttpResponseStatus;
import io.netty.handler.codec.http.HttpVersion;
import io.netty.handler.codec.spdy.DefaultSpdyRstStreamFrame;
import io.netty.handler.codec.spdy.DefaultSpdySynReplyFrame;
import io.netty.handler.codec.spdy.SpdyCodecUtil;
import io.netty.handler.codec.spdy.SpdyDataFrame;
import io.netty.handler.codec.spdy.SpdyFrame;
import io.netty.handler.codec.spdy.SpdyHeaders;
import io.netty.handler.codec.spdy.SpdyHeadersFrame;
import io.netty.handler.codec.spdy.SpdyHttpHeaders;
import io.netty.handler.codec.spdy.SpdyRstStreamFrame;
import io.netty.handler.codec.spdy.SpdyStreamStatus;
import io.netty.handler.codec.spdy.SpdySynReplyFrame;
import io.netty.handler.codec.spdy.SpdySynStreamFrame;
import io.netty.handler.codec.spdy.SpdyVersion;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;

public class SpdyHttpDecoder
extends MessageToMessageDecoder<SpdyFrame> {
    private final boolean validateHeaders;
    private final int spdyVersion;
    private final int maxContentLength;
    private final Map<Integer, FullHttpMessage> messageMap;

    public SpdyHttpDecoder(SpdyVersion version, int maxContentLength) {
        this(version, maxContentLength, new HashMap<Integer, FullHttpMessage>(), true);
    }

    public SpdyHttpDecoder(SpdyVersion version, int maxContentLength, boolean validateHeaders) {
        this(version, maxContentLength, new HashMap<Integer, FullHttpMessage>(), validateHeaders);
    }

    protected SpdyHttpDecoder(SpdyVersion version, int maxContentLength, Map<Integer, FullHttpMessage> messageMap) {
        this(version, maxContentLength, messageMap, true);
    }

    protected SpdyHttpDecoder(SpdyVersion version, int maxContentLength, Map<Integer, FullHttpMessage> messageMap, boolean validateHeaders) {
        if (version == null) {
            throw new NullPointerException("version");
        }
        if (maxContentLength <= 0) {
            throw new IllegalArgumentException("maxContentLength must be a positive integer: " + maxContentLength);
        }
        this.spdyVersion = version.getVersion();
        this.maxContentLength = maxContentLength;
        this.messageMap = messageMap;
        this.validateHeaders = validateHeaders;
    }

    protected FullHttpMessage putMessage(int streamId, FullHttpMessage message) {
        return this.messageMap.put(streamId, message);
    }

    protected FullHttpMessage getMessage(int streamId) {
        return this.messageMap.get(streamId);
    }

    protected FullHttpMessage removeMessage(int streamId) {
        return this.messageMap.remove(streamId);
    }

    protected void decode(ChannelHandlerContext ctx, SpdyFrame msg, List<Object> out) throws Exception {
        block32: {
            if (msg instanceof SpdySynStreamFrame) {
                SpdySynStreamFrame spdySynStreamFrame = (SpdySynStreamFrame)msg;
                int streamId = spdySynStreamFrame.streamId();
                if (SpdyCodecUtil.isServerId(streamId)) {
                    int associatedToStreamId = spdySynStreamFrame.associatedStreamId();
                    if (associatedToStreamId == 0) {
                        DefaultSpdyRstStreamFrame spdyRstStreamFrame = new DefaultSpdyRstStreamFrame(streamId, SpdyStreamStatus.INVALID_STREAM);
                        ctx.writeAndFlush((Object)spdyRstStreamFrame);
                        return;
                    }
                    String URL2 = spdySynStreamFrame.headers().get((CharSequence)SpdyHeaders.HttpNames.PATH);
                    spdySynStreamFrame.headers().remove((CharSequence)SpdyHeaders.HttpNames.PATH);
                    if (URL2 == null) {
                        DefaultSpdyRstStreamFrame spdyRstStreamFrame = new DefaultSpdyRstStreamFrame(streamId, SpdyStreamStatus.PROTOCOL_ERROR);
                        ctx.writeAndFlush((Object)spdyRstStreamFrame);
                        return;
                    }
                    if (spdySynStreamFrame.isTruncated()) {
                        DefaultSpdyRstStreamFrame spdyRstStreamFrame = new DefaultSpdyRstStreamFrame(streamId, SpdyStreamStatus.INTERNAL_ERROR);
                        ctx.writeAndFlush((Object)spdyRstStreamFrame);
                        return;
                    }
                    try {
                        FullHttpResponse httpResponseWithEntity = SpdyHttpDecoder.createHttpResponse(ctx, spdySynStreamFrame, this.validateHeaders);
                        HttpHeaders.setIntHeader((HttpMessage)httpResponseWithEntity, (CharSequence)SpdyHttpHeaders.Names.STREAM_ID, streamId);
                        HttpHeaders.setIntHeader((HttpMessage)httpResponseWithEntity, (CharSequence)SpdyHttpHeaders.Names.ASSOCIATED_TO_STREAM_ID, associatedToStreamId);
                        HttpHeaders.setIntHeader((HttpMessage)httpResponseWithEntity, (CharSequence)SpdyHttpHeaders.Names.PRIORITY, (int)spdySynStreamFrame.priority());
                        httpResponseWithEntity.headers().set((CharSequence)SpdyHttpHeaders.Names.URL, (Object)URL2);
                        if (spdySynStreamFrame.isLast()) {
                            HttpHeaders.setContentLength(httpResponseWithEntity, 0L);
                            out.add(httpResponseWithEntity);
                            break block32;
                        }
                        this.putMessage(streamId, httpResponseWithEntity);
                    }
                    catch (Exception ignored) {
                        DefaultSpdyRstStreamFrame spdyRstStreamFrame = new DefaultSpdyRstStreamFrame(streamId, SpdyStreamStatus.PROTOCOL_ERROR);
                        ctx.writeAndFlush((Object)spdyRstStreamFrame);
                    }
                } else {
                    if (spdySynStreamFrame.isTruncated()) {
                        DefaultSpdySynReplyFrame spdySynReplyFrame = new DefaultSpdySynReplyFrame(streamId);
                        spdySynReplyFrame.setLast(true);
                        SpdyHeaders frameHeaders = spdySynReplyFrame.headers();
                        frameHeaders.set((CharSequence)SpdyHeaders.HttpNames.STATUS, (Object)HttpResponseStatus.REQUEST_HEADER_FIELDS_TOO_LARGE);
                        frameHeaders.set((CharSequence)SpdyHeaders.HttpNames.VERSION, (Object)HttpVersion.HTTP_1_0);
                        ctx.writeAndFlush((Object)spdySynReplyFrame);
                        return;
                    }
                    try {
                        FullHttpRequest httpRequestWithEntity = SpdyHttpDecoder.createHttpRequest(this.spdyVersion, spdySynStreamFrame);
                        HttpHeaders.setIntHeader((HttpMessage)httpRequestWithEntity, (CharSequence)SpdyHttpHeaders.Names.STREAM_ID, streamId);
                        if (spdySynStreamFrame.isLast()) {
                            out.add(httpRequestWithEntity);
                            break block32;
                        }
                        this.putMessage(streamId, httpRequestWithEntity);
                    }
                    catch (Exception e) {
                        DefaultSpdySynReplyFrame spdySynReplyFrame = new DefaultSpdySynReplyFrame(streamId);
                        spdySynReplyFrame.setLast(true);
                        SpdyHeaders frameHeaders = spdySynReplyFrame.headers();
                        frameHeaders.set((CharSequence)SpdyHeaders.HttpNames.STATUS, (Object)HttpResponseStatus.BAD_REQUEST);
                        frameHeaders.set((CharSequence)SpdyHeaders.HttpNames.VERSION, (Object)HttpVersion.HTTP_1_0);
                        ctx.writeAndFlush((Object)spdySynReplyFrame);
                    }
                }
            } else if (msg instanceof SpdySynReplyFrame) {
                SpdySynReplyFrame spdySynReplyFrame = (SpdySynReplyFrame)msg;
                int streamId = spdySynReplyFrame.streamId();
                if (spdySynReplyFrame.isTruncated()) {
                    DefaultSpdyRstStreamFrame spdyRstStreamFrame = new DefaultSpdyRstStreamFrame(streamId, SpdyStreamStatus.INTERNAL_ERROR);
                    ctx.writeAndFlush((Object)spdyRstStreamFrame);
                    return;
                }
                try {
                    FullHttpResponse httpResponseWithEntity = SpdyHttpDecoder.createHttpResponse(ctx, spdySynReplyFrame, this.validateHeaders);
                    HttpHeaders.setIntHeader((HttpMessage)httpResponseWithEntity, (CharSequence)SpdyHttpHeaders.Names.STREAM_ID, streamId);
                    if (spdySynReplyFrame.isLast()) {
                        HttpHeaders.setContentLength(httpResponseWithEntity, 0L);
                        out.add(httpResponseWithEntity);
                        break block32;
                    }
                    this.putMessage(streamId, httpResponseWithEntity);
                }
                catch (Exception e) {
                    DefaultSpdyRstStreamFrame spdyRstStreamFrame = new DefaultSpdyRstStreamFrame(streamId, SpdyStreamStatus.PROTOCOL_ERROR);
                    ctx.writeAndFlush((Object)spdyRstStreamFrame);
                }
            } else if (msg instanceof SpdyHeadersFrame) {
                SpdyHeadersFrame spdyHeadersFrame = (SpdyHeadersFrame)msg;
                int streamId = spdyHeadersFrame.streamId();
                FullHttpMessage fullHttpMessage = this.getMessage(streamId);
                if (fullHttpMessage == null) {
                    return;
                }
                if (!spdyHeadersFrame.isTruncated()) {
                    Iterator spdyRstStreamFrame = spdyHeadersFrame.headers().iterator();
                    while (spdyRstStreamFrame.hasNext()) {
                        Map.Entry e = (Map.Entry)spdyRstStreamFrame.next();
                        fullHttpMessage.headers().add((String)e.getKey(), e.getValue());
                    }
                }
                if (spdyHeadersFrame.isLast()) {
                    HttpHeaders.setContentLength(fullHttpMessage, fullHttpMessage.content().readableBytes());
                    this.removeMessage(streamId);
                    out.add(fullHttpMessage);
                }
            } else if (msg instanceof SpdyDataFrame) {
                SpdyDataFrame spdyDataFrame = (SpdyDataFrame)msg;
                int streamId = spdyDataFrame.streamId();
                FullHttpMessage fullHttpMessage = this.getMessage(streamId);
                if (fullHttpMessage == null) {
                    return;
                }
                ByteBuf content = fullHttpMessage.content();
                if (content.readableBytes() > this.maxContentLength - spdyDataFrame.content().readableBytes()) {
                    this.removeMessage(streamId);
                    throw new TooLongFrameException("HTTP content length exceeded " + this.maxContentLength + " bytes.");
                }
                ByteBuf spdyDataFrameData = spdyDataFrame.content();
                int spdyDataFrameDataLen = spdyDataFrameData.readableBytes();
                content.writeBytes(spdyDataFrameData, spdyDataFrameData.readerIndex(), spdyDataFrameDataLen);
                if (spdyDataFrame.isLast()) {
                    HttpHeaders.setContentLength(fullHttpMessage, content.readableBytes());
                    this.removeMessage(streamId);
                    out.add(fullHttpMessage);
                }
            } else if (msg instanceof SpdyRstStreamFrame) {
                SpdyRstStreamFrame spdyRstStreamFrame = (SpdyRstStreamFrame)msg;
                int streamId = spdyRstStreamFrame.streamId();
                this.removeMessage(streamId);
            }
        }
    }

    private static FullHttpRequest createHttpRequest(int spdyVersion, SpdyHeadersFrame requestFrame) throws Exception {
        SpdyHeaders headers = requestFrame.headers();
        HttpMethod method = HttpMethod.valueOf(headers.get((CharSequence)SpdyHeaders.HttpNames.METHOD));
        String url = headers.get((CharSequence)SpdyHeaders.HttpNames.PATH);
        HttpVersion httpVersion = HttpVersion.valueOf(headers.get((CharSequence)SpdyHeaders.HttpNames.VERSION));
        headers.remove((CharSequence)SpdyHeaders.HttpNames.METHOD);
        headers.remove((CharSequence)SpdyHeaders.HttpNames.PATH);
        headers.remove((CharSequence)SpdyHeaders.HttpNames.VERSION);
        DefaultFullHttpRequest req = new DefaultFullHttpRequest(httpVersion, method, url);
        headers.remove((CharSequence)SpdyHeaders.HttpNames.SCHEME);
        String host = headers.get((CharSequence)SpdyHeaders.HttpNames.HOST);
        headers.remove((CharSequence)SpdyHeaders.HttpNames.HOST);
        req.headers().set("Host", (Object)host);
        Iterator iterator = requestFrame.headers().iterator();
        while (iterator.hasNext()) {
            Map.Entry e = (Map.Entry)iterator.next();
            req.headers().add((String)e.getKey(), e.getValue());
        }
        HttpHeaders.setKeepAlive(req, true);
        req.headers().remove("Transfer-Encoding");
        return req;
    }

    private static FullHttpResponse createHttpResponse(ChannelHandlerContext ctx, SpdyHeadersFrame responseFrame, boolean validateHeaders) throws Exception {
        SpdyHeaders headers = responseFrame.headers();
        HttpResponseStatus status = HttpResponseStatus.parseLine(headers.get((CharSequence)SpdyHeaders.HttpNames.STATUS));
        HttpVersion version = HttpVersion.valueOf(headers.get((CharSequence)SpdyHeaders.HttpNames.VERSION));
        headers.remove((CharSequence)SpdyHeaders.HttpNames.STATUS);
        headers.remove((CharSequence)SpdyHeaders.HttpNames.VERSION);
        DefaultFullHttpResponse res = new DefaultFullHttpResponse(version, status, ctx.alloc().buffer(), validateHeaders);
        Iterator iterator = responseFrame.headers().iterator();
        while (iterator.hasNext()) {
            Map.Entry e = (Map.Entry)iterator.next();
            res.headers().add((String)e.getKey(), e.getValue());
        }
        HttpHeaders.setKeepAlive(res, true);
        res.headers().remove("Transfer-Encoding");
        res.headers().remove("Trailer");
        return res;
    }
}

