/*
 * Decompiled with CFR 0.152.
 */
package io.netty.handler.codec.http;

import io.netty.buffer.ByteBuf;
import io.netty.handler.codec.AsciiString;
import io.netty.handler.codec.DefaultTextHeaders;
import io.netty.handler.codec.TextHeaderProcessor;
import io.netty.handler.codec.TextHeaders;
import io.netty.handler.codec.http.HttpHeaderDateFormat;
import io.netty.handler.codec.http.HttpHeaders;
import io.netty.handler.codec.http.HttpHeadersEncoder;
import java.util.Calendar;
import java.util.Date;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class DefaultHttpHeaders
extends HttpHeaders {
    private final TextHeaders headers;

    public DefaultHttpHeaders() {
        this(true);
    }

    public DefaultHttpHeaders(boolean validate) {
        this.headers = validate ? new ValidatingTextHeaders() : new NonValidatingTextHeaders();
    }

    DefaultHttpHeaders(TextHeaders headers) {
        this.headers = headers;
    }

    @Override
    public HttpHeaders add(HttpHeaders headers) {
        if (headers instanceof DefaultHttpHeaders) {
            this.headers.add(((DefaultHttpHeaders)headers).headers);
            return this;
        }
        return super.add(headers);
    }

    @Override
    public HttpHeaders set(HttpHeaders headers) {
        if (headers instanceof DefaultHttpHeaders) {
            this.headers.set(((DefaultHttpHeaders)headers).headers);
            return this;
        }
        return super.set(headers);
    }

    @Override
    public HttpHeaders add(String name, Object value) {
        this.headers.add((CharSequence)name, value);
        return this;
    }

    @Override
    public HttpHeaders add(CharSequence name, Object value) {
        this.headers.add(name, value);
        return this;
    }

    @Override
    public HttpHeaders add(String name, Iterable<?> values) {
        this.headers.add((CharSequence)name, values);
        return this;
    }

    @Override
    public HttpHeaders add(CharSequence name, Iterable<?> values) {
        this.headers.add(name, values);
        return this;
    }

    @Override
    public HttpHeaders remove(String name) {
        this.headers.remove((CharSequence)name);
        return this;
    }

    @Override
    public HttpHeaders remove(CharSequence name) {
        this.headers.remove(name);
        return this;
    }

    @Override
    public HttpHeaders set(String name, Object value) {
        this.headers.set((CharSequence)name, value);
        return this;
    }

    @Override
    public HttpHeaders set(CharSequence name, Object value) {
        this.headers.set(name, value);
        return this;
    }

    @Override
    public HttpHeaders set(String name, Iterable<?> values) {
        this.headers.set((CharSequence)name, values);
        return this;
    }

    @Override
    public HttpHeaders set(CharSequence name, Iterable<?> values) {
        this.headers.set(name, values);
        return this;
    }

    @Override
    public HttpHeaders clear() {
        this.headers.clear();
        return this;
    }

    @Override
    public String get(String name) {
        return this.headers.get((CharSequence)name);
    }

    @Override
    public String get(CharSequence name) {
        return this.headers.get(name);
    }

    @Override
    public List<String> getAll(String name) {
        return this.headers.getAll((CharSequence)name);
    }

    @Override
    public List<String> getAll(CharSequence name) {
        return this.headers.getAll(name);
    }

    @Override
    public List<Map.Entry<String, String>> entries() {
        return this.headers.entries();
    }

    @Override
    public Iterator<Map.Entry<String, String>> iterator() {
        return this.headers.iterator();
    }

    @Override
    public boolean contains(String name) {
        return this.headers.contains((CharSequence)name);
    }

    @Override
    public boolean contains(CharSequence name) {
        return this.headers.contains(name);
    }

    @Override
    public boolean isEmpty() {
        return this.headers.isEmpty();
    }

    @Override
    public boolean contains(String name, String value, boolean ignoreCase) {
        return this.headers.contains((CharSequence)name, (Object)value, ignoreCase);
    }

    @Override
    public boolean contains(CharSequence name, CharSequence value, boolean ignoreCase) {
        return this.headers.contains(name, (Object)value, ignoreCase);
    }

    @Override
    public Set<String> names() {
        return this.headers.names();
    }

    void encode(ByteBuf buf) {
        this.headers.forEachEntry((TextHeaderProcessor)new HttpHeadersEncoder(buf));
    }

    static class ValidatingTextHeaders
    extends NonValidatingTextHeaders {
        private static final int HIGHEST_INVALID_NAME_CHAR_MASK = -64;
        private static final int HIGHEST_INVALID_VALUE_CHAR_MASK = -16;
        private static final byte[] LOOKUP_TABLE = new byte[64];

        ValidatingTextHeaders() {
        }

        protected CharSequence convertName(CharSequence name) {
            if ((name = super.convertName(name)) instanceof AsciiString) {
                ValidatingTextHeaders.validateName((AsciiString)name);
            } else {
                ValidatingTextHeaders.validateName(name);
            }
            return name;
        }

        private static void validateName(AsciiString name) {
            int start = name.arrayOffset();
            int end = start + name.length();
            byte[] array = name.array();
            for (int index = start; index < end; ++index) {
                byte b = array[index];
                if (b < 0) {
                    throw new IllegalArgumentException("a header name cannot contain non-ASCII characters: " + name);
                }
                ValidatingTextHeaders.validateNameChar((CharSequence)name, b);
            }
        }

        private static void validateName(CharSequence name) {
            for (int index = 0; index < name.length(); ++index) {
                char character = name.charAt(index);
                if (character > '\u007f') {
                    throw new IllegalArgumentException("a header name cannot contain non-ASCII characters: " + name);
                }
                ValidatingTextHeaders.validateNameChar(name, character);
            }
        }

        private static void validateNameChar(CharSequence name, int character) {
            if ((character & 0xFFFFFFC0) == 0 && LOOKUP_TABLE[character] != 0) {
                throw new IllegalArgumentException("a header name cannot contain the following prohibited characters: =,;: \\t\\r\\n\\v\\f: " + name);
            }
        }

        @Override
        protected CharSequence convertValue(Object value) {
            CharSequence seq = super.convertValue(value);
            if (value instanceof AsciiString) {
                ValidatingTextHeaders.validateValue((AsciiString)seq);
            } else {
                ValidatingTextHeaders.validateValue(seq);
            }
            return seq;
        }

        private static void validateValue(AsciiString seq) {
            int state = 0;
            int start = seq.arrayOffset();
            int end = start + seq.length();
            byte[] array = seq.array();
            for (int index = start; index < end; ++index) {
                state = ValidatingTextHeaders.validateValueChar((CharSequence)seq, state, (char)(array[index] & 0xFF));
            }
            if (state != 0) {
                throw new IllegalArgumentException("a header value must not end with '\\r' or '\\n':" + seq);
            }
        }

        private static void validateValue(CharSequence seq) {
            int state = 0;
            for (int index = 0; index < seq.length(); ++index) {
                state = ValidatingTextHeaders.validateValueChar(seq, state, seq.charAt(index));
            }
            if (state != 0) {
                throw new IllegalArgumentException("a header value must not end with '\\r' or '\\n':" + seq);
            }
        }

        private static int validateValueChar(CharSequence seq, int state, char character) {
            if ((character & 0xFFFFFFF0) == 0) {
                switch (character) {
                    case '\u000b': {
                        throw new IllegalArgumentException("a header value contains a prohibited character '\\v': " + seq);
                    }
                    case '\f': {
                        throw new IllegalArgumentException("a header value contains a prohibited character '\\f': " + seq);
                    }
                }
            }
            block4 : switch (state) {
                case 0: {
                    switch (character) {
                        case '\r': {
                            state = 1;
                            break;
                        }
                        case '\n': {
                            state = 2;
                        }
                    }
                    break;
                }
                case 1: {
                    switch (character) {
                        case '\n': {
                            state = 2;
                            break block4;
                        }
                    }
                    throw new IllegalArgumentException("only '\\n' is allowed after '\\r': " + seq);
                }
                case 2: {
                    switch (character) {
                        case '\t': 
                        case ' ': {
                            state = 0;
                            break block4;
                        }
                    }
                    throw new IllegalArgumentException("only ' ' and '\\t' are allowed after '\\n': " + seq);
                }
            }
            return state;
        }

        static {
            ValidatingTextHeaders.LOOKUP_TABLE[9] = -1;
            ValidatingTextHeaders.LOOKUP_TABLE[10] = -1;
            ValidatingTextHeaders.LOOKUP_TABLE[11] = -1;
            ValidatingTextHeaders.LOOKUP_TABLE[12] = -1;
            ValidatingTextHeaders.LOOKUP_TABLE[32] = -1;
            ValidatingTextHeaders.LOOKUP_TABLE[44] = -1;
            ValidatingTextHeaders.LOOKUP_TABLE[58] = -1;
            ValidatingTextHeaders.LOOKUP_TABLE[59] = -1;
            ValidatingTextHeaders.LOOKUP_TABLE[61] = -1;
        }
    }

    static class NonValidatingTextHeaders
    extends DefaultTextHeaders {
        NonValidatingTextHeaders() {
        }

        protected CharSequence convertValue(Object value) {
            if (value == null) {
                throw new NullPointerException("value");
            }
            CharSequence seq = value instanceof CharSequence ? (CharSequence)value : (value instanceof Number ? value.toString() : (value instanceof Date ? HttpHeaderDateFormat.get().format((Date)value) : (value instanceof Calendar ? HttpHeaderDateFormat.get().format(((Calendar)value).getTime()) : value.toString())));
            return seq;
        }
    }
}

