/*
 * Decompiled with CFR 0.152.
 */
package io.netty.handler.codec.spdy;

import io.netty.channel.ChannelDuplexHandler;
import io.netty.channel.ChannelFuture;
import io.netty.channel.ChannelFutureListener;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.ChannelPromise;
import io.netty.channel.MessageList;
import io.netty.handler.codec.spdy.DefaultSpdyDataFrame;
import io.netty.handler.codec.spdy.DefaultSpdyGoAwayFrame;
import io.netty.handler.codec.spdy.DefaultSpdyRstStreamFrame;
import io.netty.handler.codec.spdy.DefaultSpdyWindowUpdateFrame;
import io.netty.handler.codec.spdy.SpdyCodecUtil;
import io.netty.handler.codec.spdy.SpdyDataFrame;
import io.netty.handler.codec.spdy.SpdyGoAwayFrame;
import io.netty.handler.codec.spdy.SpdyHeadersFrame;
import io.netty.handler.codec.spdy.SpdyPingFrame;
import io.netty.handler.codec.spdy.SpdyProtocolException;
import io.netty.handler.codec.spdy.SpdyRstStreamFrame;
import io.netty.handler.codec.spdy.SpdySession;
import io.netty.handler.codec.spdy.SpdySessionStatus;
import io.netty.handler.codec.spdy.SpdySettingsFrame;
import io.netty.handler.codec.spdy.SpdyStreamStatus;
import io.netty.handler.codec.spdy.SpdySynReplyFrame;
import io.netty.handler.codec.spdy.SpdySynStreamFrame;
import io.netty.handler.codec.spdy.SpdyWindowUpdateFrame;
import io.netty.util.concurrent.GenericFutureListener;
import io.netty.util.internal.EmptyArrays;
import java.util.concurrent.atomic.AtomicInteger;

public class SpdySessionHandler
extends ChannelDuplexHandler {
    private static final SpdyProtocolException PROTOCOL_EXCEPTION = new SpdyProtocolException();
    private static final SpdyProtocolException STREAM_CLOSED = new SpdyProtocolException("Stream closed");
    private final SpdySession spdySession = new SpdySession();
    private int lastGoodStreamId;
    private int remoteConcurrentStreams;
    private int localConcurrentStreams;
    private int maxConcurrentStreams;
    private static final int DEFAULT_WINDOW_SIZE = 65536;
    private int initialSendWindowSize = 65536;
    private int initialReceiveWindowSize = 65536;
    private final Object flowControlLock = new Object();
    private final AtomicInteger pings = new AtomicInteger();
    private boolean sentGoAwayFrame;
    private boolean receivedGoAwayFrame;
    private ChannelPromise closeSessionFuture;
    private final boolean server;
    private final boolean flowControl;

    public SpdySessionHandler(int version, boolean server) {
        if (version < 2 || version > 3) {
            throw new IllegalArgumentException("unsupported version: " + version);
        }
        this.server = server;
        this.flowControl = version >= 3;
    }

    public void messageReceived(ChannelHandlerContext ctx, MessageList<Object> in) throws Exception {
        Object msg;
        boolean handled = false;
        MessageList out = MessageList.newInstance();
        for (int i = 0; i < in.size() && (msg = in.get(i)) != null; ++i) {
            if (msg instanceof SpdySynStreamFrame && handled) {
                ctx.fireMessageReceived(out);
                out = MessageList.newInstance();
            }
            this.handleInboundMessage(ctx, msg, (MessageList<Object>)out);
            handled = true;
        }
        in.recycle();
        ctx.fireMessageReceived(out);
    }

    private void handleInboundMessage(ChannelHandlerContext ctx, Object msg, MessageList<Object> out) throws Exception {
        if (msg instanceof SpdyDataFrame) {
            SpdyDataFrame spdyDataFrame = (SpdyDataFrame)msg;
            int streamId = spdyDataFrame.getStreamId();
            if (!this.spdySession.isActiveStream(streamId)) {
                if (streamId <= this.lastGoodStreamId) {
                    this.issueStreamError(ctx, streamId, SpdyStreamStatus.PROTOCOL_ERROR, out);
                } else if (!this.sentGoAwayFrame) {
                    this.issueStreamError(ctx, streamId, SpdyStreamStatus.INVALID_STREAM, out);
                }
                return;
            }
            if (this.spdySession.isRemoteSideClosed(streamId)) {
                this.issueStreamError(ctx, streamId, SpdyStreamStatus.STREAM_ALREADY_CLOSED, out);
                return;
            }
            if (!this.isRemoteInitiatedID(streamId) && !this.spdySession.hasReceivedReply(streamId)) {
                this.issueStreamError(ctx, streamId, SpdyStreamStatus.PROTOCOL_ERROR, out);
                return;
            }
            if (this.flowControl) {
                int deltaWindowSize = -1 * spdyDataFrame.content().readableBytes();
                int newWindowSize = this.spdySession.updateReceiveWindowSize(streamId, deltaWindowSize);
                if (newWindowSize < this.spdySession.getReceiveWindowSizeLowerBound(streamId)) {
                    this.issueStreamError(ctx, streamId, SpdyStreamStatus.FLOW_CONTROL_ERROR, out);
                    return;
                }
                if (newWindowSize < 0) {
                    while (spdyDataFrame.content().readableBytes() > this.initialReceiveWindowSize) {
                        DefaultSpdyDataFrame partialDataFrame = new DefaultSpdyDataFrame(streamId, spdyDataFrame.content().readSlice(this.initialReceiveWindowSize).retain());
                        ctx.write((Object)partialDataFrame);
                    }
                }
                if (newWindowSize <= this.initialReceiveWindowSize / 2 && !spdyDataFrame.isLast()) {
                    deltaWindowSize = this.initialReceiveWindowSize - newWindowSize;
                    this.spdySession.updateReceiveWindowSize(streamId, deltaWindowSize);
                    DefaultSpdyWindowUpdateFrame spdyWindowUpdateFrame = new DefaultSpdyWindowUpdateFrame(streamId, deltaWindowSize);
                    ctx.write((Object)spdyWindowUpdateFrame);
                }
            }
            if (spdyDataFrame.isLast()) {
                this.halfCloseStream(streamId, true);
            }
        } else if (msg instanceof SpdySynStreamFrame) {
            boolean localSideClosed;
            boolean remoteSideClosed;
            SpdySynStreamFrame spdySynStreamFrame = (SpdySynStreamFrame)msg;
            int streamId = spdySynStreamFrame.getStreamId();
            if (spdySynStreamFrame.isInvalid() || !this.isRemoteInitiatedID(streamId) || this.spdySession.isActiveStream(streamId)) {
                this.issueStreamError(ctx, streamId, SpdyStreamStatus.PROTOCOL_ERROR, out);
                return;
            }
            if (streamId <= this.lastGoodStreamId) {
                this.issueSessionError(ctx, SpdySessionStatus.PROTOCOL_ERROR);
                return;
            }
            byte priority = spdySynStreamFrame.getPriority();
            if (!this.acceptStream(streamId, priority, remoteSideClosed = spdySynStreamFrame.isLast(), localSideClosed = spdySynStreamFrame.isUnidirectional())) {
                this.issueStreamError(ctx, streamId, SpdyStreamStatus.REFUSED_STREAM, out);
                return;
            }
        } else if (msg instanceof SpdySynReplyFrame) {
            SpdySynReplyFrame spdySynReplyFrame = (SpdySynReplyFrame)msg;
            int streamId = spdySynReplyFrame.getStreamId();
            if (spdySynReplyFrame.isInvalid() || this.isRemoteInitiatedID(streamId) || this.spdySession.isRemoteSideClosed(streamId)) {
                this.issueStreamError(ctx, streamId, SpdyStreamStatus.INVALID_STREAM, out);
                return;
            }
            if (this.spdySession.hasReceivedReply(streamId)) {
                this.issueStreamError(ctx, streamId, SpdyStreamStatus.STREAM_IN_USE, out);
                return;
            }
            this.spdySession.receivedReply(streamId);
            if (spdySynReplyFrame.isLast()) {
                this.halfCloseStream(streamId, true);
            }
        } else if (msg instanceof SpdyRstStreamFrame) {
            SpdyRstStreamFrame spdyRstStreamFrame = (SpdyRstStreamFrame)msg;
            this.removeStream(ctx, spdyRstStreamFrame.getStreamId());
        } else if (msg instanceof SpdySettingsFrame) {
            int newInitialWindowSize;
            SpdySettingsFrame spdySettingsFrame = (SpdySettingsFrame)msg;
            int newConcurrentStreams = spdySettingsFrame.getValue(4);
            if (newConcurrentStreams >= 0) {
                this.updateConcurrentStreams(newConcurrentStreams, true);
            }
            if (spdySettingsFrame.isPersisted(7)) {
                spdySettingsFrame.removeValue(7);
            }
            spdySettingsFrame.setPersistValue(7, false);
            if (this.flowControl && (newInitialWindowSize = spdySettingsFrame.getValue(7)) >= 0) {
                this.updateInitialSendWindowSize(newInitialWindowSize);
            }
        } else if (msg instanceof SpdyPingFrame) {
            SpdyPingFrame spdyPingFrame = (SpdyPingFrame)msg;
            if (this.isRemoteInitiatedID(spdyPingFrame.getId())) {
                ctx.write((Object)spdyPingFrame);
                return;
            }
            if (this.pings.get() == 0) {
                return;
            }
            this.pings.getAndDecrement();
        } else if (msg instanceof SpdyGoAwayFrame) {
            this.receivedGoAwayFrame = true;
        } else if (msg instanceof SpdyHeadersFrame) {
            SpdyHeadersFrame spdyHeadersFrame = (SpdyHeadersFrame)msg;
            int streamId = spdyHeadersFrame.getStreamId();
            if (spdyHeadersFrame.isInvalid()) {
                this.issueStreamError(ctx, streamId, SpdyStreamStatus.PROTOCOL_ERROR, out);
                return;
            }
            if (this.spdySession.isRemoteSideClosed(streamId)) {
                this.issueStreamError(ctx, streamId, SpdyStreamStatus.INVALID_STREAM, out);
                return;
            }
            if (spdyHeadersFrame.isLast()) {
                this.halfCloseStream(streamId, true);
            }
        } else if (msg instanceof SpdyWindowUpdateFrame && this.flowControl) {
            SpdyWindowUpdateFrame spdyWindowUpdateFrame = (SpdyWindowUpdateFrame)msg;
            int streamId = spdyWindowUpdateFrame.getStreamId();
            int deltaWindowSize = spdyWindowUpdateFrame.getDeltaWindowSize();
            if (this.spdySession.isLocalSideClosed(streamId)) {
                return;
            }
            if (this.spdySession.getSendWindowSize(streamId) > Integer.MAX_VALUE - deltaWindowSize) {
                this.issueStreamError(ctx, streamId, SpdyStreamStatus.FLOW_CONTROL_ERROR, out);
                return;
            }
            this.updateSendWindowSize(streamId, deltaWindowSize, out);
        }
        out.add(msg);
    }

    public void exceptionCaught(ChannelHandlerContext ctx, Throwable cause) throws Exception {
        if (cause instanceof SpdyProtocolException) {
            this.issueSessionError(ctx, SpdySessionStatus.PROTOCOL_ERROR);
        }
        super.exceptionCaught(ctx, cause);
    }

    public void close(ChannelHandlerContext ctx, ChannelPromise promise) throws Exception {
        this.sendGoAwayFrame(ctx, promise);
    }

    public void write(ChannelHandlerContext ctx, MessageList<Object> msgs, ChannelPromise promise) throws Exception {
        Object msg;
        MessageList out = MessageList.newInstance();
        for (int i = 0; i < msgs.size() && (msg = msgs.get(i)) != null; ++i) {
            if (msg instanceof SpdyDataFrame || msg instanceof SpdySynStreamFrame || msg instanceof SpdySynReplyFrame || msg instanceof SpdyRstStreamFrame || msg instanceof SpdySettingsFrame || msg instanceof SpdyPingFrame || msg instanceof SpdyGoAwayFrame || msg instanceof SpdyHeadersFrame || msg instanceof SpdyWindowUpdateFrame) {
                try {
                    this.handleOutboundMessage(ctx, msg, (MessageList<Object>)out);
                    continue;
                }
                catch (SpdyProtocolException e) {
                    if (e != PROTOCOL_EXCEPTION) continue;
                    promise.setFailure((Throwable)PROTOCOL_EXCEPTION);
                    return;
                }
            }
            out.add(msg);
        }
        msgs.recycle();
        ctx.write(out, promise);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void handleOutboundMessage(ChannelHandlerContext ctx, Object msg, MessageList<Object> out) throws Exception {
        if (msg instanceof SpdyDataFrame) {
            SpdyDataFrame spdyDataFrame = (SpdyDataFrame)msg;
            int streamId = spdyDataFrame.getStreamId();
            if (this.spdySession.isLocalSideClosed(streamId)) {
                throw PROTOCOL_EXCEPTION;
            }
            if (this.flowControl) {
                Object object = this.flowControlLock;
                synchronized (object) {
                    int dataLength = spdyDataFrame.content().readableBytes();
                    int sendWindowSize = this.spdySession.getSendWindowSize(streamId);
                    if (sendWindowSize <= 0) {
                        this.spdySession.putPendingWrite(streamId, spdyDataFrame);
                        return;
                    }
                    if (sendWindowSize < dataLength) {
                        this.spdySession.updateSendWindowSize(streamId, -1 * sendWindowSize);
                        DefaultSpdyDataFrame partialDataFrame = new DefaultSpdyDataFrame(streamId, spdyDataFrame.content().readSlice(sendWindowSize).retain());
                        this.spdySession.putPendingWrite(streamId, spdyDataFrame);
                        ctx.write((Object)partialDataFrame);
                        return;
                    }
                    this.spdySession.updateSendWindowSize(streamId, -1 * dataLength);
                }
            }
            if (spdyDataFrame.isLast()) {
                this.halfCloseStream(streamId, false);
            }
        } else if (msg instanceof SpdySynStreamFrame) {
            boolean localSideClosed;
            boolean remoteSideClosed;
            SpdySynStreamFrame spdySynStreamFrame = (SpdySynStreamFrame)msg;
            int streamId = spdySynStreamFrame.getStreamId();
            if (this.isRemoteInitiatedID(streamId)) {
                throw PROTOCOL_EXCEPTION;
            }
            byte priority = spdySynStreamFrame.getPriority();
            if (!this.acceptStream(streamId, priority, remoteSideClosed = spdySynStreamFrame.isUnidirectional(), localSideClosed = spdySynStreamFrame.isLast())) {
                throw PROTOCOL_EXCEPTION;
            }
        } else if (msg instanceof SpdySynReplyFrame) {
            SpdySynReplyFrame spdySynReplyFrame = (SpdySynReplyFrame)msg;
            int streamId = spdySynReplyFrame.getStreamId();
            if (!this.isRemoteInitiatedID(streamId) || this.spdySession.isLocalSideClosed(streamId)) {
                throw PROTOCOL_EXCEPTION;
            }
            if (spdySynReplyFrame.isLast()) {
                this.halfCloseStream(streamId, false);
            }
        } else if (msg instanceof SpdyRstStreamFrame) {
            SpdyRstStreamFrame spdyRstStreamFrame = (SpdyRstStreamFrame)msg;
            this.removeStream(ctx, spdyRstStreamFrame.getStreamId());
        } else if (msg instanceof SpdySettingsFrame) {
            int newInitialWindowSize;
            SpdySettingsFrame spdySettingsFrame = (SpdySettingsFrame)msg;
            int newConcurrentStreams = spdySettingsFrame.getValue(4);
            if (newConcurrentStreams >= 0) {
                this.updateConcurrentStreams(newConcurrentStreams, false);
            }
            if (spdySettingsFrame.isPersisted(7)) {
                spdySettingsFrame.removeValue(7);
            }
            spdySettingsFrame.setPersistValue(7, false);
            if (this.flowControl && (newInitialWindowSize = spdySettingsFrame.getValue(7)) >= 0) {
                this.updateInitialReceiveWindowSize(newInitialWindowSize);
            }
        } else if (msg instanceof SpdyPingFrame) {
            SpdyPingFrame spdyPingFrame = (SpdyPingFrame)msg;
            if (this.isRemoteInitiatedID(spdyPingFrame.getId())) {
                ctx.fireExceptionCaught((Throwable)new IllegalArgumentException("invalid PING ID: " + spdyPingFrame.getId()));
                return;
            }
            this.pings.getAndIncrement();
        } else {
            if (msg instanceof SpdyGoAwayFrame) {
                throw PROTOCOL_EXCEPTION;
            }
            if (msg instanceof SpdyHeadersFrame) {
                SpdyHeadersFrame spdyHeadersFrame = (SpdyHeadersFrame)msg;
                int streamId = spdyHeadersFrame.getStreamId();
                if (this.spdySession.isLocalSideClosed(streamId)) {
                    throw PROTOCOL_EXCEPTION;
                }
                if (spdyHeadersFrame.isLast()) {
                    this.halfCloseStream(streamId, false);
                }
            } else if (msg instanceof SpdyWindowUpdateFrame) {
                throw PROTOCOL_EXCEPTION;
            }
        }
        out.add(msg);
    }

    private void issueSessionError(ChannelHandlerContext ctx, SpdySessionStatus status) {
        this.sendGoAwayFrame(ctx, status).addListener((GenericFutureListener)ChannelFutureListener.CLOSE);
    }

    private void issueStreamError(ChannelHandlerContext ctx, int streamId, SpdyStreamStatus status, MessageList<Object> in) {
        boolean fireMessageReceived = !this.spdySession.isRemoteSideClosed(streamId);
        this.removeStream(ctx, streamId);
        DefaultSpdyRstStreamFrame spdyRstStreamFrame = new DefaultSpdyRstStreamFrame(streamId, status);
        ctx.write((Object)spdyRstStreamFrame);
        if (fireMessageReceived) {
            in.add((Object)spdyRstStreamFrame);
            ctx.fireMessageReceived(in.copy());
            in.clear();
        }
    }

    private boolean isRemoteInitiatedID(int id) {
        boolean serverId = SpdyCodecUtil.isServerId(id);
        return this.server && !serverId || !this.server && serverId;
    }

    private void updateConcurrentStreams(int newConcurrentStreams, boolean remote) {
        if (remote) {
            this.remoteConcurrentStreams = newConcurrentStreams;
        } else {
            this.localConcurrentStreams = newConcurrentStreams;
        }
        if (this.localConcurrentStreams == this.remoteConcurrentStreams) {
            this.maxConcurrentStreams = this.localConcurrentStreams;
            return;
        }
        if (this.localConcurrentStreams == 0) {
            this.maxConcurrentStreams = this.remoteConcurrentStreams;
            return;
        }
        if (this.remoteConcurrentStreams == 0) {
            this.maxConcurrentStreams = this.localConcurrentStreams;
            return;
        }
        this.maxConcurrentStreams = this.localConcurrentStreams > this.remoteConcurrentStreams ? this.remoteConcurrentStreams : this.localConcurrentStreams;
    }

    private synchronized void updateInitialSendWindowSize(int newInitialWindowSize) {
        int deltaWindowSize = newInitialWindowSize - this.initialSendWindowSize;
        this.initialSendWindowSize = newInitialWindowSize;
        for (Integer streamId : this.spdySession.getActiveStreams()) {
            this.spdySession.updateSendWindowSize(streamId, deltaWindowSize);
        }
    }

    private synchronized void updateInitialReceiveWindowSize(int newInitialWindowSize) {
        int deltaWindowSize = newInitialWindowSize - this.initialReceiveWindowSize;
        this.initialReceiveWindowSize = newInitialWindowSize;
        this.spdySession.updateAllReceiveWindowSizes(deltaWindowSize);
    }

    private synchronized boolean acceptStream(int streamId, byte priority, boolean remoteSideClosed, boolean localSideClosed) {
        if (this.receivedGoAwayFrame || this.sentGoAwayFrame) {
            return false;
        }
        int maxConcurrentStreams = this.maxConcurrentStreams;
        if (maxConcurrentStreams != 0 && this.spdySession.numActiveStreams() >= maxConcurrentStreams) {
            return false;
        }
        this.spdySession.acceptStream(streamId, priority, remoteSideClosed, localSideClosed, this.initialSendWindowSize, this.initialReceiveWindowSize);
        if (this.isRemoteInitiatedID(streamId)) {
            this.lastGoodStreamId = streamId;
        }
        return true;
    }

    private void halfCloseStream(int streamId, boolean remote) {
        if (remote) {
            this.spdySession.closeRemoteSide(streamId);
        } else {
            this.spdySession.closeLocalSide(streamId);
        }
        if (this.closeSessionFuture != null && this.spdySession.noActiveStreams()) {
            this.closeSessionFuture.trySuccess();
        }
    }

    private void removeStream(ChannelHandlerContext ctx, int streamId) {
        if (this.spdySession.removeStream(streamId)) {
            ctx.fireExceptionCaught((Throwable)STREAM_CLOSED);
        }
        if (this.closeSessionFuture != null && this.spdySession.noActiveStreams()) {
            this.closeSessionFuture.trySuccess();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void updateSendWindowSize(int streamId, int deltaWindowSize, MessageList<Object> out) {
        Object object = this.flowControlLock;
        synchronized (object) {
            SpdyDataFrame spdyDataFrame;
            int newWindowSize = this.spdySession.updateSendWindowSize(streamId, deltaWindowSize);
            while (newWindowSize > 0 && (spdyDataFrame = (SpdyDataFrame)this.spdySession.getPendingWrite(streamId)) != null) {
                int dataFrameSize = spdyDataFrame.content().readableBytes();
                if (newWindowSize >= dataFrameSize) {
                    this.spdySession.removePendingWrite(streamId);
                    newWindowSize = this.spdySession.updateSendWindowSize(streamId, -1 * dataFrameSize);
                    if (spdyDataFrame.isLast()) {
                        this.halfCloseStream(streamId, false);
                    }
                    out.add((Object)spdyDataFrame);
                    continue;
                }
                this.spdySession.updateSendWindowSize(streamId, -1 * newWindowSize);
                DefaultSpdyDataFrame partialDataFrame = new DefaultSpdyDataFrame(streamId, spdyDataFrame.content().readSlice(newWindowSize).retain());
                out.add((Object)partialDataFrame);
                newWindowSize = 0;
            }
        }
    }

    private void sendGoAwayFrame(ChannelHandlerContext ctx, ChannelPromise future) {
        if (!ctx.channel().isActive()) {
            ctx.close(future);
            return;
        }
        ChannelFuture f = this.sendGoAwayFrame(ctx, SpdySessionStatus.OK);
        if (this.spdySession.noActiveStreams()) {
            f.addListener((GenericFutureListener)new ClosingChannelFutureListener(ctx, future));
        } else {
            this.closeSessionFuture = ctx.newPromise();
            this.closeSessionFuture.addListener((GenericFutureListener)new ClosingChannelFutureListener(ctx, future));
        }
    }

    private synchronized ChannelFuture sendGoAwayFrame(ChannelHandlerContext ctx, SpdySessionStatus status) {
        if (!this.sentGoAwayFrame) {
            this.sentGoAwayFrame = true;
            DefaultSpdyGoAwayFrame spdyGoAwayFrame = new DefaultSpdyGoAwayFrame(this.lastGoodStreamId, status);
            return ctx.write((Object)spdyGoAwayFrame);
        }
        return ctx.newSucceededFuture();
    }

    static {
        PROTOCOL_EXCEPTION.setStackTrace(EmptyArrays.EMPTY_STACK_TRACE);
        STREAM_CLOSED.setStackTrace(EmptyArrays.EMPTY_STACK_TRACE);
    }

    private static final class ClosingChannelFutureListener
    implements ChannelFutureListener {
        private final ChannelHandlerContext ctx;
        private final ChannelPromise promise;

        ClosingChannelFutureListener(ChannelHandlerContext ctx, ChannelPromise promise) {
            this.ctx = ctx;
            this.promise = promise;
        }

        public void operationComplete(ChannelFuture sentGoAwayFuture) throws Exception {
            this.ctx.close(this.promise);
        }
    }
}

