/*
 * Decompiled with CFR 0.152.
 */
package io.netty.handler.codec.http;

import io.netty.buffer.ByteBuf;
import io.netty.buffer.Unpooled;
import io.netty.channel.ChannelHandlerContext;
import io.netty.handler.codec.MessageToByteEncoder;
import io.netty.handler.codec.UnsupportedMessageTypeException;
import io.netty.handler.codec.http.HttpChunk;
import io.netty.handler.codec.http.HttpChunkTrailer;
import io.netty.handler.codec.http.HttpMessage;
import io.netty.handler.codec.http.HttpObject;
import io.netty.handler.codec.http.HttpTransferEncoding;
import io.netty.util.CharsetUtil;
import java.nio.charset.Charset;
import java.util.Map;

public abstract class HttpMessageEncoder
extends MessageToByteEncoder<Object> {
    private static final ByteBuf LAST_CHUNK = Unpooled.copiedBuffer((CharSequence)"0\r\n\r\n", (Charset)CharsetUtil.US_ASCII);
    private HttpTransferEncoding lastTE;

    protected HttpMessageEncoder() {
        super(new Class[]{HttpObject.class});
    }

    public void encode(ChannelHandlerContext ctx, Object msg, ByteBuf out) throws Exception {
        if (msg instanceof HttpMessage) {
            HttpTransferEncoding te;
            HttpMessage m = (HttpMessage)msg;
            this.lastTE = te = m.getTransferEncoding();
            m.setTransferEncoding(te);
            out.markWriterIndex();
            this.encodeInitialLine(out, m);
            HttpMessageEncoder.encodeHeaders(out, m);
            out.writeByte(13);
            out.writeByte(10);
            ByteBuf content = m.getContent();
            out.writeBytes(content, content.readerIndex(), content.readableBytes());
        } else if (msg instanceof HttpChunk) {
            HttpChunk chunk = (HttpChunk)msg;
            HttpTransferEncoding te = this.lastTE;
            if (te == null) {
                throw new IllegalArgumentException("HttpChunk must follow an HttpMessage.");
            }
            switch (te) {
                case SINGLE: {
                    throw new IllegalArgumentException("The transfer encoding of the last encoded HttpMessage is SINGLE.");
                }
                case STREAMED: {
                    ByteBuf content = chunk.getContent();
                    out.writeBytes(content, content.readerIndex(), content.readableBytes());
                    break;
                }
                case CHUNKED: {
                    if (chunk.isLast()) {
                        if (chunk instanceof HttpChunkTrailer) {
                            out.writeByte(48);
                            out.writeByte(13);
                            out.writeByte(10);
                            HttpMessageEncoder.encodeTrailingHeaders(out, (HttpChunkTrailer)chunk);
                            out.writeByte(13);
                            out.writeByte(10);
                            break;
                        }
                        out.writeBytes(LAST_CHUNK, LAST_CHUNK.readerIndex(), LAST_CHUNK.readableBytes());
                        break;
                    }
                    ByteBuf content = chunk.getContent();
                    int contentLength = content.readableBytes();
                    out.writeBytes(Unpooled.copiedBuffer((CharSequence)Integer.toHexString(contentLength), (Charset)CharsetUtil.US_ASCII));
                    out.writeByte(13);
                    out.writeByte(10);
                    out.writeBytes(content, content.readerIndex(), contentLength);
                    out.writeByte(13);
                    out.writeByte(10);
                }
            }
        } else {
            throw new UnsupportedMessageTypeException(msg, new Class[]{HttpMessage.class, HttpChunk.class});
        }
    }

    private static void encodeHeaders(ByteBuf buf, HttpMessage message) {
        for (Map.Entry<String, String> h : message.getHeaders()) {
            HttpMessageEncoder.encodeHeader(buf, h.getKey(), h.getValue());
        }
    }

    private static void encodeTrailingHeaders(ByteBuf buf, HttpChunkTrailer trailer) {
        for (Map.Entry<String, String> h : trailer.getHeaders()) {
            HttpMessageEncoder.encodeHeader(buf, h.getKey(), h.getValue());
        }
    }

    private static void encodeHeader(ByteBuf buf, String header, String value) {
        buf.writeBytes(header.getBytes(CharsetUtil.US_ASCII));
        buf.writeByte(58);
        buf.writeByte(32);
        buf.writeBytes(value.getBytes(CharsetUtil.US_ASCII));
        buf.writeByte(13);
        buf.writeByte(10);
    }

    protected abstract void encodeInitialLine(ByteBuf var1, HttpMessage var2) throws Exception;
}

