/*
 * Decompiled with CFR 0.152.
 */
package io.netty.handler.codec.spdy;

import io.netty.buffer.ByteBuf;
import io.netty.buffer.Unpooled;
import io.netty.channel.ChannelHandlerContext;
import io.netty.handler.codec.MessageToMessageDecoder;
import io.netty.handler.codec.TooLongFrameException;
import io.netty.handler.codec.http.DefaultHttpRequest;
import io.netty.handler.codec.http.DefaultHttpResponse;
import io.netty.handler.codec.http.HttpHeaders;
import io.netty.handler.codec.http.HttpMessage;
import io.netty.handler.codec.http.HttpMethod;
import io.netty.handler.codec.http.HttpRequest;
import io.netty.handler.codec.http.HttpResponse;
import io.netty.handler.codec.http.HttpResponseStatus;
import io.netty.handler.codec.http.HttpVersion;
import io.netty.handler.codec.spdy.DefaultSpdyRstStreamFrame;
import io.netty.handler.codec.spdy.DefaultSpdySynReplyFrame;
import io.netty.handler.codec.spdy.SpdyCodecUtil;
import io.netty.handler.codec.spdy.SpdyDataFrame;
import io.netty.handler.codec.spdy.SpdyHeaderBlock;
import io.netty.handler.codec.spdy.SpdyHeaders;
import io.netty.handler.codec.spdy.SpdyHeadersFrame;
import io.netty.handler.codec.spdy.SpdyHttpHeaders;
import io.netty.handler.codec.spdy.SpdyRstStreamFrame;
import io.netty.handler.codec.spdy.SpdyStreamStatus;
import io.netty.handler.codec.spdy.SpdySynReplyFrame;
import io.netty.handler.codec.spdy.SpdySynStreamFrame;
import java.util.HashMap;
import java.util.Map;

public class SpdyHttpDecoder
extends MessageToMessageDecoder<Object, HttpMessage> {
    private final int spdyVersion;
    private final int maxContentLength;
    private final Map<Integer, HttpMessage> messageMap = new HashMap<Integer, HttpMessage>();

    public SpdyHttpDecoder(int version, int maxContentLength) {
        if (version < 2 || version > 3) {
            throw new IllegalArgumentException("unsupported version: " + version);
        }
        if (maxContentLength <= 0) {
            throw new IllegalArgumentException("maxContentLength must be a positive integer: " + maxContentLength);
        }
        this.spdyVersion = version;
        this.maxContentLength = maxContentLength;
    }

    public HttpMessage decode(ChannelHandlerContext ctx, Object msg) throws Exception {
        if (msg instanceof SpdySynStreamFrame) {
            SpdySynStreamFrame spdySynStreamFrame = (SpdySynStreamFrame)msg;
            int streamID = spdySynStreamFrame.getStreamId();
            if (SpdyCodecUtil.isServerId(streamID)) {
                String URL2;
                int associatedToStreamId = spdySynStreamFrame.getAssociatedToStreamId();
                if (associatedToStreamId == 0) {
                    DefaultSpdyRstStreamFrame spdyRstStreamFrame = new DefaultSpdyRstStreamFrame(streamID, SpdyStreamStatus.INVALID_STREAM);
                    ctx.write((Object)spdyRstStreamFrame);
                }
                if ((URL2 = SpdyHeaders.getUrl(this.spdyVersion, spdySynStreamFrame)) == null) {
                    DefaultSpdyRstStreamFrame spdyRstStreamFrame = new DefaultSpdyRstStreamFrame(streamID, SpdyStreamStatus.PROTOCOL_ERROR);
                    ctx.write((Object)spdyRstStreamFrame);
                }
                try {
                    HttpResponse httpResponse = SpdyHttpDecoder.createHttpResponse(this.spdyVersion, spdySynStreamFrame);
                    SpdyHttpHeaders.setStreamId(httpResponse, streamID);
                    SpdyHttpHeaders.setAssociatedToStreamId(httpResponse, associatedToStreamId);
                    SpdyHttpHeaders.setPriority(httpResponse, spdySynStreamFrame.getPriority());
                    SpdyHttpHeaders.setUrl(httpResponse, URL2);
                    if (spdySynStreamFrame.isLast()) {
                        HttpHeaders.setContentLength(httpResponse, 0L);
                        return httpResponse;
                    }
                    this.messageMap.put(new Integer(streamID), httpResponse);
                }
                catch (Exception e) {
                    DefaultSpdyRstStreamFrame spdyRstStreamFrame = new DefaultSpdyRstStreamFrame(streamID, SpdyStreamStatus.PROTOCOL_ERROR);
                    ctx.write((Object)spdyRstStreamFrame);
                }
            } else {
                try {
                    HttpRequest httpRequest = SpdyHttpDecoder.createHttpRequest(this.spdyVersion, spdySynStreamFrame);
                    SpdyHttpHeaders.setStreamId(httpRequest, streamID);
                    if (spdySynStreamFrame.isLast()) {
                        return httpRequest;
                    }
                    this.messageMap.put(new Integer(streamID), httpRequest);
                }
                catch (Exception e) {
                    DefaultSpdySynReplyFrame spdySynReplyFrame = new DefaultSpdySynReplyFrame(streamID);
                    spdySynReplyFrame.setLast(true);
                    SpdyHeaders.setStatus(this.spdyVersion, spdySynReplyFrame, HttpResponseStatus.BAD_REQUEST);
                    SpdyHeaders.setVersion(this.spdyVersion, spdySynReplyFrame, HttpVersion.HTTP_1_0);
                    ctx.write((Object)spdySynReplyFrame);
                }
            }
        } else if (msg instanceof SpdySynReplyFrame) {
            SpdySynReplyFrame spdySynReplyFrame = (SpdySynReplyFrame)msg;
            int streamID = spdySynReplyFrame.getStreamId();
            try {
                HttpResponse httpResponse = SpdyHttpDecoder.createHttpResponse(this.spdyVersion, spdySynReplyFrame);
                SpdyHttpHeaders.setStreamId(httpResponse, streamID);
                if (spdySynReplyFrame.isLast()) {
                    HttpHeaders.setContentLength(httpResponse, 0L);
                    return httpResponse;
                }
                this.messageMap.put(new Integer(streamID), httpResponse);
            }
            catch (Exception e) {
                DefaultSpdyRstStreamFrame spdyRstStreamFrame = new DefaultSpdyRstStreamFrame(streamID, SpdyStreamStatus.PROTOCOL_ERROR);
                ctx.write((Object)spdyRstStreamFrame);
            }
        } else if (msg instanceof SpdyHeadersFrame) {
            SpdyHeadersFrame spdyHeadersFrame = (SpdyHeadersFrame)msg;
            Integer streamID = new Integer(spdyHeadersFrame.getStreamId());
            HttpMessage httpMessage = this.messageMap.get(streamID);
            if (httpMessage == null) {
                return null;
            }
            for (Map.Entry<String, String> e : spdyHeadersFrame.getHeaders()) {
                httpMessage.addHeader(e.getKey(), e.getValue());
            }
        } else if (msg instanceof SpdyDataFrame) {
            SpdyDataFrame spdyDataFrame = (SpdyDataFrame)msg;
            Integer streamID = new Integer(spdyDataFrame.getStreamId());
            HttpMessage httpMessage = this.messageMap.get(streamID);
            if (httpMessage == null) {
                return null;
            }
            ByteBuf content = httpMessage.getContent();
            if (content.readableBytes() > this.maxContentLength - spdyDataFrame.getData().readableBytes()) {
                this.messageMap.remove(streamID);
                throw new TooLongFrameException("HTTP content length exceeded " + this.maxContentLength + " bytes.");
            }
            ByteBuf spdyDataFrameData = spdyDataFrame.getData();
            int spdyDataFrameDataLen = spdyDataFrameData.readableBytes();
            if (content == Unpooled.EMPTY_BUFFER) {
                content = Unpooled.buffer((int)spdyDataFrameDataLen);
                content.writeBytes(spdyDataFrameData, spdyDataFrameData.readerIndex(), spdyDataFrameDataLen);
                httpMessage.setContent(content);
            } else {
                content.writeBytes(spdyDataFrameData, spdyDataFrameData.readerIndex(), spdyDataFrameDataLen);
            }
            if (spdyDataFrame.isLast()) {
                HttpHeaders.setContentLength(httpMessage, content.readableBytes());
                this.messageMap.remove(streamID);
                return httpMessage;
            }
        } else if (msg instanceof SpdyRstStreamFrame) {
            SpdyRstStreamFrame spdyRstStreamFrame = (SpdyRstStreamFrame)msg;
            Integer streamID = new Integer(spdyRstStreamFrame.getStreamId());
            this.messageMap.remove(streamID);
        }
        return null;
    }

    private static HttpRequest createHttpRequest(int spdyVersion, SpdyHeaderBlock requestFrame) throws Exception {
        HttpMethod method = SpdyHeaders.getMethod(spdyVersion, requestFrame);
        String url = SpdyHeaders.getUrl(spdyVersion, requestFrame);
        HttpVersion httpVersion = SpdyHeaders.getVersion(spdyVersion, requestFrame);
        SpdyHeaders.removeMethod(spdyVersion, requestFrame);
        SpdyHeaders.removeUrl(spdyVersion, requestFrame);
        SpdyHeaders.removeVersion(spdyVersion, requestFrame);
        DefaultHttpRequest httpRequest = new DefaultHttpRequest(httpVersion, method, url);
        SpdyHeaders.removeScheme(spdyVersion, requestFrame);
        if (spdyVersion >= 3) {
            String host = SpdyHeaders.getHost(requestFrame);
            SpdyHeaders.removeHost(requestFrame);
            HttpHeaders.setHost(httpRequest, host);
        }
        for (Map.Entry<String, String> e : requestFrame.getHeaders()) {
            httpRequest.addHeader(e.getKey(), e.getValue());
        }
        HttpHeaders.setKeepAlive(httpRequest, true);
        httpRequest.removeHeader("Transfer-Encoding");
        return httpRequest;
    }

    private static HttpResponse createHttpResponse(int spdyVersion, SpdyHeaderBlock responseFrame) throws Exception {
        HttpResponseStatus status = SpdyHeaders.getStatus(spdyVersion, responseFrame);
        HttpVersion version = SpdyHeaders.getVersion(spdyVersion, responseFrame);
        SpdyHeaders.removeStatus(spdyVersion, responseFrame);
        SpdyHeaders.removeVersion(spdyVersion, responseFrame);
        DefaultHttpResponse httpResponse = new DefaultHttpResponse(version, status);
        for (Map.Entry<String, String> e : responseFrame.getHeaders()) {
            httpResponse.addHeader(e.getKey(), e.getValue());
        }
        HttpHeaders.setKeepAlive(httpResponse, true);
        httpResponse.removeHeader("Transfer-Encoding");
        httpResponse.removeHeader("Trailer");
        return httpResponse;
    }
}

