/*
 * Copyright 2012 The Netty Project
 *
 * The Netty Project licenses this file to you under the Apache License,
 * version 2.0 (the "License"); you may not use this file except in compliance
 * with the License. You may obtain a copy of the License at:
 *
 *   http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied. See the
 * License for the specific language governing permissions and limitations
 * under the License.
 */
package io.netty.handler.codec.spdy;

/**
 * An {@link Exception} which is thrown when the received frame cannot
 * be decoded by the {@link SpdyFrameDecoder}.
 * @apiviz.exclude
 */
public class SpdyProtocolException extends Exception {

    private static final long serialVersionUID = 7870000537743847264L;

    /**
     * Creates a new instance.
     */
    public SpdyProtocolException() { }

    /**
     * Creates a new instance.
     */
    public SpdyProtocolException(String message, Throwable cause) {
        super(message, cause);
    }

    /**
     * Creates a new instance.
     */
    public SpdyProtocolException(String message) {
        super(message);
    }

    /**
     * Creates a new instance.
     */
    public SpdyProtocolException(Throwable cause) {
        super(cause);
    }
}
