/*
 * Decompiled with CFR 0.152.
 */
package io.netty.handler.codec.http.websocketx;

import io.netty.channel.Channel;
import io.netty.channel.ChannelFuture;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelInboundByteHandler;
import io.netty.handler.codec.http.DefaultHttpRequest;
import io.netty.handler.codec.http.HttpMethod;
import io.netty.handler.codec.http.HttpRequestEncoder;
import io.netty.handler.codec.http.HttpResponse;
import io.netty.handler.codec.http.HttpResponseDecoder;
import io.netty.handler.codec.http.HttpResponseStatus;
import io.netty.handler.codec.http.HttpVersion;
import io.netty.handler.codec.http.websocketx.WebSocket13FrameDecoder;
import io.netty.handler.codec.http.websocketx.WebSocket13FrameEncoder;
import io.netty.handler.codec.http.websocketx.WebSocketClientHandshaker;
import io.netty.handler.codec.http.websocketx.WebSocketHandshakeException;
import io.netty.handler.codec.http.websocketx.WebSocketUtil;
import io.netty.handler.codec.http.websocketx.WebSocketVersion;
import io.netty.logging.InternalLogger;
import io.netty.logging.InternalLoggerFactory;
import io.netty.util.CharsetUtil;
import java.net.URI;
import java.util.Map;

public class WebSocketClientHandshaker13
extends WebSocketClientHandshaker {
    private static final InternalLogger logger = InternalLoggerFactory.getInstance(WebSocketClientHandshaker13.class);
    public static final String MAGIC_GUID = "258EAFA5-E914-47DA-95CA-C5AB0DC85B11";
    private String expectedChallengeResponseString;
    private final boolean allowExtensions;

    public WebSocketClientHandshaker13(URI webSocketURL, WebSocketVersion version, String subprotocol, boolean allowExtensions, Map<String, String> customHeaders, int maxFramePayloadLength) {
        super(webSocketURL, version, subprotocol, customHeaders, maxFramePayloadLength);
        this.allowExtensions = allowExtensions;
    }

    @Override
    public ChannelFuture handshake(Channel channel) {
        URI wsURL = this.getWebSocketUrl();
        String path = wsURL.getPath();
        if (wsURL.getQuery() != null && wsURL.getQuery().length() > 0) {
            path = wsURL.getPath() + "?" + wsURL.getQuery();
        }
        byte[] nonce = WebSocketUtil.randomBytes(16);
        String key = WebSocketUtil.base64(nonce);
        String acceptSeed = key + MAGIC_GUID;
        byte[] sha1 = WebSocketUtil.sha1(acceptSeed.getBytes(CharsetUtil.US_ASCII));
        this.expectedChallengeResponseString = WebSocketUtil.base64(sha1);
        if (logger.isDebugEnabled()) {
            logger.debug(String.format("WS Version 13 Client Handshake key: %s. Expected response: %s.", key, this.expectedChallengeResponseString));
        }
        DefaultHttpRequest request = new DefaultHttpRequest(HttpVersion.HTTP_1_1, HttpMethod.GET, path);
        request.addHeader("Upgrade", "WebSocket".toLowerCase());
        request.addHeader("Connection", "Upgrade");
        request.addHeader("Sec-WebSocket-Key", key);
        request.addHeader("Host", wsURL.getHost());
        int wsPort = wsURL.getPort();
        String originValue = "http://" + wsURL.getHost();
        if (wsPort != 80 && wsPort != 443) {
            originValue = originValue + ":" + wsPort;
        }
        request.addHeader("Sec-WebSocket-Origin", originValue);
        String expectedSubprotocol = this.getExpectedSubprotocol();
        if (expectedSubprotocol != null && !expectedSubprotocol.equals("")) {
            request.addHeader("Sec-WebSocket-Protocol", expectedSubprotocol);
        }
        request.addHeader("Sec-WebSocket-Version", "13");
        if (this.customHeaders != null) {
            for (String header : this.customHeaders.keySet()) {
                request.addHeader(header, this.customHeaders.get(header));
            }
        }
        ChannelFuture future = channel.write((Object)request);
        channel.pipeline().replace(HttpRequestEncoder.class, "ws-encoder", (ChannelHandler)new WebSocket13FrameEncoder(true));
        return future;
    }

    @Override
    public void finishHandshake(Channel channel, HttpResponse response) throws WebSocketHandshakeException {
        HttpResponseStatus status = HttpResponseStatus.SWITCHING_PROTOCOLS;
        if (!response.getStatus().equals(status)) {
            throw new WebSocketHandshakeException("Invalid handshake response status: " + response.getStatus());
        }
        String upgrade = response.getHeader("Upgrade");
        if (upgrade == null || !upgrade.equalsIgnoreCase("WebSocket")) {
            throw new WebSocketHandshakeException("Invalid handshake response upgrade: " + response.getHeader("Upgrade"));
        }
        String connection = response.getHeader("Connection");
        if (connection == null || !connection.equalsIgnoreCase("Upgrade")) {
            throw new WebSocketHandshakeException("Invalid handshake response connection: " + response.getHeader("Connection"));
        }
        String accept = response.getHeader("Sec-WebSocket-Accept");
        if (accept == null || !accept.equals(this.expectedChallengeResponseString)) {
            throw new WebSocketHandshakeException(String.format("Invalid challenge. Actual: %s. Expected: %s", accept, this.expectedChallengeResponseString));
        }
        String subprotocol = response.getHeader("Sec-WebSocket-Protocol");
        this.setActualSubprotocol(subprotocol);
        this.setHandshakeComplete();
        ((HttpResponseDecoder)channel.pipeline().get(HttpResponseDecoder.class)).replace("ws-decoder", (ChannelInboundByteHandler)new WebSocket13FrameDecoder(false, this.allowExtensions, this.getMaxFramePayloadLength()));
    }
}

