/*
 * Decompiled with CFR 0.152.
 */
package io.netty.handler.codec.http;

import io.netty.buffer.ByteBuf;
import io.netty.buffer.Unpooled;
import io.netty.channel.ChannelHandlerContext;
import io.netty.handler.codec.MessageToByteEncoder;
import io.netty.handler.codec.UnsupportedMessageTypeException;
import io.netty.handler.codec.http.HttpChunk;
import io.netty.handler.codec.http.HttpChunkTrailer;
import io.netty.handler.codec.http.HttpCodecUtil;
import io.netty.handler.codec.http.HttpMessage;
import io.netty.util.CharsetUtil;
import java.io.UnsupportedEncodingException;
import java.nio.charset.Charset;
import java.util.Map;

public abstract class HttpMessageEncoder
extends MessageToByteEncoder<Object> {
    private static final ByteBuf LAST_CHUNK = Unpooled.copiedBuffer((CharSequence)"0\r\n\r\n", (Charset)CharsetUtil.US_ASCII);
    private volatile boolean chunked;

    protected HttpMessageEncoder() {
    }

    public boolean isEncodable(Object msg) throws Exception {
        return msg instanceof HttpMessage || msg instanceof HttpChunk;
    }

    public void encode(ChannelHandlerContext ctx, Object msg, ByteBuf out) throws Exception {
        if (msg instanceof HttpMessage) {
            boolean chunked;
            HttpMessage m = (HttpMessage)msg;
            if (m.isChunked()) {
                if (!HttpCodecUtil.isTransferEncodingChunked(m)) {
                    m.addHeader("Transfer-Encoding", "chunked");
                }
                this.chunked = true;
                chunked = true;
            } else {
                chunked = this.chunked = HttpCodecUtil.isTransferEncodingChunked(m);
            }
            out.markWriterIndex();
            this.encodeInitialLine(out, m);
            HttpMessageEncoder.encodeHeaders(out, m);
            out.writeByte(13);
            out.writeByte(10);
            ByteBuf content = m.getContent();
            if (content.readable()) {
                if (chunked) {
                    out.resetWriterIndex();
                    throw new IllegalArgumentException("HttpMessage.content must be empty if Transfer-Encoding is chunked.");
                }
                out.writeBytes(content, content.readerIndex(), content.readableBytes());
            }
        } else if (msg instanceof HttpChunk) {
            HttpChunk chunk = (HttpChunk)msg;
            if (this.chunked) {
                if (chunk.isLast()) {
                    this.chunked = false;
                    if (chunk instanceof HttpChunkTrailer) {
                        out.writeByte(48);
                        out.writeByte(13);
                        out.writeByte(10);
                        HttpMessageEncoder.encodeTrailingHeaders(out, (HttpChunkTrailer)chunk);
                        out.writeByte(13);
                        out.writeByte(10);
                    } else {
                        out.writeBytes(LAST_CHUNK, LAST_CHUNK.readerIndex(), LAST_CHUNK.readableBytes());
                    }
                } else {
                    ByteBuf content = chunk.getContent();
                    int contentLength = content.readableBytes();
                    out.writeBytes(Unpooled.copiedBuffer((CharSequence)Integer.toHexString(contentLength), (Charset)CharsetUtil.US_ASCII));
                    out.writeByte(13);
                    out.writeByte(10);
                    out.writeBytes(content, content.readerIndex(), contentLength);
                    out.writeByte(13);
                    out.writeByte(10);
                }
            } else if (!chunk.isLast()) {
                ByteBuf chunkContent = chunk.getContent();
                out.writeBytes(chunkContent, chunkContent.readerIndex(), chunkContent.readableBytes());
            }
        } else {
            throw new UnsupportedMessageTypeException(msg, new Class[]{HttpMessage.class, HttpChunk.class});
        }
    }

    private static void encodeHeaders(ByteBuf buf, HttpMessage message) {
        try {
            for (Map.Entry<String, String> h : message.getHeaders()) {
                HttpMessageEncoder.encodeHeader(buf, h.getKey(), h.getValue());
            }
        }
        catch (UnsupportedEncodingException e) {
            throw (Error)new Error().initCause(e);
        }
    }

    private static void encodeTrailingHeaders(ByteBuf buf, HttpChunkTrailer trailer) {
        try {
            for (Map.Entry<String, String> h : trailer.getHeaders()) {
                HttpMessageEncoder.encodeHeader(buf, h.getKey(), h.getValue());
            }
        }
        catch (UnsupportedEncodingException e) {
            throw (Error)new Error().initCause(e);
        }
    }

    private static void encodeHeader(ByteBuf buf, String header, String value) throws UnsupportedEncodingException {
        buf.writeBytes(header.getBytes("ASCII"));
        buf.writeByte(58);
        buf.writeByte(32);
        buf.writeBytes(value.getBytes("ASCII"));
        buf.writeByte(13);
        buf.writeByte(10);
    }

    protected abstract void encodeInitialLine(ByteBuf var1, HttpMessage var2) throws Exception;
}

