/*
 * Decompiled with CFR 0.152.
 */
package io.netty.handler.codec.http;

import io.netty.buffer.ByteBuf;
import io.netty.buffer.CompositeByteBuf;
import io.netty.buffer.Unpooled;
import io.netty.channel.ChannelHandlerContext;
import io.netty.handler.codec.MessageToMessageDecoder;
import io.netty.handler.codec.TooLongFrameException;
import io.netty.handler.codec.http.HttpChunk;
import io.netty.handler.codec.http.HttpChunkTrailer;
import io.netty.handler.codec.http.HttpHeaders;
import io.netty.handler.codec.http.HttpMessage;
import io.netty.util.CharsetUtil;
import java.nio.charset.Charset;
import java.util.List;
import java.util.Map;

public class HttpChunkAggregator
extends MessageToMessageDecoder<Object, HttpMessage> {
    public static final int DEFAULT_MAX_COMPOSITEBUFFER_COMPONENTS = 1024;
    private static final ByteBuf CONTINUE = Unpooled.copiedBuffer((CharSequence)"HTTP/1.1 100 Continue\r\n\r\n", (Charset)CharsetUtil.US_ASCII);
    private final int maxContentLength;
    private HttpMessage currentMessage;
    private int maxCumulationBufferComponents = 1024;
    private ChannelHandlerContext ctx;

    public HttpChunkAggregator(int maxContentLength) {
        if (maxContentLength <= 0) {
            throw new IllegalArgumentException("maxContentLength must be a positive integer: " + maxContentLength);
        }
        this.maxContentLength = maxContentLength;
    }

    public final int getMaxCumulationBufferComponents() {
        return this.maxCumulationBufferComponents;
    }

    public final void setMaxCumulationBufferComponents(int maxCumulationBufferComponents) {
        if (maxCumulationBufferComponents < 2) {
            throw new IllegalArgumentException("maxCumulationBufferComponents: " + maxCumulationBufferComponents + " (expected: >= 2)");
        }
        if (this.ctx != null) {
            throw new IllegalStateException("decoder properties cannot be changed once the decoder is added to a pipeline.");
        }
        this.maxCumulationBufferComponents = maxCumulationBufferComponents;
    }

    public boolean isDecodable(Object msg) throws Exception {
        return msg instanceof HttpMessage || msg instanceof HttpChunk;
    }

    public HttpMessage decode(ChannelHandlerContext ctx, Object msg) throws Exception {
        HttpMessage currentMessage = this.currentMessage;
        if (msg instanceof HttpMessage) {
            HttpMessage m = (HttpMessage)msg;
            if (HttpHeaders.is100ContinueExpected(m)) {
                ctx.write((Object)CONTINUE.duplicate());
            }
            if (m.isChunked()) {
                List<String> encodings = m.getHeaders("Transfer-Encoding");
                encodings.remove("chunked");
                if (encodings.isEmpty()) {
                    m.removeHeader("Transfer-Encoding");
                }
                m.setChunked(false);
                m.setContent(Unpooled.dynamicBuffer());
                this.currentMessage = m;
                return null;
            }
            this.currentMessage = null;
            return m;
        }
        if (msg instanceof HttpChunk) {
            if (currentMessage == null) {
                throw new IllegalStateException("received " + HttpChunk.class.getSimpleName() + " without " + HttpMessage.class.getSimpleName());
            }
            HttpChunk chunk = (HttpChunk)msg;
            ByteBuf content = currentMessage.getContent();
            if (content.readableBytes() > this.maxContentLength - chunk.getContent().readableBytes()) {
                throw new TooLongFrameException("HTTP content length exceeded " + this.maxContentLength + " bytes.");
            }
            this.appendToCumulation(chunk.getContent());
            if (chunk.isLast()) {
                this.currentMessage = null;
                if (chunk instanceof HttpChunkTrailer) {
                    HttpChunkTrailer trailer = (HttpChunkTrailer)chunk;
                    for (Map.Entry<String, String> header : trailer.getHeaders()) {
                        currentMessage.setHeader(header.getKey(), header.getValue());
                    }
                }
                currentMessage.setHeader("Content-Length", String.valueOf(content.readableBytes()));
                return currentMessage;
            }
            return null;
        }
        throw new IllegalStateException("Only " + HttpMessage.class.getSimpleName() + " and " + HttpChunk.class.getSimpleName() + " are accepted: " + msg.getClass().getName());
    }

    protected void appendToCumulation(ByteBuf input) {
        ByteBuf cumulation = this.currentMessage.getContent();
        if (cumulation instanceof CompositeByteBuf) {
            CompositeByteBuf composite = (CompositeByteBuf)cumulation;
            if (composite.numComponents() >= this.maxCumulationBufferComponents) {
                this.currentMessage.setContent(Unpooled.wrappedBuffer((ByteBuf[])new ByteBuf[]{composite.copy(), input}));
            } else {
                List decomposed = composite.decompose(0, composite.readableBytes());
                ByteBuf[] buffers = decomposed.toArray(new ByteBuf[decomposed.size() + 1]);
                buffers[buffers.length - 1] = input;
                this.currentMessage.setContent(Unpooled.wrappedBuffer((ByteBuf[])buffers));
            }
        } else {
            this.currentMessage.setContent(Unpooled.wrappedBuffer((ByteBuf[])new ByteBuf[]{cumulation, input}));
        }
    }

    public void beforeAdd(ChannelHandlerContext ctx) throws Exception {
        this.ctx = ctx;
    }
}

