/*
 * Decompiled with CFR 0.152.
 */
package io.netty.handler.codec.dns;

import io.netty.buffer.ByteBuf;
import io.netty.buffer.Unpooled;
import io.netty.channel.AddressedEnvelope;
import io.netty.channel.ChannelHandler;
import io.netty.channel.embedded.EmbeddedChannel;
import io.netty.channel.socket.DatagramPacket;
import io.netty.handler.codec.CorruptedFrameException;
import io.netty.handler.codec.dns.DatagramDnsResponse;
import io.netty.handler.codec.dns.DatagramDnsResponseDecoder;
import io.netty.handler.codec.dns.DnsResponse;
import io.netty.handler.codec.dns.DnsSection;
import java.net.InetSocketAddress;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.junit.Assert;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.ExpectedException;

public class DnsResponseTest {
    private static final byte[][] packets = new byte[][]{{0, 1, -127, -128, 0, 1, 0, 1, 0, 0, 0, 0, 3, 119, 119, 119, 7, 101, 120, 97, 109, 112, 108, 101, 3, 99, 111, 109, 0, 0, 1, 0, 1, -64, 12, 0, 1, 0, 1, 0, 0, 16, -113, 0, 4, -64, 0, 43, 10}, {0, 1, -127, -128, 0, 1, 0, 1, 0, 0, 0, 0, 3, 119, 119, 119, 7, 101, 120, 97, 109, 112, 108, 101, 3, 99, 111, 109, 0, 0, 28, 0, 1, -64, 12, 0, 28, 0, 1, 0, 0, 69, -8, 0, 16, 32, 1, 5, 0, 0, -120, 2, 0, 0, 0, 0, 0, 0, 0, 0, 16}, {0, 2, -127, -128, 0, 1, 0, 0, 0, 1, 0, 0, 3, 119, 119, 119, 7, 101, 120, 97, 109, 112, 108, 101, 3, 99, 111, 109, 0, 0, 15, 0, 1, -64, 16, 0, 6, 0, 1, 0, 0, 3, -43, 0, 45, 3, 115, 110, 115, 3, 100, 110, 115, 5, 105, 99, 97, 110, 110, 3, 111, 114, 103, 0, 3, 110, 111, 99, -64, 49, 119, -4, 39, 112, 0, 0, 28, 32, 0, 0, 14, 16, 0, 18, 117, 0, 0, 0, 14, 16}, {0, 3, -127, -128, 0, 1, 0, 1, 0, 0, 0, 0, 3, 119, 119, 119, 7, 101, 120, 97, 109, 112, 108, 101, 3, 99, 111, 109, 0, 0, 16, 0, 1, -64, 12, 0, 16, 0, 1, 0, 0, 84, 75, 0, 12, 11, 118, 61, 115, 112, 102, 49, 32, 45, 97, 108, 108}, {-105, 19, -127, 0, 0, 1, 0, 0, 0, 13, 0, 0, 2, 104, 112, 11, 116, 105, 109, 98, 111, 117, 100, 114, 101, 97, 117, 3, 111, 114, 103, 0, 0, 1, 0, 1, 0, 0, 2, 0, 1, 0, 7, -23, 0, 0, 20, 1, 68, 12, 82, 79, 79, 84, 45, 83, 69, 82, 86, 69, 82, 83, 3, 78, 69, 84, 0, 0, 0, 2, 0, 1, 0, 7, -23, 0, 0, 4, 1, 70, -64, 49, 0, 0, 2, 0, 1, 0, 7, -23, 0, 0, 4, 1, 69, -64, 49, 0, 0, 2, 0, 1, 0, 7, -23, 0, 0, 4, 1, 75, -64, 49, 0, 0, 2, 0, 1, 0, 7, -23, 0, 0, 4, 1, 67, -64, 49, 0, 0, 2, 0, 1, 0, 7, -23, 0, 0, 4, 1, 76, -64, 49, 0, 0, 2, 0, 1, 0, 7, -23, 0, 0, 4, 1, 71, -64, 49, 0, 0, 2, 0, 1, 0, 7, -23, 0, 0, 4, 1, 73, -64, 49, 0, 0, 2, 0, 1, 0, 7, -23, 0, 0, 4, 1, 66, -64, 49, 0, 0, 2, 0, 1, 0, 7, -23, 0, 0, 4, 1, 77, -64, 49, 0, 0, 2, 0, 1, 0, 7, -23, 0, 0, 4, 1, 65, -64, 49, 0, 0, 2, 0, 1, 0, 7, -23, 0, 0, 4, 1, 72, -64, 49, 0, 0, 2, 0, 1, 0, 7, -23, 0, 0, 4, 1, 74, -64, 49}};
    private static final byte[] malformedLoopPacket = new byte[]{0, 4, -127, -128, 0, 1, 0, 0, 0, 0, 0, 0, -64, 12, 0, 1, 0, 1};
    @Rule
    public ExpectedException exception = ExpectedException.none();

    @Test
    public void readResponseTest() throws Exception {
        EmbeddedChannel embedder = new EmbeddedChannel(new ChannelHandler[]{new DatagramDnsResponseDecoder()});
        for (byte[] p : packets) {
            ByteBuf packet = embedder.alloc().buffer(512).writeBytes(p);
            embedder.writeInbound(new Object[]{new DatagramPacket(packet, null, new InetSocketAddress(0))});
            AddressedEnvelope envelope = (AddressedEnvelope)embedder.readInbound();
            Assert.assertThat((Object)envelope, (Matcher)Matchers.is((Matcher)Matchers.instanceOf(DatagramDnsResponse.class)));
            DnsResponse response = (DnsResponse)envelope.content();
            Assert.assertThat((Object)response, (Matcher)Matchers.is((Matcher)Matchers.sameInstance((Object)envelope)));
            ByteBuf raw = Unpooled.wrappedBuffer((byte[])p);
            Assert.assertThat((Object)response.id(), (Matcher)Matchers.is((Object)raw.getUnsignedShort(0)));
            Assert.assertThat((Object)response.count(DnsSection.QUESTION), (Matcher)Matchers.is((Object)raw.getUnsignedShort(4)));
            Assert.assertThat((Object)response.count(DnsSection.ANSWER), (Matcher)Matchers.is((Object)raw.getUnsignedShort(6)));
            Assert.assertThat((Object)response.count(DnsSection.AUTHORITY), (Matcher)Matchers.is((Object)raw.getUnsignedShort(8)));
            Assert.assertThat((Object)response.count(DnsSection.ADDITIONAL), (Matcher)Matchers.is((Object)raw.getUnsignedShort(10)));
            envelope.release();
        }
    }

    @Test
    public void readMalformedResponseTest() throws Exception {
        EmbeddedChannel embedder = new EmbeddedChannel(new ChannelHandler[]{new DatagramDnsResponseDecoder()});
        ByteBuf packet = embedder.alloc().buffer(512).writeBytes(malformedLoopPacket);
        this.exception.expect(CorruptedFrameException.class);
        embedder.writeInbound(new Object[]{new DatagramPacket(packet, null, new InetSocketAddress(0))});
    }
}

