/*
 * Decompiled with CFR 0.152.
 */
package io.netty.buffer;

import io.netty.buffer.ByteBuf;
import io.netty.buffer.ByteBufAllocator;
import io.netty.buffer.ReadOnlyByteBufferBuf;
import io.netty.buffer.Unpooled;
import io.netty.buffer.UnpooledByteBufAllocator;
import io.netty.util.internal.PlatformDependent;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.RandomAccessFile;
import java.nio.ByteBuffer;
import java.nio.MappedByteBuffer;
import java.nio.ReadOnlyBufferException;
import java.nio.channels.FileChannel;
import java.nio.channels.spi.AbstractInterruptibleChannel;
import org.junit.Assert;
import org.junit.Test;

public class ReadOnlyDirectByteBufferBufTest {
    protected ByteBuf buffer(ByteBuffer buffer) {
        return new ReadOnlyByteBufferBuf((ByteBufAllocator)UnpooledByteBufAllocator.DEFAULT, buffer);
    }

    protected ByteBuffer allocate(int size) {
        return ByteBuffer.allocateDirect(size);
    }

    @Test
    public void testIsContiguous() {
        ByteBuf buf = this.buffer(this.allocate(4).asReadOnlyBuffer());
        Assert.assertTrue((boolean)buf.isContiguous());
        buf.release();
    }

    @Test(expected=IllegalArgumentException.class)
    public void testConstructWithWritable() {
        this.buffer(this.allocate(1));
    }

    @Test
    public void shouldIndicateNotWritable() {
        ByteBuf buf = this.buffer(this.allocate(8).asReadOnlyBuffer()).clear();
        try {
            Assert.assertFalse((boolean)buf.isWritable());
        }
        finally {
            buf.release();
        }
    }

    @Test
    public void shouldIndicateNotWritableAnyNumber() {
        ByteBuf buf = this.buffer(this.allocate(8).asReadOnlyBuffer()).clear();
        try {
            Assert.assertFalse((boolean)buf.isWritable(1));
        }
        finally {
            buf.release();
        }
    }

    @Test
    public void ensureWritableIntStatusShouldFailButNotThrow() {
        ByteBuf buf = this.buffer(this.allocate(8).asReadOnlyBuffer()).clear();
        try {
            int result = buf.ensureWritable(1, false);
            Assert.assertEquals((long)1L, (long)result);
        }
        finally {
            buf.release();
        }
    }

    @Test
    public void ensureWritableForceIntStatusShouldFailButNotThrow() {
        ByteBuf buf = this.buffer(this.allocate(8).asReadOnlyBuffer()).clear();
        try {
            int result = buf.ensureWritable(1, true);
            Assert.assertEquals((long)1L, (long)result);
        }
        finally {
            buf.release();
        }
    }

    @Test(expected=ReadOnlyBufferException.class)
    public void ensureWritableShouldThrow() {
        ByteBuf buf = this.buffer(this.allocate(8).asReadOnlyBuffer()).clear();
        try {
            buf.ensureWritable(1);
        }
        finally {
            buf.release();
        }
    }

    @Test(expected=ReadOnlyBufferException.class)
    public void testSetByte() {
        ByteBuf buf = this.buffer(this.allocate(8).asReadOnlyBuffer());
        try {
            buf.setByte(0, 1);
        }
        finally {
            buf.release();
        }
    }

    @Test(expected=ReadOnlyBufferException.class)
    public void testSetInt() {
        ByteBuf buf = this.buffer(this.allocate(8).asReadOnlyBuffer());
        try {
            buf.setInt(0, 1);
        }
        finally {
            buf.release();
        }
    }

    @Test(expected=ReadOnlyBufferException.class)
    public void testSetShort() {
        ByteBuf buf = this.buffer(this.allocate(8).asReadOnlyBuffer());
        try {
            buf.setShort(0, 1);
        }
        finally {
            buf.release();
        }
    }

    @Test(expected=ReadOnlyBufferException.class)
    public void testSetMedium() {
        ByteBuf buf = this.buffer(this.allocate(8).asReadOnlyBuffer());
        try {
            buf.setMedium(0, 1);
        }
        finally {
            buf.release();
        }
    }

    @Test(expected=ReadOnlyBufferException.class)
    public void testSetLong() {
        ByteBuf buf = this.buffer(this.allocate(8).asReadOnlyBuffer());
        try {
            buf.setLong(0, 1L);
        }
        finally {
            buf.release();
        }
    }

    @Test(expected=ReadOnlyBufferException.class)
    public void testSetBytesViaArray() {
        ByteBuf buf = this.buffer(this.allocate(8).asReadOnlyBuffer());
        try {
            buf.setBytes(0, "test".getBytes());
        }
        finally {
            buf.release();
        }
    }

    @Test(expected=ReadOnlyBufferException.class)
    public void testSetBytesViaBuffer() {
        ByteBuf buf = this.buffer(this.allocate(8).asReadOnlyBuffer());
        ByteBuf copy = Unpooled.copyInt((int)1);
        try {
            buf.setBytes(0, copy);
        }
        finally {
            buf.release();
            copy.release();
        }
    }

    @Test(expected=ReadOnlyBufferException.class)
    public void testSetBytesViaStream() throws IOException {
        ByteBuf buf = this.buffer(ByteBuffer.allocateDirect(8).asReadOnlyBuffer());
        try {
            buf.setBytes(0, (InputStream)new ByteArrayInputStream("test".getBytes()), 2);
        }
        finally {
            buf.release();
        }
    }

    @Test
    public void testGetReadByte() {
        ByteBuf buf = this.buffer(((ByteBuffer)this.allocate(2).put(new byte[]{1, 2}).flip()).asReadOnlyBuffer());
        Assert.assertEquals((long)1L, (long)buf.getByte(0));
        Assert.assertEquals((long)2L, (long)buf.getByte(1));
        Assert.assertEquals((long)1L, (long)buf.readByte());
        Assert.assertEquals((long)2L, (long)buf.readByte());
        Assert.assertFalse((boolean)buf.isReadable());
        buf.release();
    }

    @Test
    public void testGetReadInt() {
        ByteBuf buf = this.buffer(((ByteBuffer)this.allocate(8).putInt(1).putInt(2).flip()).asReadOnlyBuffer());
        Assert.assertEquals((long)1L, (long)buf.getInt(0));
        Assert.assertEquals((long)2L, (long)buf.getInt(4));
        Assert.assertEquals((long)1L, (long)buf.readInt());
        Assert.assertEquals((long)2L, (long)buf.readInt());
        Assert.assertFalse((boolean)buf.isReadable());
        buf.release();
    }

    @Test
    public void testGetReadShort() {
        ByteBuf buf = this.buffer(((ByteBuffer)this.allocate(8).putShort((short)1).putShort((short)2).flip()).asReadOnlyBuffer());
        Assert.assertEquals((long)1L, (long)buf.getShort(0));
        Assert.assertEquals((long)2L, (long)buf.getShort(2));
        Assert.assertEquals((long)1L, (long)buf.readShort());
        Assert.assertEquals((long)2L, (long)buf.readShort());
        Assert.assertFalse((boolean)buf.isReadable());
        buf.release();
    }

    @Test
    public void testGetReadLong() {
        ByteBuf buf = this.buffer(((ByteBuffer)this.allocate(16).putLong(1L).putLong(2L).flip()).asReadOnlyBuffer());
        Assert.assertEquals((long)1L, (long)buf.getLong(0));
        Assert.assertEquals((long)2L, (long)buf.getLong(8));
        Assert.assertEquals((long)1L, (long)buf.readLong());
        Assert.assertEquals((long)2L, (long)buf.readLong());
        Assert.assertFalse((boolean)buf.isReadable());
        buf.release();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test(expected=IndexOutOfBoundsException.class)
    public void testGetBytesByteBuffer() {
        byte[] bytes = new byte[]{97, 98, 99, 100, 101, 102, 103};
        ByteBuffer nioBuffer = ByteBuffer.allocate(bytes.length + 1);
        ByteBuf buffer = this.buffer(((ByteBuffer)this.allocate(bytes.length).put(bytes).flip()).asReadOnlyBuffer());
        try {
            buffer.getBytes(buffer.readerIndex(), nioBuffer);
        }
        finally {
            buffer.release();
        }
    }

    @Test
    public void testCopy() {
        ByteBuf buf = this.buffer(((ByteBuffer)this.allocate(16).putLong(1L).putLong(2L).flip()).asReadOnlyBuffer());
        ByteBuf copy = buf.copy();
        Assert.assertEquals((Object)buf, (Object)copy);
        buf.release();
        copy.release();
    }

    @Test
    public void testCopyWithOffset() {
        ByteBuf buf = this.buffer(((ByteBuffer)this.allocate(16).putLong(1L).putLong(2L).flip()).asReadOnlyBuffer());
        ByteBuf copy = buf.copy(1, 9);
        Assert.assertEquals((Object)buf.slice(1, 9), (Object)copy);
        buf.release();
        copy.release();
    }

    @Test
    public void testWrapBufferWithNonZeroPosition() {
        ByteBuf buf = this.buffer(((ByteBuffer)this.allocate(16).putLong(1L).flip().position(1)).asReadOnlyBuffer());
        ByteBuf slice = buf.slice();
        Assert.assertEquals((Object)buf, (Object)slice);
        buf.release();
    }

    @Test
    public void testWrapBufferRoundTrip() {
        ByteBuf buf = this.buffer(((ByteBuffer)this.allocate(16).putInt(1).putInt(2).flip()).asReadOnlyBuffer());
        Assert.assertEquals((long)1L, (long)buf.readInt());
        ByteBuffer nioBuffer = buf.nioBuffer();
        Assert.assertEquals((long)2L, (long)nioBuffer.getInt());
        buf.release();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testWrapMemoryMapped() throws Exception {
        File file = PlatformDependent.createTempFile((String)"netty-test", (String)"tmp", null);
        FileChannel output = null;
        AbstractInterruptibleChannel input = null;
        ByteBuf b1 = null;
        ByteBuf b2 = null;
        try {
            output = new RandomAccessFile(file, "rw").getChannel();
            byte[] bytes = new byte[1024];
            PlatformDependent.threadLocalRandom().nextBytes(bytes);
            output.write(ByteBuffer.wrap(bytes));
            input = new RandomAccessFile(file, "r").getChannel();
            MappedByteBuffer m = ((FileChannel)input).map(FileChannel.MapMode.READ_ONLY, 0L, ((FileChannel)input).size());
            b1 = this.buffer(m);
            ByteBuffer dup = ((ByteBuffer)m).duplicate();
            dup.position(2);
            dup.limit(4);
            b2 = this.buffer(dup);
            Assert.assertEquals((Object)b2, (Object)b1.slice(2, 2));
        }
        finally {
            if (b1 != null) {
                b1.release();
            }
            if (b2 != null) {
                b2.release();
            }
            if (output != null) {
                output.close();
            }
            if (input != null) {
                input.close();
            }
            file.delete();
        }
    }

    @Test
    public void testMemoryAddress() {
        ByteBuf buf = this.buffer(this.allocate(8).asReadOnlyBuffer());
        try {
            Assert.assertFalse((boolean)buf.hasMemoryAddress());
            try {
                buf.memoryAddress();
                Assert.fail();
            }
            catch (UnsupportedOperationException unsupportedOperationException) {
                // empty catch block
            }
        }
        finally {
            buf.release();
        }
    }
}

