/*
 * Decompiled with CFR 0.152.
 */
package io.netty.buffer;

import io.netty.buffer.ByteBuf;
import io.netty.buffer.PoolArena;
import io.netty.buffer.PoolArenaMetric;
import io.netty.buffer.PooledByteBuf;
import io.netty.buffer.PooledByteBufAllocator;
import io.netty.util.internal.PlatformDependent;
import java.nio.ByteBuffer;
import org.junit.Assert;
import org.junit.Assume;
import org.junit.Test;

public class PoolArenaTest {
    @Test
    public void testNormalizeCapacity() throws Exception {
        PoolArena.DirectArena arena = new PoolArena.DirectArena(null, 0, 0, 9, 999999, 0);
        int[] reqCapacities = new int[]{0, 15, 510, 1024, 1023, 1025};
        int[] expectedResult = new int[]{0, 16, 512, 1024, 1024, 2048};
        for (int i = 0; i < reqCapacities.length; ++i) {
            Assert.assertEquals((long)expectedResult[i], (long)arena.normalizeCapacity(reqCapacities[i]));
        }
    }

    @Test
    public void testNormalizeAlignedCapacity() throws Exception {
        PoolArena.DirectArena arena = new PoolArena.DirectArena(null, 0, 0, 9, 999999, 64);
        int[] reqCapacities = new int[]{0, 15, 510, 1024, 1023, 1025};
        int[] expectedResult = new int[]{0, 64, 512, 1024, 1024, 2048};
        for (int i = 0; i < reqCapacities.length; ++i) {
            Assert.assertEquals((long)expectedResult[i], (long)arena.normalizeCapacity(reqCapacities[i]));
        }
    }

    @Test
    public void testDirectArenaOffsetCacheLine() throws Exception {
        Assume.assumeTrue((boolean)PlatformDependent.hasUnsafe());
        int capacity = 5;
        int alignment = 128;
        for (int i = 0; i < 1000; ++i) {
            ByteBuffer bb = PlatformDependent.useDirectBufferNoCleaner() ? PlatformDependent.allocateDirectNoCleaner((int)(capacity + alignment)) : ByteBuffer.allocateDirect(capacity + alignment);
            PoolArena.DirectArena arena = new PoolArena.DirectArena(null, 0, 0, 9, 9, alignment);
            int offset = arena.offsetCacheLine(bb);
            long address = PlatformDependent.directBufferAddress((ByteBuffer)bb);
            Assert.assertEquals((long)0L, (long)((long)offset + address & (long)(alignment - 1)));
            PlatformDependent.freeDirectBuffer((ByteBuffer)bb);
        }
    }

    @Test
    public void testAllocationCounter() {
        PooledByteBufAllocator allocator = new PooledByteBufAllocator(true, 0, 1, 8192, 11, 0, 0, 0, true);
        ByteBuf b1 = allocator.directBuffer(24);
        ByteBuf b2 = allocator.directBuffer(800);
        ByteBuf b3 = allocator.directBuffer(16384);
        Assert.assertNotNull((Object)b1);
        Assert.assertNotNull((Object)b2);
        Assert.assertNotNull((Object)b3);
        Assert.assertTrue((boolean)b1.release());
        Assert.assertTrue((boolean)b2.release());
        Assert.assertTrue((boolean)b3.release());
        Assert.assertTrue((allocator.directArenas().size() >= 1 ? 1 : 0) != 0);
        PoolArenaMetric metric = (PoolArenaMetric)allocator.directArenas().get(0);
        Assert.assertEquals((long)3L, (long)metric.numDeallocations());
        Assert.assertEquals((long)3L, (long)metric.numAllocations());
        Assert.assertEquals((long)1L, (long)metric.numTinyDeallocations());
        Assert.assertEquals((long)1L, (long)metric.numTinyAllocations());
        Assert.assertEquals((long)1L, (long)metric.numSmallDeallocations());
        Assert.assertEquals((long)1L, (long)metric.numSmallAllocations());
        Assert.assertEquals((long)1L, (long)metric.numNormalDeallocations());
        Assert.assertEquals((long)1L, (long)metric.numNormalAllocations());
    }

    @Test
    public void testDirectArenaMemoryCopy() {
        ByteBuf src = PooledByteBufAllocator.DEFAULT.directBuffer(512);
        ByteBuf dst = PooledByteBufAllocator.DEFAULT.directBuffer(512);
        PooledByteBuf<ByteBuffer> pooledSrc = this.unwrapIfNeeded(src);
        PooledByteBuf<ByteBuffer> pooledDst = this.unwrapIfNeeded(dst);
        pooledDst.writeBytes(ByteBuffer.allocate(128));
        pooledDst.chunk.arena.memoryCopy(pooledSrc.memory, 0, pooledDst, 512);
        src.release();
        dst.release();
    }

    private PooledByteBuf<ByteBuffer> unwrapIfNeeded(ByteBuf buf) {
        return (PooledByteBuf)(buf instanceof PooledByteBuf ? buf : buf.unwrap());
    }
}

