/*
 * Decompiled with CFR 0.152.
 */
package io.netty.buffer;

import io.netty.buffer.AbstractByteBuf;
import io.netty.buffer.ByteBuf;
import io.netty.buffer.ByteBufAllocator;
import io.netty.buffer.PooledByteBufAllocator;
import io.netty.buffer.UnpooledByteBufAllocator;
import io.netty.buffer.UnpooledDirectByteBuf;
import io.netty.buffer.UnsafeByteBufUtil;
import io.netty.util.internal.PlatformDependent;
import java.nio.ByteBuffer;
import org.junit.Assert;
import org.junit.Assume;
import org.junit.Before;
import org.junit.Test;

public class UnsafeByteBufUtilTest {
    @Before
    public void checkHasUnsafe() {
        Assume.assumeTrue((String)"sun.misc.Unsafe not found, skip tests", (boolean)PlatformDependent.hasUnsafe());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testSetBytesOnReadOnlyByteBuffer() throws Exception {
        byte[] testData = new byte[]{0, 1, 2, 3, 4, 5, 6, 7, 8, 9};
        int length = testData.length;
        ByteBuffer readOnlyBuffer = ByteBuffer.wrap(testData).asReadOnlyBuffer();
        UnpooledByteBufAllocator alloc = new UnpooledByteBufAllocator(true);
        UnpooledDirectByteBuf targetBuffer = new UnpooledDirectByteBuf((ByteBufAllocator)alloc, length, length);
        try {
            UnsafeByteBufUtil.setBytes((AbstractByteBuf)targetBuffer, (long)PlatformDependent.directBufferAddress((ByteBuffer)targetBuffer.nioBuffer()), (int)0, (ByteBuffer)readOnlyBuffer);
            byte[] check = new byte[length];
            targetBuffer.getBytes(0, check, 0, length);
            Assert.assertArrayEquals((String)"The byte array's copy does not equal the original", (byte[])testData, (byte[])check);
        }
        finally {
            targetBuffer.release();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testSetBytesOnReadOnlyByteBufferWithPooledAlloc() throws Exception {
        byte[] testData = new byte[]{0, 1, 2, 3, 4, 5, 6, 7, 8, 9};
        int length = testData.length;
        ByteBuffer readOnlyBuffer = ByteBuffer.wrap(testData).asReadOnlyBuffer();
        int pageSize = 4096;
        PooledByteBufAllocator alloc = new PooledByteBufAllocator(true, 1, 1, pageSize, 0);
        UnpooledDirectByteBuf targetBuffer = new UnpooledDirectByteBuf((ByteBufAllocator)alloc, length, length);
        ByteBuf b1 = alloc.heapBuffer(16);
        ByteBuf b2 = alloc.heapBuffer(16);
        try {
            Assert.assertEquals((long)pageSize, (long)b1.array().length);
            Assert.assertArrayEquals((byte[])b1.array(), (byte[])b2.array());
            Assert.assertNotEquals((long)b1.arrayOffset(), (long)b2.arrayOffset());
            UnsafeByteBufUtil.setBytes((AbstractByteBuf)targetBuffer, (long)PlatformDependent.directBufferAddress((ByteBuffer)targetBuffer.nioBuffer()), (int)0, (ByteBuffer)readOnlyBuffer);
            byte[] check = new byte[length];
            targetBuffer.getBytes(0, check, 0, length);
            Assert.assertArrayEquals((String)"The byte array's copy does not equal the original", (byte[])testData, (byte[])check);
        }
        finally {
            targetBuffer.release();
            b1.release();
            b2.release();
        }
    }
}

