/*
 * Decompiled with CFR 0.152.
 */
package io.netty.buffer;

import io.netty.buffer.BigEndianUnsafeDirectByteBufTest;
import io.netty.buffer.ByteBuf;
import io.netty.buffer.ByteBufAllocator;
import io.netty.buffer.UnpooledByteBufAllocator;
import io.netty.buffer.WrappedUnpooledUnsafeDirectByteBuf;
import io.netty.util.internal.PlatformDependent;
import org.junit.Assume;
import org.junit.Before;
import org.junit.Test;

public class WrappedUnpooledUnsafeByteBufTest
extends BigEndianUnsafeDirectByteBufTest {
    @Override
    @Before
    public void init() {
        Assume.assumeTrue((String)"PlatformDependent.useDirectBufferNoCleaner() returned false, skip tests", (boolean)PlatformDependent.useDirectBufferNoCleaner());
        super.init();
    }

    @Override
    protected ByteBuf newBuffer(int length, int maxCapacity) {
        Assume.assumeTrue((maxCapacity == Integer.MAX_VALUE ? 1 : 0) != 0);
        return new WrappedUnpooledUnsafeDirectByteBuf((ByteBufAllocator)UnpooledByteBufAllocator.DEFAULT, PlatformDependent.allocateMemory((long)length), length, true);
    }

    @Override
    @Test(expected=IndexOutOfBoundsException.class)
    public void testInternalNioBuffer() {
        super.testInternalNioBuffer();
    }

    @Override
    @Test(expected=IndexOutOfBoundsException.class)
    public void testDuplicateReadGatheringByteChannelMultipleThreads() throws Exception {
        super.testDuplicateReadGatheringByteChannelMultipleThreads();
    }

    @Override
    @Test(expected=IndexOutOfBoundsException.class)
    public void testSliceReadGatheringByteChannelMultipleThreads() throws Exception {
        super.testSliceReadGatheringByteChannelMultipleThreads();
    }

    @Override
    @Test(expected=IndexOutOfBoundsException.class)
    public void testDuplicateReadOutputStreamMultipleThreads() throws Exception {
        super.testDuplicateReadOutputStreamMultipleThreads();
    }

    @Override
    @Test(expected=IndexOutOfBoundsException.class)
    public void testSliceReadOutputStreamMultipleThreads() throws Exception {
        super.testSliceReadOutputStreamMultipleThreads();
    }

    @Override
    @Test(expected=IndexOutOfBoundsException.class)
    public void testDuplicateBytesInArrayMultipleThreads() throws Exception {
        super.testDuplicateBytesInArrayMultipleThreads();
    }

    @Override
    @Test(expected=IndexOutOfBoundsException.class)
    public void testSliceBytesInArrayMultipleThreads() throws Exception {
        super.testSliceBytesInArrayMultipleThreads();
    }

    @Override
    @Test(expected=IndexOutOfBoundsException.class)
    public void testNioBufferExposeOnlyRegion() {
        super.testNioBufferExposeOnlyRegion();
    }

    @Override
    @Test(expected=IndexOutOfBoundsException.class)
    public void testGetReadOnlyDirectDst() {
        super.testGetReadOnlyDirectDst();
    }

    @Override
    @Test(expected=IndexOutOfBoundsException.class)
    public void testGetReadOnlyHeapDst() {
        super.testGetReadOnlyHeapDst();
    }

    @Override
    @Test(expected=IndexOutOfBoundsException.class)
    public void testReadBytes() {
        super.testReadBytes();
    }

    @Override
    @Test(expected=IllegalArgumentException.class)
    public void testDuplicateCapacityChange() {
        super.testDuplicateCapacityChange();
    }

    @Override
    @Test(expected=IllegalArgumentException.class)
    public void testRetainedDuplicateCapacityChange() {
        super.testRetainedDuplicateCapacityChange();
    }

    @Override
    @Test(expected=IndexOutOfBoundsException.class)
    public void testLittleEndianWithExpand() {
        super.testLittleEndianWithExpand();
    }

    @Override
    @Test(expected=IndexOutOfBoundsException.class)
    public void testWriteUsAsciiCharSequenceExpand() {
        super.testWriteUsAsciiCharSequenceExpand();
    }

    @Override
    @Test(expected=IndexOutOfBoundsException.class)
    public void testWriteUtf8CharSequenceExpand() {
        super.testWriteUtf8CharSequenceExpand();
    }

    @Override
    @Test(expected=IndexOutOfBoundsException.class)
    public void testWriteIso88591CharSequenceExpand() {
        super.testWriteIso88591CharSequenceExpand();
    }

    @Override
    @Test(expected=IndexOutOfBoundsException.class)
    public void testWriteUtf16CharSequenceExpand() {
        super.testWriteUtf16CharSequenceExpand();
    }

    @Override
    @Test
    public void testForEachByteDesc2() {
    }

    @Override
    @Test
    public void testForEachByte2() {
    }
}

