/*
 * Decompiled with CFR 0.152.
 */
package io.netty.buffer;

import io.netty.buffer.AbstractByteBufTest;
import io.netty.buffer.ByteBuf;
import io.netty.buffer.SlicedByteBuf;
import io.netty.buffer.Unpooled;
import io.netty.util.internal.PlatformDependent;
import java.nio.ByteBuffer;
import org.junit.Assert;
import org.junit.Assume;
import org.junit.Ignore;
import org.junit.Test;

public class SlicedByteBufTest
extends AbstractByteBufTest {
    @Override
    protected final ByteBuf newBuffer(int length, int maxCapacity) {
        Assume.assumeTrue((maxCapacity == Integer.MAX_VALUE ? 1 : 0) != 0);
        int offset = length == 0 ? 0 : PlatformDependent.threadLocalRandom().nextInt(length);
        ByteBuf buffer = Unpooled.buffer((int)(length * 2));
        ByteBuf slice = this.newSlice(buffer, offset, length);
        Assert.assertEquals((long)0L, (long)slice.readerIndex());
        Assert.assertEquals((long)length, (long)slice.writerIndex());
        return slice;
    }

    protected ByteBuf newSlice(ByteBuf buffer, int offset, int length) {
        return buffer.slice(offset, length);
    }

    @Test
    public void testIsContiguous() {
        ByteBuf buf = this.newBuffer(4);
        Assert.assertEquals((Object)buf.unwrap().isContiguous(), (Object)buf.isContiguous());
        buf.release();
    }

    @Test(expected=NullPointerException.class)
    public void shouldNotAllowNullInConstructor() {
        new SlicedByteBuf(null, 0, 0);
    }

    @Override
    @Test(expected=IndexOutOfBoundsException.class)
    public void testInternalNioBuffer() {
        super.testInternalNioBuffer();
    }

    @Override
    @Test(expected=IndexOutOfBoundsException.class)
    public void testDuplicateReadGatheringByteChannelMultipleThreads() throws Exception {
        super.testDuplicateReadGatheringByteChannelMultipleThreads();
    }

    @Override
    @Test(expected=IndexOutOfBoundsException.class)
    public void testSliceReadGatheringByteChannelMultipleThreads() throws Exception {
        super.testSliceReadGatheringByteChannelMultipleThreads();
    }

    @Override
    @Test(expected=IndexOutOfBoundsException.class)
    public void testDuplicateReadOutputStreamMultipleThreads() throws Exception {
        super.testDuplicateReadOutputStreamMultipleThreads();
    }

    @Override
    @Test(expected=IndexOutOfBoundsException.class)
    public void testSliceReadOutputStreamMultipleThreads() throws Exception {
        super.testSliceReadOutputStreamMultipleThreads();
    }

    @Override
    @Test(expected=IndexOutOfBoundsException.class)
    public void testDuplicateBytesInArrayMultipleThreads() throws Exception {
        super.testDuplicateBytesInArrayMultipleThreads();
    }

    @Override
    @Test(expected=IndexOutOfBoundsException.class)
    public void testSliceBytesInArrayMultipleThreads() throws Exception {
        super.testSliceBytesInArrayMultipleThreads();
    }

    @Override
    @Test(expected=IndexOutOfBoundsException.class)
    public void testNioBufferExposeOnlyRegion() {
        super.testNioBufferExposeOnlyRegion();
    }

    @Override
    @Test(expected=IndexOutOfBoundsException.class)
    public void testGetReadOnlyDirectDst() {
        super.testGetReadOnlyDirectDst();
    }

    @Override
    @Test(expected=IndexOutOfBoundsException.class)
    public void testGetReadOnlyHeapDst() {
        super.testGetReadOnlyHeapDst();
    }

    @Override
    @Test
    public void testLittleEndianWithExpand() {
    }

    @Override
    @Test
    public void testReadBytes() {
    }

    @Override
    @Test
    public void testForEachByteDesc2() {
    }

    @Override
    @Test
    public void testForEachByte2() {
    }

    @Override
    @Ignore(value="Sliced ByteBuf objects don't allow the capacity to change. So this test would fail and shouldn't be run")
    public void testDuplicateCapacityChange() {
    }

    @Override
    @Ignore(value="Sliced ByteBuf objects don't allow the capacity to change. So this test would fail and shouldn't be run")
    public void testRetainedDuplicateCapacityChange() {
    }

    @Test
    public void testReaderIndexAndMarks() {
        ByteBuf wrapped = Unpooled.buffer((int)16);
        try {
            wrapped.writerIndex(14);
            wrapped.readerIndex(2);
            wrapped.markWriterIndex();
            wrapped.markReaderIndex();
            ByteBuf slice = wrapped.slice(4, 4);
            Assert.assertEquals((long)0L, (long)slice.readerIndex());
            Assert.assertEquals((long)4L, (long)slice.writerIndex());
            slice.readerIndex(slice.readerIndex() + 1);
            slice.resetReaderIndex();
            Assert.assertEquals((long)0L, (long)slice.readerIndex());
            slice.writerIndex(slice.writerIndex() - 1);
            slice.resetWriterIndex();
            Assert.assertEquals((long)0L, (long)slice.writerIndex());
        }
        finally {
            wrapped.release();
        }
    }

    @Test
    public void sliceEmptyNotLeak() {
        ByteBuf buffer = Unpooled.buffer((int)8).retain();
        Assert.assertEquals((long)2L, (long)buffer.refCnt());
        ByteBuf slice1 = buffer.slice();
        Assert.assertEquals((long)2L, (long)slice1.refCnt());
        ByteBuf slice2 = slice1.slice();
        Assert.assertEquals((long)2L, (long)slice2.refCnt());
        Assert.assertFalse((boolean)slice2.release());
        Assert.assertEquals((long)1L, (long)buffer.refCnt());
        Assert.assertEquals((long)1L, (long)slice1.refCnt());
        Assert.assertEquals((long)1L, (long)slice2.refCnt());
        Assert.assertTrue((boolean)slice2.release());
        Assert.assertEquals((long)0L, (long)buffer.refCnt());
        Assert.assertEquals((long)0L, (long)slice1.refCnt());
        Assert.assertEquals((long)0L, (long)slice2.refCnt());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @Test(expected=IndexOutOfBoundsException.class)
    public void testGetBytesByteBuffer() {
        byte[] bytes = new byte[]{97, 98, 99, 100, 101, 102, 103};
        ByteBuffer nioBuffer = ByteBuffer.allocate(bytes.length + 1);
        ByteBuf wrappedBuffer = Unpooled.wrappedBuffer((byte[])bytes).slice(0, bytes.length - 1);
        try {
            wrappedBuffer.getBytes(wrappedBuffer.readerIndex(), nioBuffer);
        }
        finally {
            wrappedBuffer.release();
        }
    }

    @Override
    @Test(expected=IndexOutOfBoundsException.class)
    public void testWriteUsAsciiCharSequenceExpand() {
        super.testWriteUsAsciiCharSequenceExpand();
    }

    @Override
    @Test(expected=IndexOutOfBoundsException.class)
    public void testWriteUtf8CharSequenceExpand() {
        super.testWriteUtf8CharSequenceExpand();
    }

    @Override
    @Test(expected=IndexOutOfBoundsException.class)
    public void testWriteIso88591CharSequenceExpand() {
        super.testWriteIso88591CharSequenceExpand();
    }

    @Override
    @Test(expected=IndexOutOfBoundsException.class)
    public void testWriteUtf16CharSequenceExpand() {
        super.testWriteUtf16CharSequenceExpand();
    }

    @Test
    public void ensureWritableWithEnoughSpaceShouldNotThrow() {
        ByteBuf slice = this.newBuffer(10);
        ByteBuf unwrapped = slice.unwrap();
        unwrapped.writerIndex(unwrapped.writerIndex() + 5);
        slice.writerIndex(slice.readerIndex());
        int originalWriterIndex = slice.writerIndex();
        int originalReadableBytes = slice.readableBytes();
        slice.ensureWritable(originalWriterIndex - slice.writerIndex());
        Assert.assertEquals((long)originalWriterIndex, (long)slice.writerIndex());
        Assert.assertEquals((long)originalReadableBytes, (long)slice.readableBytes());
        slice.release();
    }

    @Test(expected=IndexOutOfBoundsException.class)
    public void ensureWritableWithNotEnoughSpaceShouldThrow() {
        ByteBuf slice = this.newBuffer(10);
        ByteBuf unwrapped = slice.unwrap();
        unwrapped.writerIndex(unwrapped.writerIndex() + 5);
        try {
            slice.ensureWritable(1);
            Assert.fail();
        }
        finally {
            slice.release();
        }
    }
}

