/*
 * Decompiled with CFR 0.152.
 */
package io.netty.buffer;

import io.netty.buffer.ByteBuf;
import io.netty.buffer.ByteBufUtil;
import io.netty.buffer.ReadOnlyByteBuf;
import io.netty.buffer.Unpooled;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.ByteBuffer;
import java.nio.ReadOnlyBufferException;
import java.nio.channels.GatheringByteChannel;
import java.nio.channels.ScatteringByteChannel;
import org.junit.Assert;
import org.junit.Test;
import org.mockito.Mockito;

public class ReadOnlyByteBufTest {
    @Test(expected=NullPointerException.class)
    public void shouldNotAllowNullInConstructor() {
        new ReadOnlyByteBuf(null);
    }

    @Test
    public void testUnmodifiableBuffer() {
        Assert.assertTrue((boolean)(Unpooled.unmodifiableBuffer((ByteBuf)Unpooled.buffer((int)1)) instanceof ReadOnlyByteBuf));
    }

    @Test
    public void testUnwrap() {
        ByteBuf buf = Unpooled.buffer((int)1);
        Assert.assertSame((Object)buf, (Object)Unpooled.unmodifiableBuffer((ByteBuf)buf).unwrap());
    }

    @Test
    public void shouldHaveSameByteOrder() {
        ByteBuf buf = Unpooled.buffer((int)1);
        Assert.assertSame((Object)Unpooled.BIG_ENDIAN, (Object)Unpooled.unmodifiableBuffer((ByteBuf)buf).order());
        buf = buf.order(Unpooled.LITTLE_ENDIAN);
        Assert.assertSame((Object)Unpooled.LITTLE_ENDIAN, (Object)Unpooled.unmodifiableBuffer((ByteBuf)buf).order());
    }

    @Test
    public void shouldReturnReadOnlyDerivedBuffer() {
        ByteBuf buf = Unpooled.unmodifiableBuffer((ByteBuf)Unpooled.buffer((int)1));
        Assert.assertTrue((boolean)(buf.duplicate() instanceof ReadOnlyByteBuf));
        Assert.assertTrue((boolean)(buf.slice() instanceof ReadOnlyByteBuf));
        Assert.assertTrue((boolean)(buf.slice(0, 1) instanceof ReadOnlyByteBuf));
        Assert.assertTrue((boolean)(buf.duplicate() instanceof ReadOnlyByteBuf));
    }

    @Test
    public void shouldReturnWritableCopy() {
        ByteBuf buf = Unpooled.unmodifiableBuffer((ByteBuf)Unpooled.buffer((int)1));
        Assert.assertFalse((boolean)(buf.copy() instanceof ReadOnlyByteBuf));
    }

    @Test
    public void shouldForwardReadCallsBlindly() throws Exception {
        ByteBuf buf = (ByteBuf)Mockito.mock(ByteBuf.class);
        Mockito.when((Object)buf.order()).thenReturn((Object)Unpooled.BIG_ENDIAN);
        Mockito.when((Object)buf.maxCapacity()).thenReturn((Object)65536);
        Mockito.when((Object)buf.readerIndex()).thenReturn((Object)0);
        Mockito.when((Object)buf.writerIndex()).thenReturn((Object)0);
        Mockito.when((Object)buf.capacity()).thenReturn((Object)0);
        Mockito.when((Object)buf.getBytes(1, (GatheringByteChannel)null, 2)).thenReturn((Object)3);
        Mockito.when((Object)buf.getBytes(4, (OutputStream)null, 5)).thenReturn((Object)buf);
        Mockito.when((Object)buf.getBytes(6, (byte[])null, 7, 8)).thenReturn((Object)buf);
        Mockito.when((Object)buf.getBytes(9, (ByteBuf)null, 10, 11)).thenReturn((Object)buf);
        Mockito.when((Object)buf.getBytes(12, (ByteBuffer)null)).thenReturn((Object)buf);
        Mockito.when((Object)buf.getByte(13)).thenReturn((Object)14);
        Mockito.when((Object)buf.getShort(15)).thenReturn((Object)16);
        Mockito.when((Object)buf.getUnsignedMedium(17)).thenReturn((Object)18);
        Mockito.when((Object)buf.getInt(19)).thenReturn((Object)20);
        Mockito.when((Object)buf.getLong(21)).thenReturn((Object)22L);
        ByteBuffer bb = ByteBuffer.allocate(100);
        Mockito.when((Object)buf.nioBuffer(23, 24)).thenReturn((Object)bb);
        Mockito.when((Object)buf.capacity()).thenReturn((Object)27);
        ByteBuf roBuf = Unpooled.unmodifiableBuffer((ByteBuf)buf);
        Assert.assertEquals((long)3L, (long)roBuf.getBytes(1, (GatheringByteChannel)null, 2));
        roBuf.getBytes(4, (OutputStream)null, 5);
        roBuf.getBytes(6, (byte[])null, 7, 8);
        roBuf.getBytes(9, (ByteBuf)null, 10, 11);
        roBuf.getBytes(12, (ByteBuffer)null);
        Assert.assertEquals((long)14L, (long)roBuf.getByte(13));
        Assert.assertEquals((long)16L, (long)roBuf.getShort(15));
        Assert.assertEquals((long)18L, (long)roBuf.getUnsignedMedium(17));
        Assert.assertEquals((long)20L, (long)roBuf.getInt(19));
        Assert.assertEquals((long)22L, (long)roBuf.getLong(21));
        ByteBuffer roBB = roBuf.nioBuffer(23, 24);
        Assert.assertEquals((long)100L, (long)roBB.capacity());
        Assert.assertTrue((boolean)roBB.isReadOnly());
        Assert.assertEquals((long)27L, (long)roBuf.capacity());
    }

    @Test(expected=UnsupportedOperationException.class)
    public void shouldRejectDiscardReadBytes() {
        Unpooled.unmodifiableBuffer((ByteBuf)Unpooled.EMPTY_BUFFER).discardReadBytes();
    }

    @Test(expected=UnsupportedOperationException.class)
    public void shouldRejectSetByte() {
        Unpooled.unmodifiableBuffer((ByteBuf)Unpooled.EMPTY_BUFFER).setByte(0, 0);
    }

    @Test(expected=UnsupportedOperationException.class)
    public void shouldRejectSetShort() {
        Unpooled.unmodifiableBuffer((ByteBuf)Unpooled.EMPTY_BUFFER).setShort(0, 0);
    }

    @Test(expected=UnsupportedOperationException.class)
    public void shouldRejectSetMedium() {
        Unpooled.unmodifiableBuffer((ByteBuf)Unpooled.EMPTY_BUFFER).setMedium(0, 0);
    }

    @Test(expected=UnsupportedOperationException.class)
    public void shouldRejectSetInt() {
        Unpooled.unmodifiableBuffer((ByteBuf)Unpooled.EMPTY_BUFFER).setInt(0, 0);
    }

    @Test(expected=UnsupportedOperationException.class)
    public void shouldRejectSetLong() {
        Unpooled.unmodifiableBuffer((ByteBuf)Unpooled.EMPTY_BUFFER).setLong(0, 0L);
    }

    @Test(expected=UnsupportedOperationException.class)
    public void shouldRejectSetBytes1() throws IOException {
        Unpooled.unmodifiableBuffer((ByteBuf)Unpooled.EMPTY_BUFFER).setBytes(0, (InputStream)null, 0);
    }

    @Test(expected=UnsupportedOperationException.class)
    public void shouldRejectSetBytes2() throws IOException {
        Unpooled.unmodifiableBuffer((ByteBuf)Unpooled.EMPTY_BUFFER).setBytes(0, (ScatteringByteChannel)null, 0);
    }

    @Test(expected=UnsupportedOperationException.class)
    public void shouldRejectSetBytes3() {
        Unpooled.unmodifiableBuffer((ByteBuf)Unpooled.EMPTY_BUFFER).setBytes(0, (byte[])null, 0, 0);
    }

    @Test(expected=UnsupportedOperationException.class)
    public void shouldRejectSetBytes4() {
        Unpooled.unmodifiableBuffer((ByteBuf)Unpooled.EMPTY_BUFFER).setBytes(0, (ByteBuf)null, 0, 0);
    }

    @Test(expected=UnsupportedOperationException.class)
    public void shouldRejectSetBytes5() {
        Unpooled.unmodifiableBuffer((ByteBuf)Unpooled.EMPTY_BUFFER).setBytes(0, (ByteBuffer)null);
    }

    @Test
    public void shouldIndicateNotWritable() {
        Assert.assertFalse((boolean)Unpooled.unmodifiableBuffer((ByteBuf)Unpooled.buffer((int)1)).isWritable());
    }

    @Test
    public void shouldIndicateNotWritableAnyNumber() {
        Assert.assertFalse((boolean)Unpooled.unmodifiableBuffer((ByteBuf)Unpooled.buffer((int)1)).isWritable(1));
    }

    @Test
    public void ensureWritableIntStatusShouldFailButNotThrow() {
        ReadOnlyByteBufTest.ensureWritableIntStatusShouldFailButNotThrow(false);
    }

    @Test
    public void ensureWritableForceIntStatusShouldFailButNotThrow() {
        ReadOnlyByteBufTest.ensureWritableIntStatusShouldFailButNotThrow(true);
    }

    private static void ensureWritableIntStatusShouldFailButNotThrow(boolean force) {
        ByteBuf buf = Unpooled.buffer((int)1);
        ByteBuf readOnly = buf.asReadOnly();
        int result = readOnly.ensureWritable(1, force);
        Assert.assertEquals((long)1L, (long)result);
        Assert.assertFalse((boolean)ByteBufUtil.ensureWritableSuccess((int)result));
        readOnly.release();
    }

    @Test(expected=ReadOnlyBufferException.class)
    public void ensureWritableShouldThrow() {
        ByteBuf buf = Unpooled.buffer((int)1);
        ByteBuf readOnly = buf.asReadOnly();
        try {
            readOnly.ensureWritable(1);
            Assert.fail();
        }
        finally {
            buf.release();
        }
    }

    @Test
    public void asReadOnly() {
        ByteBuf buf = Unpooled.buffer((int)1);
        ByteBuf readOnly = buf.asReadOnly();
        Assert.assertTrue((boolean)readOnly.isReadOnly());
        Assert.assertSame((Object)readOnly, (Object)readOnly.asReadOnly());
        readOnly.release();
    }
}

