/*
 * Decompiled with CFR 0.152.
 */
package io.netty.buffer;

import io.netty.buffer.ByteBuf;
import io.netty.buffer.ByteBufAllocator;
import io.netty.buffer.EmptyByteBuf;
import io.netty.buffer.Unpooled;
import io.netty.buffer.UnpooledByteBufAllocator;
import io.netty.buffer.UnpooledHeapByteBuf;
import io.netty.util.CharsetUtil;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.junit.Assert;
import org.junit.Test;

public class EmptyByteBufTest {
    @Test
    public void testIsContiguous() {
        EmptyByteBuf empty = new EmptyByteBuf((ByteBufAllocator)UnpooledByteBufAllocator.DEFAULT);
        Assert.assertTrue((boolean)empty.isContiguous());
    }

    @Test
    public void testIsWritable() {
        EmptyByteBuf empty = new EmptyByteBuf((ByteBufAllocator)UnpooledByteBufAllocator.DEFAULT);
        Assert.assertFalse((boolean)empty.isWritable());
        Assert.assertFalse((boolean)empty.isWritable(1));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testWriteEmptyByteBuf() {
        EmptyByteBuf empty = new EmptyByteBuf((ByteBufAllocator)UnpooledByteBufAllocator.DEFAULT);
        empty.writeBytes(Unpooled.EMPTY_BUFFER);
        ByteBuf nonEmpty = UnpooledByteBufAllocator.DEFAULT.buffer().writeBoolean(false);
        try {
            empty.writeBytes(nonEmpty);
            Assert.fail();
        }
        catch (IndexOutOfBoundsException indexOutOfBoundsException) {
        }
        finally {
            nonEmpty.release();
        }
    }

    @Test
    public void testIsReadable() {
        EmptyByteBuf empty = new EmptyByteBuf((ByteBufAllocator)UnpooledByteBufAllocator.DEFAULT);
        Assert.assertFalse((boolean)empty.isReadable());
        Assert.assertFalse((boolean)empty.isReadable(1));
    }

    @Test
    public void testArray() {
        EmptyByteBuf empty = new EmptyByteBuf((ByteBufAllocator)UnpooledByteBufAllocator.DEFAULT);
        Assert.assertThat((Object)empty.hasArray(), (Matcher)Matchers.is((Object)true));
        Assert.assertThat((Object)empty.array().length, (Matcher)Matchers.is((Object)0));
        Assert.assertThat((Object)empty.arrayOffset(), (Matcher)Matchers.is((Object)0));
    }

    @Test
    public void testNioBuffer() {
        EmptyByteBuf empty = new EmptyByteBuf((ByteBufAllocator)UnpooledByteBufAllocator.DEFAULT);
        Assert.assertThat((Object)empty.nioBufferCount(), (Matcher)Matchers.is((Object)1));
        Assert.assertThat((Object)empty.nioBuffer().position(), (Matcher)Matchers.is((Object)0));
        Assert.assertThat((Object)empty.nioBuffer().limit(), (Matcher)Matchers.is((Object)0));
        Assert.assertThat((Object)empty.nioBuffer(), (Matcher)Matchers.is((Matcher)Matchers.sameInstance((Object)empty.nioBuffer())));
        Assert.assertThat((Object)empty.nioBuffer(), (Matcher)Matchers.is((Matcher)Matchers.sameInstance((Object)empty.internalNioBuffer(empty.readerIndex(), 0))));
    }

    @Test
    public void testMemoryAddress() {
        EmptyByteBuf empty = new EmptyByteBuf((ByteBufAllocator)UnpooledByteBufAllocator.DEFAULT);
        if (empty.hasMemoryAddress()) {
            Assert.assertThat((Object)empty.memoryAddress(), (Matcher)Matchers.is((Matcher)Matchers.not((Object)0L)));
        } else {
            try {
                empty.memoryAddress();
                Assert.fail();
            }
            catch (UnsupportedOperationException unsupportedOperationException) {
                // empty catch block
            }
        }
    }

    @Test
    public void consistentEqualsAndHashCodeWithAbstractBytebuf() {
        EmptyByteBuf empty = new EmptyByteBuf((ByteBufAllocator)UnpooledByteBufAllocator.DEFAULT);
        UnpooledHeapByteBuf emptyAbstract = new UnpooledHeapByteBuf((ByteBufAllocator)UnpooledByteBufAllocator.DEFAULT, 0, 0);
        Assert.assertEquals((Object)emptyAbstract, (Object)empty);
        Assert.assertEquals((long)emptyAbstract.hashCode(), (long)empty.hashCode());
        Assert.assertEquals((long)1L, (long)empty.hashCode());
        Assert.assertTrue((boolean)emptyAbstract.release());
        Assert.assertFalse((boolean)empty.release());
    }

    @Test
    public void testGetCharSequence() {
        EmptyByteBuf empty = new EmptyByteBuf((ByteBufAllocator)UnpooledByteBufAllocator.DEFAULT);
        Assert.assertEquals((Object)"", (Object)empty.readCharSequence(0, CharsetUtil.US_ASCII));
    }
}

