/*
 * Decompiled with CFR 0.152.
 */
package io.netty.buffer;

import io.netty.buffer.AbstractByteBufTest;
import io.netty.buffer.ByteBuf;
import io.netty.buffer.DuplicatedByteBuf;
import io.netty.buffer.Unpooled;
import org.junit.Assert;
import org.junit.Test;

public class DuplicatedByteBufTest
extends AbstractByteBufTest {
    @Override
    protected ByteBuf newBuffer(int length, int maxCapacity) {
        ByteBuf wrapped = Unpooled.buffer((int)length, (int)maxCapacity);
        DuplicatedByteBuf buffer = new DuplicatedByteBuf(wrapped);
        Assert.assertEquals((long)wrapped.writerIndex(), (long)buffer.writerIndex());
        Assert.assertEquals((long)wrapped.readerIndex(), (long)buffer.readerIndex());
        return buffer;
    }

    @Test
    public void testIsContiguous() {
        ByteBuf buf = this.newBuffer(4);
        Assert.assertEquals((Object)buf.unwrap().isContiguous(), (Object)buf.isContiguous());
        buf.release();
    }

    @Test(expected=NullPointerException.class)
    public void shouldNotAllowNullInConstructor() {
        new DuplicatedByteBuf(null);
    }

    @Test
    public void testIncreaseCapacityWrapped() {
        ByteBuf buffer = this.newBuffer(8);
        ByteBuf wrapped = buffer.unwrap();
        wrapped.writeByte(0);
        wrapped.readerIndex(wrapped.readerIndex() + 1);
        buffer.writerIndex(buffer.writerIndex() + 1);
        wrapped.capacity(wrapped.capacity() * 2);
        Assert.assertEquals((long)0L, (long)buffer.readByte());
    }

    @Test
    public void testMarksInitialized() {
        ByteBuf wrapped = Unpooled.buffer((int)8);
        try {
            wrapped.writerIndex(6);
            wrapped.readerIndex(1);
            DuplicatedByteBuf duplicate = new DuplicatedByteBuf(wrapped);
            duplicate.writerIndex(duplicate.writerIndex() + 1);
            duplicate.resetWriterIndex();
            Assert.assertEquals((long)wrapped.writerIndex(), (long)duplicate.writerIndex());
            duplicate.readerIndex(duplicate.readerIndex() + 1);
            duplicate.resetReaderIndex();
            Assert.assertEquals((long)wrapped.readerIndex(), (long)duplicate.readerIndex());
        }
        finally {
            wrapped.release();
        }
    }
}

