/*
 * Decompiled with CFR 0.152.
 */
package io.netty.buffer;

import io.netty.buffer.ByteBuf;
import io.netty.buffer.ByteBufInputStream;
import io.netty.buffer.ByteBufOutputStream;
import io.netty.buffer.Unpooled;
import io.netty.util.internal.EmptyArrays;
import java.io.EOFException;
import java.nio.charset.Charset;
import org.junit.Assert;
import org.junit.Test;

public class ByteBufStreamTest {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testAll() throws Exception {
        ByteBuf buf = Unpooled.buffer((int)0, (int)65536);
        try {
            new ByteBufOutputStream(null);
            Assert.fail();
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
        ByteBufOutputStream out = new ByteBufOutputStream(buf);
        try {
            Assert.assertSame((Object)buf, (Object)out.buffer());
            out.writeBoolean(true);
            out.writeBoolean(false);
            out.writeByte(42);
            out.writeByte(224);
            out.writeBytes("Hello, World!");
            out.writeChars("Hello, World");
            out.writeChar(33);
            out.writeDouble(42.0);
            out.writeFloat(42.0f);
            out.writeInt(42);
            out.writeLong(42L);
            out.writeShort(42);
            out.writeShort(49152);
            out.writeUTF("Hello, World!");
            out.writeBytes("The first line\r\r\n");
            out.write(EmptyArrays.EMPTY_BYTES);
            out.write(new byte[]{1, 2, 3, 4});
            out.write(new byte[]{1, 3, 3, 4}, 0, 0);
        }
        finally {
            out.close();
        }
        try {
            new ByteBufInputStream(null, true);
            Assert.fail();
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
        try {
            new ByteBufInputStream(null, 0, true);
            Assert.fail();
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
        try {
            new ByteBufInputStream(buf.retainedSlice(), -1, true);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
        try {
            new ByteBufInputStream(buf.retainedSlice(), buf.capacity() + 1, true);
        }
        catch (IndexOutOfBoundsException indexOutOfBoundsException) {
            // empty catch block
        }
        ByteBufInputStream in = new ByteBufInputStream(buf, true);
        try {
            Assert.assertTrue((boolean)in.markSupported());
            in.mark(Integer.MAX_VALUE);
            Assert.assertEquals((long)buf.writerIndex(), (long)in.skip(Long.MAX_VALUE));
            Assert.assertFalse((boolean)buf.isReadable());
            in.reset();
            Assert.assertEquals((long)0L, (long)buf.readerIndex());
            Assert.assertEquals((long)4L, (long)in.skip(4L));
            Assert.assertEquals((long)4L, (long)buf.readerIndex());
            in.reset();
            Assert.assertTrue((boolean)in.readBoolean());
            Assert.assertFalse((boolean)in.readBoolean());
            Assert.assertEquals((long)42L, (long)in.readByte());
            Assert.assertEquals((long)224L, (long)in.readUnsignedByte());
            byte[] tmp = new byte[13];
            in.readFully(tmp);
            Assert.assertEquals((Object)"Hello, World!", (Object)new String(tmp, "ISO-8859-1"));
            Assert.assertEquals((long)72L, (long)in.readChar());
            Assert.assertEquals((long)101L, (long)in.readChar());
            Assert.assertEquals((long)108L, (long)in.readChar());
            Assert.assertEquals((long)108L, (long)in.readChar());
            Assert.assertEquals((long)111L, (long)in.readChar());
            Assert.assertEquals((long)44L, (long)in.readChar());
            Assert.assertEquals((long)32L, (long)in.readChar());
            Assert.assertEquals((long)87L, (long)in.readChar());
            Assert.assertEquals((long)111L, (long)in.readChar());
            Assert.assertEquals((long)114L, (long)in.readChar());
            Assert.assertEquals((long)108L, (long)in.readChar());
            Assert.assertEquals((long)100L, (long)in.readChar());
            Assert.assertEquals((long)33L, (long)in.readChar());
            Assert.assertEquals((double)42.0, (double)in.readDouble(), (double)0.0);
            Assert.assertEquals((double)42.0, (double)in.readFloat(), (double)0.0);
            Assert.assertEquals((long)42L, (long)in.readInt());
            Assert.assertEquals((long)42L, (long)in.readLong());
            Assert.assertEquals((long)42L, (long)in.readShort());
            Assert.assertEquals((long)49152L, (long)in.readUnsignedShort());
            Assert.assertEquals((Object)"Hello, World!", (Object)in.readUTF());
            Assert.assertEquals((Object)"The first line", (Object)in.readLine());
            Assert.assertEquals((Object)"", (Object)in.readLine());
            Assert.assertEquals((long)4L, (long)in.read(tmp));
            Assert.assertEquals((long)1L, (long)tmp[0]);
            Assert.assertEquals((long)2L, (long)tmp[1]);
            Assert.assertEquals((long)3L, (long)tmp[2]);
            Assert.assertEquals((long)4L, (long)tmp[3]);
            Assert.assertEquals((long)-1L, (long)in.read());
            Assert.assertEquals((long)-1L, (long)in.read(tmp));
            try {
                in.readByte();
                Assert.fail();
            }
            catch (EOFException eOFException) {
                // empty catch block
            }
            try {
                in.readFully(tmp, 0, -1);
                Assert.fail();
            }
            catch (IndexOutOfBoundsException indexOutOfBoundsException) {
                // empty catch block
            }
            try {
                in.readFully(tmp);
                Assert.fail();
            }
            catch (EOFException eOFException) {
                // empty catch block
            }
        }
        finally {
            buf.retain();
            in.close();
        }
        Assert.assertEquals((long)buf.readerIndex(), (long)in.readBytes());
        buf.release();
    }

    @Test
    public void testReadLine() throws Exception {
        Charset utf8 = Charset.forName("UTF-8");
        ByteBuf buf = Unpooled.buffer();
        ByteBufInputStream in = new ByteBufInputStream(buf, true);
        String s = in.readLine();
        Assert.assertNull((Object)s);
        in.close();
        ByteBuf buf2 = Unpooled.buffer();
        int charCount = 7;
        byte[] abc = "\na\n\nb\r\nc\nd\ne".getBytes(utf8);
        buf2.writeBytes(abc);
        ByteBufInputStream in2 = new ByteBufInputStream(buf2, true);
        in2.mark(charCount);
        Assert.assertEquals((Object)"", (Object)in2.readLine());
        Assert.assertEquals((Object)"a", (Object)in2.readLine());
        Assert.assertEquals((Object)"", (Object)in2.readLine());
        Assert.assertEquals((Object)"b", (Object)in2.readLine());
        Assert.assertEquals((Object)"c", (Object)in2.readLine());
        Assert.assertEquals((Object)"d", (Object)in2.readLine());
        Assert.assertEquals((Object)"e", (Object)in2.readLine());
        Assert.assertNull((Object)in.readLine());
        in2.reset();
        int count = 0;
        while (in2.readLine() != null) {
            if (++count <= charCount) continue;
            Assert.fail((String)"readLine() should have returned null");
        }
        Assert.assertEquals((long)charCount, (long)count);
        in2.close();
    }

    @Test
    public void testRead() throws Exception {
        ByteBuf buf = Unpooled.buffer((int)16);
        buf.writeBytes(new byte[]{1, 2, 3, 4, 5, 6});
        ByteBufInputStream in = new ByteBufInputStream(buf, 3);
        Assert.assertEquals((long)1L, (long)in.read());
        Assert.assertEquals((long)2L, (long)in.read());
        Assert.assertEquals((long)3L, (long)in.read());
        Assert.assertEquals((long)-1L, (long)in.read());
        Assert.assertEquals((long)-1L, (long)in.read());
        Assert.assertEquals((long)-1L, (long)in.read());
        buf.release();
        in.close();
        ByteBuf buf2 = Unpooled.buffer((int)16);
        buf2.writeBytes(new byte[]{1, 2, 3, 4, 5, 6});
        ByteBufInputStream in2 = new ByteBufInputStream(buf2, 4);
        Assert.assertEquals((long)1L, (long)in2.read());
        Assert.assertEquals((long)2L, (long)in2.read());
        Assert.assertEquals((long)3L, (long)in2.read());
        Assert.assertEquals((long)4L, (long)in2.read());
        Assert.assertNotEquals((long)5L, (long)in2.read());
        Assert.assertEquals((long)-1L, (long)in2.read());
        buf2.release();
        in2.close();
    }

    @Test
    public void testReadLineLengthRespected1() throws Exception {
        ByteBuf buf = Unpooled.buffer((int)16);
        buf.writeBytes(new byte[]{1, 2, 3, 4, 5, 6});
        ByteBufInputStream in = new ByteBufInputStream(buf, 0);
        Assert.assertNull((Object)in.readLine());
        buf.release();
        in.close();
    }

    @Test
    public void testReadLineLengthRespected2() throws Exception {
        ByteBuf buf2 = Unpooled.buffer((int)16);
        buf2.writeBytes(new byte[]{65, 66, 10, 67, 69, 70});
        ByteBufInputStream in2 = new ByteBufInputStream(buf2, 4);
        Assert.assertEquals((Object)"AB", (Object)in2.readLine());
        Assert.assertEquals((Object)"C", (Object)in2.readLine());
        Assert.assertNull((Object)in2.readLine());
        buf2.release();
        in2.close();
    }

    @Test(expected=EOFException.class)
    public void testReadByteLengthRespected() throws Exception {
        ByteBuf buf = Unpooled.buffer((int)16);
        buf.writeBytes(new byte[]{1, 2, 3, 4, 5, 6});
        ByteBufInputStream in = new ByteBufInputStream(buf, 0);
        try {
            in.readByte();
        }
        finally {
            buf.release();
            in.close();
        }
    }
}

