/*
 * Decompiled with CFR 0.152.
 */
package io.netty.buffer;

import io.netty.buffer.AbstractByteBufTest;
import io.netty.buffer.ByteBuf;
import io.netty.buffer.ByteBufAllocator;
import io.netty.buffer.Unpooled;
import io.netty.buffer.UnpooledByteBufAllocator;
import io.netty.buffer.UnpooledHeapByteBuf;
import org.junit.Assert;
import org.junit.Test;

public class BigEndianHeapByteBufTest
extends AbstractByteBufTest {
    @Override
    protected ByteBuf newBuffer(int length, int maxCapacity) {
        ByteBuf buffer = Unpooled.buffer((int)length, (int)maxCapacity);
        Assert.assertEquals((long)0L, (long)buffer.writerIndex());
        return buffer;
    }

    @Test(expected=NullPointerException.class)
    public void shouldNotAllowNullInConstructor1() {
        new UnpooledHeapByteBuf(null, new byte[1], 0);
    }

    @Test(expected=NullPointerException.class)
    public void shouldNotAllowNullInConstructor2() {
        new UnpooledHeapByteBuf((ByteBufAllocator)UnpooledByteBufAllocator.DEFAULT, null, 0);
    }
}

